/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the details of the script.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScriptDetails implements SdkPojo, Serializable, ToCopyableBuilder<ScriptDetails.Builder, ScriptDetails> {
    private static final SdkField<S3Location> SCRIPT_S3_LOCATION_FIELD = SdkField.<S3Location> builder(MarshallingType.SDK_POJO)
            .memberName("ScriptS3Location").getter(getter(ScriptDetails::scriptS3Location))
            .setter(setter(Builder::scriptS3Location)).constructor(S3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScriptS3Location").build()).build();

    private static final SdkField<String> EXECUTABLE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutablePath").getter(getter(ScriptDetails::executablePath)).setter(setter(Builder::executablePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutablePath").build()).build();

    private static final SdkField<String> EXECUTABLE_PARAMETERS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutableParameters").getter(getter(ScriptDetails::executableParameters))
            .setter(setter(Builder::executableParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutableParameters").build())
            .build();

    private static final SdkField<Integer> TIMEOUT_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TimeoutInSeconds").getter(getter(ScriptDetails::timeoutInSeconds))
            .setter(setter(Builder::timeoutInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeoutInSeconds").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCRIPT_S3_LOCATION_FIELD,
            EXECUTABLE_PATH_FIELD, EXECUTABLE_PARAMETERS_FIELD, TIMEOUT_IN_SECONDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final S3Location scriptS3Location;

    private final String executablePath;

    private final String executableParameters;

    private final Integer timeoutInSeconds;

    private ScriptDetails(BuilderImpl builder) {
        this.scriptS3Location = builder.scriptS3Location;
        this.executablePath = builder.executablePath;
        this.executableParameters = builder.executableParameters;
        this.timeoutInSeconds = builder.timeoutInSeconds;
    }

    /**
     * <p>
     * The S3 object location for the script.
     * </p>
     * 
     * @return The S3 object location for the script.
     */
    public final S3Location scriptS3Location() {
        return scriptS3Location;
    }

    /**
     * <p>
     * The run path for the script.
     * </p>
     * 
     * @return The run path for the script.
     */
    public final String executablePath() {
        return executablePath;
    }

    /**
     * <p>
     * The runtime parameters passed to the run path for the script.
     * </p>
     * 
     * @return The runtime parameters passed to the run path for the script.
     */
    public final String executableParameters() {
        return executableParameters;
    }

    /**
     * <p>
     * The run timeout, in seconds, for the script.
     * </p>
     * 
     * @return The run timeout, in seconds, for the script.
     */
    public final Integer timeoutInSeconds() {
        return timeoutInSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scriptS3Location());
        hashCode = 31 * hashCode + Objects.hashCode(executablePath());
        hashCode = 31 * hashCode + Objects.hashCode(executableParameters());
        hashCode = 31 * hashCode + Objects.hashCode(timeoutInSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScriptDetails)) {
            return false;
        }
        ScriptDetails other = (ScriptDetails) obj;
        return Objects.equals(scriptS3Location(), other.scriptS3Location())
                && Objects.equals(executablePath(), other.executablePath())
                && Objects.equals(executableParameters(), other.executableParameters())
                && Objects.equals(timeoutInSeconds(), other.timeoutInSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScriptDetails").add("ScriptS3Location", scriptS3Location())
                .add("ExecutablePath", executablePath()).add("ExecutableParameters", executableParameters())
                .add("TimeoutInSeconds", timeoutInSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScriptS3Location":
            return Optional.ofNullable(clazz.cast(scriptS3Location()));
        case "ExecutablePath":
            return Optional.ofNullable(clazz.cast(executablePath()));
        case "ExecutableParameters":
            return Optional.ofNullable(clazz.cast(executableParameters()));
        case "TimeoutInSeconds":
            return Optional.ofNullable(clazz.cast(timeoutInSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScriptDetails, T> g) {
        return obj -> g.apply((ScriptDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScriptDetails> {
        /**
         * <p>
         * The S3 object location for the script.
         * </p>
         * 
         * @param scriptS3Location
         *        The S3 object location for the script.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scriptS3Location(S3Location scriptS3Location);

        /**
         * <p>
         * The S3 object location for the script.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3Location.Builder} avoiding the need to
         * create one manually via {@link S3Location#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Location.Builder#build()} is called immediately and its result
         * is passed to {@link #scriptS3Location(S3Location)}.
         * 
         * @param scriptS3Location
         *        a consumer that will call methods on {@link S3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scriptS3Location(S3Location)
         */
        default Builder scriptS3Location(Consumer<S3Location.Builder> scriptS3Location) {
            return scriptS3Location(S3Location.builder().applyMutation(scriptS3Location).build());
        }

        /**
         * <p>
         * The run path for the script.
         * </p>
         * 
         * @param executablePath
         *        The run path for the script.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executablePath(String executablePath);

        /**
         * <p>
         * The runtime parameters passed to the run path for the script.
         * </p>
         * 
         * @param executableParameters
         *        The runtime parameters passed to the run path for the script.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executableParameters(String executableParameters);

        /**
         * <p>
         * The run timeout, in seconds, for the script.
         * </p>
         * 
         * @param timeoutInSeconds
         *        The run timeout, in seconds, for the script.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutInSeconds(Integer timeoutInSeconds);
    }

    static final class BuilderImpl implements Builder {
        private S3Location scriptS3Location;

        private String executablePath;

        private String executableParameters;

        private Integer timeoutInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(ScriptDetails model) {
            scriptS3Location(model.scriptS3Location);
            executablePath(model.executablePath);
            executableParameters(model.executableParameters);
            timeoutInSeconds(model.timeoutInSeconds);
        }

        public final S3Location.Builder getScriptS3Location() {
            return scriptS3Location != null ? scriptS3Location.toBuilder() : null;
        }

        public final void setScriptS3Location(S3Location.BuilderImpl scriptS3Location) {
            this.scriptS3Location = scriptS3Location != null ? scriptS3Location.build() : null;
        }

        @Override
        public final Builder scriptS3Location(S3Location scriptS3Location) {
            this.scriptS3Location = scriptS3Location;
            return this;
        }

        public final String getExecutablePath() {
            return executablePath;
        }

        public final void setExecutablePath(String executablePath) {
            this.executablePath = executablePath;
        }

        @Override
        public final Builder executablePath(String executablePath) {
            this.executablePath = executablePath;
            return this;
        }

        public final String getExecutableParameters() {
            return executableParameters;
        }

        public final void setExecutableParameters(String executableParameters) {
            this.executableParameters = executableParameters;
        }

        @Override
        public final Builder executableParameters(String executableParameters) {
            this.executableParameters = executableParameters;
            return this;
        }

        public final Integer getTimeoutInSeconds() {
            return timeoutInSeconds;
        }

        public final void setTimeoutInSeconds(Integer timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
        }

        @Override
        public final Builder timeoutInSeconds(Integer timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
            return this;
        }

        @Override
        public ScriptDetails build() {
            return new ScriptDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
