/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationdiscovery.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDiscoverySummaryResponse extends ApplicationDiscoveryResponse implements
        ToCopyableBuilder<GetDiscoverySummaryResponse.Builder, GetDiscoverySummaryResponse> {
    private static final SdkField<Long> SERVERS_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("servers")
            .getter(getter(GetDiscoverySummaryResponse::servers)).setter(setter(Builder::servers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("servers").build()).build();

    private static final SdkField<Long> APPLICATIONS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("applications").getter(getter(GetDiscoverySummaryResponse::applications))
            .setter(setter(Builder::applications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applications").build()).build();

    private static final SdkField<Long> SERVERS_MAPPED_TO_APPLICATIONS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("serversMappedToApplications")
            .getter(getter(GetDiscoverySummaryResponse::serversMappedToApplications))
            .setter(setter(Builder::serversMappedToApplications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serversMappedToApplications")
                    .build()).build();

    private static final SdkField<Long> SERVERS_MAPPEDTO_TAGS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("serversMappedtoTags").getter(getter(GetDiscoverySummaryResponse::serversMappedtoTags))
            .setter(setter(Builder::serversMappedtoTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serversMappedtoTags").build())
            .build();

    private static final SdkField<CustomerAgentInfo> AGENT_SUMMARY_FIELD = SdkField
            .<CustomerAgentInfo> builder(MarshallingType.SDK_POJO).memberName("agentSummary")
            .getter(getter(GetDiscoverySummaryResponse::agentSummary)).setter(setter(Builder::agentSummary))
            .constructor(CustomerAgentInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentSummary").build()).build();

    private static final SdkField<CustomerConnectorInfo> CONNECTOR_SUMMARY_FIELD = SdkField
            .<CustomerConnectorInfo> builder(MarshallingType.SDK_POJO).memberName("connectorSummary")
            .getter(getter(GetDiscoverySummaryResponse::connectorSummary)).setter(setter(Builder::connectorSummary))
            .constructor(CustomerConnectorInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorSummary").build()).build();

    private static final SdkField<CustomerMeCollectorInfo> ME_COLLECTOR_SUMMARY_FIELD = SdkField
            .<CustomerMeCollectorInfo> builder(MarshallingType.SDK_POJO).memberName("meCollectorSummary")
            .getter(getter(GetDiscoverySummaryResponse::meCollectorSummary)).setter(setter(Builder::meCollectorSummary))
            .constructor(CustomerMeCollectorInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("meCollectorSummary").build())
            .build();

    private static final SdkField<CustomerAgentlessCollectorInfo> AGENTLESS_COLLECTOR_SUMMARY_FIELD = SdkField
            .<CustomerAgentlessCollectorInfo> builder(MarshallingType.SDK_POJO).memberName("agentlessCollectorSummary")
            .getter(getter(GetDiscoverySummaryResponse::agentlessCollectorSummary))
            .setter(setter(Builder::agentlessCollectorSummary)).constructor(CustomerAgentlessCollectorInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentlessCollectorSummary").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVERS_FIELD,
            APPLICATIONS_FIELD, SERVERS_MAPPED_TO_APPLICATIONS_FIELD, SERVERS_MAPPEDTO_TAGS_FIELD, AGENT_SUMMARY_FIELD,
            CONNECTOR_SUMMARY_FIELD, ME_COLLECTOR_SUMMARY_FIELD, AGENTLESS_COLLECTOR_SUMMARY_FIELD));

    private final Long servers;

    private final Long applications;

    private final Long serversMappedToApplications;

    private final Long serversMappedtoTags;

    private final CustomerAgentInfo agentSummary;

    private final CustomerConnectorInfo connectorSummary;

    private final CustomerMeCollectorInfo meCollectorSummary;

    private final CustomerAgentlessCollectorInfo agentlessCollectorSummary;

    private GetDiscoverySummaryResponse(BuilderImpl builder) {
        super(builder);
        this.servers = builder.servers;
        this.applications = builder.applications;
        this.serversMappedToApplications = builder.serversMappedToApplications;
        this.serversMappedtoTags = builder.serversMappedtoTags;
        this.agentSummary = builder.agentSummary;
        this.connectorSummary = builder.connectorSummary;
        this.meCollectorSummary = builder.meCollectorSummary;
        this.agentlessCollectorSummary = builder.agentlessCollectorSummary;
    }

    /**
     * <p>
     * The number of servers discovered.
     * </p>
     * 
     * @return The number of servers discovered.
     */
    public final Long servers() {
        return servers;
    }

    /**
     * <p>
     * The number of applications discovered.
     * </p>
     * 
     * @return The number of applications discovered.
     */
    public final Long applications() {
        return applications;
    }

    /**
     * <p>
     * The number of servers mapped to applications.
     * </p>
     * 
     * @return The number of servers mapped to applications.
     */
    public final Long serversMappedToApplications() {
        return serversMappedToApplications;
    }

    /**
     * <p>
     * The number of servers mapped to tags.
     * </p>
     * 
     * @return The number of servers mapped to tags.
     */
    public final Long serversMappedtoTags() {
        return serversMappedtoTags;
    }

    /**
     * <p>
     * Details about discovered agents, including agent status and health.
     * </p>
     * 
     * @return Details about discovered agents, including agent status and health.
     */
    public final CustomerAgentInfo agentSummary() {
        return agentSummary;
    }

    /**
     * <p>
     * Details about discovered connectors, including connector status and health.
     * </p>
     * 
     * @return Details about discovered connectors, including connector status and health.
     */
    public final CustomerConnectorInfo connectorSummary() {
        return connectorSummary;
    }

    /**
     * <p>
     * Details about Migration Evaluator collectors, including collector status and health.
     * </p>
     * 
     * @return Details about Migration Evaluator collectors, including collector status and health.
     */
    public final CustomerMeCollectorInfo meCollectorSummary() {
        return meCollectorSummary;
    }

    /**
     * <p>
     * Details about Agentless Collector collectors, including status.
     * </p>
     * 
     * @return Details about Agentless Collector collectors, including status.
     */
    public final CustomerAgentlessCollectorInfo agentlessCollectorSummary() {
        return agentlessCollectorSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(servers());
        hashCode = 31 * hashCode + Objects.hashCode(applications());
        hashCode = 31 * hashCode + Objects.hashCode(serversMappedToApplications());
        hashCode = 31 * hashCode + Objects.hashCode(serversMappedtoTags());
        hashCode = 31 * hashCode + Objects.hashCode(agentSummary());
        hashCode = 31 * hashCode + Objects.hashCode(connectorSummary());
        hashCode = 31 * hashCode + Objects.hashCode(meCollectorSummary());
        hashCode = 31 * hashCode + Objects.hashCode(agentlessCollectorSummary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDiscoverySummaryResponse)) {
            return false;
        }
        GetDiscoverySummaryResponse other = (GetDiscoverySummaryResponse) obj;
        return Objects.equals(servers(), other.servers()) && Objects.equals(applications(), other.applications())
                && Objects.equals(serversMappedToApplications(), other.serversMappedToApplications())
                && Objects.equals(serversMappedtoTags(), other.serversMappedtoTags())
                && Objects.equals(agentSummary(), other.agentSummary())
                && Objects.equals(connectorSummary(), other.connectorSummary())
                && Objects.equals(meCollectorSummary(), other.meCollectorSummary())
                && Objects.equals(agentlessCollectorSummary(), other.agentlessCollectorSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDiscoverySummaryResponse").add("Servers", servers()).add("Applications", applications())
                .add("ServersMappedToApplications", serversMappedToApplications())
                .add("ServersMappedtoTags", serversMappedtoTags()).add("AgentSummary", agentSummary())
                .add("ConnectorSummary", connectorSummary()).add("MeCollectorSummary", meCollectorSummary())
                .add("AgentlessCollectorSummary", agentlessCollectorSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "servers":
            return Optional.ofNullable(clazz.cast(servers()));
        case "applications":
            return Optional.ofNullable(clazz.cast(applications()));
        case "serversMappedToApplications":
            return Optional.ofNullable(clazz.cast(serversMappedToApplications()));
        case "serversMappedtoTags":
            return Optional.ofNullable(clazz.cast(serversMappedtoTags()));
        case "agentSummary":
            return Optional.ofNullable(clazz.cast(agentSummary()));
        case "connectorSummary":
            return Optional.ofNullable(clazz.cast(connectorSummary()));
        case "meCollectorSummary":
            return Optional.ofNullable(clazz.cast(meCollectorSummary()));
        case "agentlessCollectorSummary":
            return Optional.ofNullable(clazz.cast(agentlessCollectorSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDiscoverySummaryResponse, T> g) {
        return obj -> g.apply((GetDiscoverySummaryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationDiscoveryResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetDiscoverySummaryResponse> {
        /**
         * <p>
         * The number of servers discovered.
         * </p>
         * 
         * @param servers
         *        The number of servers discovered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder servers(Long servers);

        /**
         * <p>
         * The number of applications discovered.
         * </p>
         * 
         * @param applications
         *        The number of applications discovered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applications(Long applications);

        /**
         * <p>
         * The number of servers mapped to applications.
         * </p>
         * 
         * @param serversMappedToApplications
         *        The number of servers mapped to applications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serversMappedToApplications(Long serversMappedToApplications);

        /**
         * <p>
         * The number of servers mapped to tags.
         * </p>
         * 
         * @param serversMappedtoTags
         *        The number of servers mapped to tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serversMappedtoTags(Long serversMappedtoTags);

        /**
         * <p>
         * Details about discovered agents, including agent status and health.
         * </p>
         * 
         * @param agentSummary
         *        Details about discovered agents, including agent status and health.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentSummary(CustomerAgentInfo agentSummary);

        /**
         * <p>
         * Details about discovered agents, including agent status and health.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomerAgentInfo.Builder} avoiding the
         * need to create one manually via {@link CustomerAgentInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomerAgentInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #agentSummary(CustomerAgentInfo)}.
         * 
         * @param agentSummary
         *        a consumer that will call methods on {@link CustomerAgentInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #agentSummary(CustomerAgentInfo)
         */
        default Builder agentSummary(Consumer<CustomerAgentInfo.Builder> agentSummary) {
            return agentSummary(CustomerAgentInfo.builder().applyMutation(agentSummary).build());
        }

        /**
         * <p>
         * Details about discovered connectors, including connector status and health.
         * </p>
         * 
         * @param connectorSummary
         *        Details about discovered connectors, including connector status and health.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorSummary(CustomerConnectorInfo connectorSummary);

        /**
         * <p>
         * Details about discovered connectors, including connector status and health.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomerConnectorInfo.Builder} avoiding
         * the need to create one manually via {@link CustomerConnectorInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomerConnectorInfo.Builder#build()} is called immediately and
         * its result is passed to {@link #connectorSummary(CustomerConnectorInfo)}.
         * 
         * @param connectorSummary
         *        a consumer that will call methods on {@link CustomerConnectorInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectorSummary(CustomerConnectorInfo)
         */
        default Builder connectorSummary(Consumer<CustomerConnectorInfo.Builder> connectorSummary) {
            return connectorSummary(CustomerConnectorInfo.builder().applyMutation(connectorSummary).build());
        }

        /**
         * <p>
         * Details about Migration Evaluator collectors, including collector status and health.
         * </p>
         * 
         * @param meCollectorSummary
         *        Details about Migration Evaluator collectors, including collector status and health.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meCollectorSummary(CustomerMeCollectorInfo meCollectorSummary);

        /**
         * <p>
         * Details about Migration Evaluator collectors, including collector status and health.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomerMeCollectorInfo.Builder} avoiding
         * the need to create one manually via {@link CustomerMeCollectorInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomerMeCollectorInfo.Builder#build()} is called immediately
         * and its result is passed to {@link #meCollectorSummary(CustomerMeCollectorInfo)}.
         * 
         * @param meCollectorSummary
         *        a consumer that will call methods on {@link CustomerMeCollectorInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #meCollectorSummary(CustomerMeCollectorInfo)
         */
        default Builder meCollectorSummary(Consumer<CustomerMeCollectorInfo.Builder> meCollectorSummary) {
            return meCollectorSummary(CustomerMeCollectorInfo.builder().applyMutation(meCollectorSummary).build());
        }

        /**
         * <p>
         * Details about Agentless Collector collectors, including status.
         * </p>
         * 
         * @param agentlessCollectorSummary
         *        Details about Agentless Collector collectors, including status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentlessCollectorSummary(CustomerAgentlessCollectorInfo agentlessCollectorSummary);

        /**
         * <p>
         * Details about Agentless Collector collectors, including status.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomerAgentlessCollectorInfo.Builder}
         * avoiding the need to create one manually via {@link CustomerAgentlessCollectorInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomerAgentlessCollectorInfo.Builder#build()} is called
         * immediately and its result is passed to {@link #agentlessCollectorSummary(CustomerAgentlessCollectorInfo)}.
         * 
         * @param agentlessCollectorSummary
         *        a consumer that will call methods on {@link CustomerAgentlessCollectorInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #agentlessCollectorSummary(CustomerAgentlessCollectorInfo)
         */
        default Builder agentlessCollectorSummary(Consumer<CustomerAgentlessCollectorInfo.Builder> agentlessCollectorSummary) {
            return agentlessCollectorSummary(CustomerAgentlessCollectorInfo.builder().applyMutation(agentlessCollectorSummary)
                    .build());
        }
    }

    static final class BuilderImpl extends ApplicationDiscoveryResponse.BuilderImpl implements Builder {
        private Long servers;

        private Long applications;

        private Long serversMappedToApplications;

        private Long serversMappedtoTags;

        private CustomerAgentInfo agentSummary;

        private CustomerConnectorInfo connectorSummary;

        private CustomerMeCollectorInfo meCollectorSummary;

        private CustomerAgentlessCollectorInfo agentlessCollectorSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDiscoverySummaryResponse model) {
            super(model);
            servers(model.servers);
            applications(model.applications);
            serversMappedToApplications(model.serversMappedToApplications);
            serversMappedtoTags(model.serversMappedtoTags);
            agentSummary(model.agentSummary);
            connectorSummary(model.connectorSummary);
            meCollectorSummary(model.meCollectorSummary);
            agentlessCollectorSummary(model.agentlessCollectorSummary);
        }

        public final Long getServers() {
            return servers;
        }

        public final void setServers(Long servers) {
            this.servers = servers;
        }

        @Override
        public final Builder servers(Long servers) {
            this.servers = servers;
            return this;
        }

        public final Long getApplications() {
            return applications;
        }

        public final void setApplications(Long applications) {
            this.applications = applications;
        }

        @Override
        public final Builder applications(Long applications) {
            this.applications = applications;
            return this;
        }

        public final Long getServersMappedToApplications() {
            return serversMappedToApplications;
        }

        public final void setServersMappedToApplications(Long serversMappedToApplications) {
            this.serversMappedToApplications = serversMappedToApplications;
        }

        @Override
        public final Builder serversMappedToApplications(Long serversMappedToApplications) {
            this.serversMappedToApplications = serversMappedToApplications;
            return this;
        }

        public final Long getServersMappedtoTags() {
            return serversMappedtoTags;
        }

        public final void setServersMappedtoTags(Long serversMappedtoTags) {
            this.serversMappedtoTags = serversMappedtoTags;
        }

        @Override
        public final Builder serversMappedtoTags(Long serversMappedtoTags) {
            this.serversMappedtoTags = serversMappedtoTags;
            return this;
        }

        public final CustomerAgentInfo.Builder getAgentSummary() {
            return agentSummary != null ? agentSummary.toBuilder() : null;
        }

        public final void setAgentSummary(CustomerAgentInfo.BuilderImpl agentSummary) {
            this.agentSummary = agentSummary != null ? agentSummary.build() : null;
        }

        @Override
        public final Builder agentSummary(CustomerAgentInfo agentSummary) {
            this.agentSummary = agentSummary;
            return this;
        }

        public final CustomerConnectorInfo.Builder getConnectorSummary() {
            return connectorSummary != null ? connectorSummary.toBuilder() : null;
        }

        public final void setConnectorSummary(CustomerConnectorInfo.BuilderImpl connectorSummary) {
            this.connectorSummary = connectorSummary != null ? connectorSummary.build() : null;
        }

        @Override
        public final Builder connectorSummary(CustomerConnectorInfo connectorSummary) {
            this.connectorSummary = connectorSummary;
            return this;
        }

        public final CustomerMeCollectorInfo.Builder getMeCollectorSummary() {
            return meCollectorSummary != null ? meCollectorSummary.toBuilder() : null;
        }

        public final void setMeCollectorSummary(CustomerMeCollectorInfo.BuilderImpl meCollectorSummary) {
            this.meCollectorSummary = meCollectorSummary != null ? meCollectorSummary.build() : null;
        }

        @Override
        public final Builder meCollectorSummary(CustomerMeCollectorInfo meCollectorSummary) {
            this.meCollectorSummary = meCollectorSummary;
            return this;
        }

        public final CustomerAgentlessCollectorInfo.Builder getAgentlessCollectorSummary() {
            return agentlessCollectorSummary != null ? agentlessCollectorSummary.toBuilder() : null;
        }

        public final void setAgentlessCollectorSummary(CustomerAgentlessCollectorInfo.BuilderImpl agentlessCollectorSummary) {
            this.agentlessCollectorSummary = agentlessCollectorSummary != null ? agentlessCollectorSummary.build() : null;
        }

        @Override
        public final Builder agentlessCollectorSummary(CustomerAgentlessCollectorInfo agentlessCollectorSummary) {
            this.agentlessCollectorSummary = agentlessCollectorSummary;
            return this;
        }

        @Override
        public GetDiscoverySummaryResponse build() {
            return new GetDiscoverySummaryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
