/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationautoscaling;

import java.net.URI;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.services.applicationautoscaling.endpoints.ApplicationAutoScalingEndpointProvider;

/**
 * Internal implementation of {@link ApplicationAutoScalingAsyncClientBuilder}.
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultApplicationAutoScalingAsyncClientBuilder
        extends
        DefaultApplicationAutoScalingBaseClientBuilder<ApplicationAutoScalingAsyncClientBuilder, ApplicationAutoScalingAsyncClient>
        implements ApplicationAutoScalingAsyncClientBuilder {
    @Override
    public DefaultApplicationAutoScalingAsyncClientBuilder endpointProvider(
            ApplicationAutoScalingEndpointProvider endpointProvider) {
        clientConfiguration.option(SdkClientOption.ENDPOINT_PROVIDER, endpointProvider);
        return this;
    }

    @Override
    protected final ApplicationAutoScalingAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        this.validateClientOptions(clientConfiguration);
        ApplicationAutoScalingServiceClientConfiguration serviceClientConfiguration = initializeServiceClientConfig(clientConfiguration);
        ApplicationAutoScalingAsyncClient client = new DefaultApplicationAutoScalingAsyncClient(serviceClientConfiguration,
                clientConfiguration);
        return client;
    }

    private ApplicationAutoScalingServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option(SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = clientConfig.option(SdkClientOption.ENDPOINT);
        }
        return ApplicationAutoScalingServiceClientConfiguration.builder().overrideConfiguration(overrideConfiguration())
                .region(clientConfig.option(AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride)
                .endpointProvider(clientConfig.option(SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}
