/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Creates settings for the end of meeting reminder feature that are applied to a room profile. The end of meeting
 * reminder enables Alexa to remind users when a meeting is ending.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateEndOfMeetingReminder implements SdkPojo, Serializable,
        ToCopyableBuilder<CreateEndOfMeetingReminder.Builder, CreateEndOfMeetingReminder> {
    private static final SdkField<List<Integer>> REMINDER_AT_MINUTES_FIELD = SdkField
            .<List<Integer>> builder(MarshallingType.LIST)
            .memberName("ReminderAtMinutes")
            .getter(getter(CreateEndOfMeetingReminder::reminderAtMinutes))
            .setter(setter(Builder::reminderAtMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReminderAtMinutes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> REMINDER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReminderType").getter(getter(CreateEndOfMeetingReminder::reminderTypeAsString))
            .setter(setter(Builder::reminderType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReminderType").build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled").getter(getter(CreateEndOfMeetingReminder::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REMINDER_AT_MINUTES_FIELD,
            REMINDER_TYPE_FIELD, ENABLED_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<Integer> reminderAtMinutes;

    private final String reminderType;

    private final Boolean enabled;

    private CreateEndOfMeetingReminder(BuilderImpl builder) {
        this.reminderAtMinutes = builder.reminderAtMinutes;
        this.reminderType = builder.reminderType;
        this.enabled = builder.enabled;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReminderAtMinutes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReminderAtMinutes() {
        return reminderAtMinutes != null && !(reminderAtMinutes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A range of 3 to 15 minutes that determines when the reminder begins.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReminderAtMinutes} method.
     * </p>
     * 
     * @return A range of 3 to 15 minutes that determines when the reminder begins.
     */
    public final List<Integer> reminderAtMinutes() {
        return reminderAtMinutes;
    }

    /**
     * <p>
     * The type of sound that users hear during the end of meeting reminder.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reminderType} will
     * return {@link EndOfMeetingReminderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #reminderTypeAsString}.
     * </p>
     * 
     * @return The type of sound that users hear during the end of meeting reminder.
     * @see EndOfMeetingReminderType
     */
    public final EndOfMeetingReminderType reminderType() {
        return EndOfMeetingReminderType.fromValue(reminderType);
    }

    /**
     * <p>
     * The type of sound that users hear during the end of meeting reminder.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reminderType} will
     * return {@link EndOfMeetingReminderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #reminderTypeAsString}.
     * </p>
     * 
     * @return The type of sound that users hear during the end of meeting reminder.
     * @see EndOfMeetingReminderType
     */
    public final String reminderTypeAsString() {
        return reminderType;
    }

    /**
     * <p>
     * Whether an end of meeting reminder is enabled or not.
     * </p>
     * 
     * @return Whether an end of meeting reminder is enabled or not.
     */
    public final Boolean enabled() {
        return enabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasReminderAtMinutes() ? reminderAtMinutes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(reminderTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEndOfMeetingReminder)) {
            return false;
        }
        CreateEndOfMeetingReminder other = (CreateEndOfMeetingReminder) obj;
        return hasReminderAtMinutes() == other.hasReminderAtMinutes()
                && Objects.equals(reminderAtMinutes(), other.reminderAtMinutes())
                && Objects.equals(reminderTypeAsString(), other.reminderTypeAsString())
                && Objects.equals(enabled(), other.enabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateEndOfMeetingReminder")
                .add("ReminderAtMinutes", hasReminderAtMinutes() ? reminderAtMinutes() : null)
                .add("ReminderType", reminderTypeAsString()).add("Enabled", enabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReminderAtMinutes":
            return Optional.ofNullable(clazz.cast(reminderAtMinutes()));
        case "ReminderType":
            return Optional.ofNullable(clazz.cast(reminderTypeAsString()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateEndOfMeetingReminder, T> g) {
        return obj -> g.apply((CreateEndOfMeetingReminder) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateEndOfMeetingReminder> {
        /**
         * <p>
         * A range of 3 to 15 minutes that determines when the reminder begins.
         * </p>
         * 
         * @param reminderAtMinutes
         *        A range of 3 to 15 minutes that determines when the reminder begins.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reminderAtMinutes(Collection<Integer> reminderAtMinutes);

        /**
         * <p>
         * A range of 3 to 15 minutes that determines when the reminder begins.
         * </p>
         * 
         * @param reminderAtMinutes
         *        A range of 3 to 15 minutes that determines when the reminder begins.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reminderAtMinutes(Integer... reminderAtMinutes);

        /**
         * <p>
         * The type of sound that users hear during the end of meeting reminder.
         * </p>
         * 
         * @param reminderType
         *        The type of sound that users hear during the end of meeting reminder.
         * @see EndOfMeetingReminderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndOfMeetingReminderType
         */
        Builder reminderType(String reminderType);

        /**
         * <p>
         * The type of sound that users hear during the end of meeting reminder.
         * </p>
         * 
         * @param reminderType
         *        The type of sound that users hear during the end of meeting reminder.
         * @see EndOfMeetingReminderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndOfMeetingReminderType
         */
        Builder reminderType(EndOfMeetingReminderType reminderType);

        /**
         * <p>
         * Whether an end of meeting reminder is enabled or not.
         * </p>
         * 
         * @param enabled
         *        Whether an end of meeting reminder is enabled or not.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);
    }

    static final class BuilderImpl implements Builder {
        private List<Integer> reminderAtMinutes = DefaultSdkAutoConstructList.getInstance();

        private String reminderType;

        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEndOfMeetingReminder model) {
            reminderAtMinutes(model.reminderAtMinutes);
            reminderType(model.reminderType);
            enabled(model.enabled);
        }

        public final Collection<Integer> getReminderAtMinutes() {
            if (reminderAtMinutes instanceof SdkAutoConstructList) {
                return null;
            }
            return reminderAtMinutes;
        }

        public final void setReminderAtMinutes(Collection<Integer> reminderAtMinutes) {
            this.reminderAtMinutes = EndOfMeetingReminderMinutesListCopier.copy(reminderAtMinutes);
        }

        @Override
        public final Builder reminderAtMinutes(Collection<Integer> reminderAtMinutes) {
            this.reminderAtMinutes = EndOfMeetingReminderMinutesListCopier.copy(reminderAtMinutes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reminderAtMinutes(Integer... reminderAtMinutes) {
            reminderAtMinutes(Arrays.asList(reminderAtMinutes));
            return this;
        }

        public final String getReminderType() {
            return reminderType;
        }

        public final void setReminderType(String reminderType) {
            this.reminderType = reminderType;
        }

        @Override
        public final Builder reminderType(String reminderType) {
            this.reminderType = reminderType;
            return this;
        }

        @Override
        public final Builder reminderType(EndOfMeetingReminderType reminderType) {
            this.reminderType(reminderType == null ? null : reminderType.toString());
            return this;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        public CreateEndOfMeetingReminder build() {
            return new CreateEndOfMeetingReminder(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
