/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a batch of endpoints to create or update and the settings and attributes to set or change for each
 * endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EndpointBatchRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<EndpointBatchRequest.Builder, EndpointBatchRequest> {
    private static final SdkField<List<EndpointBatchItem>> ITEM_FIELD = SdkField
            .<List<EndpointBatchItem>> builder(MarshallingType.LIST)
            .memberName("Item")
            .getter(getter(EndpointBatchRequest::item))
            .setter(setter(Builder::item))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EndpointBatchItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(EndpointBatchItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEM_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<EndpointBatchItem> item;

    private EndpointBatchRequest(BuilderImpl builder) {
        this.item = builder.item;
    }

    /**
     * For responses, this returns true if the service returned a value for the Item property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasItem() {
        return item != null && !(item instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array that defines the endpoints to create or update and, for each endpoint, the property values to set or
     * change. An array can contain a maximum of 100 items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasItem} method.
     * </p>
     * 
     * @return An array that defines the endpoints to create or update and, for each endpoint, the property values to
     *         set or change. An array can contain a maximum of 100 items.
     */
    public final List<EndpointBatchItem> item() {
        return item;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasItem() ? item() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointBatchRequest)) {
            return false;
        }
        EndpointBatchRequest other = (EndpointBatchRequest) obj;
        return hasItem() == other.hasItem() && Objects.equals(item(), other.item());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EndpointBatchRequest").add("Item", hasItem() ? item() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Item":
            return Optional.ofNullable(clazz.cast(item()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EndpointBatchRequest, T> g) {
        return obj -> g.apply((EndpointBatchRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EndpointBatchRequest> {
        /**
         * <p>
         * An array that defines the endpoints to create or update and, for each endpoint, the property values to set or
         * change. An array can contain a maximum of 100 items.
         * </p>
         * 
         * @param item
         *        An array that defines the endpoints to create or update and, for each endpoint, the property values to
         *        set or change. An array can contain a maximum of 100 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder item(Collection<EndpointBatchItem> item);

        /**
         * <p>
         * An array that defines the endpoints to create or update and, for each endpoint, the property values to set or
         * change. An array can contain a maximum of 100 items.
         * </p>
         * 
         * @param item
         *        An array that defines the endpoints to create or update and, for each endpoint, the property values to
         *        set or change. An array can contain a maximum of 100 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder item(EndpointBatchItem... item);

        /**
         * <p>
         * An array that defines the endpoints to create or update and, for each endpoint, the property values to set or
         * change. An array can contain a maximum of 100 items.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pinpoint.model.EndpointBatchItem.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.pinpoint.model.EndpointBatchItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pinpoint.model.EndpointBatchItem.Builder#build()} is called
         * immediately and its result is passed to {@link #item(List<EndpointBatchItem>)}.
         * 
         * @param item
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pinpoint.model.EndpointBatchItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #item(java.util.Collection<EndpointBatchItem>)
         */
        Builder item(Consumer<EndpointBatchItem.Builder>... item);
    }

    static final class BuilderImpl implements Builder {
        private List<EndpointBatchItem> item = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointBatchRequest model) {
            item(model.item);
        }

        public final List<EndpointBatchItem.Builder> getItem() {
            List<EndpointBatchItem.Builder> result = ListOfEndpointBatchItemCopier.copyToBuilder(this.item);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItem(Collection<EndpointBatchItem.BuilderImpl> item) {
            this.item = ListOfEndpointBatchItemCopier.copyFromBuilder(item);
        }

        @Override
        public final Builder item(Collection<EndpointBatchItem> item) {
            this.item = ListOfEndpointBatchItemCopier.copy(item);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder item(EndpointBatchItem... item) {
            item(Arrays.asList(item));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder item(Consumer<EndpointBatchItem.Builder>... item) {
            item(Stream.of(item).map(c -> EndpointBatchItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public EndpointBatchRequest build() {
            return new EndpointBatchRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
