/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptune;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import software.amazon.awssdk.services.neptune.model.AddRoleToDbClusterRequest;
import software.amazon.awssdk.services.neptune.model.AddRoleToDbClusterResponse;
import software.amazon.awssdk.services.neptune.model.AddSourceIdentifierToSubscriptionRequest;
import software.amazon.awssdk.services.neptune.model.AddSourceIdentifierToSubscriptionResponse;
import software.amazon.awssdk.services.neptune.model.AddTagsToResourceRequest;
import software.amazon.awssdk.services.neptune.model.AddTagsToResourceResponse;
import software.amazon.awssdk.services.neptune.model.ApplyPendingMaintenanceActionRequest;
import software.amazon.awssdk.services.neptune.model.ApplyPendingMaintenanceActionResponse;
import software.amazon.awssdk.services.neptune.model.AuthorizationNotFoundException;
import software.amazon.awssdk.services.neptune.model.CertificateNotFoundException;
import software.amazon.awssdk.services.neptune.model.CopyDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.neptune.model.CopyDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.neptune.model.CopyDbClusterSnapshotRequest;
import software.amazon.awssdk.services.neptune.model.CopyDbClusterSnapshotResponse;
import software.amazon.awssdk.services.neptune.model.CopyDbParameterGroupRequest;
import software.amazon.awssdk.services.neptune.model.CopyDbParameterGroupResponse;
import software.amazon.awssdk.services.neptune.model.CreateDbClusterEndpointRequest;
import software.amazon.awssdk.services.neptune.model.CreateDbClusterEndpointResponse;
import software.amazon.awssdk.services.neptune.model.CreateDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.neptune.model.CreateDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.neptune.model.CreateDbClusterRequest;
import software.amazon.awssdk.services.neptune.model.CreateDbClusterResponse;
import software.amazon.awssdk.services.neptune.model.CreateDbClusterSnapshotRequest;
import software.amazon.awssdk.services.neptune.model.CreateDbClusterSnapshotResponse;
import software.amazon.awssdk.services.neptune.model.CreateDbInstanceRequest;
import software.amazon.awssdk.services.neptune.model.CreateDbInstanceResponse;
import software.amazon.awssdk.services.neptune.model.CreateDbParameterGroupRequest;
import software.amazon.awssdk.services.neptune.model.CreateDbParameterGroupResponse;
import software.amazon.awssdk.services.neptune.model.CreateDbSubnetGroupRequest;
import software.amazon.awssdk.services.neptune.model.CreateDbSubnetGroupResponse;
import software.amazon.awssdk.services.neptune.model.CreateEventSubscriptionRequest;
import software.amazon.awssdk.services.neptune.model.CreateEventSubscriptionResponse;
import software.amazon.awssdk.services.neptune.model.CreateGlobalClusterRequest;
import software.amazon.awssdk.services.neptune.model.CreateGlobalClusterResponse;
import software.amazon.awssdk.services.neptune.model.DbClusterAlreadyExistsException;
import software.amazon.awssdk.services.neptune.model.DbClusterEndpointAlreadyExistsException;
import software.amazon.awssdk.services.neptune.model.DbClusterEndpointNotFoundException;
import software.amazon.awssdk.services.neptune.model.DbClusterEndpointQuotaExceededException;
import software.amazon.awssdk.services.neptune.model.DbClusterNotFoundException;
import software.amazon.awssdk.services.neptune.model.DbClusterParameterGroupNotFoundException;
import software.amazon.awssdk.services.neptune.model.DbClusterQuotaExceededException;
import software.amazon.awssdk.services.neptune.model.DbClusterRoleAlreadyExistsException;
import software.amazon.awssdk.services.neptune.model.DbClusterRoleNotFoundException;
import software.amazon.awssdk.services.neptune.model.DbClusterRoleQuotaExceededException;
import software.amazon.awssdk.services.neptune.model.DbClusterSnapshotAlreadyExistsException;
import software.amazon.awssdk.services.neptune.model.DbClusterSnapshotNotFoundException;
import software.amazon.awssdk.services.neptune.model.DbInstanceAlreadyExistsException;
import software.amazon.awssdk.services.neptune.model.DbInstanceNotFoundException;
import software.amazon.awssdk.services.neptune.model.DbParameterGroupAlreadyExistsException;
import software.amazon.awssdk.services.neptune.model.DbParameterGroupNotFoundException;
import software.amazon.awssdk.services.neptune.model.DbParameterGroupQuotaExceededException;
import software.amazon.awssdk.services.neptune.model.DbSecurityGroupNotFoundException;
import software.amazon.awssdk.services.neptune.model.DbSnapshotAlreadyExistsException;
import software.amazon.awssdk.services.neptune.model.DbSnapshotNotFoundException;
import software.amazon.awssdk.services.neptune.model.DbSubnetGroupAlreadyExistsException;
import software.amazon.awssdk.services.neptune.model.DbSubnetGroupDoesNotCoverEnoughAZsException;
import software.amazon.awssdk.services.neptune.model.DbSubnetGroupNotFoundException;
import software.amazon.awssdk.services.neptune.model.DbSubnetGroupQuotaExceededException;
import software.amazon.awssdk.services.neptune.model.DbSubnetQuotaExceededException;
import software.amazon.awssdk.services.neptune.model.DbUpgradeDependencyFailureException;
import software.amazon.awssdk.services.neptune.model.DeleteDbClusterEndpointRequest;
import software.amazon.awssdk.services.neptune.model.DeleteDbClusterEndpointResponse;
import software.amazon.awssdk.services.neptune.model.DeleteDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.neptune.model.DeleteDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.neptune.model.DeleteDbClusterRequest;
import software.amazon.awssdk.services.neptune.model.DeleteDbClusterResponse;
import software.amazon.awssdk.services.neptune.model.DeleteDbClusterSnapshotRequest;
import software.amazon.awssdk.services.neptune.model.DeleteDbClusterSnapshotResponse;
import software.amazon.awssdk.services.neptune.model.DeleteDbInstanceRequest;
import software.amazon.awssdk.services.neptune.model.DeleteDbInstanceResponse;
import software.amazon.awssdk.services.neptune.model.DeleteDbParameterGroupRequest;
import software.amazon.awssdk.services.neptune.model.DeleteDbParameterGroupResponse;
import software.amazon.awssdk.services.neptune.model.DeleteDbSubnetGroupRequest;
import software.amazon.awssdk.services.neptune.model.DeleteDbSubnetGroupResponse;
import software.amazon.awssdk.services.neptune.model.DeleteEventSubscriptionRequest;
import software.amazon.awssdk.services.neptune.model.DeleteEventSubscriptionResponse;
import software.amazon.awssdk.services.neptune.model.DeleteGlobalClusterRequest;
import software.amazon.awssdk.services.neptune.model.DeleteGlobalClusterResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterEndpointsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterEndpointsResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterParameterGroupsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterParameterGroupsResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterParametersRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterParametersResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterSnapshotAttributesRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterSnapshotAttributesResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterSnapshotsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterSnapshotsResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbClustersRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbClustersResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbEngineVersionsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbEngineVersionsResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbInstancesRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbInstancesResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbParameterGroupsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbParameterGroupsResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbParametersRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbParametersResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbSubnetGroupsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbSubnetGroupsResponse;
import software.amazon.awssdk.services.neptune.model.DescribeEngineDefaultClusterParametersRequest;
import software.amazon.awssdk.services.neptune.model.DescribeEngineDefaultClusterParametersResponse;
import software.amazon.awssdk.services.neptune.model.DescribeEngineDefaultParametersRequest;
import software.amazon.awssdk.services.neptune.model.DescribeEngineDefaultParametersResponse;
import software.amazon.awssdk.services.neptune.model.DescribeEventCategoriesRequest;
import software.amazon.awssdk.services.neptune.model.DescribeEventCategoriesResponse;
import software.amazon.awssdk.services.neptune.model.DescribeEventSubscriptionsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeEventSubscriptionsResponse;
import software.amazon.awssdk.services.neptune.model.DescribeEventsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeEventsResponse;
import software.amazon.awssdk.services.neptune.model.DescribeGlobalClustersRequest;
import software.amazon.awssdk.services.neptune.model.DescribeGlobalClustersResponse;
import software.amazon.awssdk.services.neptune.model.DescribeOrderableDbInstanceOptionsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeOrderableDbInstanceOptionsResponse;
import software.amazon.awssdk.services.neptune.model.DescribePendingMaintenanceActionsRequest;
import software.amazon.awssdk.services.neptune.model.DescribePendingMaintenanceActionsResponse;
import software.amazon.awssdk.services.neptune.model.DescribeValidDbInstanceModificationsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeValidDbInstanceModificationsResponse;
import software.amazon.awssdk.services.neptune.model.DomainNotFoundException;
import software.amazon.awssdk.services.neptune.model.EventSubscriptionQuotaExceededException;
import software.amazon.awssdk.services.neptune.model.FailoverDbClusterRequest;
import software.amazon.awssdk.services.neptune.model.FailoverDbClusterResponse;
import software.amazon.awssdk.services.neptune.model.FailoverGlobalClusterRequest;
import software.amazon.awssdk.services.neptune.model.FailoverGlobalClusterResponse;
import software.amazon.awssdk.services.neptune.model.GlobalClusterAlreadyExistsException;
import software.amazon.awssdk.services.neptune.model.GlobalClusterNotFoundException;
import software.amazon.awssdk.services.neptune.model.GlobalClusterQuotaExceededException;
import software.amazon.awssdk.services.neptune.model.InstanceQuotaExceededException;
import software.amazon.awssdk.services.neptune.model.InsufficientDbClusterCapacityException;
import software.amazon.awssdk.services.neptune.model.InsufficientDbInstanceCapacityException;
import software.amazon.awssdk.services.neptune.model.InsufficientStorageClusterCapacityException;
import software.amazon.awssdk.services.neptune.model.InvalidDbClusterEndpointStateException;
import software.amazon.awssdk.services.neptune.model.InvalidDbClusterSnapshotStateException;
import software.amazon.awssdk.services.neptune.model.InvalidDbClusterStateException;
import software.amazon.awssdk.services.neptune.model.InvalidDbInstanceStateException;
import software.amazon.awssdk.services.neptune.model.InvalidDbParameterGroupStateException;
import software.amazon.awssdk.services.neptune.model.InvalidDbSecurityGroupStateException;
import software.amazon.awssdk.services.neptune.model.InvalidDbSnapshotStateException;
import software.amazon.awssdk.services.neptune.model.InvalidDbSubnetGroupStateException;
import software.amazon.awssdk.services.neptune.model.InvalidDbSubnetStateException;
import software.amazon.awssdk.services.neptune.model.InvalidEventSubscriptionStateException;
import software.amazon.awssdk.services.neptune.model.InvalidGlobalClusterStateException;
import software.amazon.awssdk.services.neptune.model.InvalidRestoreException;
import software.amazon.awssdk.services.neptune.model.InvalidSubnetException;
import software.amazon.awssdk.services.neptune.model.InvalidVpcNetworkStateException;
import software.amazon.awssdk.services.neptune.model.KmsKeyNotAccessibleException;
import software.amazon.awssdk.services.neptune.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.neptune.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.neptune.model.ModifyDbClusterEndpointRequest;
import software.amazon.awssdk.services.neptune.model.ModifyDbClusterEndpointResponse;
import software.amazon.awssdk.services.neptune.model.ModifyDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.neptune.model.ModifyDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.neptune.model.ModifyDbClusterRequest;
import software.amazon.awssdk.services.neptune.model.ModifyDbClusterResponse;
import software.amazon.awssdk.services.neptune.model.ModifyDbClusterSnapshotAttributeRequest;
import software.amazon.awssdk.services.neptune.model.ModifyDbClusterSnapshotAttributeResponse;
import software.amazon.awssdk.services.neptune.model.ModifyDbInstanceRequest;
import software.amazon.awssdk.services.neptune.model.ModifyDbInstanceResponse;
import software.amazon.awssdk.services.neptune.model.ModifyDbParameterGroupRequest;
import software.amazon.awssdk.services.neptune.model.ModifyDbParameterGroupResponse;
import software.amazon.awssdk.services.neptune.model.ModifyDbSubnetGroupRequest;
import software.amazon.awssdk.services.neptune.model.ModifyDbSubnetGroupResponse;
import software.amazon.awssdk.services.neptune.model.ModifyEventSubscriptionRequest;
import software.amazon.awssdk.services.neptune.model.ModifyEventSubscriptionResponse;
import software.amazon.awssdk.services.neptune.model.ModifyGlobalClusterRequest;
import software.amazon.awssdk.services.neptune.model.ModifyGlobalClusterResponse;
import software.amazon.awssdk.services.neptune.model.NeptuneException;
import software.amazon.awssdk.services.neptune.model.OptionGroupNotFoundException;
import software.amazon.awssdk.services.neptune.model.PromoteReadReplicaDbClusterRequest;
import software.amazon.awssdk.services.neptune.model.PromoteReadReplicaDbClusterResponse;
import software.amazon.awssdk.services.neptune.model.ProvisionedIopsNotAvailableInAzException;
import software.amazon.awssdk.services.neptune.model.RebootDbInstanceRequest;
import software.amazon.awssdk.services.neptune.model.RebootDbInstanceResponse;
import software.amazon.awssdk.services.neptune.model.RemoveFromGlobalClusterRequest;
import software.amazon.awssdk.services.neptune.model.RemoveFromGlobalClusterResponse;
import software.amazon.awssdk.services.neptune.model.RemoveRoleFromDbClusterRequest;
import software.amazon.awssdk.services.neptune.model.RemoveRoleFromDbClusterResponse;
import software.amazon.awssdk.services.neptune.model.RemoveSourceIdentifierFromSubscriptionRequest;
import software.amazon.awssdk.services.neptune.model.RemoveSourceIdentifierFromSubscriptionResponse;
import software.amazon.awssdk.services.neptune.model.RemoveTagsFromResourceRequest;
import software.amazon.awssdk.services.neptune.model.RemoveTagsFromResourceResponse;
import software.amazon.awssdk.services.neptune.model.ResetDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.neptune.model.ResetDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.neptune.model.ResetDbParameterGroupRequest;
import software.amazon.awssdk.services.neptune.model.ResetDbParameterGroupResponse;
import software.amazon.awssdk.services.neptune.model.ResourceNotFoundException;
import software.amazon.awssdk.services.neptune.model.RestoreDbClusterFromSnapshotRequest;
import software.amazon.awssdk.services.neptune.model.RestoreDbClusterFromSnapshotResponse;
import software.amazon.awssdk.services.neptune.model.RestoreDbClusterToPointInTimeRequest;
import software.amazon.awssdk.services.neptune.model.RestoreDbClusterToPointInTimeResponse;
import software.amazon.awssdk.services.neptune.model.SharedSnapshotQuotaExceededException;
import software.amazon.awssdk.services.neptune.model.SnapshotQuotaExceededException;
import software.amazon.awssdk.services.neptune.model.SnsInvalidTopicException;
import software.amazon.awssdk.services.neptune.model.SnsNoAuthorizationException;
import software.amazon.awssdk.services.neptune.model.SnsTopicArnNotFoundException;
import software.amazon.awssdk.services.neptune.model.SourceNotFoundException;
import software.amazon.awssdk.services.neptune.model.StartDbClusterRequest;
import software.amazon.awssdk.services.neptune.model.StartDbClusterResponse;
import software.amazon.awssdk.services.neptune.model.StopDbClusterRequest;
import software.amazon.awssdk.services.neptune.model.StopDbClusterResponse;
import software.amazon.awssdk.services.neptune.model.StorageQuotaExceededException;
import software.amazon.awssdk.services.neptune.model.StorageTypeNotSupportedException;
import software.amazon.awssdk.services.neptune.model.SubnetAlreadyInUseException;
import software.amazon.awssdk.services.neptune.model.SubscriptionAlreadyExistException;
import software.amazon.awssdk.services.neptune.model.SubscriptionCategoryNotFoundException;
import software.amazon.awssdk.services.neptune.model.SubscriptionNotFoundException;
import software.amazon.awssdk.services.neptune.transform.AddRoleToDbClusterRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.AddSourceIdentifierToSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.AddTagsToResourceRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.ApplyPendingMaintenanceActionRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.CopyDbClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.CopyDbClusterSnapshotRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.CopyDbParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.CreateDbClusterEndpointRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.CreateDbClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.CreateDbClusterRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.CreateDbClusterSnapshotRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.CreateDbInstanceRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.CreateDbParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.CreateDbSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.CreateEventSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.CreateGlobalClusterRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DeleteDbClusterEndpointRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DeleteDbClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DeleteDbClusterRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DeleteDbClusterSnapshotRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DeleteDbInstanceRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DeleteDbParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DeleteDbSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DeleteEventSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DeleteGlobalClusterRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeDbClusterEndpointsRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeDbClusterParameterGroupsRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeDbClusterParametersRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeDbClusterSnapshotAttributesRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeDbClusterSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeDbClustersRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeDbEngineVersionsRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeDbInstancesRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeDbParameterGroupsRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeDbParametersRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeDbSubnetGroupsRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeEngineDefaultClusterParametersRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeEngineDefaultParametersRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeEventCategoriesRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeEventSubscriptionsRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeEventsRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeGlobalClustersRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeOrderableDbInstanceOptionsRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribePendingMaintenanceActionsRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeValidDbInstanceModificationsRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.FailoverDbClusterRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.FailoverGlobalClusterRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.ModifyDbClusterEndpointRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.ModifyDbClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.ModifyDbClusterRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.ModifyDbClusterSnapshotAttributeRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.ModifyDbInstanceRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.ModifyDbParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.ModifyDbSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.ModifyEventSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.ModifyGlobalClusterRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.PromoteReadReplicaDbClusterRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.RebootDbInstanceRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.RemoveFromGlobalClusterRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.RemoveRoleFromDbClusterRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.RemoveSourceIdentifierFromSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.RemoveTagsFromResourceRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.ResetDbClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.ResetDbParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.RestoreDbClusterFromSnapshotRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.RestoreDbClusterToPointInTimeRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.StartDbClusterRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.StopDbClusterRequestMarshaller;
import software.amazon.awssdk.services.neptune.waiters.NeptuneWaiter;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link NeptuneClient}.
 *
 * @see NeptuneClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultNeptuneClient implements NeptuneClient {
    private static final Logger log = Logger.loggerFor(DefaultNeptuneClient.class);

    private final SyncClientHandler clientHandler;

    private final AwsQueryProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    private final NeptuneServiceClientConfiguration serviceClientConfiguration;

    protected DefaultNeptuneClient(NeptuneServiceClientConfiguration serviceClientConfiguration,
            SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = init();
    }

    /**
     * <p>
     * Associates an Identity and Access Management (IAM) role with an Neptune DB cluster.
     * </p>
     *
     * @param addRoleToDbClusterRequest
     * @return Result of the AddRoleToDBCluster operation returned by the service.
     * @throws DbClusterNotFoundException
     *         <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.
     * @throws DbClusterRoleAlreadyExistsException
     *         The specified IAM role Amazon Resource Name (ARN) is already associated with the specified DB cluster.
     * @throws InvalidDbClusterStateException
     *         The DB cluster is not in a valid state.
     * @throws DbClusterRoleQuotaExceededException
     *         You have exceeded the maximum number of IAM roles that can be associated with the specified DB cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.AddRoleToDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/AddRoleToDBCluster" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public AddRoleToDbClusterResponse addRoleToDBCluster(AddRoleToDbClusterRequest addRoleToDbClusterRequest)
            throws DbClusterNotFoundException, DbClusterRoleAlreadyExistsException, InvalidDbClusterStateException,
            DbClusterRoleQuotaExceededException, AwsServiceException, SdkClientException, NeptuneException {

        HttpResponseHandler<AddRoleToDbClusterResponse> responseHandler = protocolFactory
                .createResponseHandler(AddRoleToDbClusterResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addRoleToDbClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddRoleToDBCluster");

            return clientHandler.execute(new ClientExecutionParams<AddRoleToDbClusterRequest, AddRoleToDbClusterResponse>()
                    .withOperationName("AddRoleToDBCluster").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(addRoleToDbClusterRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AddRoleToDbClusterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds a source identifier to an existing event notification subscription.
     * </p>
     *
     * @param addSourceIdentifierToSubscriptionRequest
     * @return Result of the AddSourceIdentifierToSubscription operation returned by the service.
     * @throws SubscriptionNotFoundException
     *         The designated subscription could not be found.
     * @throws SourceNotFoundException
     *         The source could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.AddSourceIdentifierToSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/AddSourceIdentifierToSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AddSourceIdentifierToSubscriptionResponse addSourceIdentifierToSubscription(
            AddSourceIdentifierToSubscriptionRequest addSourceIdentifierToSubscriptionRequest)
            throws SubscriptionNotFoundException, SourceNotFoundException, AwsServiceException, SdkClientException,
            NeptuneException {

        HttpResponseHandler<AddSourceIdentifierToSubscriptionResponse> responseHandler = protocolFactory
                .createResponseHandler(AddSourceIdentifierToSubscriptionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                addSourceIdentifierToSubscriptionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddSourceIdentifierToSubscription");

            return clientHandler
                    .execute(new ClientExecutionParams<AddSourceIdentifierToSubscriptionRequest, AddSourceIdentifierToSubscriptionResponse>()
                            .withOperationName("AddSourceIdentifierToSubscription").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(addSourceIdentifierToSubscriptionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AddSourceIdentifierToSubscriptionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds metadata tags to an Amazon Neptune resource. These tags can also be used with cost allocation reporting to
     * track cost associated with Amazon Neptune resources, or used in a Condition statement in an IAM policy for Amazon
     * Neptune.
     * </p>
     *
     * @param addTagsToResourceRequest
     * @return Result of the AddTagsToResource operation returned by the service.
     * @throws DbInstanceNotFoundException
     *         <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.
     * @throws DbSnapshotNotFoundException
     *         <i>DBSnapshotIdentifier</i> does not refer to an existing DB snapshot.
     * @throws DbClusterNotFoundException
     *         <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.AddTagsToResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/AddTagsToResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public AddTagsToResourceResponse addTagsToResource(AddTagsToResourceRequest addTagsToResourceRequest)
            throws DbInstanceNotFoundException, DbSnapshotNotFoundException, DbClusterNotFoundException, AwsServiceException,
            SdkClientException, NeptuneException {

        HttpResponseHandler<AddTagsToResourceResponse> responseHandler = protocolFactory
                .createResponseHandler(AddTagsToResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addTagsToResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddTagsToResource");

            return clientHandler.execute(new ClientExecutionParams<AddTagsToResourceRequest, AddTagsToResourceResponse>()
                    .withOperationName("AddTagsToResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(addTagsToResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AddTagsToResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Applies a pending maintenance action to a resource (for example, to a DB instance).
     * </p>
     *
     * @param applyPendingMaintenanceActionRequest
     * @return Result of the ApplyPendingMaintenanceAction operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource ID was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.ApplyPendingMaintenanceAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ApplyPendingMaintenanceAction"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ApplyPendingMaintenanceActionResponse applyPendingMaintenanceAction(
            ApplyPendingMaintenanceActionRequest applyPendingMaintenanceActionRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, NeptuneException {

        HttpResponseHandler<ApplyPendingMaintenanceActionResponse> responseHandler = protocolFactory
                .createResponseHandler(ApplyPendingMaintenanceActionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                applyPendingMaintenanceActionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ApplyPendingMaintenanceAction");

            return clientHandler
                    .execute(new ClientExecutionParams<ApplyPendingMaintenanceActionRequest, ApplyPendingMaintenanceActionResponse>()
                            .withOperationName("ApplyPendingMaintenanceAction").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(applyPendingMaintenanceActionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ApplyPendingMaintenanceActionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Copies the specified DB cluster parameter group.
     * </p>
     *
     * @param copyDbClusterParameterGroupRequest
     * @return Result of the CopyDBClusterParameterGroup operation returned by the service.
     * @throws DbParameterGroupNotFoundException
     *         <i>DBParameterGroupName</i> does not refer to an existing DB parameter group.
     * @throws DbParameterGroupQuotaExceededException
     *         Request would result in user exceeding the allowed number of DB parameter groups.
     * @throws DbParameterGroupAlreadyExistsException
     *         A DB parameter group with the same name exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.CopyDBClusterParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CopyDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CopyDbClusterParameterGroupResponse copyDBClusterParameterGroup(
            CopyDbClusterParameterGroupRequest copyDbClusterParameterGroupRequest) throws DbParameterGroupNotFoundException,
            DbParameterGroupQuotaExceededException, DbParameterGroupAlreadyExistsException, AwsServiceException,
            SdkClientException, NeptuneException {

        HttpResponseHandler<CopyDbClusterParameterGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(CopyDbClusterParameterGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, copyDbClusterParameterGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CopyDBClusterParameterGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<CopyDbClusterParameterGroupRequest, CopyDbClusterParameterGroupResponse>()
                            .withOperationName("CopyDBClusterParameterGroup").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(copyDbClusterParameterGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CopyDbClusterParameterGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Copies a snapshot of a DB cluster.
     * </p>
     * <p>
     * To copy a DB cluster snapshot from a shared manual DB cluster snapshot,
     * <code>SourceDBClusterSnapshotIdentifier</code> must be the Amazon Resource Name (ARN) of the shared DB cluster
     * snapshot.
     * </p>
     *
     * @param copyDbClusterSnapshotRequest
     * @return Result of the CopyDBClusterSnapshot operation returned by the service.
     * @throws DbClusterSnapshotAlreadyExistsException
     *         User already has a DB cluster snapshot with the given identifier.
     * @throws DbClusterSnapshotNotFoundException
     *         <i>DBClusterSnapshotIdentifier</i> does not refer to an existing DB cluster snapshot.
     * @throws InvalidDbClusterStateException
     *         The DB cluster is not in a valid state.
     * @throws InvalidDbClusterSnapshotStateException
     *         The supplied value is not a valid DB cluster snapshot state.
     * @throws SnapshotQuotaExceededException
     *         Request would result in user exceeding the allowed number of DB snapshots.
     * @throws KmsKeyNotAccessibleException
     *         Error accessing KMS key.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.CopyDBClusterSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CopyDBClusterSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CopyDbClusterSnapshotResponse copyDBClusterSnapshot(CopyDbClusterSnapshotRequest copyDbClusterSnapshotRequest)
            throws DbClusterSnapshotAlreadyExistsException, DbClusterSnapshotNotFoundException, InvalidDbClusterStateException,
            InvalidDbClusterSnapshotStateException, SnapshotQuotaExceededException, KmsKeyNotAccessibleException,
            AwsServiceException, SdkClientException, NeptuneException {

        HttpResponseHandler<CopyDbClusterSnapshotResponse> responseHandler = protocolFactory
                .createResponseHandler(CopyDbClusterSnapshotResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, copyDbClusterSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CopyDBClusterSnapshot");

            return clientHandler.execute(new ClientExecutionParams<CopyDbClusterSnapshotRequest, CopyDbClusterSnapshotResponse>()
                    .withOperationName("CopyDBClusterSnapshot").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(copyDbClusterSnapshotRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CopyDbClusterSnapshotRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Copies the specified DB parameter group.
     * </p>
     *
     * @param copyDbParameterGroupRequest
     * @return Result of the CopyDBParameterGroup operation returned by the service.
     * @throws DbParameterGroupNotFoundException
     *         <i>DBParameterGroupName</i> does not refer to an existing DB parameter group.
     * @throws DbParameterGroupAlreadyExistsException
     *         A DB parameter group with the same name exists.
     * @throws DbParameterGroupQuotaExceededException
     *         Request would result in user exceeding the allowed number of DB parameter groups.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.CopyDBParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CopyDBParameterGroup" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CopyDbParameterGroupResponse copyDBParameterGroup(CopyDbParameterGroupRequest copyDbParameterGroupRequest)
            throws DbParameterGroupNotFoundException, DbParameterGroupAlreadyExistsException,
            DbParameterGroupQuotaExceededException, AwsServiceException, SdkClientException, NeptuneException {

        HttpResponseHandler<CopyDbParameterGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(CopyDbParameterGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, copyDbParameterGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CopyDBParameterGroup");

            return clientHandler.execute(new ClientExecutionParams<CopyDbParameterGroupRequest, CopyDbParameterGroupResponse>()
                    .withOperationName("CopyDBParameterGroup").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(copyDbParameterGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CopyDbParameterGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new Amazon Neptune DB cluster.
     * </p>
     * <p>
     * You can use the <code>ReplicationSourceIdentifier</code> parameter to create the DB cluster as a Read Replica of
     * another DB cluster or Amazon Neptune DB instance.
     * </p>
     * <p>
     * Note that when you create a new cluster using <code>CreateDBCluster</code> directly, deletion protection is
     * disabled by default (when you create a new production cluster in the console, deletion protection is enabled by
     * default). You can only delete a DB cluster if its <code>DeletionProtection</code> field is set to
     * <code>false</code>.
     * </p>
     *
     * @param createDbClusterRequest
     * @return Result of the CreateDBCluster operation returned by the service.
     * @throws DbClusterAlreadyExistsException
     *         User already has a DB cluster with the given identifier.
     * @throws InsufficientStorageClusterCapacityException
     *         There is insufficient storage available for the current action. You may be able to resolve this error by
     *         updating your subnet group to use different Availability Zones that have more storage available.
     * @throws DbClusterQuotaExceededException
     *         User attempted to create a new DB cluster and the user has already reached the maximum allowed DB cluster
     *         quota.
     * @throws StorageQuotaExceededException
     *         Request would result in user exceeding the allowed amount of storage available across all DB instances.
     * @throws DbSubnetGroupNotFoundException
     *         <i>DBSubnetGroupName</i> does not refer to an existing DB subnet group.
     * @throws InvalidVpcNetworkStateException
     *         DB subnet group does not cover all Availability Zones after it is created because users' change.
     * @throws InvalidDbClusterStateException
     *         The DB cluster is not in a valid state.
     * @throws InvalidDbSubnetGroupStateException
     *         The DB subnet group cannot be deleted because it is in use.
     * @throws InvalidSubnetException
     *         The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.
     * @throws InvalidDbInstanceStateException
     *         The specified DB instance is not in the <i>available</i> state.
     * @throws DbClusterParameterGroupNotFoundException
     *         <i>DBClusterParameterGroupName</i> does not refer to an existing DB Cluster parameter group.
     * @throws KmsKeyNotAccessibleException
     *         Error accessing KMS key.
     * @throws DbClusterNotFoundException
     *         <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.
     * @throws DbInstanceNotFoundException
     *         <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.
     * @throws DbSubnetGroupDoesNotCoverEnoughAZsException
     *         Subnets in the DB subnet group should cover at least two Availability Zones unless there is only one
     *         Availability Zone.
     * @throws GlobalClusterNotFoundException
     *         The <code>GlobalClusterIdentifier</code> doesn't refer to an existing global database cluster.
     * @throws InvalidGlobalClusterStateException
     *         The global cluster is in an invalid state and can't perform the requested operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.CreateDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CreateDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateDbClusterResponse createDBCluster(CreateDbClusterRequest createDbClusterRequest)
            throws DbClusterAlreadyExistsException, InsufficientStorageClusterCapacityException, DbClusterQuotaExceededException,
            StorageQuotaExceededException, DbSubnetGroupNotFoundException, InvalidVpcNetworkStateException,
            InvalidDbClusterStateException, InvalidDbSubnetGroupStateException, InvalidSubnetException,
            InvalidDbInstanceStateException, DbClusterParameterGroupNotFoundException, KmsKeyNotAccessibleException,
            DbClusterNotFoundException, DbInstanceNotFoundException, DbSubnetGroupDoesNotCoverEnoughAZsException,
            GlobalClusterNotFoundException, InvalidGlobalClusterStateException, AwsServiceException, SdkClientException,
            NeptuneException {

        HttpResponseHandler<CreateDbClusterResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateDbClusterResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDbClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDBCluster");

            return clientHandler.execute(new ClientExecutionParams<CreateDbClusterRequest, CreateDbClusterResponse>()
                    .withOperationName("CreateDBCluster").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createDbClusterRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateDbClusterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new custom endpoint and associates it with an Amazon Neptune DB cluster.
     * </p>
     *
     * @param createDbClusterEndpointRequest
     * @return Result of the CreateDBClusterEndpoint operation returned by the service.
     * @throws DbClusterEndpointQuotaExceededException
     *         The cluster already has the maximum number of custom endpoints.
     * @throws DbClusterEndpointAlreadyExistsException
     *         The specified custom endpoint cannot be created because it already exists.
     * @throws DbClusterNotFoundException
     *         <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.
     * @throws InvalidDbClusterStateException
     *         The DB cluster is not in a valid state.
     * @throws DbInstanceNotFoundException
     *         <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.
     * @throws InvalidDbInstanceStateException
     *         The specified DB instance is not in the <i>available</i> state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.CreateDBClusterEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CreateDBClusterEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateDbClusterEndpointResponse createDBClusterEndpoint(CreateDbClusterEndpointRequest createDbClusterEndpointRequest)
            throws DbClusterEndpointQuotaExceededException, DbClusterEndpointAlreadyExistsException, DbClusterNotFoundException,
            InvalidDbClusterStateException, DbInstanceNotFoundException, InvalidDbInstanceStateException, AwsServiceException,
            SdkClientException, NeptuneException {

        HttpResponseHandler<CreateDbClusterEndpointResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateDbClusterEndpointResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDbClusterEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDBClusterEndpoint");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateDbClusterEndpointRequest, CreateDbClusterEndpointResponse>()
                            .withOperationName("CreateDBClusterEndpoint").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createDbClusterEndpointRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateDbClusterEndpointRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new DB cluster parameter group.
     * </p>
     * <p>
     * Parameters in a DB cluster parameter group apply to all of the instances in a DB cluster.
     * </p>
     * <p>
     * A DB cluster parameter group is initially created with the default parameters for the database engine used by
     * instances in the DB cluster. To provide custom values for any of the parameters, you must modify the group after
     * creating it using <a>ModifyDBClusterParameterGroup</a>. Once you've created a DB cluster parameter group, you
     * need to associate it with your DB cluster using <a>ModifyDBCluster</a>. When you associate a new DB cluster
     * parameter group with a running DB cluster, you need to reboot the DB instances in the DB cluster without failover
     * for the new DB cluster parameter group and associated settings to take effect.
     * </p>
     * <important>
     * <p>
     * After you create a DB cluster parameter group, you should wait at least 5 minutes before creating your first DB
     * cluster that uses that DB cluster parameter group as the default parameter group. This allows Amazon Neptune to
     * fully complete the create action before the DB cluster parameter group is used as the default for a new DB
     * cluster. This is especially important for parameters that are critical when creating the default database for a
     * DB cluster, such as the character set for the default database defined by the <code>character_set_database</code>
     * parameter. You can use the <i>Parameter Groups</i> option of the <a
     * href="https://console.aws.amazon.com/rds/">Amazon Neptune console</a> or the <a>DescribeDBClusterParameters</a>
     * command to verify that your DB cluster parameter group has been created or modified.
     * </p>
     * </important>
     *
     * @param createDbClusterParameterGroupRequest
     * @return Result of the CreateDBClusterParameterGroup operation returned by the service.
     * @throws DbParameterGroupQuotaExceededException
     *         Request would result in user exceeding the allowed number of DB parameter groups.
     * @throws DbParameterGroupAlreadyExistsException
     *         A DB parameter group with the same name exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.CreateDBClusterParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CreateDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateDbClusterParameterGroupResponse createDBClusterParameterGroup(
            CreateDbClusterParameterGroupRequest createDbClusterParameterGroupRequest)
            throws DbParameterGroupQuotaExceededException, DbParameterGroupAlreadyExistsException, AwsServiceException,
            SdkClientException, NeptuneException {

        HttpResponseHandler<CreateDbClusterParameterGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateDbClusterParameterGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createDbClusterParameterGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDBClusterParameterGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateDbClusterParameterGroupRequest, CreateDbClusterParameterGroupResponse>()
                            .withOperationName("CreateDBClusterParameterGroup").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createDbClusterParameterGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateDbClusterParameterGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a snapshot of a DB cluster.
     * </p>
     *
     * @param createDbClusterSnapshotRequest
     * @return Result of the CreateDBClusterSnapshot operation returned by the service.
     * @throws DbClusterSnapshotAlreadyExistsException
     *         User already has a DB cluster snapshot with the given identifier.
     * @throws InvalidDbClusterStateException
     *         The DB cluster is not in a valid state.
     * @throws DbClusterNotFoundException
     *         <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.
     * @throws SnapshotQuotaExceededException
     *         Request would result in user exceeding the allowed number of DB snapshots.
     * @throws InvalidDbClusterSnapshotStateException
     *         The supplied value is not a valid DB cluster snapshot state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.CreateDBClusterSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CreateDBClusterSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateDbClusterSnapshotResponse createDBClusterSnapshot(CreateDbClusterSnapshotRequest createDbClusterSnapshotRequest)
            throws DbClusterSnapshotAlreadyExistsException, InvalidDbClusterStateException, DbClusterNotFoundException,
            SnapshotQuotaExceededException, InvalidDbClusterSnapshotStateException, AwsServiceException, SdkClientException,
            NeptuneException {

        HttpResponseHandler<CreateDbClusterSnapshotResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateDbClusterSnapshotResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDbClusterSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDBClusterSnapshot");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateDbClusterSnapshotRequest, CreateDbClusterSnapshotResponse>()
                            .withOperationName("CreateDBClusterSnapshot").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createDbClusterSnapshotRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateDbClusterSnapshotRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new DB instance.
     * </p>
     *
     * @param createDbInstanceRequest
     * @return Result of the CreateDBInstance operation returned by the service.
     * @throws DbInstanceAlreadyExistsException
     *         User already has a DB instance with the given identifier.
     * @throws InsufficientDbInstanceCapacityException
     *         Specified DB instance class is not available in the specified Availability Zone.
     * @throws DbParameterGroupNotFoundException
     *         <i>DBParameterGroupName</i> does not refer to an existing DB parameter group.
     * @throws DbSecurityGroupNotFoundException
     *         <i>DBSecurityGroupName</i> does not refer to an existing DB security group.
     * @throws InstanceQuotaExceededException
     *         Request would result in user exceeding the allowed number of DB instances.
     * @throws StorageQuotaExceededException
     *         Request would result in user exceeding the allowed amount of storage available across all DB instances.
     * @throws DbSubnetGroupNotFoundException
     *         <i>DBSubnetGroupName</i> does not refer to an existing DB subnet group.
     * @throws DbSubnetGroupDoesNotCoverEnoughAZsException
     *         Subnets in the DB subnet group should cover at least two Availability Zones unless there is only one
     *         Availability Zone.
     * @throws InvalidDbClusterStateException
     *         The DB cluster is not in a valid state.
     * @throws InvalidSubnetException
     *         The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.
     * @throws InvalidVpcNetworkStateException
     *         DB subnet group does not cover all Availability Zones after it is created because users' change.
     * @throws ProvisionedIopsNotAvailableInAzException
     *         Provisioned IOPS not available in the specified Availability Zone.
     * @throws OptionGroupNotFoundException
     *         The designated option group could not be found.
     * @throws DbClusterNotFoundException
     *         <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.
     * @throws StorageTypeNotSupportedException
     *         <i>StorageType</i> specified cannot be associated with the DB Instance.
     * @throws AuthorizationNotFoundException
     *         Specified CIDRIP or EC2 security group is not authorized for the specified DB security group.</p>
     *         <p>
     *         Neptune may not also be authorized via IAM to perform necessary actions on your behalf.
     * @throws KmsKeyNotAccessibleException
     *         Error accessing KMS key.
     * @throws DomainNotFoundException
     *         <i>Domain</i> does not refer to an existing Active Directory Domain.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.CreateDBInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CreateDBInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateDbInstanceResponse createDBInstance(CreateDbInstanceRequest createDbInstanceRequest)
            throws DbInstanceAlreadyExistsException, InsufficientDbInstanceCapacityException, DbParameterGroupNotFoundException,
            DbSecurityGroupNotFoundException, InstanceQuotaExceededException, StorageQuotaExceededException,
            DbSubnetGroupNotFoundException, DbSubnetGroupDoesNotCoverEnoughAZsException, InvalidDbClusterStateException,
            InvalidSubnetException, InvalidVpcNetworkStateException, ProvisionedIopsNotAvailableInAzException,
            OptionGroupNotFoundException, DbClusterNotFoundException, StorageTypeNotSupportedException,
            AuthorizationNotFoundException, KmsKeyNotAccessibleException, DomainNotFoundException, AwsServiceException,
            SdkClientException, NeptuneException {

        HttpResponseHandler<CreateDbInstanceResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateDbInstanceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDbInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDBInstance");

            return clientHandler.execute(new ClientExecutionParams<CreateDbInstanceRequest, CreateDbInstanceResponse>()
                    .withOperationName("CreateDBInstance").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createDbInstanceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateDbInstanceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new DB parameter group.
     * </p>
     * <p>
     * A DB parameter group is initially created with the default parameters for the database engine used by the DB
     * instance. To provide custom values for any of the parameters, you must modify the group after creating it using
     * <i>ModifyDBParameterGroup</i>. Once you've created a DB parameter group, you need to associate it with your DB
     * instance using <i>ModifyDBInstance</i>. When you associate a new DB parameter group with a running DB instance,
     * you need to reboot the DB instance without failover for the new DB parameter group and associated settings to
     * take effect.
     * </p>
     * <important>
     * <p>
     * After you create a DB parameter group, you should wait at least 5 minutes before creating your first DB instance
     * that uses that DB parameter group as the default parameter group. This allows Amazon Neptune to fully complete
     * the create action before the parameter group is used as the default for a new DB instance. This is especially
     * important for parameters that are critical when creating the default database for a DB instance, such as the
     * character set for the default database defined by the <code>character_set_database</code> parameter. You can use
     * the <i>Parameter Groups</i> option of the Amazon Neptune console or the <i>DescribeDBParameters</i> command to
     * verify that your DB parameter group has been created or modified.
     * </p>
     * </important>
     *
     * @param createDbParameterGroupRequest
     * @return Result of the CreateDBParameterGroup operation returned by the service.
     * @throws DbParameterGroupQuotaExceededException
     *         Request would result in user exceeding the allowed number of DB parameter groups.
     * @throws DbParameterGroupAlreadyExistsException
     *         A DB parameter group with the same name exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.CreateDBParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CreateDBParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateDbParameterGroupResponse createDBParameterGroup(CreateDbParameterGroupRequest createDbParameterGroupRequest)
            throws DbParameterGroupQuotaExceededException, DbParameterGroupAlreadyExistsException, AwsServiceException,
            SdkClientException, NeptuneException {

        HttpResponseHandler<CreateDbParameterGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateDbParameterGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDbParameterGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDBParameterGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateDbParameterGroupRequest, CreateDbParameterGroupResponse>()
                            .withOperationName("CreateDBParameterGroup").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createDbParameterGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateDbParameterGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new DB subnet group. DB subnet groups must contain at least one subnet in at least two AZs in the
     * Amazon Region.
     * </p>
     *
     * @param createDbSubnetGroupRequest
     * @return Result of the CreateDBSubnetGroup operation returned by the service.
     * @throws DbSubnetGroupAlreadyExistsException
     *         <i>DBSubnetGroupName</i> is already used by an existing DB subnet group.
     * @throws DbSubnetGroupQuotaExceededException
     *         Request would result in user exceeding the allowed number of DB subnet groups.
     * @throws DbSubnetQuotaExceededException
     *         Request would result in user exceeding the allowed number of subnets in a DB subnet groups.
     * @throws DbSubnetGroupDoesNotCoverEnoughAZsException
     *         Subnets in the DB subnet group should cover at least two Availability Zones unless there is only one
     *         Availability Zone.
     * @throws InvalidSubnetException
     *         The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.CreateDBSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CreateDBSubnetGroup" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateDbSubnetGroupResponse createDBSubnetGroup(CreateDbSubnetGroupRequest createDbSubnetGroupRequest)
            throws DbSubnetGroupAlreadyExistsException, DbSubnetGroupQuotaExceededException, DbSubnetQuotaExceededException,
            DbSubnetGroupDoesNotCoverEnoughAZsException, InvalidSubnetException, AwsServiceException, SdkClientException,
            NeptuneException {

        HttpResponseHandler<CreateDbSubnetGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateDbSubnetGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDbSubnetGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDBSubnetGroup");

            return clientHandler.execute(new ClientExecutionParams<CreateDbSubnetGroupRequest, CreateDbSubnetGroupResponse>()
                    .withOperationName("CreateDBSubnetGroup").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createDbSubnetGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateDbSubnetGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an event notification subscription. This action requires a topic ARN (Amazon Resource Name) created by
     * either the Neptune console, the SNS console, or the SNS API. To obtain an ARN with SNS, you must create a topic
     * in Amazon SNS and subscribe to the topic. The ARN is displayed in the SNS console.
     * </p>
     * <p>
     * You can specify the type of source (SourceType) you want to be notified of, provide a list of Neptune sources
     * (SourceIds) that triggers the events, and provide a list of event categories (EventCategories) for events you
     * want to be notified of. For example, you can specify SourceType = db-instance, SourceIds = mydbinstance1,
     * mydbinstance2 and EventCategories = Availability, Backup.
     * </p>
     * <p>
     * If you specify both the SourceType and SourceIds, such as SourceType = db-instance and SourceIdentifier =
     * myDBInstance1, you are notified of all the db-instance events for the specified source. If you specify a
     * SourceType but do not specify a SourceIdentifier, you receive notice of the events for that source type for all
     * your Neptune sources. If you do not specify either the SourceType nor the SourceIdentifier, you are notified of
     * events generated from all Neptune sources belonging to your customer account.
     * </p>
     *
     * @param createEventSubscriptionRequest
     * @return Result of the CreateEventSubscription operation returned by the service.
     * @throws EventSubscriptionQuotaExceededException
     *         You have exceeded the number of events you can subscribe to.
     * @throws SubscriptionAlreadyExistException
     *         This subscription already exists.
     * @throws SnsInvalidTopicException
     *         The SNS topic is invalid.
     * @throws SnsNoAuthorizationException
     *         There is no SNS authorization.
     * @throws SnsTopicArnNotFoundException
     *         The ARN of the SNS topic could not be found.
     * @throws SubscriptionCategoryNotFoundException
     *         The designated subscription category could not be found.
     * @throws SourceNotFoundException
     *         The source could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.CreateEventSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CreateEventSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateEventSubscriptionResponse createEventSubscription(CreateEventSubscriptionRequest createEventSubscriptionRequest)
            throws EventSubscriptionQuotaExceededException, SubscriptionAlreadyExistException, SnsInvalidTopicException,
            SnsNoAuthorizationException, SnsTopicArnNotFoundException, SubscriptionCategoryNotFoundException,
            SourceNotFoundException, AwsServiceException, SdkClientException, NeptuneException {

        HttpResponseHandler<CreateEventSubscriptionResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateEventSubscriptionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createEventSubscriptionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateEventSubscription");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateEventSubscriptionRequest, CreateEventSubscriptionResponse>()
                            .withOperationName("CreateEventSubscription").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createEventSubscriptionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateEventSubscriptionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a Neptune global database spread across multiple Amazon Regions. The global database contains a single
     * primary cluster with read-write capability, and read-only secondary clusters that receive data from the primary
     * cluster through high-speed replication performed by the Neptune storage subsystem.
     * </p>
     * <p>
     * You can create a global database that is initially empty, and then add a primary cluster and secondary clusters
     * to it, or you can specify an existing Neptune cluster during the create operation to become the primary cluster
     * of the global database.
     * </p>
     *
     * @param createGlobalClusterRequest
     * @return Result of the CreateGlobalCluster operation returned by the service.
     * @throws GlobalClusterAlreadyExistsException
     *         The <code>GlobalClusterIdentifier</code> already exists. Choose a new global database identifier (unique
     *         name) to create a new global database cluster.
     * @throws GlobalClusterQuotaExceededException
     *         The number of global database clusters for this account is already at the maximum allowed.
     * @throws InvalidDbClusterStateException
     *         The DB cluster is not in a valid state.
     * @throws DbClusterNotFoundException
     *         <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.CreateGlobalCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CreateGlobalCluster" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateGlobalClusterResponse createGlobalCluster(CreateGlobalClusterRequest createGlobalClusterRequest)
            throws GlobalClusterAlreadyExistsException, GlobalClusterQuotaExceededException, InvalidDbClusterStateException,
            DbClusterNotFoundException, AwsServiceException, SdkClientException, NeptuneException {

        HttpResponseHandler<CreateGlobalClusterResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateGlobalClusterResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createGlobalClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateGlobalCluster");

            return clientHandler.execute(new ClientExecutionParams<CreateGlobalClusterRequest, CreateGlobalClusterResponse>()
                    .withOperationName("CreateGlobalCluster").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createGlobalClusterRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateGlobalClusterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * The DeleteDBCluster action deletes a previously provisioned DB cluster. When you delete a DB cluster, all
     * automated backups for that DB cluster are deleted and can't be recovered. Manual DB cluster snapshots of the
     * specified DB cluster are not deleted.
     * </p>
     * <p>
     * Note that the DB Cluster cannot be deleted if deletion protection is enabled. To delete it, you must first set
     * its <code>DeletionProtection</code> field to <code>False</code>.
     * </p>
     *
     * @param deleteDbClusterRequest
     * @return Result of the DeleteDBCluster operation returned by the service.
     * @throws DbClusterNotFoundException
     *         <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.
     * @throws InvalidDbClusterStateException
     *         The DB cluster is not in a valid state.
     * @throws DbClusterSnapshotAlreadyExistsException
     *         User already has a DB cluster snapshot with the given identifier.
     * @throws SnapshotQuotaExceededException
     *         Request would result in user exceeding the allowed number of DB snapshots.
     * @throws InvalidDbClusterSnapshotStateException
     *         The supplied value is not a valid DB cluster snapshot state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.DeleteDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DeleteDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteDbClusterResponse deleteDBCluster(DeleteDbClusterRequest deleteDbClusterRequest)
            throws DbClusterNotFoundException, InvalidDbClusterStateException, DbClusterSnapshotAlreadyExistsException,
            SnapshotQuotaExceededException, InvalidDbClusterSnapshotStateException, AwsServiceException, SdkClientException,
            NeptuneException {

        HttpResponseHandler<DeleteDbClusterResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteDbClusterResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDbClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDBCluster");

            return clientHandler.execute(new ClientExecutionParams<DeleteDbClusterRequest, DeleteDbClusterResponse>()
                    .withOperationName("DeleteDBCluster").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteDbClusterRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteDbClusterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a custom endpoint and removes it from an Amazon Neptune DB cluster.
     * </p>
     *
     * @param deleteDbClusterEndpointRequest
     * @return Result of the DeleteDBClusterEndpoint operation returned by the service.
     * @throws InvalidDbClusterEndpointStateException
     *         The requested operation cannot be performed on the endpoint while the endpoint is in this state.
     * @throws DbClusterEndpointNotFoundException
     *         The specified custom endpoint doesn't exist.
     * @throws InvalidDbClusterStateException
     *         The DB cluster is not in a valid state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.DeleteDBClusterEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DeleteDBClusterEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteDbClusterEndpointResponse deleteDBClusterEndpoint(DeleteDbClusterEndpointRequest deleteDbClusterEndpointRequest)
            throws InvalidDbClusterEndpointStateException, DbClusterEndpointNotFoundException, InvalidDbClusterStateException,
            AwsServiceException, SdkClientException, NeptuneException {

        HttpResponseHandler<DeleteDbClusterEndpointResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteDbClusterEndpointResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDbClusterEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDBClusterEndpoint");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteDbClusterEndpointRequest, DeleteDbClusterEndpointResponse>()
                            .withOperationName("DeleteDBClusterEndpoint").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteDbClusterEndpointRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteDbClusterEndpointRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a specified DB cluster parameter group. The DB cluster parameter group to be deleted can't be associated
     * with any DB clusters.
     * </p>
     *
     * @param deleteDbClusterParameterGroupRequest
     * @return Result of the DeleteDBClusterParameterGroup operation returned by the service.
     * @throws InvalidDbParameterGroupStateException
     *         The DB parameter group is in use or is in an invalid state. If you are attempting to delete the parameter
     *         group, you cannot delete it when the parameter group is in this state.
     * @throws DbParameterGroupNotFoundException
     *         <i>DBParameterGroupName</i> does not refer to an existing DB parameter group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.DeleteDBClusterParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DeleteDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteDbClusterParameterGroupResponse deleteDBClusterParameterGroup(
            DeleteDbClusterParameterGroupRequest deleteDbClusterParameterGroupRequest)
            throws InvalidDbParameterGroupStateException, DbParameterGroupNotFoundException, AwsServiceException,
            SdkClientException, NeptuneException {

        HttpResponseHandler<DeleteDbClusterParameterGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteDbClusterParameterGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteDbClusterParameterGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDBClusterParameterGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteDbClusterParameterGroupRequest, DeleteDbClusterParameterGroupResponse>()
                            .withOperationName("DeleteDBClusterParameterGroup").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteDbClusterParameterGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteDbClusterParameterGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a DB cluster snapshot. If the snapshot is being copied, the copy operation is terminated.
     * </p>
     * <note>
     * <p>
     * The DB cluster snapshot must be in the <code>available</code> state to be deleted.
     * </p>
     * </note>
     *
     * @param deleteDbClusterSnapshotRequest
     * @return Result of the DeleteDBClusterSnapshot operation returned by the service.
     * @throws InvalidDbClusterSnapshotStateException
     *         The supplied value is not a valid DB cluster snapshot state.
     * @throws DbClusterSnapshotNotFoundException
     *         <i>DBClusterSnapshotIdentifier</i> does not refer to an existing DB cluster snapshot.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.DeleteDBClusterSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DeleteDBClusterSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteDbClusterSnapshotResponse deleteDBClusterSnapshot(DeleteDbClusterSnapshotRequest deleteDbClusterSnapshotRequest)
            throws InvalidDbClusterSnapshotStateException, DbClusterSnapshotNotFoundException, AwsServiceException,
            SdkClientException, NeptuneException {

        HttpResponseHandler<DeleteDbClusterSnapshotResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteDbClusterSnapshotResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDbClusterSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDBClusterSnapshot");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteDbClusterSnapshotRequest, DeleteDbClusterSnapshotResponse>()
                            .withOperationName("DeleteDBClusterSnapshot").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteDbClusterSnapshotRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteDbClusterSnapshotRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * The DeleteDBInstance action deletes a previously provisioned DB instance. When you delete a DB instance, all
     * automated backups for that instance are deleted and can't be recovered. Manual DB snapshots of the DB instance to
     * be deleted by <code>DeleteDBInstance</code> are not deleted.
     * </p>
     * <p>
     * If you request a final DB snapshot the status of the Amazon Neptune DB instance is <code>deleting</code> until
     * the DB snapshot is created. The API action <code>DescribeDBInstance</code> is used to monitor the status of this
     * operation. The action can't be canceled or reverted once submitted.
     * </p>
     * <p>
     * Note that when a DB instance is in a failure state and has a status of <code>failed</code>,
     * <code>incompatible-restore</code>, or <code>incompatible-network</code>, you can only delete it when the
     * <code>SkipFinalSnapshot</code> parameter is set to <code>true</code>.
     * </p>
     * <p>
     * You can't delete a DB instance if it is the only instance in the DB cluster, or if it has deletion protection
     * enabled.
     * </p>
     *
     * @param deleteDbInstanceRequest
     * @return Result of the DeleteDBInstance operation returned by the service.
     * @throws DbInstanceNotFoundException
     *         <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.
     * @throws InvalidDbInstanceStateException
     *         The specified DB instance is not in the <i>available</i> state.
     * @throws DbSnapshotAlreadyExistsException
     *         <i>DBSnapshotIdentifier</i> is already used by an existing snapshot.
     * @throws SnapshotQuotaExceededException
     *         Request would result in user exceeding the allowed number of DB snapshots.
     * @throws InvalidDbClusterStateException
     *         The DB cluster is not in a valid state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.DeleteDBInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DeleteDBInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteDbInstanceResponse deleteDBInstance(DeleteDbInstanceRequest deleteDbInstanceRequest)
            throws DbInstanceNotFoundException, InvalidDbInstanceStateException, DbSnapshotAlreadyExistsException,
            SnapshotQuotaExceededException, InvalidDbClusterStateException, AwsServiceException, SdkClientException,
            NeptuneException {

        HttpResponseHandler<DeleteDbInstanceResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteDbInstanceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDbInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDBInstance");

            return clientHandler.execute(new ClientExecutionParams<DeleteDbInstanceRequest, DeleteDbInstanceResponse>()
                    .withOperationName("DeleteDBInstance").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteDbInstanceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteDbInstanceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a specified DBParameterGroup. The DBParameterGroup to be deleted can't be associated with any DB
     * instances.
     * </p>
     *
     * @param deleteDbParameterGroupRequest
     * @return Result of the DeleteDBParameterGroup operation returned by the service.
     * @throws InvalidDbParameterGroupStateException
     *         The DB parameter group is in use or is in an invalid state. If you are attempting to delete the parameter
     *         group, you cannot delete it when the parameter group is in this state.
     * @throws DbParameterGroupNotFoundException
     *         <i>DBParameterGroupName</i> does not refer to an existing DB parameter group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.DeleteDBParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DeleteDBParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteDbParameterGroupResponse deleteDBParameterGroup(DeleteDbParameterGroupRequest deleteDbParameterGroupRequest)
            throws InvalidDbParameterGroupStateException, DbParameterGroupNotFoundException, AwsServiceException,
            SdkClientException, NeptuneException {

        HttpResponseHandler<DeleteDbParameterGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteDbParameterGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDbParameterGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDBParameterGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteDbParameterGroupRequest, DeleteDbParameterGroupResponse>()
                            .withOperationName("DeleteDBParameterGroup").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteDbParameterGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteDbParameterGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a DB subnet group.
     * </p>
     * <note>
     * <p>
     * The specified database subnet group must not be associated with any DB instances.
     * </p>
     * </note>
     *
     * @param deleteDbSubnetGroupRequest
     * @return Result of the DeleteDBSubnetGroup operation returned by the service.
     * @throws InvalidDbSubnetGroupStateException
     *         The DB subnet group cannot be deleted because it is in use.
     * @throws InvalidDbSubnetStateException
     *         The DB subnet is not in the <i>available</i> state.
     * @throws DbSubnetGroupNotFoundException
     *         <i>DBSubnetGroupName</i> does not refer to an existing DB subnet group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.DeleteDBSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DeleteDBSubnetGroup" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteDbSubnetGroupResponse deleteDBSubnetGroup(DeleteDbSubnetGroupRequest deleteDbSubnetGroupRequest)
            throws InvalidDbSubnetGroupStateException, InvalidDbSubnetStateException, DbSubnetGroupNotFoundException,
            AwsServiceException, SdkClientException, NeptuneException {

        HttpResponseHandler<DeleteDbSubnetGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteDbSubnetGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDbSubnetGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDBSubnetGroup");

            return clientHandler.execute(new ClientExecutionParams<DeleteDbSubnetGroupRequest, DeleteDbSubnetGroupResponse>()
                    .withOperationName("DeleteDBSubnetGroup").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteDbSubnetGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteDbSubnetGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an event notification subscription.
     * </p>
     *
     * @param deleteEventSubscriptionRequest
     * @return Result of the DeleteEventSubscription operation returned by the service.
     * @throws SubscriptionNotFoundException
     *         The designated subscription could not be found.
     * @throws InvalidEventSubscriptionStateException
     *         The event subscription is in an invalid state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.DeleteEventSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DeleteEventSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteEventSubscriptionResponse deleteEventSubscription(DeleteEventSubscriptionRequest deleteEventSubscriptionRequest)
            throws SubscriptionNotFoundException, InvalidEventSubscriptionStateException, AwsServiceException,
            SdkClientException, NeptuneException {

        HttpResponseHandler<DeleteEventSubscriptionResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteEventSubscriptionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEventSubscriptionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEventSubscription");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteEventSubscriptionRequest, DeleteEventSubscriptionResponse>()
                            .withOperationName("DeleteEventSubscription").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteEventSubscriptionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteEventSubscriptionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a global database. The primary and all secondary clusters must already be detached or deleted first.
     * </p>
     *
     * @param deleteGlobalClusterRequest
     * @return Result of the DeleteGlobalCluster operation returned by the service.
     * @throws GlobalClusterNotFoundException
     *         The <code>GlobalClusterIdentifier</code> doesn't refer to an existing global database cluster.
     * @throws InvalidGlobalClusterStateException
     *         The global cluster is in an invalid state and can't perform the requested operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.DeleteGlobalCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DeleteGlobalCluster" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteGlobalClusterResponse deleteGlobalCluster(DeleteGlobalClusterRequest deleteGlobalClusterRequest)
            throws GlobalClusterNotFoundException, InvalidGlobalClusterStateException, AwsServiceException, SdkClientException,
            NeptuneException {

        HttpResponseHandler<DeleteGlobalClusterResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteGlobalClusterResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteGlobalClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteGlobalCluster");

            return clientHandler.execute(new ClientExecutionParams<DeleteGlobalClusterRequest, DeleteGlobalClusterResponse>()
                    .withOperationName("DeleteGlobalCluster").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteGlobalClusterRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteGlobalClusterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about endpoints for an Amazon Neptune DB cluster.
     * </p>
     * <note>
     * <p>
     * This operation can also return information for Amazon RDS clusters and Amazon DocDB clusters.
     * </p>
     * </note>
     *
     * @param describeDbClusterEndpointsRequest
     * @return Result of the DescribeDBClusterEndpoints operation returned by the service.
     * @throws DbClusterNotFoundException
     *         <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.DescribeDBClusterEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBClusterEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeDbClusterEndpointsResponse describeDBClusterEndpoints(
            DescribeDbClusterEndpointsRequest describeDbClusterEndpointsRequest) throws DbClusterNotFoundException,
            AwsServiceException, SdkClientException, NeptuneException {

        HttpResponseHandler<DescribeDbClusterEndpointsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeDbClusterEndpointsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDbClusterEndpointsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDBClusterEndpoints");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeDbClusterEndpointsRequest, DescribeDbClusterEndpointsResponse>()
                            .withOperationName("DescribeDBClusterEndpoints").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeDbClusterEndpointsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeDbClusterEndpointsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of <code>DBClusterParameterGroup</code> descriptions. If a
     * <code>DBClusterParameterGroupName</code> parameter is specified, the list will contain only the description of
     * the specified DB cluster parameter group.
     * </p>
     *
     * @param describeDbClusterParameterGroupsRequest
     * @return Result of the DescribeDBClusterParameterGroups operation returned by the service.
     * @throws DbParameterGroupNotFoundException
     *         <i>DBParameterGroupName</i> does not refer to an existing DB parameter group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.DescribeDBClusterParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBClusterParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeDbClusterParameterGroupsResponse describeDBClusterParameterGroups(
            DescribeDbClusterParameterGroupsRequest describeDbClusterParameterGroupsRequest)
            throws DbParameterGroupNotFoundException, AwsServiceException, SdkClientException, NeptuneException {

        HttpResponseHandler<DescribeDbClusterParameterGroupsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeDbClusterParameterGroupsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeDbClusterParameterGroupsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDBClusterParameterGroups");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeDbClusterParameterGroupsRequest, DescribeDbClusterParameterGroupsResponse>()
                            .withOperationName("DescribeDBClusterParameterGroups").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeDbClusterParameterGroupsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeDbClusterParameterGroupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the detailed parameter list for a particular DB cluster parameter group.
     * </p>
     *
     * @param describeDbClusterParametersRequest
     * @return Result of the DescribeDBClusterParameters operation returned by the service.
     * @throws DbParameterGroupNotFoundException
     *         <i>DBParameterGroupName</i> does not refer to an existing DB parameter group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.DescribeDBClusterParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBClusterParameters"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeDbClusterParametersResponse describeDBClusterParameters(
            DescribeDbClusterParametersRequest describeDbClusterParametersRequest) throws DbParameterGroupNotFoundException,
            AwsServiceException, SdkClientException, NeptuneException {

        HttpResponseHandler<DescribeDbClusterParametersResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeDbClusterParametersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDbClusterParametersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDBClusterParameters");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeDbClusterParametersRequest, DescribeDbClusterParametersResponse>()
                            .withOperationName("DescribeDBClusterParameters").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeDbClusterParametersRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeDbClusterParametersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of DB cluster snapshot attribute names and values for a manual DB cluster snapshot.
     * </p>
     * <p>
     * When sharing snapshots with other Amazon accounts, <code>DescribeDBClusterSnapshotAttributes</code> returns the
     * <code>restore</code> attribute and a list of IDs for the Amazon accounts that are authorized to copy or restore
     * the manual DB cluster snapshot. If <code>all</code> is included in the list of values for the
     * <code>restore</code> attribute, then the manual DB cluster snapshot is public and can be copied or restored by
     * all Amazon accounts.
     * </p>
     * <p>
     * To add or remove access for an Amazon account to copy or restore a manual DB cluster snapshot, or to make the
     * manual DB cluster snapshot public or private, use the <a>ModifyDBClusterSnapshotAttribute</a> API action.
     * </p>
     *
     * @param describeDbClusterSnapshotAttributesRequest
     * @return Result of the DescribeDBClusterSnapshotAttributes operation returned by the service.
     * @throws DbClusterSnapshotNotFoundException
     *         <i>DBClusterSnapshotIdentifier</i> does not refer to an existing DB cluster snapshot.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.DescribeDBClusterSnapshotAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBClusterSnapshotAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeDbClusterSnapshotAttributesResponse describeDBClusterSnapshotAttributes(
            DescribeDbClusterSnapshotAttributesRequest describeDbClusterSnapshotAttributesRequest)
            throws DbClusterSnapshotNotFoundException, AwsServiceException, SdkClientException, NeptuneException {

        HttpResponseHandler<DescribeDbClusterSnapshotAttributesResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeDbClusterSnapshotAttributesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeDbClusterSnapshotAttributesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDBClusterSnapshotAttributes");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeDbClusterSnapshotAttributesRequest, DescribeDbClusterSnapshotAttributesResponse>()
                            .withOperationName("DescribeDBClusterSnapshotAttributes").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeDbClusterSnapshotAttributesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeDbClusterSnapshotAttributesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about DB cluster snapshots. This API action supports pagination.
     * </p>
     *
     * @param describeDbClusterSnapshotsRequest
     * @return Result of the DescribeDBClusterSnapshots operation returned by the service.
     * @throws DbClusterSnapshotNotFoundException
     *         <i>DBClusterSnapshotIdentifier</i> does not refer to an existing DB cluster snapshot.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.DescribeDBClusterSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBClusterSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeDbClusterSnapshotsResponse describeDBClusterSnapshots(
            DescribeDbClusterSnapshotsRequest describeDbClusterSnapshotsRequest) throws DbClusterSnapshotNotFoundException,
            AwsServiceException, SdkClientException, NeptuneException {

        HttpResponseHandler<DescribeDbClusterSnapshotsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeDbClusterSnapshotsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDbClusterSnapshotsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDBClusterSnapshots");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeDbClusterSnapshotsRequest, DescribeDbClusterSnapshotsResponse>()
                            .withOperationName("DescribeDBClusterSnapshots").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeDbClusterSnapshotsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeDbClusterSnapshotsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about provisioned DB clusters, and supports pagination.
     * </p>
     * <note>
     * <p>
     * This operation can also return information for Amazon RDS clusters and Amazon DocDB clusters.
     * </p>
     * </note>
     *
     * @param describeDbClustersRequest
     * @return Result of the DescribeDBClusters operation returned by the service.
     * @throws DbClusterNotFoundException
     *         <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.DescribeDBClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBClusters" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeDbClustersResponse describeDBClusters(DescribeDbClustersRequest describeDbClustersRequest)
            throws DbClusterNotFoundException, AwsServiceException, SdkClientException, NeptuneException {

        HttpResponseHandler<DescribeDbClustersResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeDbClustersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDbClustersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDBClusters");

            return clientHandler.execute(new ClientExecutionParams<DescribeDbClustersRequest, DescribeDbClustersResponse>()
                    .withOperationName("DescribeDBClusters").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeDbClustersRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeDbClustersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of the available DB engines.
     * </p>
     *
     * @param describeDbEngineVersionsRequest
     * @return Result of the DescribeDBEngineVersions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.DescribeDBEngineVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBEngineVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeDbEngineVersionsResponse describeDBEngineVersions(
            DescribeDbEngineVersionsRequest describeDbEngineVersionsRequest) throws AwsServiceException, SdkClientException,
            NeptuneException {

        HttpResponseHandler<DescribeDbEngineVersionsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeDbEngineVersionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDbEngineVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDBEngineVersions");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeDbEngineVersionsRequest, DescribeDbEngineVersionsResponse>()
                            .withOperationName("DescribeDBEngineVersions").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeDbEngineVersionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeDbEngineVersionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about provisioned instances, and supports pagination.
     * </p>
     * <note>
     * <p>
     * This operation can also return information for Amazon RDS instances and Amazon DocDB instances.
     * </p>
     * </note>
     *
     * @param describeDbInstancesRequest
     * @return Result of the DescribeDBInstances operation returned by the service.
     * @throws DbInstanceNotFoundException
     *         <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.DescribeDBInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBInstances" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeDbInstancesResponse describeDBInstances(DescribeDbInstancesRequest describeDbInstancesRequest)
            throws DbInstanceNotFoundException, AwsServiceException, SdkClientException, NeptuneException {

        HttpResponseHandler<DescribeDbInstancesResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeDbInstancesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDbInstancesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDBInstances");

            return clientHandler.execute(new ClientExecutionParams<DescribeDbInstancesRequest, DescribeDbInstancesResponse>()
                    .withOperationName("DescribeDBInstances").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeDbInstancesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeDbInstancesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of <code>DBParameterGroup</code> descriptions. If a <code>DBParameterGroupName</code> is
     * specified, the list will contain only the description of the specified DB parameter group.
     * </p>
     *
     * @param describeDbParameterGroupsRequest
     * @return Result of the DescribeDBParameterGroups operation returned by the service.
     * @throws DbParameterGroupNotFoundException
     *         <i>DBParameterGroupName</i> does not refer to an existing DB parameter group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.DescribeDBParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeDbParameterGroupsResponse describeDBParameterGroups(
            DescribeDbParameterGroupsRequest describeDbParameterGroupsRequest) throws DbParameterGroupNotFoundException,
            AwsServiceException, SdkClientException, NeptuneException {

        HttpResponseHandler<DescribeDbParameterGroupsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeDbParameterGroupsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDbParameterGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDBParameterGroups");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeDbParameterGroupsRequest, DescribeDbParameterGroupsResponse>()
                            .withOperationName("DescribeDBParameterGroups").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeDbParameterGroupsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeDbParameterGroupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the detailed parameter list for a particular DB parameter group.
     * </p>
     *
     * @param describeDbParametersRequest
     * @return Result of the DescribeDBParameters operation returned by the service.
     * @throws DbParameterGroupNotFoundException
     *         <i>DBParameterGroupName</i> does not refer to an existing DB parameter group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.DescribeDBParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBParameters" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeDbParametersResponse describeDBParameters(DescribeDbParametersRequest describeDbParametersRequest)
            throws DbParameterGroupNotFoundException, AwsServiceException, SdkClientException, NeptuneException {

        HttpResponseHandler<DescribeDbParametersResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeDbParametersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDbParametersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDBParameters");

            return clientHandler.execute(new ClientExecutionParams<DescribeDbParametersRequest, DescribeDbParametersResponse>()
                    .withOperationName("DescribeDBParameters").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeDbParametersRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeDbParametersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of DBSubnetGroup descriptions. If a DBSubnetGroupName is specified, the list will contain only the
     * descriptions of the specified DBSubnetGroup.
     * </p>
     * <p>
     * For an overview of CIDR ranges, go to the <a
     * href="http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Wikipedia Tutorial</a>.
     * </p>
     *
     * @param describeDbSubnetGroupsRequest
     * @return Result of the DescribeDBSubnetGroups operation returned by the service.
     * @throws DbSubnetGroupNotFoundException
     *         <i>DBSubnetGroupName</i> does not refer to an existing DB subnet group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.DescribeDBSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBSubnetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeDbSubnetGroupsResponse describeDBSubnetGroups(DescribeDbSubnetGroupsRequest describeDbSubnetGroupsRequest)
            throws DbSubnetGroupNotFoundException, AwsServiceException, SdkClientException, NeptuneException {

        HttpResponseHandler<DescribeDbSubnetGroupsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeDbSubnetGroupsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDbSubnetGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDBSubnetGroups");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeDbSubnetGroupsRequest, DescribeDbSubnetGroupsResponse>()
                            .withOperationName("DescribeDBSubnetGroups").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeDbSubnetGroupsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeDbSubnetGroupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the default engine and system parameter information for the cluster database engine.
     * </p>
     *
     * @param describeEngineDefaultClusterParametersRequest
     * @return Result of the DescribeEngineDefaultClusterParameters operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.DescribeEngineDefaultClusterParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeEngineDefaultClusterParameters"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeEngineDefaultClusterParametersResponse describeEngineDefaultClusterParameters(
            DescribeEngineDefaultClusterParametersRequest describeEngineDefaultClusterParametersRequest)
            throws AwsServiceException, SdkClientException, NeptuneException {

        HttpResponseHandler<DescribeEngineDefaultClusterParametersResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeEngineDefaultClusterParametersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeEngineDefaultClusterParametersRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEngineDefaultClusterParameters");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeEngineDefaultClusterParametersRequest, DescribeEngineDefaultClusterParametersResponse>()
                            .withOperationName("DescribeEngineDefaultClusterParameters").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeEngineDefaultClusterParametersRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeEngineDefaultClusterParametersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the default engine and system parameter information for the specified database engine.
     * </p>
     *
     * @param describeEngineDefaultParametersRequest
     * @return Result of the DescribeEngineDefaultParameters operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.DescribeEngineDefaultParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeEngineDefaultParameters"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeEngineDefaultParametersResponse describeEngineDefaultParameters(
            DescribeEngineDefaultParametersRequest describeEngineDefaultParametersRequest) throws AwsServiceException,
            SdkClientException, NeptuneException {

        HttpResponseHandler<DescribeEngineDefaultParametersResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeEngineDefaultParametersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeEngineDefaultParametersRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEngineDefaultParameters");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeEngineDefaultParametersRequest, DescribeEngineDefaultParametersResponse>()
                            .withOperationName("DescribeEngineDefaultParameters").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeEngineDefaultParametersRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeEngineDefaultParametersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Displays a list of categories for all event source types, or, if specified, for a specified source type.
     * </p>
     *
     * @param describeEventCategoriesRequest
     * @return Result of the DescribeEventCategories operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.DescribeEventCategories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeEventCategories"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeEventCategoriesResponse describeEventCategories(DescribeEventCategoriesRequest describeEventCategoriesRequest)
            throws AwsServiceException, SdkClientException, NeptuneException {

        HttpResponseHandler<DescribeEventCategoriesResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeEventCategoriesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEventCategoriesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEventCategories");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeEventCategoriesRequest, DescribeEventCategoriesResponse>()
                            .withOperationName("DescribeEventCategories").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeEventCategoriesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeEventCategoriesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all the subscription descriptions for a customer account. The description for a subscription includes
     * SubscriptionName, SNSTopicARN, CustomerID, SourceType, SourceID, CreationTime, and Status.
     * </p>
     * <p>
     * If you specify a SubscriptionName, lists the description for that subscription.
     * </p>
     *
     * @param describeEventSubscriptionsRequest
     * @return Result of the DescribeEventSubscriptions operation returned by the service.
     * @throws SubscriptionNotFoundException
     *         The designated subscription could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.DescribeEventSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeEventSubscriptionsResponse describeEventSubscriptions(
            DescribeEventSubscriptionsRequest describeEventSubscriptionsRequest) throws SubscriptionNotFoundException,
            AwsServiceException, SdkClientException, NeptuneException {

        HttpResponseHandler<DescribeEventSubscriptionsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeEventSubscriptionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEventSubscriptionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEventSubscriptions");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeEventSubscriptionsRequest, DescribeEventSubscriptionsResponse>()
                            .withOperationName("DescribeEventSubscriptions").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeEventSubscriptionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeEventSubscriptionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns events related to DB instances, DB security groups, DB snapshots, and DB parameter groups for the past 14
     * days. Events specific to a particular DB instance, DB security group, database snapshot, or DB parameter group
     * can be obtained by providing the name as a parameter. By default, the past hour of events are returned.
     * </p>
     *
     * @param describeEventsRequest
     * @return Result of the DescribeEvents operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeEventsResponse describeEvents(DescribeEventsRequest describeEventsRequest) throws AwsServiceException,
            SdkClientException, NeptuneException {

        HttpResponseHandler<DescribeEventsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeEventsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEventsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEvents");

            return clientHandler.execute(new ClientExecutionParams<DescribeEventsRequest, DescribeEventsResponse>()
                    .withOperationName("DescribeEvents").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeEventsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeEventsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about Neptune global database clusters. This API supports pagination.
     * </p>
     *
     * @param describeGlobalClustersRequest
     * @return Result of the DescribeGlobalClusters operation returned by the service.
     * @throws GlobalClusterNotFoundException
     *         The <code>GlobalClusterIdentifier</code> doesn't refer to an existing global database cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.DescribeGlobalClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeGlobalClusters"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeGlobalClustersResponse describeGlobalClusters(DescribeGlobalClustersRequest describeGlobalClustersRequest)
            throws GlobalClusterNotFoundException, AwsServiceException, SdkClientException, NeptuneException {

        HttpResponseHandler<DescribeGlobalClustersResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeGlobalClustersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeGlobalClustersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeGlobalClusters");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeGlobalClustersRequest, DescribeGlobalClustersResponse>()
                            .withOperationName("DescribeGlobalClusters").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeGlobalClustersRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeGlobalClustersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of orderable DB instance options for the specified engine.
     * </p>
     *
     * @param describeOrderableDbInstanceOptionsRequest
     * @return Result of the DescribeOrderableDBInstanceOptions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.DescribeOrderableDBInstanceOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeOrderableDBInstanceOptions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeOrderableDbInstanceOptionsResponse describeOrderableDBInstanceOptions(
            DescribeOrderableDbInstanceOptionsRequest describeOrderableDbInstanceOptionsRequest) throws AwsServiceException,
            SdkClientException, NeptuneException {

        HttpResponseHandler<DescribeOrderableDbInstanceOptionsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeOrderableDbInstanceOptionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeOrderableDbInstanceOptionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeOrderableDBInstanceOptions");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeOrderableDbInstanceOptionsRequest, DescribeOrderableDbInstanceOptionsResponse>()
                            .withOperationName("DescribeOrderableDBInstanceOptions").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeOrderableDbInstanceOptionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeOrderableDbInstanceOptionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of resources (for example, DB instances) that have at least one pending maintenance action.
     * </p>
     *
     * @param describePendingMaintenanceActionsRequest
     * @return Result of the DescribePendingMaintenanceActions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource ID was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.DescribePendingMaintenanceActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribePendingMaintenanceActions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribePendingMaintenanceActionsResponse describePendingMaintenanceActions(
            DescribePendingMaintenanceActionsRequest describePendingMaintenanceActionsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, NeptuneException {

        HttpResponseHandler<DescribePendingMaintenanceActionsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribePendingMaintenanceActionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describePendingMaintenanceActionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribePendingMaintenanceActions");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribePendingMaintenanceActionsRequest, DescribePendingMaintenanceActionsResponse>()
                            .withOperationName("DescribePendingMaintenanceActions").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describePendingMaintenanceActionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribePendingMaintenanceActionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * You can call <a>DescribeValidDBInstanceModifications</a> to learn what modifications you can make to your DB
     * instance. You can use this information when you call <a>ModifyDBInstance</a>.
     * </p>
     *
     * @param describeValidDbInstanceModificationsRequest
     * @return Result of the DescribeValidDBInstanceModifications operation returned by the service.
     * @throws DbInstanceNotFoundException
     *         <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.
     * @throws InvalidDbInstanceStateException
     *         The specified DB instance is not in the <i>available</i> state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.DescribeValidDBInstanceModifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeValidDBInstanceModifications"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeValidDbInstanceModificationsResponse describeValidDBInstanceModifications(
            DescribeValidDbInstanceModificationsRequest describeValidDbInstanceModificationsRequest)
            throws DbInstanceNotFoundException, InvalidDbInstanceStateException, AwsServiceException, SdkClientException,
            NeptuneException {

        HttpResponseHandler<DescribeValidDbInstanceModificationsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeValidDbInstanceModificationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeValidDbInstanceModificationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeValidDBInstanceModifications");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeValidDbInstanceModificationsRequest, DescribeValidDbInstanceModificationsResponse>()
                            .withOperationName("DescribeValidDBInstanceModifications").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeValidDbInstanceModificationsRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeValidDbInstanceModificationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Forces a failover for a DB cluster.
     * </p>
     * <p>
     * A failover for a DB cluster promotes one of the Read Replicas (read-only instances) in the DB cluster to be the
     * primary instance (the cluster writer).
     * </p>
     * <p>
     * Amazon Neptune will automatically fail over to a Read Replica, if one exists, when the primary instance fails.
     * You can force a failover when you want to simulate a failure of a primary instance for testing. Because each
     * instance in a DB cluster has its own endpoint address, you will need to clean up and re-establish any existing
     * connections that use those endpoint addresses when the failover is complete.
     * </p>
     *
     * @param failoverDbClusterRequest
     * @return Result of the FailoverDBCluster operation returned by the service.
     * @throws DbClusterNotFoundException
     *         <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.
     * @throws InvalidDbClusterStateException
     *         The DB cluster is not in a valid state.
     * @throws InvalidDbInstanceStateException
     *         The specified DB instance is not in the <i>available</i> state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.FailoverDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/FailoverDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public FailoverDbClusterResponse failoverDBCluster(FailoverDbClusterRequest failoverDbClusterRequest)
            throws DbClusterNotFoundException, InvalidDbClusterStateException, InvalidDbInstanceStateException,
            AwsServiceException, SdkClientException, NeptuneException {

        HttpResponseHandler<FailoverDbClusterResponse> responseHandler = protocolFactory
                .createResponseHandler(FailoverDbClusterResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, failoverDbClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "FailoverDBCluster");

            return clientHandler.execute(new ClientExecutionParams<FailoverDbClusterRequest, FailoverDbClusterResponse>()
                    .withOperationName("FailoverDBCluster").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(failoverDbClusterRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new FailoverDbClusterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Initiates the failover process for a Neptune global database.
     * </p>
     * <p>
     * A failover for a Neptune global database promotes one of secondary read-only DB clusters to be the primary DB
     * cluster and demotes the primary DB cluster to being a secondary (read-only) DB cluster. In other words, the role
     * of the current primary DB cluster and the selected target secondary DB cluster are switched. The selected
     * secondary DB cluster assumes full read/write capabilities for the Neptune global database.
     * </p>
     * <note>
     * <p>
     * This action applies <b>only</b> to Neptune global databases. This action is only intended for use on healthy
     * Neptune global databases with healthy Neptune DB clusters and no region-wide outages, to test disaster recovery
     * scenarios or to reconfigure the global database topology.
     * </p>
     * </note>
     *
     * @param failoverGlobalClusterRequest
     * @return Result of the FailoverGlobalCluster operation returned by the service.
     * @throws GlobalClusterNotFoundException
     *         The <code>GlobalClusterIdentifier</code> doesn't refer to an existing global database cluster.
     * @throws InvalidGlobalClusterStateException
     *         The global cluster is in an invalid state and can't perform the requested operation.
     * @throws InvalidDbClusterStateException
     *         The DB cluster is not in a valid state.
     * @throws DbClusterNotFoundException
     *         <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.FailoverGlobalCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/FailoverGlobalCluster" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public FailoverGlobalClusterResponse failoverGlobalCluster(FailoverGlobalClusterRequest failoverGlobalClusterRequest)
            throws GlobalClusterNotFoundException, InvalidGlobalClusterStateException, InvalidDbClusterStateException,
            DbClusterNotFoundException, AwsServiceException, SdkClientException, NeptuneException {

        HttpResponseHandler<FailoverGlobalClusterResponse> responseHandler = protocolFactory
                .createResponseHandler(FailoverGlobalClusterResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, failoverGlobalClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "FailoverGlobalCluster");

            return clientHandler.execute(new ClientExecutionParams<FailoverGlobalClusterRequest, FailoverGlobalClusterResponse>()
                    .withOperationName("FailoverGlobalCluster").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(failoverGlobalClusterRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new FailoverGlobalClusterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all tags on an Amazon Neptune resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws DbInstanceNotFoundException
     *         <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.
     * @throws DbSnapshotNotFoundException
     *         <i>DBSnapshotIdentifier</i> does not refer to an existing DB snapshot.
     * @throws DbClusterNotFoundException
     *         <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws DbInstanceNotFoundException, DbSnapshotNotFoundException, DbClusterNotFoundException, AwsServiceException,
            SdkClientException, NeptuneException {

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory
                .createResponseHandler(ListTagsForResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listTagsForResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modify a setting for a DB cluster. You can change one or more database configuration parameters by specifying
     * these parameters and the new values in the request.
     * </p>
     *
     * @param modifyDbClusterRequest
     * @return Result of the ModifyDBCluster operation returned by the service.
     * @throws DbClusterNotFoundException
     *         <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.
     * @throws InvalidDbClusterStateException
     *         The DB cluster is not in a valid state.
     * @throws StorageQuotaExceededException
     *         Request would result in user exceeding the allowed amount of storage available across all DB instances.
     * @throws DbSubnetGroupNotFoundException
     *         <i>DBSubnetGroupName</i> does not refer to an existing DB subnet group.
     * @throws InvalidVpcNetworkStateException
     *         DB subnet group does not cover all Availability Zones after it is created because users' change.
     * @throws InvalidDbSubnetGroupStateException
     *         The DB subnet group cannot be deleted because it is in use.
     * @throws InvalidSubnetException
     *         The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.
     * @throws DbClusterParameterGroupNotFoundException
     *         <i>DBClusterParameterGroupName</i> does not refer to an existing DB Cluster parameter group.
     * @throws InvalidDbSecurityGroupStateException
     *         The state of the DB security group does not allow deletion.
     * @throws InvalidDbInstanceStateException
     *         The specified DB instance is not in the <i>available</i> state.
     * @throws DbClusterAlreadyExistsException
     *         User already has a DB cluster with the given identifier.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.ModifyDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ModifyDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ModifyDbClusterResponse modifyDBCluster(ModifyDbClusterRequest modifyDbClusterRequest)
            throws DbClusterNotFoundException, InvalidDbClusterStateException, StorageQuotaExceededException,
            DbSubnetGroupNotFoundException, InvalidVpcNetworkStateException, InvalidDbSubnetGroupStateException,
            InvalidSubnetException, DbClusterParameterGroupNotFoundException, InvalidDbSecurityGroupStateException,
            InvalidDbInstanceStateException, DbClusterAlreadyExistsException, AwsServiceException, SdkClientException,
            NeptuneException {

        HttpResponseHandler<ModifyDbClusterResponse> responseHandler = protocolFactory
                .createResponseHandler(ModifyDbClusterResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyDbClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyDBCluster");

            return clientHandler.execute(new ClientExecutionParams<ModifyDbClusterRequest, ModifyDbClusterResponse>()
                    .withOperationName("ModifyDBCluster").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(modifyDbClusterRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ModifyDbClusterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies the properties of an endpoint in an Amazon Neptune DB cluster.
     * </p>
     *
     * @param modifyDbClusterEndpointRequest
     * @return Result of the ModifyDBClusterEndpoint operation returned by the service.
     * @throws InvalidDbClusterStateException
     *         The DB cluster is not in a valid state.
     * @throws InvalidDbClusterEndpointStateException
     *         The requested operation cannot be performed on the endpoint while the endpoint is in this state.
     * @throws DbClusterEndpointNotFoundException
     *         The specified custom endpoint doesn't exist.
     * @throws DbInstanceNotFoundException
     *         <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.
     * @throws InvalidDbInstanceStateException
     *         The specified DB instance is not in the <i>available</i> state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.ModifyDBClusterEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ModifyDBClusterEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ModifyDbClusterEndpointResponse modifyDBClusterEndpoint(ModifyDbClusterEndpointRequest modifyDbClusterEndpointRequest)
            throws InvalidDbClusterStateException, InvalidDbClusterEndpointStateException, DbClusterEndpointNotFoundException,
            DbInstanceNotFoundException, InvalidDbInstanceStateException, AwsServiceException, SdkClientException,
            NeptuneException {

        HttpResponseHandler<ModifyDbClusterEndpointResponse> responseHandler = protocolFactory
                .createResponseHandler(ModifyDbClusterEndpointResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyDbClusterEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyDBClusterEndpoint");

            return clientHandler
                    .execute(new ClientExecutionParams<ModifyDbClusterEndpointRequest, ModifyDbClusterEndpointResponse>()
                            .withOperationName("ModifyDBClusterEndpoint").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(modifyDbClusterEndpointRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ModifyDbClusterEndpointRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies the parameters of a DB cluster parameter group. To modify more than one parameter, submit a list of the
     * following: <code>ParameterName</code>, <code>ParameterValue</code>, and <code>ApplyMethod</code>. A maximum of 20
     * parameters can be modified in a single request.
     * </p>
     * <note>
     * <p>
     * Changes to dynamic parameters are applied immediately. Changes to static parameters require a reboot without
     * failover to the DB cluster associated with the parameter group before the change can take effect.
     * </p>
     * </note> <important>
     * <p>
     * After you create a DB cluster parameter group, you should wait at least 5 minutes before creating your first DB
     * cluster that uses that DB cluster parameter group as the default parameter group. This allows Amazon Neptune to
     * fully complete the create action before the parameter group is used as the default for a new DB cluster. This is
     * especially important for parameters that are critical when creating the default database for a DB cluster, such
     * as the character set for the default database defined by the <code>character_set_database</code> parameter. You
     * can use the <i>Parameter Groups</i> option of the Amazon Neptune console or the
     * <a>DescribeDBClusterParameters</a> command to verify that your DB cluster parameter group has been created or
     * modified.
     * </p>
     * </important>
     *
     * @param modifyDbClusterParameterGroupRequest
     * @return Result of the ModifyDBClusterParameterGroup operation returned by the service.
     * @throws DbParameterGroupNotFoundException
     *         <i>DBParameterGroupName</i> does not refer to an existing DB parameter group.
     * @throws InvalidDbParameterGroupStateException
     *         The DB parameter group is in use or is in an invalid state. If you are attempting to delete the parameter
     *         group, you cannot delete it when the parameter group is in this state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.ModifyDBClusterParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ModifyDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ModifyDbClusterParameterGroupResponse modifyDBClusterParameterGroup(
            ModifyDbClusterParameterGroupRequest modifyDbClusterParameterGroupRequest) throws DbParameterGroupNotFoundException,
            InvalidDbParameterGroupStateException, AwsServiceException, SdkClientException, NeptuneException {

        HttpResponseHandler<ModifyDbClusterParameterGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(ModifyDbClusterParameterGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                modifyDbClusterParameterGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyDBClusterParameterGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<ModifyDbClusterParameterGroupRequest, ModifyDbClusterParameterGroupResponse>()
                            .withOperationName("ModifyDBClusterParameterGroup").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(modifyDbClusterParameterGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ModifyDbClusterParameterGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds an attribute and values to, or removes an attribute and values from, a manual DB cluster snapshot.
     * </p>
     * <p>
     * To share a manual DB cluster snapshot with other Amazon accounts, specify <code>restore</code> as the
     * <code>AttributeName</code> and use the <code>ValuesToAdd</code> parameter to add a list of IDs of the Amazon
     * accounts that are authorized to restore the manual DB cluster snapshot. Use the value <code>all</code> to make
     * the manual DB cluster snapshot public, which means that it can be copied or restored by all Amazon accounts. Do
     * not add the <code>all</code> value for any manual DB cluster snapshots that contain private information that you
     * don't want available to all Amazon accounts. If a manual DB cluster snapshot is encrypted, it can be shared, but
     * only by specifying a list of authorized Amazon account IDs for the <code>ValuesToAdd</code> parameter. You can't
     * use <code>all</code> as a value for that parameter in this case.
     * </p>
     * <p>
     * To view which Amazon accounts have access to copy or restore a manual DB cluster snapshot, or whether a manual DB
     * cluster snapshot public or private, use the <a>DescribeDBClusterSnapshotAttributes</a> API action.
     * </p>
     *
     * @param modifyDbClusterSnapshotAttributeRequest
     * @return Result of the ModifyDBClusterSnapshotAttribute operation returned by the service.
     * @throws DbClusterSnapshotNotFoundException
     *         <i>DBClusterSnapshotIdentifier</i> does not refer to an existing DB cluster snapshot.
     * @throws InvalidDbClusterSnapshotStateException
     *         The supplied value is not a valid DB cluster snapshot state.
     * @throws SharedSnapshotQuotaExceededException
     *         You have exceeded the maximum number of accounts that you can share a manual DB snapshot with.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.ModifyDBClusterSnapshotAttribute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ModifyDBClusterSnapshotAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ModifyDbClusterSnapshotAttributeResponse modifyDBClusterSnapshotAttribute(
            ModifyDbClusterSnapshotAttributeRequest modifyDbClusterSnapshotAttributeRequest)
            throws DbClusterSnapshotNotFoundException, InvalidDbClusterSnapshotStateException,
            SharedSnapshotQuotaExceededException, AwsServiceException, SdkClientException, NeptuneException {

        HttpResponseHandler<ModifyDbClusterSnapshotAttributeResponse> responseHandler = protocolFactory
                .createResponseHandler(ModifyDbClusterSnapshotAttributeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                modifyDbClusterSnapshotAttributeRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyDBClusterSnapshotAttribute");

            return clientHandler
                    .execute(new ClientExecutionParams<ModifyDbClusterSnapshotAttributeRequest, ModifyDbClusterSnapshotAttributeResponse>()
                            .withOperationName("ModifyDBClusterSnapshotAttribute").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(modifyDbClusterSnapshotAttributeRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ModifyDbClusterSnapshotAttributeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies settings for a DB instance. You can change one or more database configuration parameters by specifying
     * these parameters and the new values in the request. To learn what modifications you can make to your DB instance,
     * call <a>DescribeValidDBInstanceModifications</a> before you call <a>ModifyDBInstance</a>.
     * </p>
     *
     * @param modifyDbInstanceRequest
     * @return Result of the ModifyDBInstance operation returned by the service.
     * @throws InvalidDbInstanceStateException
     *         The specified DB instance is not in the <i>available</i> state.
     * @throws InvalidDbSecurityGroupStateException
     *         The state of the DB security group does not allow deletion.
     * @throws DbInstanceAlreadyExistsException
     *         User already has a DB instance with the given identifier.
     * @throws DbInstanceNotFoundException
     *         <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.
     * @throws DbSecurityGroupNotFoundException
     *         <i>DBSecurityGroupName</i> does not refer to an existing DB security group.
     * @throws DbParameterGroupNotFoundException
     *         <i>DBParameterGroupName</i> does not refer to an existing DB parameter group.
     * @throws InsufficientDbInstanceCapacityException
     *         Specified DB instance class is not available in the specified Availability Zone.
     * @throws StorageQuotaExceededException
     *         Request would result in user exceeding the allowed amount of storage available across all DB instances.
     * @throws InvalidVpcNetworkStateException
     *         DB subnet group does not cover all Availability Zones after it is created because users' change.
     * @throws ProvisionedIopsNotAvailableInAzException
     *         Provisioned IOPS not available in the specified Availability Zone.
     * @throws OptionGroupNotFoundException
     *         The designated option group could not be found.
     * @throws DbUpgradeDependencyFailureException
     *         The DB upgrade failed because a resource the DB depends on could not be modified.
     * @throws StorageTypeNotSupportedException
     *         <i>StorageType</i> specified cannot be associated with the DB Instance.
     * @throws AuthorizationNotFoundException
     *         Specified CIDRIP or EC2 security group is not authorized for the specified DB security group.</p>
     *         <p>
     *         Neptune may not also be authorized via IAM to perform necessary actions on your behalf.
     * @throws CertificateNotFoundException
     *         <i>CertificateIdentifier</i> does not refer to an existing certificate.
     * @throws DomainNotFoundException
     *         <i>Domain</i> does not refer to an existing Active Directory Domain.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.ModifyDBInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ModifyDBInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ModifyDbInstanceResponse modifyDBInstance(ModifyDbInstanceRequest modifyDbInstanceRequest)
            throws InvalidDbInstanceStateException, InvalidDbSecurityGroupStateException, DbInstanceAlreadyExistsException,
            DbInstanceNotFoundException, DbSecurityGroupNotFoundException, DbParameterGroupNotFoundException,
            InsufficientDbInstanceCapacityException, StorageQuotaExceededException, InvalidVpcNetworkStateException,
            ProvisionedIopsNotAvailableInAzException, OptionGroupNotFoundException, DbUpgradeDependencyFailureException,
            StorageTypeNotSupportedException, AuthorizationNotFoundException, CertificateNotFoundException,
            DomainNotFoundException, AwsServiceException, SdkClientException, NeptuneException {

        HttpResponseHandler<ModifyDbInstanceResponse> responseHandler = protocolFactory
                .createResponseHandler(ModifyDbInstanceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyDbInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyDBInstance");

            return clientHandler.execute(new ClientExecutionParams<ModifyDbInstanceRequest, ModifyDbInstanceResponse>()
                    .withOperationName("ModifyDBInstance").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(modifyDbInstanceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ModifyDbInstanceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies the parameters of a DB parameter group. To modify more than one parameter, submit a list of the
     * following: <code>ParameterName</code>, <code>ParameterValue</code>, and <code>ApplyMethod</code>. A maximum of 20
     * parameters can be modified in a single request.
     * </p>
     * <note>
     * <p>
     * Changes to dynamic parameters are applied immediately. Changes to static parameters require a reboot without
     * failover to the DB instance associated with the parameter group before the change can take effect.
     * </p>
     * </note> <important>
     * <p>
     * After you modify a DB parameter group, you should wait at least 5 minutes before creating your first DB instance
     * that uses that DB parameter group as the default parameter group. This allows Amazon Neptune to fully complete
     * the modify action before the parameter group is used as the default for a new DB instance. This is especially
     * important for parameters that are critical when creating the default database for a DB instance, such as the
     * character set for the default database defined by the <code>character_set_database</code> parameter. You can use
     * the <i>Parameter Groups</i> option of the Amazon Neptune console or the <i>DescribeDBParameters</i> command to
     * verify that your DB parameter group has been created or modified.
     * </p>
     * </important>
     *
     * @param modifyDbParameterGroupRequest
     * @return Result of the ModifyDBParameterGroup operation returned by the service.
     * @throws DbParameterGroupNotFoundException
     *         <i>DBParameterGroupName</i> does not refer to an existing DB parameter group.
     * @throws InvalidDbParameterGroupStateException
     *         The DB parameter group is in use or is in an invalid state. If you are attempting to delete the parameter
     *         group, you cannot delete it when the parameter group is in this state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.ModifyDBParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ModifyDBParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ModifyDbParameterGroupResponse modifyDBParameterGroup(ModifyDbParameterGroupRequest modifyDbParameterGroupRequest)
            throws DbParameterGroupNotFoundException, InvalidDbParameterGroupStateException, AwsServiceException,
            SdkClientException, NeptuneException {

        HttpResponseHandler<ModifyDbParameterGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(ModifyDbParameterGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyDbParameterGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyDBParameterGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<ModifyDbParameterGroupRequest, ModifyDbParameterGroupResponse>()
                            .withOperationName("ModifyDBParameterGroup").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(modifyDbParameterGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ModifyDbParameterGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies an existing DB subnet group. DB subnet groups must contain at least one subnet in at least two AZs in
     * the Amazon Region.
     * </p>
     *
     * @param modifyDbSubnetGroupRequest
     * @return Result of the ModifyDBSubnetGroup operation returned by the service.
     * @throws DbSubnetGroupNotFoundException
     *         <i>DBSubnetGroupName</i> does not refer to an existing DB subnet group.
     * @throws DbSubnetQuotaExceededException
     *         Request would result in user exceeding the allowed number of subnets in a DB subnet groups.
     * @throws SubnetAlreadyInUseException
     *         The DB subnet is already in use in the Availability Zone.
     * @throws DbSubnetGroupDoesNotCoverEnoughAZsException
     *         Subnets in the DB subnet group should cover at least two Availability Zones unless there is only one
     *         Availability Zone.
     * @throws InvalidSubnetException
     *         The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.ModifyDBSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ModifyDBSubnetGroup" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ModifyDbSubnetGroupResponse modifyDBSubnetGroup(ModifyDbSubnetGroupRequest modifyDbSubnetGroupRequest)
            throws DbSubnetGroupNotFoundException, DbSubnetQuotaExceededException, SubnetAlreadyInUseException,
            DbSubnetGroupDoesNotCoverEnoughAZsException, InvalidSubnetException, AwsServiceException, SdkClientException,
            NeptuneException {

        HttpResponseHandler<ModifyDbSubnetGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(ModifyDbSubnetGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyDbSubnetGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyDBSubnetGroup");

            return clientHandler.execute(new ClientExecutionParams<ModifyDbSubnetGroupRequest, ModifyDbSubnetGroupResponse>()
                    .withOperationName("ModifyDBSubnetGroup").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(modifyDbSubnetGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ModifyDbSubnetGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies an existing event notification subscription. Note that you can't modify the source identifiers using
     * this call; to change source identifiers for a subscription, use the <a>AddSourceIdentifierToSubscription</a> and
     * <a>RemoveSourceIdentifierFromSubscription</a> calls.
     * </p>
     * <p>
     * You can see a list of the event categories for a given SourceType by using the <b>DescribeEventCategories</b>
     * action.
     * </p>
     *
     * @param modifyEventSubscriptionRequest
     * @return Result of the ModifyEventSubscription operation returned by the service.
     * @throws EventSubscriptionQuotaExceededException
     *         You have exceeded the number of events you can subscribe to.
     * @throws SubscriptionNotFoundException
     *         The designated subscription could not be found.
     * @throws SnsInvalidTopicException
     *         The SNS topic is invalid.
     * @throws SnsNoAuthorizationException
     *         There is no SNS authorization.
     * @throws SnsTopicArnNotFoundException
     *         The ARN of the SNS topic could not be found.
     * @throws SubscriptionCategoryNotFoundException
     *         The designated subscription category could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.ModifyEventSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ModifyEventSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ModifyEventSubscriptionResponse modifyEventSubscription(ModifyEventSubscriptionRequest modifyEventSubscriptionRequest)
            throws EventSubscriptionQuotaExceededException, SubscriptionNotFoundException, SnsInvalidTopicException,
            SnsNoAuthorizationException, SnsTopicArnNotFoundException, SubscriptionCategoryNotFoundException,
            AwsServiceException, SdkClientException, NeptuneException {

        HttpResponseHandler<ModifyEventSubscriptionResponse> responseHandler = protocolFactory
                .createResponseHandler(ModifyEventSubscriptionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyEventSubscriptionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyEventSubscription");

            return clientHandler
                    .execute(new ClientExecutionParams<ModifyEventSubscriptionRequest, ModifyEventSubscriptionResponse>()
                            .withOperationName("ModifyEventSubscription").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(modifyEventSubscriptionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ModifyEventSubscriptionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modify a setting for an Amazon Neptune global cluster. You can change one or more database configuration
     * parameters by specifying these parameters and their new values in the request.
     * </p>
     *
     * @param modifyGlobalClusterRequest
     * @return Result of the ModifyGlobalCluster operation returned by the service.
     * @throws GlobalClusterNotFoundException
     *         The <code>GlobalClusterIdentifier</code> doesn't refer to an existing global database cluster.
     * @throws InvalidGlobalClusterStateException
     *         The global cluster is in an invalid state and can't perform the requested operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.ModifyGlobalCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ModifyGlobalCluster" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ModifyGlobalClusterResponse modifyGlobalCluster(ModifyGlobalClusterRequest modifyGlobalClusterRequest)
            throws GlobalClusterNotFoundException, InvalidGlobalClusterStateException, AwsServiceException, SdkClientException,
            NeptuneException {

        HttpResponseHandler<ModifyGlobalClusterResponse> responseHandler = protocolFactory
                .createResponseHandler(ModifyGlobalClusterResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyGlobalClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyGlobalCluster");

            return clientHandler.execute(new ClientExecutionParams<ModifyGlobalClusterRequest, ModifyGlobalClusterResponse>()
                    .withOperationName("ModifyGlobalCluster").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(modifyGlobalClusterRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ModifyGlobalClusterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Not supported.
     * </p>
     *
     * @param promoteReadReplicaDbClusterRequest
     * @return Result of the PromoteReadReplicaDBCluster operation returned by the service.
     * @throws DbClusterNotFoundException
     *         <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.
     * @throws InvalidDbClusterStateException
     *         The DB cluster is not in a valid state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.PromoteReadReplicaDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/PromoteReadReplicaDBCluster"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PromoteReadReplicaDbClusterResponse promoteReadReplicaDBCluster(
            PromoteReadReplicaDbClusterRequest promoteReadReplicaDbClusterRequest) throws DbClusterNotFoundException,
            InvalidDbClusterStateException, AwsServiceException, SdkClientException, NeptuneException {

        HttpResponseHandler<PromoteReadReplicaDbClusterResponse> responseHandler = protocolFactory
                .createResponseHandler(PromoteReadReplicaDbClusterResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, promoteReadReplicaDbClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PromoteReadReplicaDBCluster");

            return clientHandler
                    .execute(new ClientExecutionParams<PromoteReadReplicaDbClusterRequest, PromoteReadReplicaDbClusterResponse>()
                            .withOperationName("PromoteReadReplicaDBCluster").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(promoteReadReplicaDbClusterRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new PromoteReadReplicaDbClusterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * You might need to reboot your DB instance, usually for maintenance reasons. For example, if you make certain
     * modifications, or if you change the DB parameter group associated with the DB instance, you must reboot the
     * instance for the changes to take effect.
     * </p>
     * <p>
     * Rebooting a DB instance restarts the database engine service. Rebooting a DB instance results in a momentary
     * outage, during which the DB instance status is set to rebooting.
     * </p>
     *
     * @param rebootDbInstanceRequest
     * @return Result of the RebootDBInstance operation returned by the service.
     * @throws InvalidDbInstanceStateException
     *         The specified DB instance is not in the <i>available</i> state.
     * @throws DbInstanceNotFoundException
     *         <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.RebootDBInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/RebootDBInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public RebootDbInstanceResponse rebootDBInstance(RebootDbInstanceRequest rebootDbInstanceRequest)
            throws InvalidDbInstanceStateException, DbInstanceNotFoundException, AwsServiceException, SdkClientException,
            NeptuneException {

        HttpResponseHandler<RebootDbInstanceResponse> responseHandler = protocolFactory
                .createResponseHandler(RebootDbInstanceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, rebootDbInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RebootDBInstance");

            return clientHandler.execute(new ClientExecutionParams<RebootDbInstanceRequest, RebootDbInstanceResponse>()
                    .withOperationName("RebootDBInstance").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(rebootDbInstanceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new RebootDbInstanceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Detaches a Neptune DB cluster from a Neptune global database. A secondary cluster becomes a normal standalone
     * cluster with read-write capability instead of being read-only, and no longer receives data from a the primary
     * cluster.
     * </p>
     *
     * @param removeFromGlobalClusterRequest
     * @return Result of the RemoveFromGlobalCluster operation returned by the service.
     * @throws GlobalClusterNotFoundException
     *         The <code>GlobalClusterIdentifier</code> doesn't refer to an existing global database cluster.
     * @throws InvalidGlobalClusterStateException
     *         The global cluster is in an invalid state and can't perform the requested operation.
     * @throws DbClusterNotFoundException
     *         <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.RemoveFromGlobalCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/RemoveFromGlobalCluster"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RemoveFromGlobalClusterResponse removeFromGlobalCluster(RemoveFromGlobalClusterRequest removeFromGlobalClusterRequest)
            throws GlobalClusterNotFoundException, InvalidGlobalClusterStateException, DbClusterNotFoundException,
            AwsServiceException, SdkClientException, NeptuneException {

        HttpResponseHandler<RemoveFromGlobalClusterResponse> responseHandler = protocolFactory
                .createResponseHandler(RemoveFromGlobalClusterResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeFromGlobalClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveFromGlobalCluster");

            return clientHandler
                    .execute(new ClientExecutionParams<RemoveFromGlobalClusterRequest, RemoveFromGlobalClusterResponse>()
                            .withOperationName("RemoveFromGlobalCluster").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(removeFromGlobalClusterRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RemoveFromGlobalClusterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disassociates an Identity and Access Management (IAM) role from a DB cluster.
     * </p>
     *
     * @param removeRoleFromDbClusterRequest
     * @return Result of the RemoveRoleFromDBCluster operation returned by the service.
     * @throws DbClusterNotFoundException
     *         <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.
     * @throws DbClusterRoleNotFoundException
     *         The specified IAM role Amazon Resource Name (ARN) is not associated with the specified DB cluster.
     * @throws InvalidDbClusterStateException
     *         The DB cluster is not in a valid state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.RemoveRoleFromDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/RemoveRoleFromDBCluster"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RemoveRoleFromDbClusterResponse removeRoleFromDBCluster(RemoveRoleFromDbClusterRequest removeRoleFromDbClusterRequest)
            throws DbClusterNotFoundException, DbClusterRoleNotFoundException, InvalidDbClusterStateException,
            AwsServiceException, SdkClientException, NeptuneException {

        HttpResponseHandler<RemoveRoleFromDbClusterResponse> responseHandler = protocolFactory
                .createResponseHandler(RemoveRoleFromDbClusterResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeRoleFromDbClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveRoleFromDBCluster");

            return clientHandler
                    .execute(new ClientExecutionParams<RemoveRoleFromDbClusterRequest, RemoveRoleFromDbClusterResponse>()
                            .withOperationName("RemoveRoleFromDBCluster").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(removeRoleFromDbClusterRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RemoveRoleFromDbClusterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes a source identifier from an existing event notification subscription.
     * </p>
     *
     * @param removeSourceIdentifierFromSubscriptionRequest
     * @return Result of the RemoveSourceIdentifierFromSubscription operation returned by the service.
     * @throws SubscriptionNotFoundException
     *         The designated subscription could not be found.
     * @throws SourceNotFoundException
     *         The source could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.RemoveSourceIdentifierFromSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/RemoveSourceIdentifierFromSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RemoveSourceIdentifierFromSubscriptionResponse removeSourceIdentifierFromSubscription(
            RemoveSourceIdentifierFromSubscriptionRequest removeSourceIdentifierFromSubscriptionRequest)
            throws SubscriptionNotFoundException, SourceNotFoundException, AwsServiceException, SdkClientException,
            NeptuneException {

        HttpResponseHandler<RemoveSourceIdentifierFromSubscriptionResponse> responseHandler = protocolFactory
                .createResponseHandler(RemoveSourceIdentifierFromSubscriptionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                removeSourceIdentifierFromSubscriptionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveSourceIdentifierFromSubscription");

            return clientHandler
                    .execute(new ClientExecutionParams<RemoveSourceIdentifierFromSubscriptionRequest, RemoveSourceIdentifierFromSubscriptionResponse>()
                            .withOperationName("RemoveSourceIdentifierFromSubscription").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(removeSourceIdentifierFromSubscriptionRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RemoveSourceIdentifierFromSubscriptionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes metadata tags from an Amazon Neptune resource.
     * </p>
     *
     * @param removeTagsFromResourceRequest
     * @return Result of the RemoveTagsFromResource operation returned by the service.
     * @throws DbInstanceNotFoundException
     *         <i>DBInstanceIdentifier</i> does not refer to an existing DB instance.
     * @throws DbSnapshotNotFoundException
     *         <i>DBSnapshotIdentifier</i> does not refer to an existing DB snapshot.
     * @throws DbClusterNotFoundException
     *         <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.RemoveTagsFromResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/RemoveTagsFromResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RemoveTagsFromResourceResponse removeTagsFromResource(RemoveTagsFromResourceRequest removeTagsFromResourceRequest)
            throws DbInstanceNotFoundException, DbSnapshotNotFoundException, DbClusterNotFoundException, AwsServiceException,
            SdkClientException, NeptuneException {

        HttpResponseHandler<RemoveTagsFromResourceResponse> responseHandler = protocolFactory
                .createResponseHandler(RemoveTagsFromResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeTagsFromResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveTagsFromResource");

            return clientHandler
                    .execute(new ClientExecutionParams<RemoveTagsFromResourceRequest, RemoveTagsFromResourceResponse>()
                            .withOperationName("RemoveTagsFromResource").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(removeTagsFromResourceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RemoveTagsFromResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies the parameters of a DB cluster parameter group to the default value. To reset specific parameters submit
     * a list of the following: <code>ParameterName</code> and <code>ApplyMethod</code>. To reset the entire DB cluster
     * parameter group, specify the <code>DBClusterParameterGroupName</code> and <code>ResetAllParameters</code>
     * parameters.
     * </p>
     * <p>
     * When resetting the entire group, dynamic parameters are updated immediately and static parameters are set to
     * <code>pending-reboot</code> to take effect on the next DB instance restart or <a>RebootDBInstance</a> request.
     * You must call <a>RebootDBInstance</a> for every DB instance in your DB cluster that you want the updated static
     * parameter to apply to.
     * </p>
     *
     * @param resetDbClusterParameterGroupRequest
     * @return Result of the ResetDBClusterParameterGroup operation returned by the service.
     * @throws InvalidDbParameterGroupStateException
     *         The DB parameter group is in use or is in an invalid state. If you are attempting to delete the parameter
     *         group, you cannot delete it when the parameter group is in this state.
     * @throws DbParameterGroupNotFoundException
     *         <i>DBParameterGroupName</i> does not refer to an existing DB parameter group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.ResetDBClusterParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ResetDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ResetDbClusterParameterGroupResponse resetDBClusterParameterGroup(
            ResetDbClusterParameterGroupRequest resetDbClusterParameterGroupRequest)
            throws InvalidDbParameterGroupStateException, DbParameterGroupNotFoundException, AwsServiceException,
            SdkClientException, NeptuneException {

        HttpResponseHandler<ResetDbClusterParameterGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(ResetDbClusterParameterGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, resetDbClusterParameterGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ResetDBClusterParameterGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<ResetDbClusterParameterGroupRequest, ResetDbClusterParameterGroupResponse>()
                            .withOperationName("ResetDBClusterParameterGroup").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(resetDbClusterParameterGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ResetDbClusterParameterGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies the parameters of a DB parameter group to the engine/system default value. To reset specific parameters,
     * provide a list of the following: <code>ParameterName</code> and <code>ApplyMethod</code>. To reset the entire DB
     * parameter group, specify the <code>DBParameterGroup</code> name and <code>ResetAllParameters</code> parameters.
     * When resetting the entire group, dynamic parameters are updated immediately and static parameters are set to
     * <code>pending-reboot</code> to take effect on the next DB instance restart or <code>RebootDBInstance</code>
     * request.
     * </p>
     *
     * @param resetDbParameterGroupRequest
     * @return Result of the ResetDBParameterGroup operation returned by the service.
     * @throws InvalidDbParameterGroupStateException
     *         The DB parameter group is in use or is in an invalid state. If you are attempting to delete the parameter
     *         group, you cannot delete it when the parameter group is in this state.
     * @throws DbParameterGroupNotFoundException
     *         <i>DBParameterGroupName</i> does not refer to an existing DB parameter group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.ResetDBParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ResetDBParameterGroup" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ResetDbParameterGroupResponse resetDBParameterGroup(ResetDbParameterGroupRequest resetDbParameterGroupRequest)
            throws InvalidDbParameterGroupStateException, DbParameterGroupNotFoundException, AwsServiceException,
            SdkClientException, NeptuneException {

        HttpResponseHandler<ResetDbParameterGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(ResetDbParameterGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, resetDbParameterGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ResetDBParameterGroup");

            return clientHandler.execute(new ClientExecutionParams<ResetDbParameterGroupRequest, ResetDbParameterGroupResponse>()
                    .withOperationName("ResetDBParameterGroup").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(resetDbParameterGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ResetDbParameterGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new DB cluster from a DB snapshot or DB cluster snapshot.
     * </p>
     * <p>
     * If a DB snapshot is specified, the target DB cluster is created from the source DB snapshot with a default
     * configuration and default security group.
     * </p>
     * <p>
     * If a DB cluster snapshot is specified, the target DB cluster is created from the source DB cluster restore point
     * with the same configuration as the original source DB cluster, except that the new DB cluster is created with the
     * default security group.
     * </p>
     *
     * @param restoreDbClusterFromSnapshotRequest
     * @return Result of the RestoreDBClusterFromSnapshot operation returned by the service.
     * @throws DbClusterAlreadyExistsException
     *         User already has a DB cluster with the given identifier.
     * @throws DbClusterQuotaExceededException
     *         User attempted to create a new DB cluster and the user has already reached the maximum allowed DB cluster
     *         quota.
     * @throws StorageQuotaExceededException
     *         Request would result in user exceeding the allowed amount of storage available across all DB instances.
     * @throws DbSubnetGroupNotFoundException
     *         <i>DBSubnetGroupName</i> does not refer to an existing DB subnet group.
     * @throws DbSnapshotNotFoundException
     *         <i>DBSnapshotIdentifier</i> does not refer to an existing DB snapshot.
     * @throws DbClusterSnapshotNotFoundException
     *         <i>DBClusterSnapshotIdentifier</i> does not refer to an existing DB cluster snapshot.
     * @throws InsufficientDbClusterCapacityException
     *         The DB cluster does not have enough capacity for the current operation.
     * @throws InsufficientStorageClusterCapacityException
     *         There is insufficient storage available for the current action. You may be able to resolve this error by
     *         updating your subnet group to use different Availability Zones that have more storage available.
     * @throws InvalidDbSnapshotStateException
     *         The state of the DB snapshot does not allow deletion.
     * @throws InvalidDbClusterSnapshotStateException
     *         The supplied value is not a valid DB cluster snapshot state.
     * @throws StorageQuotaExceededException
     *         Request would result in user exceeding the allowed amount of storage available across all DB instances.
     * @throws InvalidVpcNetworkStateException
     *         DB subnet group does not cover all Availability Zones after it is created because users' change.
     * @throws InvalidRestoreException
     *         Cannot restore from vpc backup to non-vpc DB instance.
     * @throws DbSubnetGroupNotFoundException
     *         <i>DBSubnetGroupName</i> does not refer to an existing DB subnet group.
     * @throws InvalidSubnetException
     *         The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.
     * @throws OptionGroupNotFoundException
     *         The designated option group could not be found.
     * @throws KmsKeyNotAccessibleException
     *         Error accessing KMS key.
     * @throws DbClusterParameterGroupNotFoundException
     *         <i>DBClusterParameterGroupName</i> does not refer to an existing DB Cluster parameter group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.RestoreDBClusterFromSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/RestoreDBClusterFromSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RestoreDbClusterFromSnapshotResponse restoreDBClusterFromSnapshot(
            RestoreDbClusterFromSnapshotRequest restoreDbClusterFromSnapshotRequest) throws DbClusterAlreadyExistsException,
            DbClusterQuotaExceededException, StorageQuotaExceededException, DbSubnetGroupNotFoundException,
            DbSnapshotNotFoundException, DbClusterSnapshotNotFoundException, InsufficientDbClusterCapacityException,
            InsufficientStorageClusterCapacityException, InvalidDbSnapshotStateException, InvalidDbClusterSnapshotStateException,
            InvalidVpcNetworkStateException, InvalidRestoreException, InvalidSubnetException, OptionGroupNotFoundException,
            KmsKeyNotAccessibleException, DbClusterParameterGroupNotFoundException, AwsServiceException, SdkClientException,
            NeptuneException {

        HttpResponseHandler<RestoreDbClusterFromSnapshotResponse> responseHandler = protocolFactory
                .createResponseHandler(RestoreDbClusterFromSnapshotResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, restoreDbClusterFromSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RestoreDBClusterFromSnapshot");

            return clientHandler
                    .execute(new ClientExecutionParams<RestoreDbClusterFromSnapshotRequest, RestoreDbClusterFromSnapshotResponse>()
                            .withOperationName("RestoreDBClusterFromSnapshot").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(restoreDbClusterFromSnapshotRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RestoreDbClusterFromSnapshotRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Restores a DB cluster to an arbitrary point in time. Users can restore to any point in time before
     * <code>LatestRestorableTime</code> for up to <code>BackupRetentionPeriod</code> days. The target DB cluster is
     * created from the source DB cluster with the same configuration as the original DB cluster, except that the new DB
     * cluster is created with the default DB security group.
     * </p>
     * <note>
     * <p>
     * This action only restores the DB cluster, not the DB instances for that DB cluster. You must invoke the
     * <a>CreateDBInstance</a> action to create DB instances for the restored DB cluster, specifying the identifier of
     * the restored DB cluster in <code>DBClusterIdentifier</code>. You can create DB instances only after the
     * <code>RestoreDBClusterToPointInTime</code> action has completed and the DB cluster is available.
     * </p>
     * </note>
     *
     * @param restoreDbClusterToPointInTimeRequest
     * @return Result of the RestoreDBClusterToPointInTime operation returned by the service.
     * @throws DbClusterAlreadyExistsException
     *         User already has a DB cluster with the given identifier.
     * @throws DbClusterNotFoundException
     *         <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.
     * @throws DbClusterQuotaExceededException
     *         User attempted to create a new DB cluster and the user has already reached the maximum allowed DB cluster
     *         quota.
     * @throws DbClusterSnapshotNotFoundException
     *         <i>DBClusterSnapshotIdentifier</i> does not refer to an existing DB cluster snapshot.
     * @throws DbSubnetGroupNotFoundException
     *         <i>DBSubnetGroupName</i> does not refer to an existing DB subnet group.
     * @throws InsufficientDbClusterCapacityException
     *         The DB cluster does not have enough capacity for the current operation.
     * @throws InsufficientStorageClusterCapacityException
     *         There is insufficient storage available for the current action. You may be able to resolve this error by
     *         updating your subnet group to use different Availability Zones that have more storage available.
     * @throws InvalidDbClusterSnapshotStateException
     *         The supplied value is not a valid DB cluster snapshot state.
     * @throws InvalidDbClusterStateException
     *         The DB cluster is not in a valid state.
     * @throws InvalidDbSnapshotStateException
     *         The state of the DB snapshot does not allow deletion.
     * @throws InvalidRestoreException
     *         Cannot restore from vpc backup to non-vpc DB instance.
     * @throws InvalidSubnetException
     *         The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.
     * @throws InvalidVpcNetworkStateException
     *         DB subnet group does not cover all Availability Zones after it is created because users' change.
     * @throws KmsKeyNotAccessibleException
     *         Error accessing KMS key.
     * @throws OptionGroupNotFoundException
     *         The designated option group could not be found.
     * @throws StorageQuotaExceededException
     *         Request would result in user exceeding the allowed amount of storage available across all DB instances.
     * @throws DbClusterParameterGroupNotFoundException
     *         <i>DBClusterParameterGroupName</i> does not refer to an existing DB Cluster parameter group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.RestoreDBClusterToPointInTime
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/RestoreDBClusterToPointInTime"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RestoreDbClusterToPointInTimeResponse restoreDBClusterToPointInTime(
            RestoreDbClusterToPointInTimeRequest restoreDbClusterToPointInTimeRequest) throws DbClusterAlreadyExistsException,
            DbClusterNotFoundException, DbClusterQuotaExceededException, DbClusterSnapshotNotFoundException,
            DbSubnetGroupNotFoundException, InsufficientDbClusterCapacityException, InsufficientStorageClusterCapacityException,
            InvalidDbClusterSnapshotStateException, InvalidDbClusterStateException, InvalidDbSnapshotStateException,
            InvalidRestoreException, InvalidSubnetException, InvalidVpcNetworkStateException, KmsKeyNotAccessibleException,
            OptionGroupNotFoundException, StorageQuotaExceededException, DbClusterParameterGroupNotFoundException,
            AwsServiceException, SdkClientException, NeptuneException {

        HttpResponseHandler<RestoreDbClusterToPointInTimeResponse> responseHandler = protocolFactory
                .createResponseHandler(RestoreDbClusterToPointInTimeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                restoreDbClusterToPointInTimeRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RestoreDBClusterToPointInTime");

            return clientHandler
                    .execute(new ClientExecutionParams<RestoreDbClusterToPointInTimeRequest, RestoreDbClusterToPointInTimeResponse>()
                            .withOperationName("RestoreDBClusterToPointInTime").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(restoreDbClusterToPointInTimeRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RestoreDbClusterToPointInTimeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts an Amazon Neptune DB cluster that was stopped using the Amazon console, the Amazon CLI stop-db-cluster
     * command, or the StopDBCluster API.
     * </p>
     *
     * @param startDbClusterRequest
     * @return Result of the StartDBCluster operation returned by the service.
     * @throws DbClusterNotFoundException
     *         <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.
     * @throws InvalidDbClusterStateException
     *         The DB cluster is not in a valid state.
     * @throws InvalidDbInstanceStateException
     *         The specified DB instance is not in the <i>available</i> state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.StartDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/StartDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StartDbClusterResponse startDBCluster(StartDbClusterRequest startDbClusterRequest) throws DbClusterNotFoundException,
            InvalidDbClusterStateException, InvalidDbInstanceStateException, AwsServiceException, SdkClientException,
            NeptuneException {

        HttpResponseHandler<StartDbClusterResponse> responseHandler = protocolFactory
                .createResponseHandler(StartDbClusterResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startDbClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartDBCluster");

            return clientHandler.execute(new ClientExecutionParams<StartDbClusterRequest, StartDbClusterResponse>()
                    .withOperationName("StartDBCluster").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(startDbClusterRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartDbClusterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Stops an Amazon Neptune DB cluster. When you stop a DB cluster, Neptune retains the DB cluster's metadata,
     * including its endpoints and DB parameter groups.
     * </p>
     * <p>
     * Neptune also retains the transaction logs so you can do a point-in-time restore if necessary.
     * </p>
     *
     * @param stopDbClusterRequest
     * @return Result of the StopDBCluster operation returned by the service.
     * @throws DbClusterNotFoundException
     *         <i>DBClusterIdentifier</i> does not refer to an existing DB cluster.
     * @throws InvalidDbClusterStateException
     *         The DB cluster is not in a valid state.
     * @throws InvalidDbInstanceStateException
     *         The specified DB instance is not in the <i>available</i> state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneClient.StopDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/StopDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StopDbClusterResponse stopDBCluster(StopDbClusterRequest stopDbClusterRequest) throws DbClusterNotFoundException,
            InvalidDbClusterStateException, InvalidDbInstanceStateException, AwsServiceException, SdkClientException,
            NeptuneException {

        HttpResponseHandler<StopDbClusterResponse> responseHandler = protocolFactory
                .createResponseHandler(StopDbClusterResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopDbClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Neptune");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopDBCluster");

            return clientHandler.execute(new ClientExecutionParams<StopDbClusterRequest, StopDbClusterResponse>()
                    .withOperationName("StopDBCluster").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(stopDbClusterRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StopDbClusterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Create an instance of {@link NeptuneWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link NeptuneWaiter}
     */
    @Override
    public NeptuneWaiter waiter() {
        return NeptuneWaiter.builder().client(this).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private AwsQueryProtocolFactory init() {
        return AwsQueryProtocolFactory
                .builder()
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBParameterGroupNotFound")
                                .exceptionBuilderSupplier(DbParameterGroupNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBClusterQuotaExceededFault")
                                .exceptionBuilderSupplier(DbClusterQuotaExceededException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBClusterRoleNotFound")
                                .exceptionBuilderSupplier(DbClusterRoleNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SubscriptionCategoryNotFound")
                                .exceptionBuilderSupplier(SubscriptionCategoryNotFoundException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRestoreFault")
                                .exceptionBuilderSupplier(InvalidRestoreException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InsufficientDBClusterCapacityFault")
                                .exceptionBuilderSupplier(InsufficientDbClusterCapacityException::builder).httpStatusCode(403)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBInstanceNotFound")
                                .exceptionBuilderSupplier(DbInstanceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBSubnetGroupDoesNotCoverEnoughAZs")
                                .exceptionBuilderSupplier(DbSubnetGroupDoesNotCoverEnoughAZsException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBSubnetGroupQuotaExceeded")
                                .exceptionBuilderSupplier(DbSubnetGroupQuotaExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault")
                                .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBClusterRoleQuotaExceeded")
                                .exceptionBuilderSupplier(DbClusterRoleQuotaExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault")
                                .exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CertificateNotFound")
                                .exceptionBuilderSupplier(CertificateNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDBSecurityGroupState")
                                .exceptionBuilderSupplier(InvalidDbSecurityGroupStateException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundFault")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBParameterGroupQuotaExceeded")
                                .exceptionBuilderSupplier(DbParameterGroupQuotaExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("StorageTypeNotSupported")
                                .exceptionBuilderSupplier(StorageTypeNotSupportedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SubscriptionNotFound")
                                .exceptionBuilderSupplier(SubscriptionNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InsufficientStorageClusterCapacity")
                                .exceptionBuilderSupplier(InsufficientStorageClusterCapacityException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBInstanceAlreadyExists")
                                .exceptionBuilderSupplier(DbInstanceAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse")
                                .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("GlobalClusterNotFoundFault")
                                .exceptionBuilderSupplier(GlobalClusterNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBSubnetGroupAlreadyExists")
                                .exceptionBuilderSupplier(DbSubnetGroupAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBClusterAlreadyExistsFault")
                                .exceptionBuilderSupplier(DbClusterAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBClusterRoleAlreadyExists")
                                .exceptionBuilderSupplier(DbClusterRoleAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidEventSubscriptionState")
                                .exceptionBuilderSupplier(InvalidEventSubscriptionStateException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDBSnapshotState")
                                .exceptionBuilderSupplier(InvalidDbSnapshotStateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidSubnet")
                                .exceptionBuilderSupplier(InvalidSubnetException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SNSTopicArnNotFound")
                                .exceptionBuilderSupplier(SnsTopicArnNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InstanceQuotaExceeded")
                                .exceptionBuilderSupplier(InstanceQuotaExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBClusterNotFoundFault")
                                .exceptionBuilderSupplier(DbClusterNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SnapshotQuotaExceeded")
                                .exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("GlobalClusterQuotaExceededFault")
                                .exceptionBuilderSupplier(GlobalClusterQuotaExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDBSubnetStateFault")
                                .exceptionBuilderSupplier(InvalidDbSubnetStateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("GlobalClusterAlreadyExistsFault")
                                .exceptionBuilderSupplier(GlobalClusterAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SharedSnapshotQuotaExceeded")
                                .exceptionBuilderSupplier(SharedSnapshotQuotaExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBSnapshotAlreadyExists")
                                .exceptionBuilderSupplier(DbSnapshotAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBClusterSnapshotAlreadyExistsFault")
                                .exceptionBuilderSupplier(DbClusterSnapshotAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidGlobalClusterStateFault")
                                .exceptionBuilderSupplier(InvalidGlobalClusterStateException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDBClusterStateFault")
                                .exceptionBuilderSupplier(InvalidDbClusterStateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDBSubnetGroupStateFault")
                                .exceptionBuilderSupplier(InvalidDbSubnetGroupStateException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBClusterParameterGroupNotFound")
                                .exceptionBuilderSupplier(DbClusterParameterGroupNotFoundException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBSubnetQuotaExceededFault")
                                .exceptionBuilderSupplier(DbSubnetQuotaExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SNSInvalidTopic")
                                .exceptionBuilderSupplier(SnsInvalidTopicException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBSubnetGroupNotFoundFault")
                                .exceptionBuilderSupplier(DbSubnetGroupNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBUpgradeDependencyFailure")
                                .exceptionBuilderSupplier(DbUpgradeDependencyFailureException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ProvisionedIopsNotAvailableInAZFault")
                                .exceptionBuilderSupplier(ProvisionedIopsNotAvailableInAzException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDBClusterSnapshotStateFault")
                                .exceptionBuilderSupplier(InvalidDbClusterSnapshotStateException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBSecurityGroupNotFound")
                                .exceptionBuilderSupplier(DbSecurityGroupNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBClusterEndpointAlreadyExistsFault")
                                .exceptionBuilderSupplier(DbClusterEndpointAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InsufficientDBInstanceCapacity")
                                .exceptionBuilderSupplier(InsufficientDbInstanceCapacityException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBParameterGroupAlreadyExists")
                                .exceptionBuilderSupplier(DbParameterGroupAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SNSNoAuthorization")
                                .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBClusterEndpointQuotaExceededFault")
                                .exceptionBuilderSupplier(DbClusterEndpointQuotaExceededException::builder).httpStatusCode(403)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBSnapshotNotFound")
                                .exceptionBuilderSupplier(DbSnapshotNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SubscriptionAlreadyExist")
                                .exceptionBuilderSupplier(SubscriptionAlreadyExistException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OptionGroupNotFoundFault")
                                .exceptionBuilderSupplier(OptionGroupNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBClusterSnapshotNotFoundFault")
                                .exceptionBuilderSupplier(DbClusterSnapshotNotFoundException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SourceNotFound")
                                .exceptionBuilderSupplier(SourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDBInstanceState")
                                .exceptionBuilderSupplier(InvalidDbInstanceStateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DomainNotFoundFault")
                                .exceptionBuilderSupplier(DomainNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EventSubscriptionQuotaExceeded")
                                .exceptionBuilderSupplier(EventSubscriptionQuotaExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DBClusterEndpointNotFoundFault")
                                .exceptionBuilderSupplier(DbClusterEndpointNotFoundException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("StorageQuotaExceeded")
                                .exceptionBuilderSupplier(StorageQuotaExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDBClusterEndpointStateFault")
                                .exceptionBuilderSupplier(InvalidDbClusterEndpointStateException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDBParameterGroupState")
                                .exceptionBuilderSupplier(InvalidDbParameterGroupStateException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AuthorizationNotFound")
                                .exceptionBuilderSupplier(AuthorizationNotFoundException::builder).httpStatusCode(404).build())
                .clientConfiguration(clientConfiguration).defaultServiceExceptionSupplier(NeptuneException::builder).build();
    }

    @Override
    public final NeptuneServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
