/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mq.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeBrokerInstanceOptionsResponse extends MqResponse implements
        ToCopyableBuilder<DescribeBrokerInstanceOptionsResponse.Builder, DescribeBrokerInstanceOptionsResponse> {
    private static final SdkField<List<BrokerInstanceOption>> BROKER_INSTANCE_OPTIONS_FIELD = SdkField
            .<List<BrokerInstanceOption>> builder(MarshallingType.LIST)
            .memberName("BrokerInstanceOptions")
            .getter(getter(DescribeBrokerInstanceOptionsResponse::brokerInstanceOptions))
            .setter(setter(Builder::brokerInstanceOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerInstanceOptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BrokerInstanceOption> builder(MarshallingType.SDK_POJO)
                                            .constructor(BrokerInstanceOption::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(DescribeBrokerInstanceOptionsResponse::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeBrokerInstanceOptionsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BROKER_INSTANCE_OPTIONS_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final List<BrokerInstanceOption> brokerInstanceOptions;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeBrokerInstanceOptionsResponse(BuilderImpl builder) {
        super(builder);
        this.brokerInstanceOptions = builder.brokerInstanceOptions;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the BrokerInstanceOptions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasBrokerInstanceOptions() {
        return brokerInstanceOptions != null && !(brokerInstanceOptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of available broker instance options.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBrokerInstanceOptions} method.
     * </p>
     * 
     * @return List of available broker instance options.
     */
    public final List<BrokerInstanceOption> brokerInstanceOptions() {
        return brokerInstanceOptions;
    }

    /**
     * <p>
     * Required. The maximum number of instance options that can be returned per page (20 by default). This value must
     * be an integer from 5 to 100.
     * </p>
     * 
     * @return Required. The maximum number of instance options that can be returned per page (20 by default). This
     *         value must be an integer from 5 to 100.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token that specifies the next page of results Amazon MQ should return. To request the first page, leave
     * nextToken empty.
     * </p>
     * 
     * @return The token that specifies the next page of results Amazon MQ should return. To request the first page,
     *         leave nextToken empty.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasBrokerInstanceOptions() ? brokerInstanceOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBrokerInstanceOptionsResponse)) {
            return false;
        }
        DescribeBrokerInstanceOptionsResponse other = (DescribeBrokerInstanceOptionsResponse) obj;
        return hasBrokerInstanceOptions() == other.hasBrokerInstanceOptions()
                && Objects.equals(brokerInstanceOptions(), other.brokerInstanceOptions())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeBrokerInstanceOptionsResponse")
                .add("BrokerInstanceOptions", hasBrokerInstanceOptions() ? brokerInstanceOptions() : null)
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BrokerInstanceOptions":
            return Optional.ofNullable(clazz.cast(brokerInstanceOptions()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeBrokerInstanceOptionsResponse, T> g) {
        return obj -> g.apply((DescribeBrokerInstanceOptionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MqResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeBrokerInstanceOptionsResponse> {
        /**
         * <p>
         * List of available broker instance options.
         * </p>
         * 
         * @param brokerInstanceOptions
         *        List of available broker instance options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brokerInstanceOptions(Collection<BrokerInstanceOption> brokerInstanceOptions);

        /**
         * <p>
         * List of available broker instance options.
         * </p>
         * 
         * @param brokerInstanceOptions
         *        List of available broker instance options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brokerInstanceOptions(BrokerInstanceOption... brokerInstanceOptions);

        /**
         * <p>
         * List of available broker instance options.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mq.model.BrokerInstanceOption.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.mq.model.BrokerInstanceOption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mq.model.BrokerInstanceOption.Builder#build()} is called immediately
         * and its result is passed to {@link #brokerInstanceOptions(List<BrokerInstanceOption>)}.
         * 
         * @param brokerInstanceOptions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mq.model.BrokerInstanceOption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #brokerInstanceOptions(java.util.Collection<BrokerInstanceOption>)
         */
        Builder brokerInstanceOptions(Consumer<BrokerInstanceOption.Builder>... brokerInstanceOptions);

        /**
         * <p>
         * Required. The maximum number of instance options that can be returned per page (20 by default). This value
         * must be an integer from 5 to 100.
         * </p>
         * 
         * @param maxResults
         *        Required. The maximum number of instance options that can be returned per page (20 by default). This
         *        value must be an integer from 5 to 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token that specifies the next page of results Amazon MQ should return. To request the first page, leave
         * nextToken empty.
         * </p>
         * 
         * @param nextToken
         *        The token that specifies the next page of results Amazon MQ should return. To request the first page,
         *        leave nextToken empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends MqResponse.BuilderImpl implements Builder {
        private List<BrokerInstanceOption> brokerInstanceOptions = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBrokerInstanceOptionsResponse model) {
            super(model);
            brokerInstanceOptions(model.brokerInstanceOptions);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final List<BrokerInstanceOption.Builder> getBrokerInstanceOptions() {
            List<BrokerInstanceOption.Builder> result = ___listOfBrokerInstanceOptionCopier
                    .copyToBuilder(this.brokerInstanceOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBrokerInstanceOptions(Collection<BrokerInstanceOption.BuilderImpl> brokerInstanceOptions) {
            this.brokerInstanceOptions = ___listOfBrokerInstanceOptionCopier.copyFromBuilder(brokerInstanceOptions);
        }

        @Override
        public final Builder brokerInstanceOptions(Collection<BrokerInstanceOption> brokerInstanceOptions) {
            this.brokerInstanceOptions = ___listOfBrokerInstanceOptionCopier.copy(brokerInstanceOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder brokerInstanceOptions(BrokerInstanceOption... brokerInstanceOptions) {
            brokerInstanceOptions(Arrays.asList(brokerInstanceOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder brokerInstanceOptions(Consumer<BrokerInstanceOption.Builder>... brokerInstanceOptions) {
            brokerInstanceOptions(Stream.of(brokerInstanceOptions)
                    .map(c -> BrokerInstanceOption.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeBrokerInstanceOptionsResponse build() {
            return new DescribeBrokerInstanceOptionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
