/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mq;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.mq.model.BadRequestException;
import software.amazon.awssdk.services.mq.model.ConflictException;
import software.amazon.awssdk.services.mq.model.CreateBrokerRequest;
import software.amazon.awssdk.services.mq.model.CreateBrokerResponse;
import software.amazon.awssdk.services.mq.model.CreateConfigurationRequest;
import software.amazon.awssdk.services.mq.model.CreateConfigurationResponse;
import software.amazon.awssdk.services.mq.model.CreateTagsRequest;
import software.amazon.awssdk.services.mq.model.CreateTagsResponse;
import software.amazon.awssdk.services.mq.model.CreateUserRequest;
import software.amazon.awssdk.services.mq.model.CreateUserResponse;
import software.amazon.awssdk.services.mq.model.DeleteBrokerRequest;
import software.amazon.awssdk.services.mq.model.DeleteBrokerResponse;
import software.amazon.awssdk.services.mq.model.DeleteTagsRequest;
import software.amazon.awssdk.services.mq.model.DeleteTagsResponse;
import software.amazon.awssdk.services.mq.model.DeleteUserRequest;
import software.amazon.awssdk.services.mq.model.DeleteUserResponse;
import software.amazon.awssdk.services.mq.model.DescribeBrokerEngineTypesRequest;
import software.amazon.awssdk.services.mq.model.DescribeBrokerEngineTypesResponse;
import software.amazon.awssdk.services.mq.model.DescribeBrokerInstanceOptionsRequest;
import software.amazon.awssdk.services.mq.model.DescribeBrokerInstanceOptionsResponse;
import software.amazon.awssdk.services.mq.model.DescribeBrokerRequest;
import software.amazon.awssdk.services.mq.model.DescribeBrokerResponse;
import software.amazon.awssdk.services.mq.model.DescribeConfigurationRequest;
import software.amazon.awssdk.services.mq.model.DescribeConfigurationResponse;
import software.amazon.awssdk.services.mq.model.DescribeConfigurationRevisionRequest;
import software.amazon.awssdk.services.mq.model.DescribeConfigurationRevisionResponse;
import software.amazon.awssdk.services.mq.model.DescribeUserRequest;
import software.amazon.awssdk.services.mq.model.DescribeUserResponse;
import software.amazon.awssdk.services.mq.model.ForbiddenException;
import software.amazon.awssdk.services.mq.model.InternalServerErrorException;
import software.amazon.awssdk.services.mq.model.ListBrokersRequest;
import software.amazon.awssdk.services.mq.model.ListBrokersResponse;
import software.amazon.awssdk.services.mq.model.ListConfigurationRevisionsRequest;
import software.amazon.awssdk.services.mq.model.ListConfigurationRevisionsResponse;
import software.amazon.awssdk.services.mq.model.ListConfigurationsRequest;
import software.amazon.awssdk.services.mq.model.ListConfigurationsResponse;
import software.amazon.awssdk.services.mq.model.ListTagsRequest;
import software.amazon.awssdk.services.mq.model.ListTagsResponse;
import software.amazon.awssdk.services.mq.model.ListUsersRequest;
import software.amazon.awssdk.services.mq.model.ListUsersResponse;
import software.amazon.awssdk.services.mq.model.MqException;
import software.amazon.awssdk.services.mq.model.NotFoundException;
import software.amazon.awssdk.services.mq.model.PromoteRequest;
import software.amazon.awssdk.services.mq.model.PromoteResponse;
import software.amazon.awssdk.services.mq.model.RebootBrokerRequest;
import software.amazon.awssdk.services.mq.model.RebootBrokerResponse;
import software.amazon.awssdk.services.mq.model.UnauthorizedException;
import software.amazon.awssdk.services.mq.model.UpdateBrokerRequest;
import software.amazon.awssdk.services.mq.model.UpdateBrokerResponse;
import software.amazon.awssdk.services.mq.model.UpdateConfigurationRequest;
import software.amazon.awssdk.services.mq.model.UpdateConfigurationResponse;
import software.amazon.awssdk.services.mq.model.UpdateUserRequest;
import software.amazon.awssdk.services.mq.model.UpdateUserResponse;
import software.amazon.awssdk.services.mq.paginators.ListBrokersIterable;

/**
 * Service client for accessing AmazonMQ. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Amazon MQ is a managed message broker service for Apache ActiveMQ and RabbitMQ that makes it easy to set up and
 * operate message brokers in the cloud. A message broker allows software applications and components to communicate
 * using various programming languages, operating systems, and formal messaging protocols.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface MqClient extends AwsClient {
    String SERVICE_NAME = "mq";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "mq";

    /**
     * <p>
     * Creates a broker. Note: This API is asynchronous.
     * </p>
     * <p>
     * To create a broker, you must either use the AmazonMQFullAccess IAM policy or include the following EC2
     * permissions in your IAM policy.
     * </p>
     * <ul>
     * <li>
     * <p>
     * ec2:CreateNetworkInterface
     * </p>
     * <p>
     * This permission is required to allow Amazon MQ to create an elastic network interface (ENI) on behalf of your
     * account.
     * </p>
     * </li>
     * <li>
     * <p>
     * ec2:CreateNetworkInterfacePermission
     * </p>
     * <p>
     * This permission is required to attach the ENI to the broker instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * ec2:DeleteNetworkInterface
     * </p>
     * </li>
     * <li>
     * <p>
     * ec2:DeleteNetworkInterfacePermission
     * </p>
     * </li>
     * <li>
     * <p>
     * ec2:DetachNetworkInterface
     * </p>
     * </li>
     * <li>
     * <p>
     * ec2:DescribeInternetGateways
     * </p>
     * </li>
     * <li>
     * <p>
     * ec2:DescribeNetworkInterfaces
     * </p>
     * </li>
     * <li>
     * <p>
     * ec2:DescribeNetworkInterfacePermissions
     * </p>
     * </li>
     * <li>
     * <p>
     * ec2:DescribeRouteTables
     * </p>
     * </li>
     * <li>
     * <p>
     * ec2:DescribeSecurityGroups
     * </p>
     * </li>
     * <li>
     * <p>
     * ec2:DescribeSubnets
     * </p>
     * </li>
     * <li>
     * <p>
     * ec2:DescribeVpcs
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/amazon-mq-setting-up.html#create-iam-user"
     * >Create an IAM User and Get Your Amazon Web Services Credentials</a> and <a href=
     * "https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/connecting-to-amazon-mq.html#never-modify-delete-elastic-network-interface"
     * >Never Modify or Delete the Amazon MQ Elastic Network Interface</a> in the <i>Amazon MQ Developer Guide</i>.
     * </p>
     *
     * @param createBrokerRequest
     *        Creates a broker using the specified properties.
     * @return Result of the CreateBroker operation returned by the service.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws UnauthorizedException
     *         HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ConflictException
     *         HTTP Status Code 409: Conflict. This broker name already exists. Retry your request with another name.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MqException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MqClient.CreateBroker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/CreateBroker" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateBrokerResponse createBroker(CreateBrokerRequest createBrokerRequest) throws BadRequestException,
            UnauthorizedException, InternalServerErrorException, ConflictException, ForbiddenException, AwsServiceException,
            SdkClientException, MqException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a broker. Note: This API is asynchronous.
     * </p>
     * <p>
     * To create a broker, you must either use the AmazonMQFullAccess IAM policy or include the following EC2
     * permissions in your IAM policy.
     * </p>
     * <ul>
     * <li>
     * <p>
     * ec2:CreateNetworkInterface
     * </p>
     * <p>
     * This permission is required to allow Amazon MQ to create an elastic network interface (ENI) on behalf of your
     * account.
     * </p>
     * </li>
     * <li>
     * <p>
     * ec2:CreateNetworkInterfacePermission
     * </p>
     * <p>
     * This permission is required to attach the ENI to the broker instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * ec2:DeleteNetworkInterface
     * </p>
     * </li>
     * <li>
     * <p>
     * ec2:DeleteNetworkInterfacePermission
     * </p>
     * </li>
     * <li>
     * <p>
     * ec2:DetachNetworkInterface
     * </p>
     * </li>
     * <li>
     * <p>
     * ec2:DescribeInternetGateways
     * </p>
     * </li>
     * <li>
     * <p>
     * ec2:DescribeNetworkInterfaces
     * </p>
     * </li>
     * <li>
     * <p>
     * ec2:DescribeNetworkInterfacePermissions
     * </p>
     * </li>
     * <li>
     * <p>
     * ec2:DescribeRouteTables
     * </p>
     * </li>
     * <li>
     * <p>
     * ec2:DescribeSecurityGroups
     * </p>
     * </li>
     * <li>
     * <p>
     * ec2:DescribeSubnets
     * </p>
     * </li>
     * <li>
     * <p>
     * ec2:DescribeVpcs
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/amazon-mq-setting-up.html#create-iam-user"
     * >Create an IAM User and Get Your Amazon Web Services Credentials</a> and <a href=
     * "https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/connecting-to-amazon-mq.html#never-modify-delete-elastic-network-interface"
     * >Never Modify or Delete the Amazon MQ Elastic Network Interface</a> in the <i>Amazon MQ Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBrokerRequest.Builder} avoiding the need to
     * create one manually via {@link CreateBrokerRequest#builder()}
     * </p>
     *
     * @param createBrokerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mq.model.CreateBrokerRequest.Builder} to create a request. Creates
     *        a broker using the specified properties.
     * @return Result of the CreateBroker operation returned by the service.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws UnauthorizedException
     *         HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ConflictException
     *         HTTP Status Code 409: Conflict. This broker name already exists. Retry your request with another name.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MqException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MqClient.CreateBroker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/CreateBroker" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateBrokerResponse createBroker(Consumer<CreateBrokerRequest.Builder> createBrokerRequest)
            throws BadRequestException, UnauthorizedException, InternalServerErrorException, ConflictException,
            ForbiddenException, AwsServiceException, SdkClientException, MqException {
        return createBroker(CreateBrokerRequest.builder().applyMutation(createBrokerRequest).build());
    }

    /**
     * <p>
     * Creates a new configuration for the specified configuration name. Amazon MQ uses the default configuration (the
     * engine type and version).
     * </p>
     *
     * @param createConfigurationRequest
     *        Creates a new configuration for the specified configuration name. Amazon MQ uses the default configuration
     *        (the engine type and version).
     * @return Result of the CreateConfiguration operation returned by the service.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ConflictException
     *         HTTP Status Code 409: Conflict. This broker name already exists. Retry your request with another name.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MqException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MqClient.CreateConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/CreateConfiguration" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateConfigurationResponse createConfiguration(CreateConfigurationRequest createConfigurationRequest)
            throws BadRequestException, InternalServerErrorException, ConflictException, ForbiddenException, AwsServiceException,
            SdkClientException, MqException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new configuration for the specified configuration name. Amazon MQ uses the default configuration (the
     * engine type and version).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConfigurationRequest.Builder} avoiding the
     * need to create one manually via {@link CreateConfigurationRequest#builder()}
     * </p>
     *
     * @param createConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mq.model.CreateConfigurationRequest.Builder} to create a request.
     *        Creates a new configuration for the specified configuration name. Amazon MQ uses the default configuration
     *        (the engine type and version).
     * @return Result of the CreateConfiguration operation returned by the service.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ConflictException
     *         HTTP Status Code 409: Conflict. This broker name already exists. Retry your request with another name.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MqException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MqClient.CreateConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/CreateConfiguration" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateConfigurationResponse createConfiguration(
            Consumer<CreateConfigurationRequest.Builder> createConfigurationRequest) throws BadRequestException,
            InternalServerErrorException, ConflictException, ForbiddenException, AwsServiceException, SdkClientException,
            MqException {
        return createConfiguration(CreateConfigurationRequest.builder().applyMutation(createConfigurationRequest).build());
    }

    /**
     * <p>
     * Add a tag to a resource.
     * </p>
     *
     * @param createTagsRequest
     *        A map of the key-value pairs for the resource tag.
     * @return Result of the CreateTags operation returned by the service.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MqException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MqClient.CreateTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/CreateTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateTagsResponse createTags(CreateTagsRequest createTagsRequest) throws NotFoundException, BadRequestException,
            InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Add a tag to a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTagsRequest.Builder} avoiding the need to
     * create one manually via {@link CreateTagsRequest#builder()}
     * </p>
     *
     * @param createTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mq.model.CreateTagsRequest.Builder} to create a request. A map of
     *        the key-value pairs for the resource tag.
     * @return Result of the CreateTags operation returned by the service.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MqException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MqClient.CreateTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/CreateTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateTagsResponse createTags(Consumer<CreateTagsRequest.Builder> createTagsRequest) throws NotFoundException,
            BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException,
            MqException {
        return createTags(CreateTagsRequest.builder().applyMutation(createTagsRequest).build());
    }

    /**
     * <p>
     * Creates an ActiveMQ user.
     * </p>
     * <important>
     * <p>
     * Do not add personally identifiable information (PII) or other confidential or sensitive information in broker
     * usernames. Broker usernames are accessible to other Amazon Web Services services, including CloudWatch Logs.
     * Broker usernames are not intended to be used for private or sensitive data.
     * </p>
     * </important>
     *
     * @param createUserRequest
     *        Creates a new ActiveMQ user.
     * @return Result of the CreateUser operation returned by the service.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ConflictException
     *         HTTP Status Code 409: Conflict. This broker name already exists. Retry your request with another name.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MqException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MqClient.CreateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/CreateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateUserResponse createUser(CreateUserRequest createUserRequest) throws NotFoundException, BadRequestException,
            InternalServerErrorException, ConflictException, ForbiddenException, AwsServiceException, SdkClientException,
            MqException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an ActiveMQ user.
     * </p>
     * <important>
     * <p>
     * Do not add personally identifiable information (PII) or other confidential or sensitive information in broker
     * usernames. Broker usernames are accessible to other Amazon Web Services services, including CloudWatch Logs.
     * Broker usernames are not intended to be used for private or sensitive data.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUserRequest.Builder} avoiding the need to
     * create one manually via {@link CreateUserRequest#builder()}
     * </p>
     *
     * @param createUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mq.model.CreateUserRequest.Builder} to create a request. Creates a
     *        new ActiveMQ user.
     * @return Result of the CreateUser operation returned by the service.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ConflictException
     *         HTTP Status Code 409: Conflict. This broker name already exists. Retry your request with another name.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MqException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MqClient.CreateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/CreateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateUserResponse createUser(Consumer<CreateUserRequest.Builder> createUserRequest) throws NotFoundException,
            BadRequestException, InternalServerErrorException, ConflictException, ForbiddenException, AwsServiceException,
            SdkClientException, MqException {
        return createUser(CreateUserRequest.builder().applyMutation(createUserRequest).build());
    }

    /**
     * <p>
     * Deletes a broker. Note: This API is asynchronous.
     * </p>
     *
     * @param deleteBrokerRequest
     * @return Result of the DeleteBroker operation returned by the service.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MqException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MqClient.DeleteBroker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/DeleteBroker" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteBrokerResponse deleteBroker(DeleteBrokerRequest deleteBrokerRequest) throws NotFoundException,
            BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException,
            MqException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a broker. Note: This API is asynchronous.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBrokerRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteBrokerRequest#builder()}
     * </p>
     *
     * @param deleteBrokerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mq.model.DeleteBrokerRequest.Builder} to create a request.
     * @return Result of the DeleteBroker operation returned by the service.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MqException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MqClient.DeleteBroker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/DeleteBroker" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteBrokerResponse deleteBroker(Consumer<DeleteBrokerRequest.Builder> deleteBrokerRequest)
            throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, MqException {
        return deleteBroker(DeleteBrokerRequest.builder().applyMutation(deleteBrokerRequest).build());
    }

    /**
     * <p>
     * Removes a tag from a resource.
     * </p>
     *
     * @param deleteTagsRequest
     * @return Result of the DeleteTags operation returned by the service.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MqException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MqClient.DeleteTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/DeleteTags" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteTagsResponse deleteTags(DeleteTagsRequest deleteTagsRequest) throws NotFoundException, BadRequestException,
            InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a tag from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTagsRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteTagsRequest#builder()}
     * </p>
     *
     * @param deleteTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mq.model.DeleteTagsRequest.Builder} to create a request.
     * @return Result of the DeleteTags operation returned by the service.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MqException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MqClient.DeleteTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/DeleteTags" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteTagsResponse deleteTags(Consumer<DeleteTagsRequest.Builder> deleteTagsRequest) throws NotFoundException,
            BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException,
            MqException {
        return deleteTags(DeleteTagsRequest.builder().applyMutation(deleteTagsRequest).build());
    }

    /**
     * <p>
     * Deletes an ActiveMQ user.
     * </p>
     *
     * @param deleteUserRequest
     * @return Result of the DeleteUser operation returned by the service.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MqException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MqClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteUserResponse deleteUser(DeleteUserRequest deleteUserRequest) throws NotFoundException, BadRequestException,
            InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an ActiveMQ user.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteUserRequest#builder()}
     * </p>
     *
     * @param deleteUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mq.model.DeleteUserRequest.Builder} to create a request.
     * @return Result of the DeleteUser operation returned by the service.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MqException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MqClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteUserResponse deleteUser(Consumer<DeleteUserRequest.Builder> deleteUserRequest) throws NotFoundException,
            BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException,
            MqException {
        return deleteUser(DeleteUserRequest.builder().applyMutation(deleteUserRequest).build());
    }

    /**
     * <p>
     * Returns information about the specified broker.
     * </p>
     *
     * @param describeBrokerRequest
     * @return Result of the DescribeBroker operation returned by the service.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MqException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MqClient.DescribeBroker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/DescribeBroker" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeBrokerResponse describeBroker(DescribeBrokerRequest describeBrokerRequest) throws NotFoundException,
            BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException,
            MqException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the specified broker.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBrokerRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeBrokerRequest#builder()}
     * </p>
     *
     * @param describeBrokerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mq.model.DescribeBrokerRequest.Builder} to create a request.
     * @return Result of the DescribeBroker operation returned by the service.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MqException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MqClient.DescribeBroker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/DescribeBroker" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeBrokerResponse describeBroker(Consumer<DescribeBrokerRequest.Builder> describeBrokerRequest)
            throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, MqException {
        return describeBroker(DescribeBrokerRequest.builder().applyMutation(describeBrokerRequest).build());
    }

    /**
     * <p>
     * Describe available engine types and versions.
     * </p>
     *
     * @param describeBrokerEngineTypesRequest
     * @return Result of the DescribeBrokerEngineTypes operation returned by the service.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MqException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MqClient.DescribeBrokerEngineTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/DescribeBrokerEngineTypes" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeBrokerEngineTypesResponse describeBrokerEngineTypes(
            DescribeBrokerEngineTypesRequest describeBrokerEngineTypesRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describe available engine types and versions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBrokerEngineTypesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeBrokerEngineTypesRequest#builder()}
     * </p>
     *
     * @param describeBrokerEngineTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mq.model.DescribeBrokerEngineTypesRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeBrokerEngineTypes operation returned by the service.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MqException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MqClient.DescribeBrokerEngineTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/DescribeBrokerEngineTypes" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeBrokerEngineTypesResponse describeBrokerEngineTypes(
            Consumer<DescribeBrokerEngineTypesRequest.Builder> describeBrokerEngineTypesRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        return describeBrokerEngineTypes(DescribeBrokerEngineTypesRequest.builder()
                .applyMutation(describeBrokerEngineTypesRequest).build());
    }

    /**
     * <p>
     * Describe available broker instance options.
     * </p>
     *
     * @param describeBrokerInstanceOptionsRequest
     * @return Result of the DescribeBrokerInstanceOptions operation returned by the service.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MqException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MqClient.DescribeBrokerInstanceOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/DescribeBrokerInstanceOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeBrokerInstanceOptionsResponse describeBrokerInstanceOptions(
            DescribeBrokerInstanceOptionsRequest describeBrokerInstanceOptionsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describe available broker instance options.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBrokerInstanceOptionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeBrokerInstanceOptionsRequest#builder()}
     * </p>
     *
     * @param describeBrokerInstanceOptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mq.model.DescribeBrokerInstanceOptionsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeBrokerInstanceOptions operation returned by the service.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MqException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MqClient.DescribeBrokerInstanceOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/DescribeBrokerInstanceOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeBrokerInstanceOptionsResponse describeBrokerInstanceOptions(
            Consumer<DescribeBrokerInstanceOptionsRequest.Builder> describeBrokerInstanceOptionsRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, MqException {
        return describeBrokerInstanceOptions(DescribeBrokerInstanceOptionsRequest.builder()
                .applyMutation(describeBrokerInstanceOptionsRequest).build());
    }

    /**
     * <p>
     * Returns information about the specified configuration.
     * </p>
     *
     * @param describeConfigurationRequest
     * @return Result of the DescribeConfiguration operation returned by the service.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MqException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MqClient.DescribeConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/DescribeConfiguration" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeConfigurationResponse describeConfiguration(DescribeConfigurationRequest describeConfigurationRequest)
            throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, MqException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the specified configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConfigurationRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeConfigurationRequest#builder()}
     * </p>
     *
     * @param describeConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mq.model.DescribeConfigurationRequest.Builder} to create a request.
     * @return Result of the DescribeConfiguration operation returned by the service.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MqException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MqClient.DescribeConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/DescribeConfiguration" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeConfigurationResponse describeConfiguration(
            Consumer<DescribeConfigurationRequest.Builder> describeConfigurationRequest) throws NotFoundException,
            BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException,
            MqException {
        return describeConfiguration(DescribeConfigurationRequest.builder().applyMutation(describeConfigurationRequest).build());
    }

    /**
     * <p>
     * Returns the specified configuration revision for the specified configuration.
     * </p>
     *
     * @param describeConfigurationRevisionRequest
     * @return Result of the DescribeConfigurationRevision operation returned by the service.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MqException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MqClient.DescribeConfigurationRevision
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/DescribeConfigurationRevision"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConfigurationRevisionResponse describeConfigurationRevision(
            DescribeConfigurationRevisionRequest describeConfigurationRevisionRequest) throws NotFoundException,
            BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException,
            MqException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the specified configuration revision for the specified configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConfigurationRevisionRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeConfigurationRevisionRequest#builder()}
     * </p>
     *
     * @param describeConfigurationRevisionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mq.model.DescribeConfigurationRevisionRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeConfigurationRevision operation returned by the service.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MqException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MqClient.DescribeConfigurationRevision
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/DescribeConfigurationRevision"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConfigurationRevisionResponse describeConfigurationRevision(
            Consumer<DescribeConfigurationRevisionRequest.Builder> describeConfigurationRevisionRequest)
            throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, MqException {
        return describeConfigurationRevision(DescribeConfigurationRevisionRequest.builder()
                .applyMutation(describeConfigurationRevisionRequest).build());
    }

    /**
     * <p>
     * Returns information about an ActiveMQ user.
     * </p>
     *
     * @param describeUserRequest
     * @return Result of the DescribeUser operation returned by the service.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MqException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MqClient.DescribeUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/DescribeUser" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeUserResponse describeUser(DescribeUserRequest describeUserRequest) throws NotFoundException,
            BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException,
            MqException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about an ActiveMQ user.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeUserRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeUserRequest#builder()}
     * </p>
     *
     * @param describeUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mq.model.DescribeUserRequest.Builder} to create a request.
     * @return Result of the DescribeUser operation returned by the service.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MqException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MqClient.DescribeUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/DescribeUser" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeUserResponse describeUser(Consumer<DescribeUserRequest.Builder> describeUserRequest)
            throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, MqException {
        return describeUser(DescribeUserRequest.builder().applyMutation(describeUserRequest).build());
    }

    /**
     * <p>
     * Returns a list of all brokers.
     * </p>
     *
     * @param listBrokersRequest
     * @return Result of the ListBrokers operation returned by the service.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MqException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MqClient.ListBrokers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/ListBrokers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBrokersResponse listBrokers(ListBrokersRequest listBrokersRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all brokers.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBrokersRequest.Builder} avoiding the need to
     * create one manually via {@link ListBrokersRequest#builder()}
     * </p>
     *
     * @param listBrokersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mq.model.ListBrokersRequest.Builder} to create a request.
     * @return Result of the ListBrokers operation returned by the service.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MqException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MqClient.ListBrokers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/ListBrokers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBrokersResponse listBrokers(Consumer<ListBrokersRequest.Builder> listBrokersRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        return listBrokers(ListBrokersRequest.builder().applyMutation(listBrokersRequest).build());
    }

    /**
     * <p>
     * Returns a list of all brokers.
     * </p>
     *
     * @return Result of the ListBrokers operation returned by the service.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MqException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MqClient.ListBrokers
     * @see #listBrokers(ListBrokersRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/ListBrokers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBrokersResponse listBrokers() throws BadRequestException, InternalServerErrorException, ForbiddenException,
            AwsServiceException, SdkClientException, MqException {
        return listBrokers(ListBrokersRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of all brokers.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listBrokers(software.amazon.awssdk.services.mq.model.ListBrokersRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mq.paginators.ListBrokersIterable responses = client.listBrokersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mq.paginators.ListBrokersIterable responses = client.listBrokersPaginator(request);
     *     for (software.amazon.awssdk.services.mq.model.ListBrokersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mq.paginators.ListBrokersIterable responses = client.listBrokersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBrokers(software.amazon.awssdk.services.mq.model.ListBrokersRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MqException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MqClient.ListBrokers
     * @see #listBrokersPaginator(ListBrokersRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/ListBrokers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBrokersIterable listBrokersPaginator() throws BadRequestException, InternalServerErrorException,
            ForbiddenException, AwsServiceException, SdkClientException, MqException {
        return listBrokersPaginator(ListBrokersRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of all brokers.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listBrokers(software.amazon.awssdk.services.mq.model.ListBrokersRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mq.paginators.ListBrokersIterable responses = client.listBrokersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mq.paginators.ListBrokersIterable responses = client.listBrokersPaginator(request);
     *     for (software.amazon.awssdk.services.mq.model.ListBrokersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mq.paginators.ListBrokersIterable responses = client.listBrokersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBrokers(software.amazon.awssdk.services.mq.model.ListBrokersRequest)} operation.</b>
     * </p>
     *
     * @param listBrokersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MqException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MqClient.ListBrokers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/ListBrokers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBrokersIterable listBrokersPaginator(ListBrokersRequest listBrokersRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        return new ListBrokersIterable(this, listBrokersRequest);
    }

    /**
     * <p>
     * Returns a list of all brokers.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listBrokers(software.amazon.awssdk.services.mq.model.ListBrokersRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mq.paginators.ListBrokersIterable responses = client.listBrokersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mq.paginators.ListBrokersIterable responses = client.listBrokersPaginator(request);
     *     for (software.amazon.awssdk.services.mq.model.ListBrokersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mq.paginators.ListBrokersIterable responses = client.listBrokersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBrokers(software.amazon.awssdk.services.mq.model.ListBrokersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBrokersRequest.Builder} avoiding the need to
     * create one manually via {@link ListBrokersRequest#builder()}
     * </p>
     *
     * @param listBrokersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mq.model.ListBrokersRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MqException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MqClient.ListBrokers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/ListBrokers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBrokersIterable listBrokersPaginator(Consumer<ListBrokersRequest.Builder> listBrokersRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, MqException {
        return listBrokersPaginator(ListBrokersRequest.builder().applyMutation(listBrokersRequest).build());
    }

    /**
     * <p>
     * Returns a list of all revisions for the specified configuration.
     * </p>
     *
     * @param listConfigurationRevisionsRequest
     * @return Result of the ListConfigurationRevisions operation returned by the service.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MqException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MqClient.ListConfigurationRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/ListConfigurationRevisions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListConfigurationRevisionsResponse listConfigurationRevisions(
            ListConfigurationRevisionsRequest listConfigurationRevisionsRequest) throws NotFoundException, BadRequestException,
            InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all revisions for the specified configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfigurationRevisionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListConfigurationRevisionsRequest#builder()}
     * </p>
     *
     * @param listConfigurationRevisionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mq.model.ListConfigurationRevisionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListConfigurationRevisions operation returned by the service.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MqException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MqClient.ListConfigurationRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/ListConfigurationRevisions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListConfigurationRevisionsResponse listConfigurationRevisions(
            Consumer<ListConfigurationRevisionsRequest.Builder> listConfigurationRevisionsRequest) throws NotFoundException,
            BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException,
            MqException {
        return listConfigurationRevisions(ListConfigurationRevisionsRequest.builder()
                .applyMutation(listConfigurationRevisionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all configurations.
     * </p>
     *
     * @param listConfigurationsRequest
     * @return Result of the ListConfigurations operation returned by the service.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MqException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MqClient.ListConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/ListConfigurations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListConfigurationsResponse listConfigurations(ListConfigurationsRequest listConfigurationsRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, MqException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all configurations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfigurationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListConfigurationsRequest#builder()}
     * </p>
     *
     * @param listConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mq.model.ListConfigurationsRequest.Builder} to create a request.
     * @return Result of the ListConfigurations operation returned by the service.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MqException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MqClient.ListConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/ListConfigurations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListConfigurationsResponse listConfigurations(Consumer<ListConfigurationsRequest.Builder> listConfigurationsRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, MqException {
        return listConfigurations(ListConfigurationsRequest.builder().applyMutation(listConfigurationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all configurations.
     * </p>
     *
     * @return Result of the ListConfigurations operation returned by the service.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MqException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MqClient.ListConfigurations
     * @see #listConfigurations(ListConfigurationsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/ListConfigurations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListConfigurationsResponse listConfigurations() throws BadRequestException, InternalServerErrorException,
            ForbiddenException, AwsServiceException, SdkClientException, MqException {
        return listConfigurations(ListConfigurationsRequest.builder().build());
    }

    /**
     * <p>
     * Lists tags for a resource.
     * </p>
     *
     * @param listTagsRequest
     * @return Result of the ListTags operation returned by the service.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MqException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MqClient.ListTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsResponse listTags(ListTagsRequest listTagsRequest) throws NotFoundException, BadRequestException,
            InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists tags for a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTagsRequest#builder()}
     * </p>
     *
     * @param listTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mq.model.ListTagsRequest.Builder} to create a request.
     * @return Result of the ListTags operation returned by the service.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MqException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MqClient.ListTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsResponse listTags(Consumer<ListTagsRequest.Builder> listTagsRequest) throws NotFoundException,
            BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException,
            MqException {
        return listTags(ListTagsRequest.builder().applyMutation(listTagsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all ActiveMQ users.
     * </p>
     *
     * @param listUsersRequest
     * @return Result of the ListUsers operation returned by the service.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MqException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MqClient.ListUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUsersResponse listUsers(ListUsersRequest listUsersRequest) throws NotFoundException, BadRequestException,
            InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all ActiveMQ users.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUsersRequest.Builder} avoiding the need to
     * create one manually via {@link ListUsersRequest#builder()}
     * </p>
     *
     * @param listUsersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mq.model.ListUsersRequest.Builder} to create a request.
     * @return Result of the ListUsers operation returned by the service.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MqException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MqClient.ListUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUsersResponse listUsers(Consumer<ListUsersRequest.Builder> listUsersRequest) throws NotFoundException,
            BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException,
            MqException {
        return listUsers(ListUsersRequest.builder().applyMutation(listUsersRequest).build());
    }

    /**
     * <p>
     * Promotes a data replication replica broker to the primary broker role.
     * </p>
     *
     * @param promoteRequest
     *        Promotes a data replication replica broker to the primary broker role.
     * @return Result of the Promote operation returned by the service.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MqException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MqClient.Promote
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/Promote" target="_top">AWS API
     *      Documentation</a>
     */
    default PromoteResponse promote(PromoteRequest promoteRequest) throws NotFoundException, BadRequestException,
            InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Promotes a data replication replica broker to the primary broker role.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PromoteRequest.Builder} avoiding the need to create
     * one manually via {@link PromoteRequest#builder()}
     * </p>
     *
     * @param promoteRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mq.model.PromoteRequest.Builder} to create a request. Promotes a
     *        data replication replica broker to the primary broker role.
     * @return Result of the Promote operation returned by the service.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MqException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MqClient.Promote
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/Promote" target="_top">AWS API
     *      Documentation</a>
     */
    default PromoteResponse promote(Consumer<PromoteRequest.Builder> promoteRequest) throws NotFoundException,
            BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException,
            MqException {
        return promote(PromoteRequest.builder().applyMutation(promoteRequest).build());
    }

    /**
     * <p>
     * Reboots a broker. Note: This API is asynchronous.
     * </p>
     *
     * @param rebootBrokerRequest
     * @return Result of the RebootBroker operation returned by the service.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MqException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MqClient.RebootBroker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/RebootBroker" target="_top">AWS API
     *      Documentation</a>
     */
    default RebootBrokerResponse rebootBroker(RebootBrokerRequest rebootBrokerRequest) throws NotFoundException,
            BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException,
            MqException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Reboots a broker. Note: This API is asynchronous.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RebootBrokerRequest.Builder} avoiding the need to
     * create one manually via {@link RebootBrokerRequest#builder()}
     * </p>
     *
     * @param rebootBrokerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mq.model.RebootBrokerRequest.Builder} to create a request.
     * @return Result of the RebootBroker operation returned by the service.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MqException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MqClient.RebootBroker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/RebootBroker" target="_top">AWS API
     *      Documentation</a>
     */
    default RebootBrokerResponse rebootBroker(Consumer<RebootBrokerRequest.Builder> rebootBrokerRequest)
            throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, MqException {
        return rebootBroker(RebootBrokerRequest.builder().applyMutation(rebootBrokerRequest).build());
    }

    /**
     * <p>
     * Adds a pending configuration change to a broker.
     * </p>
     *
     * @param updateBrokerRequest
     *        Updates the broker using the specified properties.
     * @return Result of the UpdateBroker operation returned by the service.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ConflictException
     *         HTTP Status Code 409: Conflict. This broker name already exists. Retry your request with another name.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MqException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MqClient.UpdateBroker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/UpdateBroker" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateBrokerResponse updateBroker(UpdateBrokerRequest updateBrokerRequest) throws NotFoundException,
            BadRequestException, InternalServerErrorException, ConflictException, ForbiddenException, AwsServiceException,
            SdkClientException, MqException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a pending configuration change to a broker.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBrokerRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateBrokerRequest#builder()}
     * </p>
     *
     * @param updateBrokerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mq.model.UpdateBrokerRequest.Builder} to create a request. Updates
     *        the broker using the specified properties.
     * @return Result of the UpdateBroker operation returned by the service.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ConflictException
     *         HTTP Status Code 409: Conflict. This broker name already exists. Retry your request with another name.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MqException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MqClient.UpdateBroker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/UpdateBroker" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateBrokerResponse updateBroker(Consumer<UpdateBrokerRequest.Builder> updateBrokerRequest)
            throws NotFoundException, BadRequestException, InternalServerErrorException, ConflictException, ForbiddenException,
            AwsServiceException, SdkClientException, MqException {
        return updateBroker(UpdateBrokerRequest.builder().applyMutation(updateBrokerRequest).build());
    }

    /**
     * <p>
     * Updates the specified configuration.
     * </p>
     *
     * @param updateConfigurationRequest
     *        Updates the specified configuration.
     * @return Result of the UpdateConfiguration operation returned by the service.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ConflictException
     *         HTTP Status Code 409: Conflict. This broker name already exists. Retry your request with another name.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MqException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MqClient.UpdateConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/UpdateConfiguration" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateConfigurationResponse updateConfiguration(UpdateConfigurationRequest updateConfigurationRequest)
            throws NotFoundException, BadRequestException, InternalServerErrorException, ConflictException, ForbiddenException,
            AwsServiceException, SdkClientException, MqException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateConfigurationRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateConfigurationRequest#builder()}
     * </p>
     *
     * @param updateConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mq.model.UpdateConfigurationRequest.Builder} to create a request.
     *        Updates the specified configuration.
     * @return Result of the UpdateConfiguration operation returned by the service.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ConflictException
     *         HTTP Status Code 409: Conflict. This broker name already exists. Retry your request with another name.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MqException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MqClient.UpdateConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/UpdateConfiguration" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateConfigurationResponse updateConfiguration(
            Consumer<UpdateConfigurationRequest.Builder> updateConfigurationRequest) throws NotFoundException,
            BadRequestException, InternalServerErrorException, ConflictException, ForbiddenException, AwsServiceException,
            SdkClientException, MqException {
        return updateConfiguration(UpdateConfigurationRequest.builder().applyMutation(updateConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates the information for an ActiveMQ user.
     * </p>
     *
     * @param updateUserRequest
     *        Updates the information for an ActiveMQ user.
     * @return Result of the UpdateUser operation returned by the service.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ConflictException
     *         HTTP Status Code 409: Conflict. This broker name already exists. Retry your request with another name.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MqException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MqClient.UpdateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/UpdateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateUserResponse updateUser(UpdateUserRequest updateUserRequest) throws NotFoundException, BadRequestException,
            InternalServerErrorException, ConflictException, ForbiddenException, AwsServiceException, SdkClientException,
            MqException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the information for an ActiveMQ user.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateUserRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateUserRequest#builder()}
     * </p>
     *
     * @param updateUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mq.model.UpdateUserRequest.Builder} to create a request. Updates
     *        the information for an ActiveMQ user.
     * @return Result of the UpdateUser operation returned by the service.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ConflictException
     *         HTTP Status Code 409: Conflict. This broker name already exists. Retry your request with another name.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MqException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MqClient.UpdateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/UpdateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateUserResponse updateUser(Consumer<UpdateUserRequest.Builder> updateUserRequest) throws NotFoundException,
            BadRequestException, InternalServerErrorException, ConflictException, ForbiddenException, AwsServiceException,
            SdkClientException, MqException {
        return updateUser(UpdateUserRequest.builder().applyMutation(updateUserRequest).build());
    }

    /**
     * Create a {@link MqClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static MqClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link MqClient}.
     */
    static MqClientBuilder builder() {
        return new DefaultMqClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default MqServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
