/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Task object encapsulating task information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Task implements SdkPojo, Serializable, ToCopyableBuilder<Task.Builder, Task> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(Task::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_DETAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusDetail").getter(getter(Task::statusDetail)).setter(setter(Builder::statusDetail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusDetail").build()).build();

    private static final SdkField<Integer> PROGRESS_PERCENT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ProgressPercent").getter(getter(Task::progressPercent)).setter(setter(Builder::progressPercent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgressPercent").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            STATUS_DETAIL_FIELD, PROGRESS_PERCENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String status;

    private final String statusDetail;

    private final Integer progressPercent;

    private Task(BuilderImpl builder) {
        this.status = builder.status;
        this.statusDetail = builder.statusDetail;
        this.progressPercent = builder.progressPercent;
    }

    /**
     * <p>
     * Status of the task - Not Started, In-Progress, Complete.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the task - Not Started, In-Progress, Complete.
     * @see Status
     */
    public final Status status() {
        return Status.fromValue(status);
    }

    /**
     * <p>
     * Status of the task - Not Started, In-Progress, Complete.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the task - Not Started, In-Progress, Complete.
     * @see Status
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Details of task status as notified by a migration tool. A tool might use this field to provide clarifying
     * information about the status that is unique to that tool or that explains an error state.
     * </p>
     * 
     * @return Details of task status as notified by a migration tool. A tool might use this field to provide clarifying
     *         information about the status that is unique to that tool or that explains an error state.
     */
    public final String statusDetail() {
        return statusDetail;
    }

    /**
     * <p>
     * Indication of the percentage completion of the task.
     * </p>
     * 
     * @return Indication of the percentage completion of the task.
     */
    public final Integer progressPercent() {
        return progressPercent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusDetail());
        hashCode = 31 * hashCode + Objects.hashCode(progressPercent());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Task)) {
            return false;
        }
        Task other = (Task) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(statusDetail(), other.statusDetail())
                && Objects.equals(progressPercent(), other.progressPercent());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Task").add("Status", statusAsString()).add("StatusDetail", statusDetail())
                .add("ProgressPercent", progressPercent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusDetail":
            return Optional.ofNullable(clazz.cast(statusDetail()));
        case "ProgressPercent":
            return Optional.ofNullable(clazz.cast(progressPercent()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Task, T> g) {
        return obj -> g.apply((Task) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Task> {
        /**
         * <p>
         * Status of the task - Not Started, In-Progress, Complete.
         * </p>
         * 
         * @param status
         *        Status of the task - Not Started, In-Progress, Complete.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(String status);

        /**
         * <p>
         * Status of the task - Not Started, In-Progress, Complete.
         * </p>
         * 
         * @param status
         *        Status of the task - Not Started, In-Progress, Complete.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(Status status);

        /**
         * <p>
         * Details of task status as notified by a migration tool. A tool might use this field to provide clarifying
         * information about the status that is unique to that tool or that explains an error state.
         * </p>
         * 
         * @param statusDetail
         *        Details of task status as notified by a migration tool. A tool might use this field to provide
         *        clarifying information about the status that is unique to that tool or that explains an error state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusDetail(String statusDetail);

        /**
         * <p>
         * Indication of the percentage completion of the task.
         * </p>
         * 
         * @param progressPercent
         *        Indication of the percentage completion of the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progressPercent(Integer progressPercent);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private String statusDetail;

        private Integer progressPercent;

        private BuilderImpl() {
        }

        private BuilderImpl(Task model) {
            status(model.status);
            statusDetail(model.statusDetail);
            progressPercent(model.progressPercent);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusDetail() {
            return statusDetail;
        }

        public final void setStatusDetail(String statusDetail) {
            this.statusDetail = statusDetail;
        }

        @Override
        public final Builder statusDetail(String statusDetail) {
            this.statusDetail = statusDetail;
            return this;
        }

        public final Integer getProgressPercent() {
            return progressPercent;
        }

        public final void setProgressPercent(Integer progressPercent) {
            this.progressPercent = progressPercent;
        }

        @Override
        public final Builder progressPercent(Integer progressPercent) {
            this.progressPercent = progressPercent;
            return this;
        }

        @Override
        public Task build() {
            return new Task(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
