/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagevod.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A DASH manifest configuration.
 */
@Generated("software.amazon.awssdk:codegen")
public final class DashManifest implements SdkPojo, Serializable, ToCopyableBuilder<DashManifest.Builder, DashManifest> {
    private static final SdkField<String> MANIFEST_LAYOUT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ManifestLayout").getter(getter(DashManifest::manifestLayoutAsString))
            .setter(setter(Builder::manifestLayout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manifestLayout").build()).build();

    private static final SdkField<String> MANIFEST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ManifestName").getter(getter(DashManifest::manifestName)).setter(setter(Builder::manifestName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manifestName").build()).build();

    private static final SdkField<Integer> MIN_BUFFER_TIME_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinBufferTimeSeconds").getter(getter(DashManifest::minBufferTimeSeconds))
            .setter(setter(Builder::minBufferTimeSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minBufferTimeSeconds").build())
            .build();

    private static final SdkField<String> PROFILE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Profile")
            .getter(getter(DashManifest::profileAsString)).setter(setter(Builder::profile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profile").build()).build();

    private static final SdkField<String> SCTE_MARKERS_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScteMarkersSource").getter(getter(DashManifest::scteMarkersSourceAsString))
            .setter(setter(Builder::scteMarkersSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scteMarkersSource").build()).build();

    private static final SdkField<StreamSelection> STREAM_SELECTION_FIELD = SdkField
            .<StreamSelection> builder(MarshallingType.SDK_POJO).memberName("StreamSelection")
            .getter(getter(DashManifest::streamSelection)).setter(setter(Builder::streamSelection))
            .constructor(StreamSelection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamSelection").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(MANIFEST_LAYOUT_FIELD, MANIFEST_NAME_FIELD, MIN_BUFFER_TIME_SECONDS_FIELD,
                    PROFILE_FIELD, SCTE_MARKERS_SOURCE_FIELD, STREAM_SELECTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String manifestLayout;

    private final String manifestName;

    private final Integer minBufferTimeSeconds;

    private final String profile;

    private final String scteMarkersSource;

    private final StreamSelection streamSelection;

    private DashManifest(BuilderImpl builder) {
        this.manifestLayout = builder.manifestLayout;
        this.manifestName = builder.manifestName;
        this.minBufferTimeSeconds = builder.minBufferTimeSeconds;
        this.profile = builder.profile;
        this.scteMarkersSource = builder.scteMarkersSource;
        this.streamSelection = builder.streamSelection;
    }

    /**
     * Determines the position of some tags in the Media Presentation Description (MPD). When set to FULL, elements like
     * SegmentTemplate and ContentProtection are included in each Representation. When set to COMPACT, duplicate
     * elements are combined and presented at the AdaptationSet level.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #manifestLayout}
     * will return {@link ManifestLayout#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #manifestLayoutAsString}.
     * </p>
     * 
     * @return Determines the position of some tags in the Media Presentation Description (MPD). When set to FULL,
     *         elements like SegmentTemplate and ContentProtection are included in each Representation. When set to
     *         COMPACT, duplicate elements are combined and presented at the AdaptationSet level.
     * @see ManifestLayout
     */
    public final ManifestLayout manifestLayout() {
        return ManifestLayout.fromValue(manifestLayout);
    }

    /**
     * Determines the position of some tags in the Media Presentation Description (MPD). When set to FULL, elements like
     * SegmentTemplate and ContentProtection are included in each Representation. When set to COMPACT, duplicate
     * elements are combined and presented at the AdaptationSet level.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #manifestLayout}
     * will return {@link ManifestLayout#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #manifestLayoutAsString}.
     * </p>
     * 
     * @return Determines the position of some tags in the Media Presentation Description (MPD). When set to FULL,
     *         elements like SegmentTemplate and ContentProtection are included in each Representation. When set to
     *         COMPACT, duplicate elements are combined and presented at the AdaptationSet level.
     * @see ManifestLayout
     */
    public final String manifestLayoutAsString() {
        return manifestLayout;
    }

    /**
     * An optional string to include in the name of the manifest.
     * 
     * @return An optional string to include in the name of the manifest.
     */
    public final String manifestName() {
        return manifestName;
    }

    /**
     * Minimum duration (in seconds) that a player will buffer media before starting the presentation.
     * 
     * @return Minimum duration (in seconds) that a player will buffer media before starting the presentation.
     */
    public final Integer minBufferTimeSeconds() {
        return minBufferTimeSeconds;
    }

    /**
     * The Dynamic Adaptive Streaming over HTTP (DASH) profile type. When set to "HBBTV_1_5", HbbTV 1.5 compliant output
     * is enabled.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #profile} will
     * return {@link Profile#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #profileAsString}.
     * </p>
     * 
     * @return The Dynamic Adaptive Streaming over HTTP (DASH) profile type. When set to "HBBTV_1_5", HbbTV 1.5
     *         compliant output is enabled.
     * @see Profile
     */
    public final Profile profile() {
        return Profile.fromValue(profile);
    }

    /**
     * The Dynamic Adaptive Streaming over HTTP (DASH) profile type. When set to "HBBTV_1_5", HbbTV 1.5 compliant output
     * is enabled.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #profile} will
     * return {@link Profile#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #profileAsString}.
     * </p>
     * 
     * @return The Dynamic Adaptive Streaming over HTTP (DASH) profile type. When set to "HBBTV_1_5", HbbTV 1.5
     *         compliant output is enabled.
     * @see Profile
     */
    public final String profileAsString() {
        return profile;
    }

    /**
     * The source of scte markers used. When set to SEGMENTS, the scte markers are sourced from the segments of the
     * ingested content. When set to MANIFEST, the scte markers are sourced from the manifest of the ingested content.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scteMarkersSource}
     * will return {@link ScteMarkersSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #scteMarkersSourceAsString}.
     * </p>
     * 
     * @return The source of scte markers used. When set to SEGMENTS, the scte markers are sourced from the segments of
     *         the ingested content. When set to MANIFEST, the scte markers are sourced from the manifest of the
     *         ingested content.
     * @see ScteMarkersSource
     */
    public final ScteMarkersSource scteMarkersSource() {
        return ScteMarkersSource.fromValue(scteMarkersSource);
    }

    /**
     * The source of scte markers used. When set to SEGMENTS, the scte markers are sourced from the segments of the
     * ingested content. When set to MANIFEST, the scte markers are sourced from the manifest of the ingested content.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scteMarkersSource}
     * will return {@link ScteMarkersSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #scteMarkersSourceAsString}.
     * </p>
     * 
     * @return The source of scte markers used. When set to SEGMENTS, the scte markers are sourced from the segments of
     *         the ingested content. When set to MANIFEST, the scte markers are sourced from the manifest of the
     *         ingested content.
     * @see ScteMarkersSource
     */
    public final String scteMarkersSourceAsString() {
        return scteMarkersSource;
    }

    /**
     * Returns the value of the StreamSelection property for this object.
     * 
     * @return The value of the StreamSelection property for this object.
     */
    public final StreamSelection streamSelection() {
        return streamSelection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(manifestLayoutAsString());
        hashCode = 31 * hashCode + Objects.hashCode(manifestName());
        hashCode = 31 * hashCode + Objects.hashCode(minBufferTimeSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(profileAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scteMarkersSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(streamSelection());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DashManifest)) {
            return false;
        }
        DashManifest other = (DashManifest) obj;
        return Objects.equals(manifestLayoutAsString(), other.manifestLayoutAsString())
                && Objects.equals(manifestName(), other.manifestName())
                && Objects.equals(minBufferTimeSeconds(), other.minBufferTimeSeconds())
                && Objects.equals(profileAsString(), other.profileAsString())
                && Objects.equals(scteMarkersSourceAsString(), other.scteMarkersSourceAsString())
                && Objects.equals(streamSelection(), other.streamSelection());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DashManifest").add("ManifestLayout", manifestLayoutAsString())
                .add("ManifestName", manifestName()).add("MinBufferTimeSeconds", minBufferTimeSeconds())
                .add("Profile", profileAsString()).add("ScteMarkersSource", scteMarkersSourceAsString())
                .add("StreamSelection", streamSelection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ManifestLayout":
            return Optional.ofNullable(clazz.cast(manifestLayoutAsString()));
        case "ManifestName":
            return Optional.ofNullable(clazz.cast(manifestName()));
        case "MinBufferTimeSeconds":
            return Optional.ofNullable(clazz.cast(minBufferTimeSeconds()));
        case "Profile":
            return Optional.ofNullable(clazz.cast(profileAsString()));
        case "ScteMarkersSource":
            return Optional.ofNullable(clazz.cast(scteMarkersSourceAsString()));
        case "StreamSelection":
            return Optional.ofNullable(clazz.cast(streamSelection()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DashManifest, T> g) {
        return obj -> g.apply((DashManifest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DashManifest> {
        /**
         * Determines the position of some tags in the Media Presentation Description (MPD). When set to FULL, elements
         * like SegmentTemplate and ContentProtection are included in each Representation. When set to COMPACT,
         * duplicate elements are combined and presented at the AdaptationSet level.
         * 
         * @param manifestLayout
         *        Determines the position of some tags in the Media Presentation Description (MPD). When set to FULL,
         *        elements like SegmentTemplate and ContentProtection are included in each Representation. When set to
         *        COMPACT, duplicate elements are combined and presented at the AdaptationSet level.
         * @see ManifestLayout
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ManifestLayout
         */
        Builder manifestLayout(String manifestLayout);

        /**
         * Determines the position of some tags in the Media Presentation Description (MPD). When set to FULL, elements
         * like SegmentTemplate and ContentProtection are included in each Representation. When set to COMPACT,
         * duplicate elements are combined and presented at the AdaptationSet level.
         * 
         * @param manifestLayout
         *        Determines the position of some tags in the Media Presentation Description (MPD). When set to FULL,
         *        elements like SegmentTemplate and ContentProtection are included in each Representation. When set to
         *        COMPACT, duplicate elements are combined and presented at the AdaptationSet level.
         * @see ManifestLayout
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ManifestLayout
         */
        Builder manifestLayout(ManifestLayout manifestLayout);

        /**
         * An optional string to include in the name of the manifest.
         * 
         * @param manifestName
         *        An optional string to include in the name of the manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manifestName(String manifestName);

        /**
         * Minimum duration (in seconds) that a player will buffer media before starting the presentation.
         * 
         * @param minBufferTimeSeconds
         *        Minimum duration (in seconds) that a player will buffer media before starting the presentation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minBufferTimeSeconds(Integer minBufferTimeSeconds);

        /**
         * The Dynamic Adaptive Streaming over HTTP (DASH) profile type. When set to "HBBTV_1_5", HbbTV 1.5 compliant
         * output is enabled.
         * 
         * @param profile
         *        The Dynamic Adaptive Streaming over HTTP (DASH) profile type. When set to "HBBTV_1_5", HbbTV 1.5
         *        compliant output is enabled.
         * @see Profile
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Profile
         */
        Builder profile(String profile);

        /**
         * The Dynamic Adaptive Streaming over HTTP (DASH) profile type. When set to "HBBTV_1_5", HbbTV 1.5 compliant
         * output is enabled.
         * 
         * @param profile
         *        The Dynamic Adaptive Streaming over HTTP (DASH) profile type. When set to "HBBTV_1_5", HbbTV 1.5
         *        compliant output is enabled.
         * @see Profile
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Profile
         */
        Builder profile(Profile profile);

        /**
         * The source of scte markers used. When set to SEGMENTS, the scte markers are sourced from the segments of the
         * ingested content. When set to MANIFEST, the scte markers are sourced from the manifest of the ingested
         * content.
         * 
         * @param scteMarkersSource
         *        The source of scte markers used. When set to SEGMENTS, the scte markers are sourced from the segments
         *        of the ingested content. When set to MANIFEST, the scte markers are sourced from the manifest of the
         *        ingested content.
         * @see ScteMarkersSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScteMarkersSource
         */
        Builder scteMarkersSource(String scteMarkersSource);

        /**
         * The source of scte markers used. When set to SEGMENTS, the scte markers are sourced from the segments of the
         * ingested content. When set to MANIFEST, the scte markers are sourced from the manifest of the ingested
         * content.
         * 
         * @param scteMarkersSource
         *        The source of scte markers used. When set to SEGMENTS, the scte markers are sourced from the segments
         *        of the ingested content. When set to MANIFEST, the scte markers are sourced from the manifest of the
         *        ingested content.
         * @see ScteMarkersSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScteMarkersSource
         */
        Builder scteMarkersSource(ScteMarkersSource scteMarkersSource);

        /**
         * Sets the value of the StreamSelection property for this object.
         *
         * @param streamSelection
         *        The new value for the StreamSelection property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamSelection(StreamSelection streamSelection);

        /**
         * Sets the value of the StreamSelection property for this object.
         *
         * This is a convenience method that creates an instance of the {@link StreamSelection.Builder} avoiding the
         * need to create one manually via {@link StreamSelection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StreamSelection.Builder#build()} is called immediately and its
         * result is passed to {@link #streamSelection(StreamSelection)}.
         * 
         * @param streamSelection
         *        a consumer that will call methods on {@link StreamSelection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamSelection(StreamSelection)
         */
        default Builder streamSelection(Consumer<StreamSelection.Builder> streamSelection) {
            return streamSelection(StreamSelection.builder().applyMutation(streamSelection).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String manifestLayout;

        private String manifestName;

        private Integer minBufferTimeSeconds;

        private String profile;

        private String scteMarkersSource;

        private StreamSelection streamSelection;

        private BuilderImpl() {
        }

        private BuilderImpl(DashManifest model) {
            manifestLayout(model.manifestLayout);
            manifestName(model.manifestName);
            minBufferTimeSeconds(model.minBufferTimeSeconds);
            profile(model.profile);
            scteMarkersSource(model.scteMarkersSource);
            streamSelection(model.streamSelection);
        }

        public final String getManifestLayout() {
            return manifestLayout;
        }

        public final void setManifestLayout(String manifestLayout) {
            this.manifestLayout = manifestLayout;
        }

        @Override
        public final Builder manifestLayout(String manifestLayout) {
            this.manifestLayout = manifestLayout;
            return this;
        }

        @Override
        public final Builder manifestLayout(ManifestLayout manifestLayout) {
            this.manifestLayout(manifestLayout == null ? null : manifestLayout.toString());
            return this;
        }

        public final String getManifestName() {
            return manifestName;
        }

        public final void setManifestName(String manifestName) {
            this.manifestName = manifestName;
        }

        @Override
        public final Builder manifestName(String manifestName) {
            this.manifestName = manifestName;
            return this;
        }

        public final Integer getMinBufferTimeSeconds() {
            return minBufferTimeSeconds;
        }

        public final void setMinBufferTimeSeconds(Integer minBufferTimeSeconds) {
            this.minBufferTimeSeconds = minBufferTimeSeconds;
        }

        @Override
        public final Builder minBufferTimeSeconds(Integer minBufferTimeSeconds) {
            this.minBufferTimeSeconds = minBufferTimeSeconds;
            return this;
        }

        public final String getProfile() {
            return profile;
        }

        public final void setProfile(String profile) {
            this.profile = profile;
        }

        @Override
        public final Builder profile(String profile) {
            this.profile = profile;
            return this;
        }

        @Override
        public final Builder profile(Profile profile) {
            this.profile(profile == null ? null : profile.toString());
            return this;
        }

        public final String getScteMarkersSource() {
            return scteMarkersSource;
        }

        public final void setScteMarkersSource(String scteMarkersSource) {
            this.scteMarkersSource = scteMarkersSource;
        }

        @Override
        public final Builder scteMarkersSource(String scteMarkersSource) {
            this.scteMarkersSource = scteMarkersSource;
            return this;
        }

        @Override
        public final Builder scteMarkersSource(ScteMarkersSource scteMarkersSource) {
            this.scteMarkersSource(scteMarkersSource == null ? null : scteMarkersSource.toString());
            return this;
        }

        public final StreamSelection.Builder getStreamSelection() {
            return streamSelection != null ? streamSelection.toBuilder() : null;
        }

        public final void setStreamSelection(StreamSelection.BuilderImpl streamSelection) {
            this.streamSelection = streamSelection != null ? streamSelection.build() : null;
        }

        @Override
        public final Builder streamSelection(StreamSelection streamSelection) {
            this.streamSelection = streamSelection;
            return this;
        }

        @Override
        public DashManifest build() {
            return new DashManifest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
