/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Holds one set of SCTE-35 Descriptor Settings.
 */
@Generated("software.amazon.awssdk:codegen")
public final class Scte35Descriptor implements SdkPojo, Serializable,
        ToCopyableBuilder<Scte35Descriptor.Builder, Scte35Descriptor> {
    private static final SdkField<Scte35DescriptorSettings> SCTE35_DESCRIPTOR_SETTINGS_FIELD = SdkField
            .<Scte35DescriptorSettings> builder(MarshallingType.SDK_POJO).memberName("Scte35DescriptorSettings")
            .getter(getter(Scte35Descriptor::scte35DescriptorSettings)).setter(setter(Builder::scte35DescriptorSettings))
            .constructor(Scte35DescriptorSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scte35DescriptorSettings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SCTE35_DESCRIPTOR_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Scte35DescriptorSettings scte35DescriptorSettings;

    private Scte35Descriptor(BuilderImpl builder) {
        this.scte35DescriptorSettings = builder.scte35DescriptorSettings;
    }

    /**
     * SCTE-35 Descriptor Settings.
     * 
     * @return SCTE-35 Descriptor Settings.
     */
    public final Scte35DescriptorSettings scte35DescriptorSettings() {
        return scte35DescriptorSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scte35DescriptorSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Scte35Descriptor)) {
            return false;
        }
        Scte35Descriptor other = (Scte35Descriptor) obj;
        return Objects.equals(scte35DescriptorSettings(), other.scte35DescriptorSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Scte35Descriptor").add("Scte35DescriptorSettings", scte35DescriptorSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Scte35DescriptorSettings":
            return Optional.ofNullable(clazz.cast(scte35DescriptorSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Scte35Descriptor, T> g) {
        return obj -> g.apply((Scte35Descriptor) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Scte35Descriptor> {
        /**
         * SCTE-35 Descriptor Settings.
         * 
         * @param scte35DescriptorSettings
         *        SCTE-35 Descriptor Settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scte35DescriptorSettings(Scte35DescriptorSettings scte35DescriptorSettings);

        /**
         * SCTE-35 Descriptor Settings. This is a convenience method that creates an instance of the
         * {@link Scte35DescriptorSettings.Builder} avoiding the need to create one manually via
         * {@link Scte35DescriptorSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Scte35DescriptorSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #scte35DescriptorSettings(Scte35DescriptorSettings)}.
         * 
         * @param scte35DescriptorSettings
         *        a consumer that will call methods on {@link Scte35DescriptorSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scte35DescriptorSettings(Scte35DescriptorSettings)
         */
        default Builder scte35DescriptorSettings(Consumer<Scte35DescriptorSettings.Builder> scte35DescriptorSettings) {
            return scte35DescriptorSettings(Scte35DescriptorSettings.builder().applyMutation(scte35DescriptorSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Scte35DescriptorSettings scte35DescriptorSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(Scte35Descriptor model) {
            scte35DescriptorSettings(model.scte35DescriptorSettings);
        }

        public final Scte35DescriptorSettings.Builder getScte35DescriptorSettings() {
            return scte35DescriptorSettings != null ? scte35DescriptorSettings.toBuilder() : null;
        }

        public final void setScte35DescriptorSettings(Scte35DescriptorSettings.BuilderImpl scte35DescriptorSettings) {
            this.scte35DescriptorSettings = scte35DescriptorSettings != null ? scte35DescriptorSettings.build() : null;
        }

        @Override
        public final Builder scte35DescriptorSettings(Scte35DescriptorSettings scte35DescriptorSettings) {
            this.scte35DescriptorSettings = scte35DescriptorSettings;
            return this;
        }

        @Override
        public Scte35Descriptor build() {
            return new Scte35Descriptor(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
