/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Corresponds to the archive_allowed parameter. A value of ARCHIVE_NOT_ALLOWED corresponds to 0 (false) in the SCTE-35
 * specification. If you include one of the "restriction" flags then you must include all four of them.
 */
@Generated("software.amazon.awssdk:codegen")
public enum Scte35ArchiveAllowedFlag {
    ARCHIVE_NOT_ALLOWED("ARCHIVE_NOT_ALLOWED"),

    ARCHIVE_ALLOWED("ARCHIVE_ALLOWED"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Scte35ArchiveAllowedFlag> VALUE_MAP = EnumUtils.uniqueIndex(Scte35ArchiveAllowedFlag.class,
            Scte35ArchiveAllowedFlag::toString);

    private final String value;

    private Scte35ArchiveAllowedFlag(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return Scte35ArchiveAllowedFlag corresponding to the value
     */
    public static Scte35ArchiveAllowedFlag fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link Scte35ArchiveAllowedFlag}s
     */
    public static Set<Scte35ArchiveAllowedFlag> knownValues() {
        Set<Scte35ArchiveAllowedFlag> knownValues = EnumSet.allOf(Scte35ArchiveAllowedFlag.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
