/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Settings to specify the rendering of motion graphics into the video stream.
 */
@Generated("software.amazon.awssdk:codegen")
public final class MotionGraphicsActivateScheduleActionSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<MotionGraphicsActivateScheduleActionSettings.Builder, MotionGraphicsActivateScheduleActionSettings> {
    private static final SdkField<Long> DURATION_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Duration")
            .getter(getter(MotionGraphicsActivateScheduleActionSettings::duration)).setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("duration").build()).build();

    private static final SdkField<String> PASSWORD_PARAM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PasswordParam").getter(getter(MotionGraphicsActivateScheduleActionSettings::passwordParam))
            .setter(setter(Builder::passwordParam))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("passwordParam").build()).build();

    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Url")
            .getter(getter(MotionGraphicsActivateScheduleActionSettings::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()).build();

    private static final SdkField<String> USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Username").getter(getter(MotionGraphicsActivateScheduleActionSettings::username))
            .setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("username").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DURATION_FIELD,
            PASSWORD_PARAM_FIELD, URL_FIELD, USERNAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long duration;

    private final String passwordParam;

    private final String url;

    private final String username;

    private MotionGraphicsActivateScheduleActionSettings(BuilderImpl builder) {
        this.duration = builder.duration;
        this.passwordParam = builder.passwordParam;
        this.url = builder.url;
        this.username = builder.username;
    }

    /**
     * Duration (in milliseconds) that motion graphics should render on to the video stream. Leaving out this property
     * or setting to 0 will result in rendering continuing until a deactivate action is processed.
     * 
     * @return Duration (in milliseconds) that motion graphics should render on to the video stream. Leaving out this
     *         property or setting to 0 will result in rendering continuing until a deactivate action is processed.
     */
    public final Long duration() {
        return duration;
    }

    /**
     * Key used to extract the password from EC2 Parameter store
     * 
     * @return Key used to extract the password from EC2 Parameter store
     */
    public final String passwordParam() {
        return passwordParam;
    }

    /**
     * URI of the HTML5 content to be rendered into the live stream.
     * 
     * @return URI of the HTML5 content to be rendered into the live stream.
     */
    public final String url() {
        return url;
    }

    /**
     * Documentation update needed
     * 
     * @return Documentation update needed
     */
    public final String username() {
        return username;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(passwordParam());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        hashCode = 31 * hashCode + Objects.hashCode(username());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MotionGraphicsActivateScheduleActionSettings)) {
            return false;
        }
        MotionGraphicsActivateScheduleActionSettings other = (MotionGraphicsActivateScheduleActionSettings) obj;
        return Objects.equals(duration(), other.duration()) && Objects.equals(passwordParam(), other.passwordParam())
                && Objects.equals(url(), other.url()) && Objects.equals(username(), other.username());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MotionGraphicsActivateScheduleActionSettings").add("Duration", duration())
                .add("PasswordParam", passwordParam()).add("Url", url()).add("Username", username()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Duration":
            return Optional.ofNullable(clazz.cast(duration()));
        case "PasswordParam":
            return Optional.ofNullable(clazz.cast(passwordParam()));
        case "Url":
            return Optional.ofNullable(clazz.cast(url()));
        case "Username":
            return Optional.ofNullable(clazz.cast(username()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MotionGraphicsActivateScheduleActionSettings, T> g) {
        return obj -> g.apply((MotionGraphicsActivateScheduleActionSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MotionGraphicsActivateScheduleActionSettings> {
        /**
         * Duration (in milliseconds) that motion graphics should render on to the video stream. Leaving out this
         * property or setting to 0 will result in rendering continuing until a deactivate action is processed.
         * 
         * @param duration
         *        Duration (in milliseconds) that motion graphics should render on to the video stream. Leaving out this
         *        property or setting to 0 will result in rendering continuing until a deactivate action is processed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Long duration);

        /**
         * Key used to extract the password from EC2 Parameter store
         * 
         * @param passwordParam
         *        Key used to extract the password from EC2 Parameter store
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder passwordParam(String passwordParam);

        /**
         * URI of the HTML5 content to be rendered into the live stream.
         * 
         * @param url
         *        URI of the HTML5 content to be rendered into the live stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);

        /**
         * Documentation update needed
         * 
         * @param username
         *        Documentation update needed
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);
    }

    static final class BuilderImpl implements Builder {
        private Long duration;

        private String passwordParam;

        private String url;

        private String username;

        private BuilderImpl() {
        }

        private BuilderImpl(MotionGraphicsActivateScheduleActionSettings model) {
            duration(model.duration);
            passwordParam(model.passwordParam);
            url(model.url);
            username(model.username);
        }

        public final Long getDuration() {
            return duration;
        }

        public final void setDuration(Long duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(Long duration) {
            this.duration = duration;
            return this;
        }

        public final String getPasswordParam() {
            return passwordParam;
        }

        public final void setPasswordParam(String passwordParam) {
            this.passwordParam = passwordParam;
        }

        @Override
        public final Builder passwordParam(String passwordParam) {
            this.passwordParam = passwordParam;
            return this;
        }

        public final String getUrl() {
            return url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final String getUsername() {
            return username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        @Override
        public MotionGraphicsActivateScheduleActionSettings build() {
            return new MotionGraphicsActivateScheduleActionSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
