/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for ListInputDeviceTransfersResponse
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListInputDeviceTransfersResponse extends MediaLiveResponse implements
        ToCopyableBuilder<ListInputDeviceTransfersResponse.Builder, ListInputDeviceTransfersResponse> {
    private static final SdkField<List<TransferringInputDeviceSummary>> INPUT_DEVICE_TRANSFERS_FIELD = SdkField
            .<List<TransferringInputDeviceSummary>> builder(MarshallingType.LIST)
            .memberName("InputDeviceTransfers")
            .getter(getter(ListInputDeviceTransfersResponse::inputDeviceTransfers))
            .setter(setter(Builder::inputDeviceTransfers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputDeviceTransfers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TransferringInputDeviceSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(TransferringInputDeviceSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListInputDeviceTransfersResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_DEVICE_TRANSFERS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<TransferringInputDeviceSummary> inputDeviceTransfers;

    private final String nextToken;

    private ListInputDeviceTransfersResponse(BuilderImpl builder) {
        super(builder);
        this.inputDeviceTransfers = builder.inputDeviceTransfers;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the InputDeviceTransfers property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInputDeviceTransfers() {
        return inputDeviceTransfers != null && !(inputDeviceTransfers instanceof SdkAutoConstructList);
    }

    /**
     * The list of devices that you are transferring or are being transferred to you.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputDeviceTransfers} method.
     * </p>
     * 
     * @return The list of devices that you are transferring or are being transferred to you.
     */
    public final List<TransferringInputDeviceSummary> inputDeviceTransfers() {
        return inputDeviceTransfers;
    }

    /**
     * A token to get additional list results.
     * 
     * @return A token to get additional list results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasInputDeviceTransfers() ? inputDeviceTransfers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInputDeviceTransfersResponse)) {
            return false;
        }
        ListInputDeviceTransfersResponse other = (ListInputDeviceTransfersResponse) obj;
        return hasInputDeviceTransfers() == other.hasInputDeviceTransfers()
                && Objects.equals(inputDeviceTransfers(), other.inputDeviceTransfers())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListInputDeviceTransfersResponse")
                .add("InputDeviceTransfers", hasInputDeviceTransfers() ? inputDeviceTransfers() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InputDeviceTransfers":
            return Optional.ofNullable(clazz.cast(inputDeviceTransfers()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListInputDeviceTransfersResponse, T> g) {
        return obj -> g.apply((ListInputDeviceTransfersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListInputDeviceTransfersResponse> {
        /**
         * The list of devices that you are transferring or are being transferred to you.
         * 
         * @param inputDeviceTransfers
         *        The list of devices that you are transferring or are being transferred to you.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDeviceTransfers(Collection<TransferringInputDeviceSummary> inputDeviceTransfers);

        /**
         * The list of devices that you are transferring or are being transferred to you.
         * 
         * @param inputDeviceTransfers
         *        The list of devices that you are transferring or are being transferred to you.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDeviceTransfers(TransferringInputDeviceSummary... inputDeviceTransfers);

        /**
         * The list of devices that you are transferring or are being transferred to you. This is a convenience method
         * that creates an instance of the
         * {@link software.amazon.awssdk.services.medialive.model.TransferringInputDeviceSummary.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.medialive.model.TransferringInputDeviceSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.medialive.model.TransferringInputDeviceSummary.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #inputDeviceTransfers(List<TransferringInputDeviceSummary>)}.
         * 
         * @param inputDeviceTransfers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.medialive.model.TransferringInputDeviceSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputDeviceTransfers(java.util.Collection<TransferringInputDeviceSummary>)
         */
        Builder inputDeviceTransfers(Consumer<TransferringInputDeviceSummary.Builder>... inputDeviceTransfers);

        /**
         * A token to get additional list results.
         * 
         * @param nextToken
         *        A token to get additional list results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends MediaLiveResponse.BuilderImpl implements Builder {
        private List<TransferringInputDeviceSummary> inputDeviceTransfers = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInputDeviceTransfersResponse model) {
            super(model);
            inputDeviceTransfers(model.inputDeviceTransfers);
            nextToken(model.nextToken);
        }

        public final List<TransferringInputDeviceSummary.Builder> getInputDeviceTransfers() {
            List<TransferringInputDeviceSummary.Builder> result = ___listOfTransferringInputDeviceSummaryCopier
                    .copyToBuilder(this.inputDeviceTransfers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputDeviceTransfers(Collection<TransferringInputDeviceSummary.BuilderImpl> inputDeviceTransfers) {
            this.inputDeviceTransfers = ___listOfTransferringInputDeviceSummaryCopier.copyFromBuilder(inputDeviceTransfers);
        }

        @Override
        public final Builder inputDeviceTransfers(Collection<TransferringInputDeviceSummary> inputDeviceTransfers) {
            this.inputDeviceTransfers = ___listOfTransferringInputDeviceSummaryCopier.copy(inputDeviceTransfers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDeviceTransfers(TransferringInputDeviceSummary... inputDeviceTransfers) {
            inputDeviceTransfers(Arrays.asList(inputDeviceTransfers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDeviceTransfers(Consumer<TransferringInputDeviceSummary.Builder>... inputDeviceTransfers) {
            inputDeviceTransfers(Stream.of(inputDeviceTransfers)
                    .map(c -> TransferringInputDeviceSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListInputDeviceTransfersResponse build() {
            return new ListInputDeviceTransfersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
