/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Hls Webdav Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class HlsWebdavSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<HlsWebdavSettings.Builder, HlsWebdavSettings> {
    private static final SdkField<Integer> CONNECTION_RETRY_INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ConnectionRetryInterval").getter(getter(HlsWebdavSettings::connectionRetryInterval))
            .setter(setter(Builder::connectionRetryInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionRetryInterval").build())
            .build();

    private static final SdkField<Integer> FILECACHE_DURATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FilecacheDuration").getter(getter(HlsWebdavSettings::filecacheDuration))
            .setter(setter(Builder::filecacheDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filecacheDuration").build()).build();

    private static final SdkField<String> HTTP_TRANSFER_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HttpTransferMode").getter(getter(HlsWebdavSettings::httpTransferModeAsString))
            .setter(setter(Builder::httpTransferMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpTransferMode").build()).build();

    private static final SdkField<Integer> NUM_RETRIES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumRetries").getter(getter(HlsWebdavSettings::numRetries)).setter(setter(Builder::numRetries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numRetries").build()).build();

    private static final SdkField<Integer> RESTART_DELAY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RestartDelay").getter(getter(HlsWebdavSettings::restartDelay)).setter(setter(Builder::restartDelay))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("restartDelay").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONNECTION_RETRY_INTERVAL_FIELD, FILECACHE_DURATION_FIELD, HTTP_TRANSFER_MODE_FIELD, NUM_RETRIES_FIELD,
            RESTART_DELAY_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer connectionRetryInterval;

    private final Integer filecacheDuration;

    private final String httpTransferMode;

    private final Integer numRetries;

    private final Integer restartDelay;

    private HlsWebdavSettings(BuilderImpl builder) {
        this.connectionRetryInterval = builder.connectionRetryInterval;
        this.filecacheDuration = builder.filecacheDuration;
        this.httpTransferMode = builder.httpTransferMode;
        this.numRetries = builder.numRetries;
        this.restartDelay = builder.restartDelay;
    }

    /**
     * Number of seconds to wait before retrying connection to the CDN if the connection is lost.
     * 
     * @return Number of seconds to wait before retrying connection to the CDN if the connection is lost.
     */
    public final Integer connectionRetryInterval() {
        return connectionRetryInterval;
    }

    /**
     * Size in seconds of file cache for streaming outputs.
     * 
     * @return Size in seconds of file cache for streaming outputs.
     */
    public final Integer filecacheDuration() {
        return filecacheDuration;
    }

    /**
     * Specify whether or not to use chunked transfer encoding to WebDAV.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #httpTransferMode}
     * will return {@link HlsWebdavHttpTransferMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #httpTransferModeAsString}.
     * </p>
     * 
     * @return Specify whether or not to use chunked transfer encoding to WebDAV.
     * @see HlsWebdavHttpTransferMode
     */
    public final HlsWebdavHttpTransferMode httpTransferMode() {
        return HlsWebdavHttpTransferMode.fromValue(httpTransferMode);
    }

    /**
     * Specify whether or not to use chunked transfer encoding to WebDAV.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #httpTransferMode}
     * will return {@link HlsWebdavHttpTransferMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #httpTransferModeAsString}.
     * </p>
     * 
     * @return Specify whether or not to use chunked transfer encoding to WebDAV.
     * @see HlsWebdavHttpTransferMode
     */
    public final String httpTransferModeAsString() {
        return httpTransferMode;
    }

    /**
     * Number of retry attempts that will be made before the Live Event is put into an error state. Applies only if the
     * CDN destination URI begins with "s3" or "mediastore". For other URIs, the value is always 3.
     * 
     * @return Number of retry attempts that will be made before the Live Event is put into an error state. Applies only
     *         if the CDN destination URI begins with "s3" or "mediastore". For other URIs, the value is always 3.
     */
    public final Integer numRetries() {
        return numRetries;
    }

    /**
     * If a streaming output fails, number of seconds to wait until a restart is initiated. A value of 0 means never
     * restart.
     * 
     * @return If a streaming output fails, number of seconds to wait until a restart is initiated. A value of 0 means
     *         never restart.
     */
    public final Integer restartDelay() {
        return restartDelay;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connectionRetryInterval());
        hashCode = 31 * hashCode + Objects.hashCode(filecacheDuration());
        hashCode = 31 * hashCode + Objects.hashCode(httpTransferModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(numRetries());
        hashCode = 31 * hashCode + Objects.hashCode(restartDelay());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsWebdavSettings)) {
            return false;
        }
        HlsWebdavSettings other = (HlsWebdavSettings) obj;
        return Objects.equals(connectionRetryInterval(), other.connectionRetryInterval())
                && Objects.equals(filecacheDuration(), other.filecacheDuration())
                && Objects.equals(httpTransferModeAsString(), other.httpTransferModeAsString())
                && Objects.equals(numRetries(), other.numRetries()) && Objects.equals(restartDelay(), other.restartDelay());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HlsWebdavSettings").add("ConnectionRetryInterval", connectionRetryInterval())
                .add("FilecacheDuration", filecacheDuration()).add("HttpTransferMode", httpTransferModeAsString())
                .add("NumRetries", numRetries()).add("RestartDelay", restartDelay()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectionRetryInterval":
            return Optional.ofNullable(clazz.cast(connectionRetryInterval()));
        case "FilecacheDuration":
            return Optional.ofNullable(clazz.cast(filecacheDuration()));
        case "HttpTransferMode":
            return Optional.ofNullable(clazz.cast(httpTransferModeAsString()));
        case "NumRetries":
            return Optional.ofNullable(clazz.cast(numRetries()));
        case "RestartDelay":
            return Optional.ofNullable(clazz.cast(restartDelay()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HlsWebdavSettings, T> g) {
        return obj -> g.apply((HlsWebdavSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HlsWebdavSettings> {
        /**
         * Number of seconds to wait before retrying connection to the CDN if the connection is lost.
         * 
         * @param connectionRetryInterval
         *        Number of seconds to wait before retrying connection to the CDN if the connection is lost.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionRetryInterval(Integer connectionRetryInterval);

        /**
         * Size in seconds of file cache for streaming outputs.
         * 
         * @param filecacheDuration
         *        Size in seconds of file cache for streaming outputs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filecacheDuration(Integer filecacheDuration);

        /**
         * Specify whether or not to use chunked transfer encoding to WebDAV.
         * 
         * @param httpTransferMode
         *        Specify whether or not to use chunked transfer encoding to WebDAV.
         * @see HlsWebdavHttpTransferMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsWebdavHttpTransferMode
         */
        Builder httpTransferMode(String httpTransferMode);

        /**
         * Specify whether or not to use chunked transfer encoding to WebDAV.
         * 
         * @param httpTransferMode
         *        Specify whether or not to use chunked transfer encoding to WebDAV.
         * @see HlsWebdavHttpTransferMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsWebdavHttpTransferMode
         */
        Builder httpTransferMode(HlsWebdavHttpTransferMode httpTransferMode);

        /**
         * Number of retry attempts that will be made before the Live Event is put into an error state. Applies only if
         * the CDN destination URI begins with "s3" or "mediastore". For other URIs, the value is always 3.
         * 
         * @param numRetries
         *        Number of retry attempts that will be made before the Live Event is put into an error state. Applies
         *        only if the CDN destination URI begins with "s3" or "mediastore". For other URIs, the value is always
         *        3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numRetries(Integer numRetries);

        /**
         * If a streaming output fails, number of seconds to wait until a restart is initiated. A value of 0 means never
         * restart.
         * 
         * @param restartDelay
         *        If a streaming output fails, number of seconds to wait until a restart is initiated. A value of 0
         *        means never restart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restartDelay(Integer restartDelay);
    }

    static final class BuilderImpl implements Builder {
        private Integer connectionRetryInterval;

        private Integer filecacheDuration;

        private String httpTransferMode;

        private Integer numRetries;

        private Integer restartDelay;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsWebdavSettings model) {
            connectionRetryInterval(model.connectionRetryInterval);
            filecacheDuration(model.filecacheDuration);
            httpTransferMode(model.httpTransferMode);
            numRetries(model.numRetries);
            restartDelay(model.restartDelay);
        }

        public final Integer getConnectionRetryInterval() {
            return connectionRetryInterval;
        }

        public final void setConnectionRetryInterval(Integer connectionRetryInterval) {
            this.connectionRetryInterval = connectionRetryInterval;
        }

        @Override
        public final Builder connectionRetryInterval(Integer connectionRetryInterval) {
            this.connectionRetryInterval = connectionRetryInterval;
            return this;
        }

        public final Integer getFilecacheDuration() {
            return filecacheDuration;
        }

        public final void setFilecacheDuration(Integer filecacheDuration) {
            this.filecacheDuration = filecacheDuration;
        }

        @Override
        public final Builder filecacheDuration(Integer filecacheDuration) {
            this.filecacheDuration = filecacheDuration;
            return this;
        }

        public final String getHttpTransferMode() {
            return httpTransferMode;
        }

        public final void setHttpTransferMode(String httpTransferMode) {
            this.httpTransferMode = httpTransferMode;
        }

        @Override
        public final Builder httpTransferMode(String httpTransferMode) {
            this.httpTransferMode = httpTransferMode;
            return this;
        }

        @Override
        public final Builder httpTransferMode(HlsWebdavHttpTransferMode httpTransferMode) {
            this.httpTransferMode(httpTransferMode == null ? null : httpTransferMode.toString());
            return this;
        }

        public final Integer getNumRetries() {
            return numRetries;
        }

        public final void setNumRetries(Integer numRetries) {
            this.numRetries = numRetries;
        }

        @Override
        public final Builder numRetries(Integer numRetries) {
            this.numRetries = numRetries;
            return this;
        }

        public final Integer getRestartDelay() {
            return restartDelay;
        }

        public final void setRestartDelay(Integer restartDelay) {
            this.restartDelay = restartDelay;
        }

        @Override
        public final Builder restartDelay(Integer restartDelay) {
            this.restartDelay = restartDelay;
            return this;
        }

        @Override
        public HlsWebdavSettings build() {
            return new HlsWebdavSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
