/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Fmp4 Hls Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class Fmp4HlsSettings implements SdkPojo, Serializable, ToCopyableBuilder<Fmp4HlsSettings.Builder, Fmp4HlsSettings> {
    private static final SdkField<String> AUDIO_RENDITION_SETS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AudioRenditionSets").getter(getter(Fmp4HlsSettings::audioRenditionSets))
            .setter(setter(Builder::audioRenditionSets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioRenditionSets").build())
            .build();

    private static final SdkField<String> NIELSEN_ID3_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NielsenId3Behavior").getter(getter(Fmp4HlsSettings::nielsenId3BehaviorAsString))
            .setter(setter(Builder::nielsenId3Behavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nielsenId3Behavior").build())
            .build();

    private static final SdkField<String> TIMED_METADATA_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimedMetadataBehavior").getter(getter(Fmp4HlsSettings::timedMetadataBehaviorAsString))
            .setter(setter(Builder::timedMetadataBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timedMetadataBehavior").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_RENDITION_SETS_FIELD,
            NIELSEN_ID3_BEHAVIOR_FIELD, TIMED_METADATA_BEHAVIOR_FIELD));

    private static final long serialVersionUID = 1L;

    private final String audioRenditionSets;

    private final String nielsenId3Behavior;

    private final String timedMetadataBehavior;

    private Fmp4HlsSettings(BuilderImpl builder) {
        this.audioRenditionSets = builder.audioRenditionSets;
        this.nielsenId3Behavior = builder.nielsenId3Behavior;
        this.timedMetadataBehavior = builder.timedMetadataBehavior;
    }

    /**
     * List all the audio groups that are used with the video output stream. Input all the audio GROUP-IDs that are
     * associated to the video, separate by ','.
     * 
     * @return List all the audio groups that are used with the video output stream. Input all the audio GROUP-IDs that
     *         are associated to the video, separate by ','.
     */
    public final String audioRenditionSets() {
        return audioRenditionSets;
    }

    /**
     * If set to passthrough, Nielsen inaudible tones for media tracking will be detected in the input audio and an
     * equivalent ID3 tag will be inserted in the output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #nielsenId3Behavior} will return {@link Fmp4NielsenId3Behavior#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #nielsenId3BehaviorAsString}.
     * </p>
     * 
     * @return If set to passthrough, Nielsen inaudible tones for media tracking will be detected in the input audio and
     *         an equivalent ID3 tag will be inserted in the output.
     * @see Fmp4NielsenId3Behavior
     */
    public final Fmp4NielsenId3Behavior nielsenId3Behavior() {
        return Fmp4NielsenId3Behavior.fromValue(nielsenId3Behavior);
    }

    /**
     * If set to passthrough, Nielsen inaudible tones for media tracking will be detected in the input audio and an
     * equivalent ID3 tag will be inserted in the output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #nielsenId3Behavior} will return {@link Fmp4NielsenId3Behavior#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #nielsenId3BehaviorAsString}.
     * </p>
     * 
     * @return If set to passthrough, Nielsen inaudible tones for media tracking will be detected in the input audio and
     *         an equivalent ID3 tag will be inserted in the output.
     * @see Fmp4NielsenId3Behavior
     */
    public final String nielsenId3BehaviorAsString() {
        return nielsenId3Behavior;
    }

    /**
     * When set to passthrough, timed metadata is passed through from input to output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #timedMetadataBehavior} will return {@link Fmp4TimedMetadataBehavior#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #timedMetadataBehaviorAsString}.
     * </p>
     * 
     * @return When set to passthrough, timed metadata is passed through from input to output.
     * @see Fmp4TimedMetadataBehavior
     */
    public final Fmp4TimedMetadataBehavior timedMetadataBehavior() {
        return Fmp4TimedMetadataBehavior.fromValue(timedMetadataBehavior);
    }

    /**
     * When set to passthrough, timed metadata is passed through from input to output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #timedMetadataBehavior} will return {@link Fmp4TimedMetadataBehavior#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #timedMetadataBehaviorAsString}.
     * </p>
     * 
     * @return When set to passthrough, timed metadata is passed through from input to output.
     * @see Fmp4TimedMetadataBehavior
     */
    public final String timedMetadataBehaviorAsString() {
        return timedMetadataBehavior;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(audioRenditionSets());
        hashCode = 31 * hashCode + Objects.hashCode(nielsenId3BehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timedMetadataBehaviorAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Fmp4HlsSettings)) {
            return false;
        }
        Fmp4HlsSettings other = (Fmp4HlsSettings) obj;
        return Objects.equals(audioRenditionSets(), other.audioRenditionSets())
                && Objects.equals(nielsenId3BehaviorAsString(), other.nielsenId3BehaviorAsString())
                && Objects.equals(timedMetadataBehaviorAsString(), other.timedMetadataBehaviorAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Fmp4HlsSettings").add("AudioRenditionSets", audioRenditionSets())
                .add("NielsenId3Behavior", nielsenId3BehaviorAsString())
                .add("TimedMetadataBehavior", timedMetadataBehaviorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AudioRenditionSets":
            return Optional.ofNullable(clazz.cast(audioRenditionSets()));
        case "NielsenId3Behavior":
            return Optional.ofNullable(clazz.cast(nielsenId3BehaviorAsString()));
        case "TimedMetadataBehavior":
            return Optional.ofNullable(clazz.cast(timedMetadataBehaviorAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Fmp4HlsSettings, T> g) {
        return obj -> g.apply((Fmp4HlsSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Fmp4HlsSettings> {
        /**
         * List all the audio groups that are used with the video output stream. Input all the audio GROUP-IDs that are
         * associated to the video, separate by ','.
         * 
         * @param audioRenditionSets
         *        List all the audio groups that are used with the video output stream. Input all the audio GROUP-IDs
         *        that are associated to the video, separate by ','.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioRenditionSets(String audioRenditionSets);

        /**
         * If set to passthrough, Nielsen inaudible tones for media tracking will be detected in the input audio and an
         * equivalent ID3 tag will be inserted in the output.
         * 
         * @param nielsenId3Behavior
         *        If set to passthrough, Nielsen inaudible tones for media tracking will be detected in the input audio
         *        and an equivalent ID3 tag will be inserted in the output.
         * @see Fmp4NielsenId3Behavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Fmp4NielsenId3Behavior
         */
        Builder nielsenId3Behavior(String nielsenId3Behavior);

        /**
         * If set to passthrough, Nielsen inaudible tones for media tracking will be detected in the input audio and an
         * equivalent ID3 tag will be inserted in the output.
         * 
         * @param nielsenId3Behavior
         *        If set to passthrough, Nielsen inaudible tones for media tracking will be detected in the input audio
         *        and an equivalent ID3 tag will be inserted in the output.
         * @see Fmp4NielsenId3Behavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Fmp4NielsenId3Behavior
         */
        Builder nielsenId3Behavior(Fmp4NielsenId3Behavior nielsenId3Behavior);

        /**
         * When set to passthrough, timed metadata is passed through from input to output.
         * 
         * @param timedMetadataBehavior
         *        When set to passthrough, timed metadata is passed through from input to output.
         * @see Fmp4TimedMetadataBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Fmp4TimedMetadataBehavior
         */
        Builder timedMetadataBehavior(String timedMetadataBehavior);

        /**
         * When set to passthrough, timed metadata is passed through from input to output.
         * 
         * @param timedMetadataBehavior
         *        When set to passthrough, timed metadata is passed through from input to output.
         * @see Fmp4TimedMetadataBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Fmp4TimedMetadataBehavior
         */
        Builder timedMetadataBehavior(Fmp4TimedMetadataBehavior timedMetadataBehavior);
    }

    static final class BuilderImpl implements Builder {
        private String audioRenditionSets;

        private String nielsenId3Behavior;

        private String timedMetadataBehavior;

        private BuilderImpl() {
        }

        private BuilderImpl(Fmp4HlsSettings model) {
            audioRenditionSets(model.audioRenditionSets);
            nielsenId3Behavior(model.nielsenId3Behavior);
            timedMetadataBehavior(model.timedMetadataBehavior);
        }

        public final String getAudioRenditionSets() {
            return audioRenditionSets;
        }

        public final void setAudioRenditionSets(String audioRenditionSets) {
            this.audioRenditionSets = audioRenditionSets;
        }

        @Override
        public final Builder audioRenditionSets(String audioRenditionSets) {
            this.audioRenditionSets = audioRenditionSets;
            return this;
        }

        public final String getNielsenId3Behavior() {
            return nielsenId3Behavior;
        }

        public final void setNielsenId3Behavior(String nielsenId3Behavior) {
            this.nielsenId3Behavior = nielsenId3Behavior;
        }

        @Override
        public final Builder nielsenId3Behavior(String nielsenId3Behavior) {
            this.nielsenId3Behavior = nielsenId3Behavior;
            return this;
        }

        @Override
        public final Builder nielsenId3Behavior(Fmp4NielsenId3Behavior nielsenId3Behavior) {
            this.nielsenId3Behavior(nielsenId3Behavior == null ? null : nielsenId3Behavior.toString());
            return this;
        }

        public final String getTimedMetadataBehavior() {
            return timedMetadataBehavior;
        }

        public final void setTimedMetadataBehavior(String timedMetadataBehavior) {
            this.timedMetadataBehavior = timedMetadataBehavior;
        }

        @Override
        public final Builder timedMetadataBehavior(String timedMetadataBehavior) {
            this.timedMetadataBehavior = timedMetadataBehavior;
            return this;
        }

        @Override
        public final Builder timedMetadataBehavior(Fmp4TimedMetadataBehavior timedMetadataBehavior) {
            this.timedMetadataBehavior(timedMetadataBehavior == null ? null : timedMetadataBehavior.toString());
            return this;
        }

        @Override
        public Fmp4HlsSettings build() {
            return new Fmp4HlsSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
