/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Esam
 */
@Generated("software.amazon.awssdk:codegen")
public final class Esam implements SdkPojo, Serializable, ToCopyableBuilder<Esam.Builder, Esam> {
    private static final SdkField<String> ACQUISITION_POINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AcquisitionPointId").getter(getter(Esam::acquisitionPointId))
            .setter(setter(Builder::acquisitionPointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acquisitionPointId").build())
            .build();

    private static final SdkField<Integer> AD_AVAIL_OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AdAvailOffset").getter(getter(Esam::adAvailOffset)).setter(setter(Builder::adAvailOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adAvailOffset").build()).build();

    private static final SdkField<String> PASSWORD_PARAM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PasswordParam").getter(getter(Esam::passwordParam)).setter(setter(Builder::passwordParam))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("passwordParam").build()).build();

    private static final SdkField<String> POIS_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PoisEndpoint").getter(getter(Esam::poisEndpoint)).setter(setter(Builder::poisEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("poisEndpoint").build()).build();

    private static final SdkField<String> USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Username").getter(getter(Esam::username)).setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("username").build()).build();

    private static final SdkField<String> ZONE_IDENTITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ZoneIdentity").getter(getter(Esam::zoneIdentity)).setter(setter(Builder::zoneIdentity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("zoneIdentity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACQUISITION_POINT_ID_FIELD,
            AD_AVAIL_OFFSET_FIELD, PASSWORD_PARAM_FIELD, POIS_ENDPOINT_FIELD, USERNAME_FIELD, ZONE_IDENTITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String acquisitionPointId;

    private final Integer adAvailOffset;

    private final String passwordParam;

    private final String poisEndpoint;

    private final String username;

    private final String zoneIdentity;

    private Esam(BuilderImpl builder) {
        this.acquisitionPointId = builder.acquisitionPointId;
        this.adAvailOffset = builder.adAvailOffset;
        this.passwordParam = builder.passwordParam;
        this.poisEndpoint = builder.poisEndpoint;
        this.username = builder.username;
        this.zoneIdentity = builder.zoneIdentity;
    }

    /**
     * Sent as acquisitionPointIdentity to identify the MediaLive channel to the POIS.
     * 
     * @return Sent as acquisitionPointIdentity to identify the MediaLive channel to the POIS.
     */
    public final String acquisitionPointId() {
        return acquisitionPointId;
    }

    /**
     * When specified, this offset (in milliseconds) is added to the input Ad Avail PTS time. This only applies to
     * embedded SCTE 104/35 messages and does not apply to OOB messages.
     * 
     * @return When specified, this offset (in milliseconds) is added to the input Ad Avail PTS time. This only applies
     *         to embedded SCTE 104/35 messages and does not apply to OOB messages.
     */
    public final Integer adAvailOffset() {
        return adAvailOffset;
    }

    /**
     * Documentation update needed
     * 
     * @return Documentation update needed
     */
    public final String passwordParam() {
        return passwordParam;
    }

    /**
     * The URL of the signal conditioner endpoint on the Placement Opportunity Information System (POIS). MediaLive
     * sends SignalProcessingEvents here when SCTE-35 messages are read.
     * 
     * @return The URL of the signal conditioner endpoint on the Placement Opportunity Information System (POIS).
     *         MediaLive sends SignalProcessingEvents here when SCTE-35 messages are read.
     */
    public final String poisEndpoint() {
        return poisEndpoint;
    }

    /**
     * Documentation update needed
     * 
     * @return Documentation update needed
     */
    public final String username() {
        return username;
    }

    /**
     * Optional data sent as zoneIdentity to identify the MediaLive channel to the POIS.
     * 
     * @return Optional data sent as zoneIdentity to identify the MediaLive channel to the POIS.
     */
    public final String zoneIdentity() {
        return zoneIdentity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(acquisitionPointId());
        hashCode = 31 * hashCode + Objects.hashCode(adAvailOffset());
        hashCode = 31 * hashCode + Objects.hashCode(passwordParam());
        hashCode = 31 * hashCode + Objects.hashCode(poisEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(username());
        hashCode = 31 * hashCode + Objects.hashCode(zoneIdentity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Esam)) {
            return false;
        }
        Esam other = (Esam) obj;
        return Objects.equals(acquisitionPointId(), other.acquisitionPointId())
                && Objects.equals(adAvailOffset(), other.adAvailOffset())
                && Objects.equals(passwordParam(), other.passwordParam()) && Objects.equals(poisEndpoint(), other.poisEndpoint())
                && Objects.equals(username(), other.username()) && Objects.equals(zoneIdentity(), other.zoneIdentity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Esam").add("AcquisitionPointId", acquisitionPointId()).add("AdAvailOffset", adAvailOffset())
                .add("PasswordParam", passwordParam()).add("PoisEndpoint", poisEndpoint()).add("Username", username())
                .add("ZoneIdentity", zoneIdentity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AcquisitionPointId":
            return Optional.ofNullable(clazz.cast(acquisitionPointId()));
        case "AdAvailOffset":
            return Optional.ofNullable(clazz.cast(adAvailOffset()));
        case "PasswordParam":
            return Optional.ofNullable(clazz.cast(passwordParam()));
        case "PoisEndpoint":
            return Optional.ofNullable(clazz.cast(poisEndpoint()));
        case "Username":
            return Optional.ofNullable(clazz.cast(username()));
        case "ZoneIdentity":
            return Optional.ofNullable(clazz.cast(zoneIdentity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Esam, T> g) {
        return obj -> g.apply((Esam) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Esam> {
        /**
         * Sent as acquisitionPointIdentity to identify the MediaLive channel to the POIS.
         * 
         * @param acquisitionPointId
         *        Sent as acquisitionPointIdentity to identify the MediaLive channel to the POIS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acquisitionPointId(String acquisitionPointId);

        /**
         * When specified, this offset (in milliseconds) is added to the input Ad Avail PTS time. This only applies to
         * embedded SCTE 104/35 messages and does not apply to OOB messages.
         * 
         * @param adAvailOffset
         *        When specified, this offset (in milliseconds) is added to the input Ad Avail PTS time. This only
         *        applies to embedded SCTE 104/35 messages and does not apply to OOB messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adAvailOffset(Integer adAvailOffset);

        /**
         * Documentation update needed
         * 
         * @param passwordParam
         *        Documentation update needed
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder passwordParam(String passwordParam);

        /**
         * The URL of the signal conditioner endpoint on the Placement Opportunity Information System (POIS). MediaLive
         * sends SignalProcessingEvents here when SCTE-35 messages are read.
         * 
         * @param poisEndpoint
         *        The URL of the signal conditioner endpoint on the Placement Opportunity Information System (POIS).
         *        MediaLive sends SignalProcessingEvents here when SCTE-35 messages are read.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poisEndpoint(String poisEndpoint);

        /**
         * Documentation update needed
         * 
         * @param username
         *        Documentation update needed
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);

        /**
         * Optional data sent as zoneIdentity to identify the MediaLive channel to the POIS.
         * 
         * @param zoneIdentity
         *        Optional data sent as zoneIdentity to identify the MediaLive channel to the POIS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zoneIdentity(String zoneIdentity);
    }

    static final class BuilderImpl implements Builder {
        private String acquisitionPointId;

        private Integer adAvailOffset;

        private String passwordParam;

        private String poisEndpoint;

        private String username;

        private String zoneIdentity;

        private BuilderImpl() {
        }

        private BuilderImpl(Esam model) {
            acquisitionPointId(model.acquisitionPointId);
            adAvailOffset(model.adAvailOffset);
            passwordParam(model.passwordParam);
            poisEndpoint(model.poisEndpoint);
            username(model.username);
            zoneIdentity(model.zoneIdentity);
        }

        public final String getAcquisitionPointId() {
            return acquisitionPointId;
        }

        public final void setAcquisitionPointId(String acquisitionPointId) {
            this.acquisitionPointId = acquisitionPointId;
        }

        @Override
        public final Builder acquisitionPointId(String acquisitionPointId) {
            this.acquisitionPointId = acquisitionPointId;
            return this;
        }

        public final Integer getAdAvailOffset() {
            return adAvailOffset;
        }

        public final void setAdAvailOffset(Integer adAvailOffset) {
            this.adAvailOffset = adAvailOffset;
        }

        @Override
        public final Builder adAvailOffset(Integer adAvailOffset) {
            this.adAvailOffset = adAvailOffset;
            return this;
        }

        public final String getPasswordParam() {
            return passwordParam;
        }

        public final void setPasswordParam(String passwordParam) {
            this.passwordParam = passwordParam;
        }

        @Override
        public final Builder passwordParam(String passwordParam) {
            this.passwordParam = passwordParam;
            return this;
        }

        public final String getPoisEndpoint() {
            return poisEndpoint;
        }

        public final void setPoisEndpoint(String poisEndpoint) {
            this.poisEndpoint = poisEndpoint;
        }

        @Override
        public final Builder poisEndpoint(String poisEndpoint) {
            this.poisEndpoint = poisEndpoint;
            return this;
        }

        public final String getUsername() {
            return username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final String getZoneIdentity() {
            return zoneIdentity;
        }

        public final void setZoneIdentity(String zoneIdentity) {
            this.zoneIdentity = zoneIdentity;
        }

        @Override
        public final Builder zoneIdentity(String zoneIdentity) {
            this.zoneIdentity = zoneIdentity;
            return this;
        }

        @Override
        public Esam build() {
            return new Esam(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
