/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Required when you set Codec to the value XAVC.
 */
@Generated("software.amazon.awssdk:codegen")
public final class XavcSettings implements SdkPojo, Serializable, ToCopyableBuilder<XavcSettings.Builder, XavcSettings> {
    private static final SdkField<String> ADAPTIVE_QUANTIZATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AdaptiveQuantization").getter(getter(XavcSettings::adaptiveQuantizationAsString))
            .setter(setter(Builder::adaptiveQuantization))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adaptiveQuantization").build())
            .build();

    private static final SdkField<String> ENTROPY_ENCODING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EntropyEncoding").getter(getter(XavcSettings::entropyEncodingAsString))
            .setter(setter(Builder::entropyEncoding))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entropyEncoding").build()).build();

    private static final SdkField<String> FRAMERATE_CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FramerateControl").getter(getter(XavcSettings::framerateControlAsString))
            .setter(setter(Builder::framerateControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateControl").build()).build();

    private static final SdkField<String> FRAMERATE_CONVERSION_ALGORITHM_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("FramerateConversionAlgorithm")
            .getter(getter(XavcSettings::framerateConversionAlgorithmAsString))
            .setter(setter(Builder::framerateConversionAlgorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateConversionAlgorithm")
                    .build()).build();

    private static final SdkField<Integer> FRAMERATE_DENOMINATOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FramerateDenominator").getter(getter(XavcSettings::framerateDenominator))
            .setter(setter(Builder::framerateDenominator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateDenominator").build())
            .build();

    private static final SdkField<Integer> FRAMERATE_NUMERATOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FramerateNumerator").getter(getter(XavcSettings::framerateNumerator))
            .setter(setter(Builder::framerateNumerator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateNumerator").build())
            .build();

    private static final SdkField<String> PROFILE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Profile")
            .getter(getter(XavcSettings::profileAsString)).setter(setter(Builder::profile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profile").build()).build();

    private static final SdkField<String> SLOW_PAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SlowPal").getter(getter(XavcSettings::slowPalAsString)).setter(setter(Builder::slowPal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slowPal").build()).build();

    private static final SdkField<Integer> SOFTNESS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Softness").getter(getter(XavcSettings::softness)).setter(setter(Builder::softness))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("softness").build()).build();

    private static final SdkField<String> SPATIAL_ADAPTIVE_QUANTIZATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SpatialAdaptiveQuantization")
            .getter(getter(XavcSettings::spatialAdaptiveQuantizationAsString))
            .setter(setter(Builder::spatialAdaptiveQuantization))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spatialAdaptiveQuantization")
                    .build()).build();

    private static final SdkField<String> TEMPORAL_ADAPTIVE_QUANTIZATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TemporalAdaptiveQuantization")
            .getter(getter(XavcSettings::temporalAdaptiveQuantizationAsString))
            .setter(setter(Builder::temporalAdaptiveQuantization))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("temporalAdaptiveQuantization")
                    .build()).build();

    private static final SdkField<Xavc4kIntraCbgProfileSettings> XAVC4_K_INTRA_CBG_PROFILE_SETTINGS_FIELD = SdkField
            .<Xavc4kIntraCbgProfileSettings> builder(MarshallingType.SDK_POJO)
            .memberName("Xavc4kIntraCbgProfileSettings")
            .getter(getter(XavcSettings::xavc4kIntraCbgProfileSettings))
            .setter(setter(Builder::xavc4kIntraCbgProfileSettings))
            .constructor(Xavc4kIntraCbgProfileSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("xavc4kIntraCbgProfileSettings")
                    .build()).build();

    private static final SdkField<Xavc4kIntraVbrProfileSettings> XAVC4_K_INTRA_VBR_PROFILE_SETTINGS_FIELD = SdkField
            .<Xavc4kIntraVbrProfileSettings> builder(MarshallingType.SDK_POJO)
            .memberName("Xavc4kIntraVbrProfileSettings")
            .getter(getter(XavcSettings::xavc4kIntraVbrProfileSettings))
            .setter(setter(Builder::xavc4kIntraVbrProfileSettings))
            .constructor(Xavc4kIntraVbrProfileSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("xavc4kIntraVbrProfileSettings")
                    .build()).build();

    private static final SdkField<Xavc4kProfileSettings> XAVC4_K_PROFILE_SETTINGS_FIELD = SdkField
            .<Xavc4kProfileSettings> builder(MarshallingType.SDK_POJO).memberName("Xavc4kProfileSettings")
            .getter(getter(XavcSettings::xavc4kProfileSettings)).setter(setter(Builder::xavc4kProfileSettings))
            .constructor(Xavc4kProfileSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("xavc4kProfileSettings").build())
            .build();

    private static final SdkField<XavcHdIntraCbgProfileSettings> XAVC_HD_INTRA_CBG_PROFILE_SETTINGS_FIELD = SdkField
            .<XavcHdIntraCbgProfileSettings> builder(MarshallingType.SDK_POJO)
            .memberName("XavcHdIntraCbgProfileSettings")
            .getter(getter(XavcSettings::xavcHdIntraCbgProfileSettings))
            .setter(setter(Builder::xavcHdIntraCbgProfileSettings))
            .constructor(XavcHdIntraCbgProfileSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("xavcHdIntraCbgProfileSettings")
                    .build()).build();

    private static final SdkField<XavcHdProfileSettings> XAVC_HD_PROFILE_SETTINGS_FIELD = SdkField
            .<XavcHdProfileSettings> builder(MarshallingType.SDK_POJO).memberName("XavcHdProfileSettings")
            .getter(getter(XavcSettings::xavcHdProfileSettings)).setter(setter(Builder::xavcHdProfileSettings))
            .constructor(XavcHdProfileSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("xavcHdProfileSettings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADAPTIVE_QUANTIZATION_FIELD,
            ENTROPY_ENCODING_FIELD, FRAMERATE_CONTROL_FIELD, FRAMERATE_CONVERSION_ALGORITHM_FIELD, FRAMERATE_DENOMINATOR_FIELD,
            FRAMERATE_NUMERATOR_FIELD, PROFILE_FIELD, SLOW_PAL_FIELD, SOFTNESS_FIELD, SPATIAL_ADAPTIVE_QUANTIZATION_FIELD,
            TEMPORAL_ADAPTIVE_QUANTIZATION_FIELD, XAVC4_K_INTRA_CBG_PROFILE_SETTINGS_FIELD,
            XAVC4_K_INTRA_VBR_PROFILE_SETTINGS_FIELD, XAVC4_K_PROFILE_SETTINGS_FIELD, XAVC_HD_INTRA_CBG_PROFILE_SETTINGS_FIELD,
            XAVC_HD_PROFILE_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String adaptiveQuantization;

    private final String entropyEncoding;

    private final String framerateControl;

    private final String framerateConversionAlgorithm;

    private final Integer framerateDenominator;

    private final Integer framerateNumerator;

    private final String profile;

    private final String slowPal;

    private final Integer softness;

    private final String spatialAdaptiveQuantization;

    private final String temporalAdaptiveQuantization;

    private final Xavc4kIntraCbgProfileSettings xavc4kIntraCbgProfileSettings;

    private final Xavc4kIntraVbrProfileSettings xavc4kIntraVbrProfileSettings;

    private final Xavc4kProfileSettings xavc4kProfileSettings;

    private final XavcHdIntraCbgProfileSettings xavcHdIntraCbgProfileSettings;

    private final XavcHdProfileSettings xavcHdProfileSettings;

    private XavcSettings(BuilderImpl builder) {
        this.adaptiveQuantization = builder.adaptiveQuantization;
        this.entropyEncoding = builder.entropyEncoding;
        this.framerateControl = builder.framerateControl;
        this.framerateConversionAlgorithm = builder.framerateConversionAlgorithm;
        this.framerateDenominator = builder.framerateDenominator;
        this.framerateNumerator = builder.framerateNumerator;
        this.profile = builder.profile;
        this.slowPal = builder.slowPal;
        this.softness = builder.softness;
        this.spatialAdaptiveQuantization = builder.spatialAdaptiveQuantization;
        this.temporalAdaptiveQuantization = builder.temporalAdaptiveQuantization;
        this.xavc4kIntraCbgProfileSettings = builder.xavc4kIntraCbgProfileSettings;
        this.xavc4kIntraVbrProfileSettings = builder.xavc4kIntraVbrProfileSettings;
        this.xavc4kProfileSettings = builder.xavc4kProfileSettings;
        this.xavcHdIntraCbgProfileSettings = builder.xavcHdIntraCbgProfileSettings;
        this.xavcHdProfileSettings = builder.xavcHdProfileSettings;
    }

    /**
     * Keep the default value, Auto, for this setting to have MediaConvert automatically apply the best types of
     * quantization for your video content. When you want to apply your quantization settings manually, you must set
     * Adaptive quantization to a value other than Auto. Use this setting to specify the strength of any adaptive
     * quantization filters that you enable. If you don't want MediaConvert to do any adaptive quantization in this
     * transcode, set Adaptive quantization to Off. Related settings: The value that you choose here applies to the
     * following settings: Flicker adaptive quantization (flickerAdaptiveQuantization), Spatial adaptive quantization,
     * and Temporal adaptive quantization.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #adaptiveQuantization} will return {@link XavcAdaptiveQuantization#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #adaptiveQuantizationAsString}.
     * </p>
     * 
     * @return Keep the default value, Auto, for this setting to have MediaConvert automatically apply the best types of
     *         quantization for your video content. When you want to apply your quantization settings manually, you must
     *         set Adaptive quantization to a value other than Auto. Use this setting to specify the strength of any
     *         adaptive quantization filters that you enable. If you don't want MediaConvert to do any adaptive
     *         quantization in this transcode, set Adaptive quantization to Off. Related settings: The value that you
     *         choose here applies to the following settings: Flicker adaptive quantization
     *         (flickerAdaptiveQuantization), Spatial adaptive quantization, and Temporal adaptive quantization.
     * @see XavcAdaptiveQuantization
     */
    public final XavcAdaptiveQuantization adaptiveQuantization() {
        return XavcAdaptiveQuantization.fromValue(adaptiveQuantization);
    }

    /**
     * Keep the default value, Auto, for this setting to have MediaConvert automatically apply the best types of
     * quantization for your video content. When you want to apply your quantization settings manually, you must set
     * Adaptive quantization to a value other than Auto. Use this setting to specify the strength of any adaptive
     * quantization filters that you enable. If you don't want MediaConvert to do any adaptive quantization in this
     * transcode, set Adaptive quantization to Off. Related settings: The value that you choose here applies to the
     * following settings: Flicker adaptive quantization (flickerAdaptiveQuantization), Spatial adaptive quantization,
     * and Temporal adaptive quantization.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #adaptiveQuantization} will return {@link XavcAdaptiveQuantization#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #adaptiveQuantizationAsString}.
     * </p>
     * 
     * @return Keep the default value, Auto, for this setting to have MediaConvert automatically apply the best types of
     *         quantization for your video content. When you want to apply your quantization settings manually, you must
     *         set Adaptive quantization to a value other than Auto. Use this setting to specify the strength of any
     *         adaptive quantization filters that you enable. If you don't want MediaConvert to do any adaptive
     *         quantization in this transcode, set Adaptive quantization to Off. Related settings: The value that you
     *         choose here applies to the following settings: Flicker adaptive quantization
     *         (flickerAdaptiveQuantization), Spatial adaptive quantization, and Temporal adaptive quantization.
     * @see XavcAdaptiveQuantization
     */
    public final String adaptiveQuantizationAsString() {
        return adaptiveQuantization;
    }

    /**
     * Optional. Choose a specific entropy encoding mode only when you want to override XAVC recommendations. If you
     * choose the value auto, MediaConvert uses the mode that the XAVC file format specifies given this output's
     * operating point.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #entropyEncoding}
     * will return {@link XavcEntropyEncoding#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #entropyEncodingAsString}.
     * </p>
     * 
     * @return Optional. Choose a specific entropy encoding mode only when you want to override XAVC recommendations. If
     *         you choose the value auto, MediaConvert uses the mode that the XAVC file format specifies given this
     *         output's operating point.
     * @see XavcEntropyEncoding
     */
    public final XavcEntropyEncoding entropyEncoding() {
        return XavcEntropyEncoding.fromValue(entropyEncoding);
    }

    /**
     * Optional. Choose a specific entropy encoding mode only when you want to override XAVC recommendations. If you
     * choose the value auto, MediaConvert uses the mode that the XAVC file format specifies given this output's
     * operating point.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #entropyEncoding}
     * will return {@link XavcEntropyEncoding#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #entropyEncodingAsString}.
     * </p>
     * 
     * @return Optional. Choose a specific entropy encoding mode only when you want to override XAVC recommendations. If
     *         you choose the value auto, MediaConvert uses the mode that the XAVC file format specifies given this
     *         output's operating point.
     * @see XavcEntropyEncoding
     */
    public final String entropyEncodingAsString() {
        return entropyEncoding;
    }

    /**
     * If you are using the console, use the Frame rate setting to specify the frame rate for this output. If you want
     * to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion,
     * choose a frame rate from the dropdown list. The framerates shown in the dropdown list are decimal approximations
     * of fractions.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #framerateControl}
     * will return {@link XavcFramerateControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #framerateControlAsString}.
     * </p>
     * 
     * @return If you are using the console, use the Frame rate setting to specify the frame rate for this output. If
     *         you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame
     *         rate conversion, choose a frame rate from the dropdown list. The framerates shown in the dropdown list
     *         are decimal approximations of fractions.
     * @see XavcFramerateControl
     */
    public final XavcFramerateControl framerateControl() {
        return XavcFramerateControl.fromValue(framerateControl);
    }

    /**
     * If you are using the console, use the Frame rate setting to specify the frame rate for this output. If you want
     * to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion,
     * choose a frame rate from the dropdown list. The framerates shown in the dropdown list are decimal approximations
     * of fractions.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #framerateControl}
     * will return {@link XavcFramerateControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #framerateControlAsString}.
     * </p>
     * 
     * @return If you are using the console, use the Frame rate setting to specify the frame rate for this output. If
     *         you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame
     *         rate conversion, choose a frame rate from the dropdown list. The framerates shown in the dropdown list
     *         are decimal approximations of fractions.
     * @see XavcFramerateControl
     */
    public final String framerateControlAsString() {
        return framerateControl;
    }

    /**
     * Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. For numerically
     * simple conversions, such as 60 fps to 30 fps: We recommend that you keep the default value, Drop duplicate. For
     * numerically complex conversions, to avoid stutter: Choose Interpolate. This results in a smooth picture, but
     * might introduce undesirable video artifacts. For complex frame rate conversions, especially if your source video
     * has already been converted from its original cadence: Choose FrameFormer to do motion-compensated interpolation.
     * FrameFormer uses the best conversion method frame by frame. Note that using FrameFormer increases the transcoding
     * time and incurs a significant add-on cost. When you choose FrameFormer, your input video resolution must be at
     * least 128x96.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #framerateConversionAlgorithm} will return {@link XavcFramerateConversionAlgorithm#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #framerateConversionAlgorithmAsString}.
     * </p>
     * 
     * @return Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. For
     *         numerically simple conversions, such as 60 fps to 30 fps: We recommend that you keep the default value,
     *         Drop duplicate. For numerically complex conversions, to avoid stutter: Choose Interpolate. This results
     *         in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions,
     *         especially if your source video has already been converted from its original cadence: Choose FrameFormer
     *         to do motion-compensated interpolation. FrameFormer uses the best conversion method frame by frame. Note
     *         that using FrameFormer increases the transcoding time and incurs a significant add-on cost. When you
     *         choose FrameFormer, your input video resolution must be at least 128x96.
     * @see XavcFramerateConversionAlgorithm
     */
    public final XavcFramerateConversionAlgorithm framerateConversionAlgorithm() {
        return XavcFramerateConversionAlgorithm.fromValue(framerateConversionAlgorithm);
    }

    /**
     * Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. For numerically
     * simple conversions, such as 60 fps to 30 fps: We recommend that you keep the default value, Drop duplicate. For
     * numerically complex conversions, to avoid stutter: Choose Interpolate. This results in a smooth picture, but
     * might introduce undesirable video artifacts. For complex frame rate conversions, especially if your source video
     * has already been converted from its original cadence: Choose FrameFormer to do motion-compensated interpolation.
     * FrameFormer uses the best conversion method frame by frame. Note that using FrameFormer increases the transcoding
     * time and incurs a significant add-on cost. When you choose FrameFormer, your input video resolution must be at
     * least 128x96.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #framerateConversionAlgorithm} will return {@link XavcFramerateConversionAlgorithm#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #framerateConversionAlgorithmAsString}.
     * </p>
     * 
     * @return Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. For
     *         numerically simple conversions, such as 60 fps to 30 fps: We recommend that you keep the default value,
     *         Drop duplicate. For numerically complex conversions, to avoid stutter: Choose Interpolate. This results
     *         in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions,
     *         especially if your source video has already been converted from its original cadence: Choose FrameFormer
     *         to do motion-compensated interpolation. FrameFormer uses the best conversion method frame by frame. Note
     *         that using FrameFormer increases the transcoding time and incurs a significant add-on cost. When you
     *         choose FrameFormer, your input video resolution must be at least 128x96.
     * @see XavcFramerateConversionAlgorithm
     */
    public final String framerateConversionAlgorithmAsString() {
        return framerateConversionAlgorithm;
    }

    /**
     * When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For
     * example, 24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction. In this
     * example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs that use
     * frame rate conversion, provide the value as a decimal number for Frame rate. In this example, specify 23.976.
     * 
     * @return When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a
     *         fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of
     *         this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the console
     *         for transcode jobs that use frame rate conversion, provide the value as a decimal number for Frame rate.
     *         In this example, specify 23.976.
     */
    public final Integer framerateDenominator() {
        return framerateDenominator;
    }

    /**
     * When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For
     * example, 24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In this
     * example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that use
     * frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
     * 
     * @return When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a
     *         fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this
     *         fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the console for
     *         transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In
     *         this example, specify 23.976.
     */
    public final Integer framerateNumerator() {
        return framerateNumerator;
    }

    /**
     * Specify the XAVC profile for this output. For more information, see the Sony documentation at
     * https://www.xavc-info.org/. Note that MediaConvert doesn't support the interlaced video XAVC operating points for
     * XAVC_HD_INTRA_CBG. To create an interlaced XAVC output, choose the profile XAVC_HD.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #profile} will
     * return {@link XavcProfile#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #profileAsString}.
     * </p>
     * 
     * @return Specify the XAVC profile for this output. For more information, see the Sony documentation at
     *         https://www.xavc-info.org/. Note that MediaConvert doesn't support the interlaced video XAVC operating
     *         points for XAVC_HD_INTRA_CBG. To create an interlaced XAVC output, choose the profile XAVC_HD.
     * @see XavcProfile
     */
    public final XavcProfile profile() {
        return XavcProfile.fromValue(profile);
    }

    /**
     * Specify the XAVC profile for this output. For more information, see the Sony documentation at
     * https://www.xavc-info.org/. Note that MediaConvert doesn't support the interlaced video XAVC operating points for
     * XAVC_HD_INTRA_CBG. To create an interlaced XAVC output, choose the profile XAVC_HD.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #profile} will
     * return {@link XavcProfile#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #profileAsString}.
     * </p>
     * 
     * @return Specify the XAVC profile for this output. For more information, see the Sony documentation at
     *         https://www.xavc-info.org/. Note that MediaConvert doesn't support the interlaced video XAVC operating
     *         points for XAVC_HD_INTRA_CBG. To create an interlaced XAVC output, choose the profile XAVC_HD.
     * @see XavcProfile
     */
    public final String profileAsString() {
        return profile;
    }

    /**
     * Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to
     * create a 25 fps output by relabeling the video frames and resampling your audio. Note that enabling this setting
     * will slightly reduce the duration of your video. Related settings: You must also set Frame rate to 25.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #slowPal} will
     * return {@link XavcSlowPal#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #slowPalAsString}.
     * </p>
     * 
     * @return Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL
     *         to create a 25 fps output by relabeling the video frames and resampling your audio. Note that enabling
     *         this setting will slightly reduce the duration of your video. Related settings: You must also set Frame
     *         rate to 25.
     * @see XavcSlowPal
     */
    public final XavcSlowPal slowPal() {
        return XavcSlowPal.fromValue(slowPal);
    }

    /**
     * Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to
     * create a 25 fps output by relabeling the video frames and resampling your audio. Note that enabling this setting
     * will slightly reduce the duration of your video. Related settings: You must also set Frame rate to 25.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #slowPal} will
     * return {@link XavcSlowPal#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #slowPalAsString}.
     * </p>
     * 
     * @return Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL
     *         to create a 25 fps output by relabeling the video frames and resampling your audio. Note that enabling
     *         this setting will slightly reduce the duration of your video. Related settings: You must also set Frame
     *         rate to 25.
     * @see XavcSlowPal
     */
    public final String slowPalAsString() {
        return slowPal;
    }

    /**
     * Ignore this setting unless your downstream workflow requires that you specify it explicitly. Otherwise, we
     * recommend that you adjust the softness of your output by using a lower value for the setting Sharpness or by
     * enabling a noise reducer filter. The Softness setting specifies the quantization matrices that the encoder uses.
     * Keep the default value, 0, for flat quantization. Choose the value 1 or 16 to use the default JVT softening
     * quantization matricies from the H.264 specification. Choose a value from 17 to 128 to use planar interpolation.
     * Increasing values from 17 to 128 result in increasing reduction of high-frequency data. The value 128 results in
     * the softest video.
     * 
     * @return Ignore this setting unless your downstream workflow requires that you specify it explicitly. Otherwise,
     *         we recommend that you adjust the softness of your output by using a lower value for the setting Sharpness
     *         or by enabling a noise reducer filter. The Softness setting specifies the quantization matrices that the
     *         encoder uses. Keep the default value, 0, for flat quantization. Choose the value 1 or 16 to use the
     *         default JVT softening quantization matricies from the H.264 specification. Choose a value from 17 to 128
     *         to use planar interpolation. Increasing values from 17 to 128 result in increasing reduction of
     *         high-frequency data. The value 128 results in the softest video.
     */
    public final Integer softness() {
        return softness;
    }

    /**
     * The best way to set up adaptive quantization is to keep the default value, Auto, for the setting Adaptive
     * quantization. When you do so, MediaConvert automatically applies the best types of quantization for your video
     * content. Include this setting in your JSON job specification only when you choose to change the default value for
     * Adaptive quantization. For this setting, keep the default value, Enabled, to adjust quantization within each
     * frame based on spatial variation of content complexity. When you enable this feature, the encoder uses fewer bits
     * on areas that can sustain more distortion with no noticeable visual degradation and uses more bits on areas where
     * any small distortion will be noticeable. For example, complex textured blocks are encoded with fewer bits and
     * smooth textured blocks are encoded with more bits. Enabling this feature will almost always improve your video
     * quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to be.
     * If viewers are likely to be focusing their attention on a part of the screen with a lot of complex texture, you
     * might choose to disable this feature. Related setting: When you enable spatial adaptive quantization, set the
     * value for Adaptive quantization depending on your content. For homogeneous content, such as cartoons and video
     * games, set it to Low. For content with a wider variety of textures, set it to High or Higher.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #spatialAdaptiveQuantization} will return {@link XavcSpatialAdaptiveQuantization#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #spatialAdaptiveQuantizationAsString}.
     * </p>
     * 
     * @return The best way to set up adaptive quantization is to keep the default value, Auto, for the setting Adaptive
     *         quantization. When you do so, MediaConvert automatically applies the best types of quantization for your
     *         video content. Include this setting in your JSON job specification only when you choose to change the
     *         default value for Adaptive quantization. For this setting, keep the default value, Enabled, to adjust
     *         quantization within each frame based on spatial variation of content complexity. When you enable this
     *         feature, the encoder uses fewer bits on areas that can sustain more distortion with no noticeable visual
     *         degradation and uses more bits on areas where any small distortion will be noticeable. For example,
     *         complex textured blocks are encoded with fewer bits and smooth textured blocks are encoded with more
     *         bits. Enabling this feature will almost always improve your video quality. Note, though, that this
     *         feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to
     *         be focusing their attention on a part of the screen with a lot of complex texture, you might choose to
     *         disable this feature. Related setting: When you enable spatial adaptive quantization, set the value for
     *         Adaptive quantization depending on your content. For homogeneous content, such as cartoons and video
     *         games, set it to Low. For content with a wider variety of textures, set it to High or Higher.
     * @see XavcSpatialAdaptiveQuantization
     */
    public final XavcSpatialAdaptiveQuantization spatialAdaptiveQuantization() {
        return XavcSpatialAdaptiveQuantization.fromValue(spatialAdaptiveQuantization);
    }

    /**
     * The best way to set up adaptive quantization is to keep the default value, Auto, for the setting Adaptive
     * quantization. When you do so, MediaConvert automatically applies the best types of quantization for your video
     * content. Include this setting in your JSON job specification only when you choose to change the default value for
     * Adaptive quantization. For this setting, keep the default value, Enabled, to adjust quantization within each
     * frame based on spatial variation of content complexity. When you enable this feature, the encoder uses fewer bits
     * on areas that can sustain more distortion with no noticeable visual degradation and uses more bits on areas where
     * any small distortion will be noticeable. For example, complex textured blocks are encoded with fewer bits and
     * smooth textured blocks are encoded with more bits. Enabling this feature will almost always improve your video
     * quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to be.
     * If viewers are likely to be focusing their attention on a part of the screen with a lot of complex texture, you
     * might choose to disable this feature. Related setting: When you enable spatial adaptive quantization, set the
     * value for Adaptive quantization depending on your content. For homogeneous content, such as cartoons and video
     * games, set it to Low. For content with a wider variety of textures, set it to High or Higher.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #spatialAdaptiveQuantization} will return {@link XavcSpatialAdaptiveQuantization#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #spatialAdaptiveQuantizationAsString}.
     * </p>
     * 
     * @return The best way to set up adaptive quantization is to keep the default value, Auto, for the setting Adaptive
     *         quantization. When you do so, MediaConvert automatically applies the best types of quantization for your
     *         video content. Include this setting in your JSON job specification only when you choose to change the
     *         default value for Adaptive quantization. For this setting, keep the default value, Enabled, to adjust
     *         quantization within each frame based on spatial variation of content complexity. When you enable this
     *         feature, the encoder uses fewer bits on areas that can sustain more distortion with no noticeable visual
     *         degradation and uses more bits on areas where any small distortion will be noticeable. For example,
     *         complex textured blocks are encoded with fewer bits and smooth textured blocks are encoded with more
     *         bits. Enabling this feature will almost always improve your video quality. Note, though, that this
     *         feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to
     *         be focusing their attention on a part of the screen with a lot of complex texture, you might choose to
     *         disable this feature. Related setting: When you enable spatial adaptive quantization, set the value for
     *         Adaptive quantization depending on your content. For homogeneous content, such as cartoons and video
     *         games, set it to Low. For content with a wider variety of textures, set it to High or Higher.
     * @see XavcSpatialAdaptiveQuantization
     */
    public final String spatialAdaptiveQuantizationAsString() {
        return spatialAdaptiveQuantization;
    }

    /**
     * The best way to set up adaptive quantization is to keep the default value, Auto, for the setting Adaptive
     * quantization. When you do so, MediaConvert automatically applies the best types of quantization for your video
     * content. Include this setting in your JSON job specification only when you choose to change the default value for
     * Adaptive quantization. For this setting, keep the default value, Enabled, to adjust quantization within each
     * frame based on temporal variation of content complexity. When you enable this feature, the encoder uses fewer
     * bits on areas of the frame that aren't moving and uses more bits on complex objects with sharp edges that move a
     * lot. For example, this feature improves the readability of text tickers on newscasts and scoreboards on sports
     * matches. Enabling this feature will almost always improve your video quality. Note, though, that this feature
     * doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be focusing
     * their attention on a part of the screen that doesn't have moving objects with sharp edges, such as sports
     * athletes' faces, you might choose to disable this feature. Related setting: When you enable temporal adaptive
     * quantization, adjust the strength of the filter with the setting Adaptive quantization.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #temporalAdaptiveQuantization} will return {@link XavcTemporalAdaptiveQuantization#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #temporalAdaptiveQuantizationAsString}.
     * </p>
     * 
     * @return The best way to set up adaptive quantization is to keep the default value, Auto, for the setting Adaptive
     *         quantization. When you do so, MediaConvert automatically applies the best types of quantization for your
     *         video content. Include this setting in your JSON job specification only when you choose to change the
     *         default value for Adaptive quantization. For this setting, keep the default value, Enabled, to adjust
     *         quantization within each frame based on temporal variation of content complexity. When you enable this
     *         feature, the encoder uses fewer bits on areas of the frame that aren't moving and uses more bits on
     *         complex objects with sharp edges that move a lot. For example, this feature improves the readability of
     *         text tickers on newscasts and scoreboards on sports matches. Enabling this feature will almost always
     *         improve your video quality. Note, though, that this feature doesn't take into account where the viewer's
     *         attention is likely to be. If viewers are likely to be focusing their attention on a part of the screen
     *         that doesn't have moving objects with sharp edges, such as sports athletes' faces, you might choose to
     *         disable this feature. Related setting: When you enable temporal adaptive quantization, adjust the
     *         strength of the filter with the setting Adaptive quantization.
     * @see XavcTemporalAdaptiveQuantization
     */
    public final XavcTemporalAdaptiveQuantization temporalAdaptiveQuantization() {
        return XavcTemporalAdaptiveQuantization.fromValue(temporalAdaptiveQuantization);
    }

    /**
     * The best way to set up adaptive quantization is to keep the default value, Auto, for the setting Adaptive
     * quantization. When you do so, MediaConvert automatically applies the best types of quantization for your video
     * content. Include this setting in your JSON job specification only when you choose to change the default value for
     * Adaptive quantization. For this setting, keep the default value, Enabled, to adjust quantization within each
     * frame based on temporal variation of content complexity. When you enable this feature, the encoder uses fewer
     * bits on areas of the frame that aren't moving and uses more bits on complex objects with sharp edges that move a
     * lot. For example, this feature improves the readability of text tickers on newscasts and scoreboards on sports
     * matches. Enabling this feature will almost always improve your video quality. Note, though, that this feature
     * doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be focusing
     * their attention on a part of the screen that doesn't have moving objects with sharp edges, such as sports
     * athletes' faces, you might choose to disable this feature. Related setting: When you enable temporal adaptive
     * quantization, adjust the strength of the filter with the setting Adaptive quantization.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #temporalAdaptiveQuantization} will return {@link XavcTemporalAdaptiveQuantization#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #temporalAdaptiveQuantizationAsString}.
     * </p>
     * 
     * @return The best way to set up adaptive quantization is to keep the default value, Auto, for the setting Adaptive
     *         quantization. When you do so, MediaConvert automatically applies the best types of quantization for your
     *         video content. Include this setting in your JSON job specification only when you choose to change the
     *         default value for Adaptive quantization. For this setting, keep the default value, Enabled, to adjust
     *         quantization within each frame based on temporal variation of content complexity. When you enable this
     *         feature, the encoder uses fewer bits on areas of the frame that aren't moving and uses more bits on
     *         complex objects with sharp edges that move a lot. For example, this feature improves the readability of
     *         text tickers on newscasts and scoreboards on sports matches. Enabling this feature will almost always
     *         improve your video quality. Note, though, that this feature doesn't take into account where the viewer's
     *         attention is likely to be. If viewers are likely to be focusing their attention on a part of the screen
     *         that doesn't have moving objects with sharp edges, such as sports athletes' faces, you might choose to
     *         disable this feature. Related setting: When you enable temporal adaptive quantization, adjust the
     *         strength of the filter with the setting Adaptive quantization.
     * @see XavcTemporalAdaptiveQuantization
     */
    public final String temporalAdaptiveQuantizationAsString() {
        return temporalAdaptiveQuantization;
    }

    /**
     * Required when you set Profile to the value XAVC_4K_INTRA_CBG.
     * 
     * @return Required when you set Profile to the value XAVC_4K_INTRA_CBG.
     */
    public final Xavc4kIntraCbgProfileSettings xavc4kIntraCbgProfileSettings() {
        return xavc4kIntraCbgProfileSettings;
    }

    /**
     * Required when you set Profile to the value XAVC_4K_INTRA_VBR.
     * 
     * @return Required when you set Profile to the value XAVC_4K_INTRA_VBR.
     */
    public final Xavc4kIntraVbrProfileSettings xavc4kIntraVbrProfileSettings() {
        return xavc4kIntraVbrProfileSettings;
    }

    /**
     * Required when you set Profile to the value XAVC_4K.
     * 
     * @return Required when you set Profile to the value XAVC_4K.
     */
    public final Xavc4kProfileSettings xavc4kProfileSettings() {
        return xavc4kProfileSettings;
    }

    /**
     * Required when you set Profile to the value XAVC_HD_INTRA_CBG.
     * 
     * @return Required when you set Profile to the value XAVC_HD_INTRA_CBG.
     */
    public final XavcHdIntraCbgProfileSettings xavcHdIntraCbgProfileSettings() {
        return xavcHdIntraCbgProfileSettings;
    }

    /**
     * Required when you set Profile to the value XAVC_HD.
     * 
     * @return Required when you set Profile to the value XAVC_HD.
     */
    public final XavcHdProfileSettings xavcHdProfileSettings() {
        return xavcHdProfileSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(adaptiveQuantizationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(entropyEncodingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(framerateControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(framerateConversionAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(framerateDenominator());
        hashCode = 31 * hashCode + Objects.hashCode(framerateNumerator());
        hashCode = 31 * hashCode + Objects.hashCode(profileAsString());
        hashCode = 31 * hashCode + Objects.hashCode(slowPalAsString());
        hashCode = 31 * hashCode + Objects.hashCode(softness());
        hashCode = 31 * hashCode + Objects.hashCode(spatialAdaptiveQuantizationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(temporalAdaptiveQuantizationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(xavc4kIntraCbgProfileSettings());
        hashCode = 31 * hashCode + Objects.hashCode(xavc4kIntraVbrProfileSettings());
        hashCode = 31 * hashCode + Objects.hashCode(xavc4kProfileSettings());
        hashCode = 31 * hashCode + Objects.hashCode(xavcHdIntraCbgProfileSettings());
        hashCode = 31 * hashCode + Objects.hashCode(xavcHdProfileSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof XavcSettings)) {
            return false;
        }
        XavcSettings other = (XavcSettings) obj;
        return Objects.equals(adaptiveQuantizationAsString(), other.adaptiveQuantizationAsString())
                && Objects.equals(entropyEncodingAsString(), other.entropyEncodingAsString())
                && Objects.equals(framerateControlAsString(), other.framerateControlAsString())
                && Objects.equals(framerateConversionAlgorithmAsString(), other.framerateConversionAlgorithmAsString())
                && Objects.equals(framerateDenominator(), other.framerateDenominator())
                && Objects.equals(framerateNumerator(), other.framerateNumerator())
                && Objects.equals(profileAsString(), other.profileAsString())
                && Objects.equals(slowPalAsString(), other.slowPalAsString()) && Objects.equals(softness(), other.softness())
                && Objects.equals(spatialAdaptiveQuantizationAsString(), other.spatialAdaptiveQuantizationAsString())
                && Objects.equals(temporalAdaptiveQuantizationAsString(), other.temporalAdaptiveQuantizationAsString())
                && Objects.equals(xavc4kIntraCbgProfileSettings(), other.xavc4kIntraCbgProfileSettings())
                && Objects.equals(xavc4kIntraVbrProfileSettings(), other.xavc4kIntraVbrProfileSettings())
                && Objects.equals(xavc4kProfileSettings(), other.xavc4kProfileSettings())
                && Objects.equals(xavcHdIntraCbgProfileSettings(), other.xavcHdIntraCbgProfileSettings())
                && Objects.equals(xavcHdProfileSettings(), other.xavcHdProfileSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("XavcSettings").add("AdaptiveQuantization", adaptiveQuantizationAsString())
                .add("EntropyEncoding", entropyEncodingAsString()).add("FramerateControl", framerateControlAsString())
                .add("FramerateConversionAlgorithm", framerateConversionAlgorithmAsString())
                .add("FramerateDenominator", framerateDenominator()).add("FramerateNumerator", framerateNumerator())
                .add("Profile", profileAsString()).add("SlowPal", slowPalAsString()).add("Softness", softness())
                .add("SpatialAdaptiveQuantization", spatialAdaptiveQuantizationAsString())
                .add("TemporalAdaptiveQuantization", temporalAdaptiveQuantizationAsString())
                .add("Xavc4kIntraCbgProfileSettings", xavc4kIntraCbgProfileSettings())
                .add("Xavc4kIntraVbrProfileSettings", xavc4kIntraVbrProfileSettings())
                .add("Xavc4kProfileSettings", xavc4kProfileSettings())
                .add("XavcHdIntraCbgProfileSettings", xavcHdIntraCbgProfileSettings())
                .add("XavcHdProfileSettings", xavcHdProfileSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdaptiveQuantization":
            return Optional.ofNullable(clazz.cast(adaptiveQuantizationAsString()));
        case "EntropyEncoding":
            return Optional.ofNullable(clazz.cast(entropyEncodingAsString()));
        case "FramerateControl":
            return Optional.ofNullable(clazz.cast(framerateControlAsString()));
        case "FramerateConversionAlgorithm":
            return Optional.ofNullable(clazz.cast(framerateConversionAlgorithmAsString()));
        case "FramerateDenominator":
            return Optional.ofNullable(clazz.cast(framerateDenominator()));
        case "FramerateNumerator":
            return Optional.ofNullable(clazz.cast(framerateNumerator()));
        case "Profile":
            return Optional.ofNullable(clazz.cast(profileAsString()));
        case "SlowPal":
            return Optional.ofNullable(clazz.cast(slowPalAsString()));
        case "Softness":
            return Optional.ofNullable(clazz.cast(softness()));
        case "SpatialAdaptiveQuantization":
            return Optional.ofNullable(clazz.cast(spatialAdaptiveQuantizationAsString()));
        case "TemporalAdaptiveQuantization":
            return Optional.ofNullable(clazz.cast(temporalAdaptiveQuantizationAsString()));
        case "Xavc4kIntraCbgProfileSettings":
            return Optional.ofNullable(clazz.cast(xavc4kIntraCbgProfileSettings()));
        case "Xavc4kIntraVbrProfileSettings":
            return Optional.ofNullable(clazz.cast(xavc4kIntraVbrProfileSettings()));
        case "Xavc4kProfileSettings":
            return Optional.ofNullable(clazz.cast(xavc4kProfileSettings()));
        case "XavcHdIntraCbgProfileSettings":
            return Optional.ofNullable(clazz.cast(xavcHdIntraCbgProfileSettings()));
        case "XavcHdProfileSettings":
            return Optional.ofNullable(clazz.cast(xavcHdProfileSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<XavcSettings, T> g) {
        return obj -> g.apply((XavcSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, XavcSettings> {
        /**
         * Keep the default value, Auto, for this setting to have MediaConvert automatically apply the best types of
         * quantization for your video content. When you want to apply your quantization settings manually, you must set
         * Adaptive quantization to a value other than Auto. Use this setting to specify the strength of any adaptive
         * quantization filters that you enable. If you don't want MediaConvert to do any adaptive quantization in this
         * transcode, set Adaptive quantization to Off. Related settings: The value that you choose here applies to the
         * following settings: Flicker adaptive quantization (flickerAdaptiveQuantization), Spatial adaptive
         * quantization, and Temporal adaptive quantization.
         * 
         * @param adaptiveQuantization
         *        Keep the default value, Auto, for this setting to have MediaConvert automatically apply the best types
         *        of quantization for your video content. When you want to apply your quantization settings manually,
         *        you must set Adaptive quantization to a value other than Auto. Use this setting to specify the
         *        strength of any adaptive quantization filters that you enable. If you don't want MediaConvert to do
         *        any adaptive quantization in this transcode, set Adaptive quantization to Off. Related settings: The
         *        value that you choose here applies to the following settings: Flicker adaptive quantization
         *        (flickerAdaptiveQuantization), Spatial adaptive quantization, and Temporal adaptive quantization.
         * @see XavcAdaptiveQuantization
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see XavcAdaptiveQuantization
         */
        Builder adaptiveQuantization(String adaptiveQuantization);

        /**
         * Keep the default value, Auto, for this setting to have MediaConvert automatically apply the best types of
         * quantization for your video content. When you want to apply your quantization settings manually, you must set
         * Adaptive quantization to a value other than Auto. Use this setting to specify the strength of any adaptive
         * quantization filters that you enable. If you don't want MediaConvert to do any adaptive quantization in this
         * transcode, set Adaptive quantization to Off. Related settings: The value that you choose here applies to the
         * following settings: Flicker adaptive quantization (flickerAdaptiveQuantization), Spatial adaptive
         * quantization, and Temporal adaptive quantization.
         * 
         * @param adaptiveQuantization
         *        Keep the default value, Auto, for this setting to have MediaConvert automatically apply the best types
         *        of quantization for your video content. When you want to apply your quantization settings manually,
         *        you must set Adaptive quantization to a value other than Auto. Use this setting to specify the
         *        strength of any adaptive quantization filters that you enable. If you don't want MediaConvert to do
         *        any adaptive quantization in this transcode, set Adaptive quantization to Off. Related settings: The
         *        value that you choose here applies to the following settings: Flicker adaptive quantization
         *        (flickerAdaptiveQuantization), Spatial adaptive quantization, and Temporal adaptive quantization.
         * @see XavcAdaptiveQuantization
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see XavcAdaptiveQuantization
         */
        Builder adaptiveQuantization(XavcAdaptiveQuantization adaptiveQuantization);

        /**
         * Optional. Choose a specific entropy encoding mode only when you want to override XAVC recommendations. If you
         * choose the value auto, MediaConvert uses the mode that the XAVC file format specifies given this output's
         * operating point.
         * 
         * @param entropyEncoding
         *        Optional. Choose a specific entropy encoding mode only when you want to override XAVC recommendations.
         *        If you choose the value auto, MediaConvert uses the mode that the XAVC file format specifies given
         *        this output's operating point.
         * @see XavcEntropyEncoding
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see XavcEntropyEncoding
         */
        Builder entropyEncoding(String entropyEncoding);

        /**
         * Optional. Choose a specific entropy encoding mode only when you want to override XAVC recommendations. If you
         * choose the value auto, MediaConvert uses the mode that the XAVC file format specifies given this output's
         * operating point.
         * 
         * @param entropyEncoding
         *        Optional. Choose a specific entropy encoding mode only when you want to override XAVC recommendations.
         *        If you choose the value auto, MediaConvert uses the mode that the XAVC file format specifies given
         *        this output's operating point.
         * @see XavcEntropyEncoding
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see XavcEntropyEncoding
         */
        Builder entropyEncoding(XavcEntropyEncoding entropyEncoding);

        /**
         * If you are using the console, use the Frame rate setting to specify the frame rate for this output. If you
         * want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate
         * conversion, choose a frame rate from the dropdown list. The framerates shown in the dropdown list are decimal
         * approximations of fractions.
         * 
         * @param framerateControl
         *        If you are using the console, use the Frame rate setting to specify the frame rate for this output. If
         *        you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame
         *        rate conversion, choose a frame rate from the dropdown list. The framerates shown in the dropdown list
         *        are decimal approximations of fractions.
         * @see XavcFramerateControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see XavcFramerateControl
         */
        Builder framerateControl(String framerateControl);

        /**
         * If you are using the console, use the Frame rate setting to specify the frame rate for this output. If you
         * want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate
         * conversion, choose a frame rate from the dropdown list. The framerates shown in the dropdown list are decimal
         * approximations of fractions.
         * 
         * @param framerateControl
         *        If you are using the console, use the Frame rate setting to specify the frame rate for this output. If
         *        you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame
         *        rate conversion, choose a frame rate from the dropdown list. The framerates shown in the dropdown list
         *        are decimal approximations of fractions.
         * @see XavcFramerateControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see XavcFramerateControl
         */
        Builder framerateControl(XavcFramerateControl framerateControl);

        /**
         * Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. For
         * numerically simple conversions, such as 60 fps to 30 fps: We recommend that you keep the default value, Drop
         * duplicate. For numerically complex conversions, to avoid stutter: Choose Interpolate. This results in a
         * smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions,
         * especially if your source video has already been converted from its original cadence: Choose FrameFormer to
         * do motion-compensated interpolation. FrameFormer uses the best conversion method frame by frame. Note that
         * using FrameFormer increases the transcoding time and incurs a significant add-on cost. When you choose
         * FrameFormer, your input video resolution must be at least 128x96.
         * 
         * @param framerateConversionAlgorithm
         *        Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. For
         *        numerically simple conversions, such as 60 fps to 30 fps: We recommend that you keep the default
         *        value, Drop duplicate. For numerically complex conversions, to avoid stutter: Choose Interpolate. This
         *        results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate
         *        conversions, especially if your source video has already been converted from its original cadence:
         *        Choose FrameFormer to do motion-compensated interpolation. FrameFormer uses the best conversion method
         *        frame by frame. Note that using FrameFormer increases the transcoding time and incurs a significant
         *        add-on cost. When you choose FrameFormer, your input video resolution must be at least 128x96.
         * @see XavcFramerateConversionAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see XavcFramerateConversionAlgorithm
         */
        Builder framerateConversionAlgorithm(String framerateConversionAlgorithm);

        /**
         * Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. For
         * numerically simple conversions, such as 60 fps to 30 fps: We recommend that you keep the default value, Drop
         * duplicate. For numerically complex conversions, to avoid stutter: Choose Interpolate. This results in a
         * smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions,
         * especially if your source video has already been converted from its original cadence: Choose FrameFormer to
         * do motion-compensated interpolation. FrameFormer uses the best conversion method frame by frame. Note that
         * using FrameFormer increases the transcoding time and incurs a significant add-on cost. When you choose
         * FrameFormer, your input video resolution must be at least 128x96.
         * 
         * @param framerateConversionAlgorithm
         *        Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. For
         *        numerically simple conversions, such as 60 fps to 30 fps: We recommend that you keep the default
         *        value, Drop duplicate. For numerically complex conversions, to avoid stutter: Choose Interpolate. This
         *        results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate
         *        conversions, especially if your source video has already been converted from its original cadence:
         *        Choose FrameFormer to do motion-compensated interpolation. FrameFormer uses the best conversion method
         *        frame by frame. Note that using FrameFormer increases the transcoding time and incurs a significant
         *        add-on cost. When you choose FrameFormer, your input video resolution must be at least 128x96.
         * @see XavcFramerateConversionAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see XavcFramerateConversionAlgorithm
         */
        Builder framerateConversionAlgorithm(XavcFramerateConversionAlgorithm framerateConversionAlgorithm);

        /**
         * When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction.
         * For example, 24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction.
         * In this example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs
         * that use frame rate conversion, provide the value as a decimal number for Frame rate. In this example,
         * specify 23.976.
         * 
         * @param framerateDenominator
         *        When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a
         *        fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator
         *        of this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the
         *        console for transcode jobs that use frame rate conversion, provide the value as a decimal number for
         *        Frame rate. In this example, specify 23.976.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder framerateDenominator(Integer framerateDenominator);

        /**
         * When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction.
         * For example, 24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In
         * this example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that
         * use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify
         * 23.976.
         * 
         * @param framerateNumerator
         *        When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a
         *        fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of
         *        this fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the
         *        console for transcode jobs that use frame rate conversion, provide the value as a decimal number for
         *        Framerate. In this example, specify 23.976.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder framerateNumerator(Integer framerateNumerator);

        /**
         * Specify the XAVC profile for this output. For more information, see the Sony documentation at
         * https://www.xavc-info.org/. Note that MediaConvert doesn't support the interlaced video XAVC operating points
         * for XAVC_HD_INTRA_CBG. To create an interlaced XAVC output, choose the profile XAVC_HD.
         * 
         * @param profile
         *        Specify the XAVC profile for this output. For more information, see the Sony documentation at
         *        https://www.xavc-info.org/. Note that MediaConvert doesn't support the interlaced video XAVC operating
         *        points for XAVC_HD_INTRA_CBG. To create an interlaced XAVC output, choose the profile XAVC_HD.
         * @see XavcProfile
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see XavcProfile
         */
        Builder profile(String profile);

        /**
         * Specify the XAVC profile for this output. For more information, see the Sony documentation at
         * https://www.xavc-info.org/. Note that MediaConvert doesn't support the interlaced video XAVC operating points
         * for XAVC_HD_INTRA_CBG. To create an interlaced XAVC output, choose the profile XAVC_HD.
         * 
         * @param profile
         *        Specify the XAVC profile for this output. For more information, see the Sony documentation at
         *        https://www.xavc-info.org/. Note that MediaConvert doesn't support the interlaced video XAVC operating
         *        points for XAVC_HD_INTRA_CBG. To create an interlaced XAVC output, choose the profile XAVC_HD.
         * @see XavcProfile
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see XavcProfile
         */
        Builder profile(XavcProfile profile);

        /**
         * Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to
         * create a 25 fps output by relabeling the video frames and resampling your audio. Note that enabling this
         * setting will slightly reduce the duration of your video. Related settings: You must also set Frame rate to
         * 25.
         * 
         * @param slowPal
         *        Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow
         *        PAL to create a 25 fps output by relabeling the video frames and resampling your audio. Note that
         *        enabling this setting will slightly reduce the duration of your video. Related settings: You must also
         *        set Frame rate to 25.
         * @see XavcSlowPal
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see XavcSlowPal
         */
        Builder slowPal(String slowPal);

        /**
         * Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to
         * create a 25 fps output by relabeling the video frames and resampling your audio. Note that enabling this
         * setting will slightly reduce the duration of your video. Related settings: You must also set Frame rate to
         * 25.
         * 
         * @param slowPal
         *        Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow
         *        PAL to create a 25 fps output by relabeling the video frames and resampling your audio. Note that
         *        enabling this setting will slightly reduce the duration of your video. Related settings: You must also
         *        set Frame rate to 25.
         * @see XavcSlowPal
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see XavcSlowPal
         */
        Builder slowPal(XavcSlowPal slowPal);

        /**
         * Ignore this setting unless your downstream workflow requires that you specify it explicitly. Otherwise, we
         * recommend that you adjust the softness of your output by using a lower value for the setting Sharpness or by
         * enabling a noise reducer filter. The Softness setting specifies the quantization matrices that the encoder
         * uses. Keep the default value, 0, for flat quantization. Choose the value 1 or 16 to use the default JVT
         * softening quantization matricies from the H.264 specification. Choose a value from 17 to 128 to use planar
         * interpolation. Increasing values from 17 to 128 result in increasing reduction of high-frequency data. The
         * value 128 results in the softest video.
         * 
         * @param softness
         *        Ignore this setting unless your downstream workflow requires that you specify it explicitly.
         *        Otherwise, we recommend that you adjust the softness of your output by using a lower value for the
         *        setting Sharpness or by enabling a noise reducer filter. The Softness setting specifies the
         *        quantization matrices that the encoder uses. Keep the default value, 0, for flat quantization. Choose
         *        the value 1 or 16 to use the default JVT softening quantization matricies from the H.264
         *        specification. Choose a value from 17 to 128 to use planar interpolation. Increasing values from 17 to
         *        128 result in increasing reduction of high-frequency data. The value 128 results in the softest video.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder softness(Integer softness);

        /**
         * The best way to set up adaptive quantization is to keep the default value, Auto, for the setting Adaptive
         * quantization. When you do so, MediaConvert automatically applies the best types of quantization for your
         * video content. Include this setting in your JSON job specification only when you choose to change the default
         * value for Adaptive quantization. For this setting, keep the default value, Enabled, to adjust quantization
         * within each frame based on spatial variation of content complexity. When you enable this feature, the encoder
         * uses fewer bits on areas that can sustain more distortion with no noticeable visual degradation and uses more
         * bits on areas where any small distortion will be noticeable. For example, complex textured blocks are encoded
         * with fewer bits and smooth textured blocks are encoded with more bits. Enabling this feature will almost
         * always improve your video quality. Note, though, that this feature doesn't take into account where the
         * viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of the
         * screen with a lot of complex texture, you might choose to disable this feature. Related setting: When you
         * enable spatial adaptive quantization, set the value for Adaptive quantization depending on your content. For
         * homogeneous content, such as cartoons and video games, set it to Low. For content with a wider variety of
         * textures, set it to High or Higher.
         * 
         * @param spatialAdaptiveQuantization
         *        The best way to set up adaptive quantization is to keep the default value, Auto, for the setting
         *        Adaptive quantization. When you do so, MediaConvert automatically applies the best types of
         *        quantization for your video content. Include this setting in your JSON job specification only when you
         *        choose to change the default value for Adaptive quantization. For this setting, keep the default
         *        value, Enabled, to adjust quantization within each frame based on spatial variation of content
         *        complexity. When you enable this feature, the encoder uses fewer bits on areas that can sustain more
         *        distortion with no noticeable visual degradation and uses more bits on areas where any small
         *        distortion will be noticeable. For example, complex textured blocks are encoded with fewer bits and
         *        smooth textured blocks are encoded with more bits. Enabling this feature will almost always improve
         *        your video quality. Note, though, that this feature doesn't take into account where the viewer's
         *        attention is likely to be. If viewers are likely to be focusing their attention on a part of the
         *        screen with a lot of complex texture, you might choose to disable this feature. Related setting: When
         *        you enable spatial adaptive quantization, set the value for Adaptive quantization depending on your
         *        content. For homogeneous content, such as cartoons and video games, set it to Low. For content with a
         *        wider variety of textures, set it to High or Higher.
         * @see XavcSpatialAdaptiveQuantization
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see XavcSpatialAdaptiveQuantization
         */
        Builder spatialAdaptiveQuantization(String spatialAdaptiveQuantization);

        /**
         * The best way to set up adaptive quantization is to keep the default value, Auto, for the setting Adaptive
         * quantization. When you do so, MediaConvert automatically applies the best types of quantization for your
         * video content. Include this setting in your JSON job specification only when you choose to change the default
         * value for Adaptive quantization. For this setting, keep the default value, Enabled, to adjust quantization
         * within each frame based on spatial variation of content complexity. When you enable this feature, the encoder
         * uses fewer bits on areas that can sustain more distortion with no noticeable visual degradation and uses more
         * bits on areas where any small distortion will be noticeable. For example, complex textured blocks are encoded
         * with fewer bits and smooth textured blocks are encoded with more bits. Enabling this feature will almost
         * always improve your video quality. Note, though, that this feature doesn't take into account where the
         * viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of the
         * screen with a lot of complex texture, you might choose to disable this feature. Related setting: When you
         * enable spatial adaptive quantization, set the value for Adaptive quantization depending on your content. For
         * homogeneous content, such as cartoons and video games, set it to Low. For content with a wider variety of
         * textures, set it to High or Higher.
         * 
         * @param spatialAdaptiveQuantization
         *        The best way to set up adaptive quantization is to keep the default value, Auto, for the setting
         *        Adaptive quantization. When you do so, MediaConvert automatically applies the best types of
         *        quantization for your video content. Include this setting in your JSON job specification only when you
         *        choose to change the default value for Adaptive quantization. For this setting, keep the default
         *        value, Enabled, to adjust quantization within each frame based on spatial variation of content
         *        complexity. When you enable this feature, the encoder uses fewer bits on areas that can sustain more
         *        distortion with no noticeable visual degradation and uses more bits on areas where any small
         *        distortion will be noticeable. For example, complex textured blocks are encoded with fewer bits and
         *        smooth textured blocks are encoded with more bits. Enabling this feature will almost always improve
         *        your video quality. Note, though, that this feature doesn't take into account where the viewer's
         *        attention is likely to be. If viewers are likely to be focusing their attention on a part of the
         *        screen with a lot of complex texture, you might choose to disable this feature. Related setting: When
         *        you enable spatial adaptive quantization, set the value for Adaptive quantization depending on your
         *        content. For homogeneous content, such as cartoons and video games, set it to Low. For content with a
         *        wider variety of textures, set it to High or Higher.
         * @see XavcSpatialAdaptiveQuantization
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see XavcSpatialAdaptiveQuantization
         */
        Builder spatialAdaptiveQuantization(XavcSpatialAdaptiveQuantization spatialAdaptiveQuantization);

        /**
         * The best way to set up adaptive quantization is to keep the default value, Auto, for the setting Adaptive
         * quantization. When you do so, MediaConvert automatically applies the best types of quantization for your
         * video content. Include this setting in your JSON job specification only when you choose to change the default
         * value for Adaptive quantization. For this setting, keep the default value, Enabled, to adjust quantization
         * within each frame based on temporal variation of content complexity. When you enable this feature, the
         * encoder uses fewer bits on areas of the frame that aren't moving and uses more bits on complex objects with
         * sharp edges that move a lot. For example, this feature improves the readability of text tickers on newscasts
         * and scoreboards on sports matches. Enabling this feature will almost always improve your video quality. Note,
         * though, that this feature doesn't take into account where the viewer's attention is likely to be. If viewers
         * are likely to be focusing their attention on a part of the screen that doesn't have moving objects with sharp
         * edges, such as sports athletes' faces, you might choose to disable this feature. Related setting: When you
         * enable temporal adaptive quantization, adjust the strength of the filter with the setting Adaptive
         * quantization.
         * 
         * @param temporalAdaptiveQuantization
         *        The best way to set up adaptive quantization is to keep the default value, Auto, for the setting
         *        Adaptive quantization. When you do so, MediaConvert automatically applies the best types of
         *        quantization for your video content. Include this setting in your JSON job specification only when you
         *        choose to change the default value for Adaptive quantization. For this setting, keep the default
         *        value, Enabled, to adjust quantization within each frame based on temporal variation of content
         *        complexity. When you enable this feature, the encoder uses fewer bits on areas of the frame that
         *        aren't moving and uses more bits on complex objects with sharp edges that move a lot. For example,
         *        this feature improves the readability of text tickers on newscasts and scoreboards on sports matches.
         *        Enabling this feature will almost always improve your video quality. Note, though, that this feature
         *        doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be
         *        focusing their attention on a part of the screen that doesn't have moving objects with sharp edges,
         *        such as sports athletes' faces, you might choose to disable this feature. Related setting: When you
         *        enable temporal adaptive quantization, adjust the strength of the filter with the setting Adaptive
         *        quantization.
         * @see XavcTemporalAdaptiveQuantization
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see XavcTemporalAdaptiveQuantization
         */
        Builder temporalAdaptiveQuantization(String temporalAdaptiveQuantization);

        /**
         * The best way to set up adaptive quantization is to keep the default value, Auto, for the setting Adaptive
         * quantization. When you do so, MediaConvert automatically applies the best types of quantization for your
         * video content. Include this setting in your JSON job specification only when you choose to change the default
         * value for Adaptive quantization. For this setting, keep the default value, Enabled, to adjust quantization
         * within each frame based on temporal variation of content complexity. When you enable this feature, the
         * encoder uses fewer bits on areas of the frame that aren't moving and uses more bits on complex objects with
         * sharp edges that move a lot. For example, this feature improves the readability of text tickers on newscasts
         * and scoreboards on sports matches. Enabling this feature will almost always improve your video quality. Note,
         * though, that this feature doesn't take into account where the viewer's attention is likely to be. If viewers
         * are likely to be focusing their attention on a part of the screen that doesn't have moving objects with sharp
         * edges, such as sports athletes' faces, you might choose to disable this feature. Related setting: When you
         * enable temporal adaptive quantization, adjust the strength of the filter with the setting Adaptive
         * quantization.
         * 
         * @param temporalAdaptiveQuantization
         *        The best way to set up adaptive quantization is to keep the default value, Auto, for the setting
         *        Adaptive quantization. When you do so, MediaConvert automatically applies the best types of
         *        quantization for your video content. Include this setting in your JSON job specification only when you
         *        choose to change the default value for Adaptive quantization. For this setting, keep the default
         *        value, Enabled, to adjust quantization within each frame based on temporal variation of content
         *        complexity. When you enable this feature, the encoder uses fewer bits on areas of the frame that
         *        aren't moving and uses more bits on complex objects with sharp edges that move a lot. For example,
         *        this feature improves the readability of text tickers on newscasts and scoreboards on sports matches.
         *        Enabling this feature will almost always improve your video quality. Note, though, that this feature
         *        doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be
         *        focusing their attention on a part of the screen that doesn't have moving objects with sharp edges,
         *        such as sports athletes' faces, you might choose to disable this feature. Related setting: When you
         *        enable temporal adaptive quantization, adjust the strength of the filter with the setting Adaptive
         *        quantization.
         * @see XavcTemporalAdaptiveQuantization
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see XavcTemporalAdaptiveQuantization
         */
        Builder temporalAdaptiveQuantization(XavcTemporalAdaptiveQuantization temporalAdaptiveQuantization);

        /**
         * Required when you set Profile to the value XAVC_4K_INTRA_CBG.
         * 
         * @param xavc4kIntraCbgProfileSettings
         *        Required when you set Profile to the value XAVC_4K_INTRA_CBG.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xavc4kIntraCbgProfileSettings(Xavc4kIntraCbgProfileSettings xavc4kIntraCbgProfileSettings);

        /**
         * Required when you set Profile to the value XAVC_4K_INTRA_CBG. This is a convenience method that creates an
         * instance of the {@link Xavc4kIntraCbgProfileSettings.Builder} avoiding the need to create one manually via
         * {@link Xavc4kIntraCbgProfileSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Xavc4kIntraCbgProfileSettings.Builder#build()} is called
         * immediately and its result is passed to {@link #xavc4kIntraCbgProfileSettings(Xavc4kIntraCbgProfileSettings)}.
         * 
         * @param xavc4kIntraCbgProfileSettings
         *        a consumer that will call methods on {@link Xavc4kIntraCbgProfileSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #xavc4kIntraCbgProfileSettings(Xavc4kIntraCbgProfileSettings)
         */
        default Builder xavc4kIntraCbgProfileSettings(
                Consumer<Xavc4kIntraCbgProfileSettings.Builder> xavc4kIntraCbgProfileSettings) {
            return xavc4kIntraCbgProfileSettings(Xavc4kIntraCbgProfileSettings.builder()
                    .applyMutation(xavc4kIntraCbgProfileSettings).build());
        }

        /**
         * Required when you set Profile to the value XAVC_4K_INTRA_VBR.
         * 
         * @param xavc4kIntraVbrProfileSettings
         *        Required when you set Profile to the value XAVC_4K_INTRA_VBR.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xavc4kIntraVbrProfileSettings(Xavc4kIntraVbrProfileSettings xavc4kIntraVbrProfileSettings);

        /**
         * Required when you set Profile to the value XAVC_4K_INTRA_VBR. This is a convenience method that creates an
         * instance of the {@link Xavc4kIntraVbrProfileSettings.Builder} avoiding the need to create one manually via
         * {@link Xavc4kIntraVbrProfileSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Xavc4kIntraVbrProfileSettings.Builder#build()} is called
         * immediately and its result is passed to {@link #xavc4kIntraVbrProfileSettings(Xavc4kIntraVbrProfileSettings)}.
         * 
         * @param xavc4kIntraVbrProfileSettings
         *        a consumer that will call methods on {@link Xavc4kIntraVbrProfileSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #xavc4kIntraVbrProfileSettings(Xavc4kIntraVbrProfileSettings)
         */
        default Builder xavc4kIntraVbrProfileSettings(
                Consumer<Xavc4kIntraVbrProfileSettings.Builder> xavc4kIntraVbrProfileSettings) {
            return xavc4kIntraVbrProfileSettings(Xavc4kIntraVbrProfileSettings.builder()
                    .applyMutation(xavc4kIntraVbrProfileSettings).build());
        }

        /**
         * Required when you set Profile to the value XAVC_4K.
         * 
         * @param xavc4kProfileSettings
         *        Required when you set Profile to the value XAVC_4K.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xavc4kProfileSettings(Xavc4kProfileSettings xavc4kProfileSettings);

        /**
         * Required when you set Profile to the value XAVC_4K. This is a convenience method that creates an instance of
         * the {@link Xavc4kProfileSettings.Builder} avoiding the need to create one manually via
         * {@link Xavc4kProfileSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Xavc4kProfileSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #xavc4kProfileSettings(Xavc4kProfileSettings)}.
         * 
         * @param xavc4kProfileSettings
         *        a consumer that will call methods on {@link Xavc4kProfileSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #xavc4kProfileSettings(Xavc4kProfileSettings)
         */
        default Builder xavc4kProfileSettings(Consumer<Xavc4kProfileSettings.Builder> xavc4kProfileSettings) {
            return xavc4kProfileSettings(Xavc4kProfileSettings.builder().applyMutation(xavc4kProfileSettings).build());
        }

        /**
         * Required when you set Profile to the value XAVC_HD_INTRA_CBG.
         * 
         * @param xavcHdIntraCbgProfileSettings
         *        Required when you set Profile to the value XAVC_HD_INTRA_CBG.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xavcHdIntraCbgProfileSettings(XavcHdIntraCbgProfileSettings xavcHdIntraCbgProfileSettings);

        /**
         * Required when you set Profile to the value XAVC_HD_INTRA_CBG. This is a convenience method that creates an
         * instance of the {@link XavcHdIntraCbgProfileSettings.Builder} avoiding the need to create one manually via
         * {@link XavcHdIntraCbgProfileSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link XavcHdIntraCbgProfileSettings.Builder#build()} is called
         * immediately and its result is passed to {@link #xavcHdIntraCbgProfileSettings(XavcHdIntraCbgProfileSettings)}.
         * 
         * @param xavcHdIntraCbgProfileSettings
         *        a consumer that will call methods on {@link XavcHdIntraCbgProfileSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #xavcHdIntraCbgProfileSettings(XavcHdIntraCbgProfileSettings)
         */
        default Builder xavcHdIntraCbgProfileSettings(
                Consumer<XavcHdIntraCbgProfileSettings.Builder> xavcHdIntraCbgProfileSettings) {
            return xavcHdIntraCbgProfileSettings(XavcHdIntraCbgProfileSettings.builder()
                    .applyMutation(xavcHdIntraCbgProfileSettings).build());
        }

        /**
         * Required when you set Profile to the value XAVC_HD.
         * 
         * @param xavcHdProfileSettings
         *        Required when you set Profile to the value XAVC_HD.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xavcHdProfileSettings(XavcHdProfileSettings xavcHdProfileSettings);

        /**
         * Required when you set Profile to the value XAVC_HD. This is a convenience method that creates an instance of
         * the {@link XavcHdProfileSettings.Builder} avoiding the need to create one manually via
         * {@link XavcHdProfileSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link XavcHdProfileSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #xavcHdProfileSettings(XavcHdProfileSettings)}.
         * 
         * @param xavcHdProfileSettings
         *        a consumer that will call methods on {@link XavcHdProfileSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #xavcHdProfileSettings(XavcHdProfileSettings)
         */
        default Builder xavcHdProfileSettings(Consumer<XavcHdProfileSettings.Builder> xavcHdProfileSettings) {
            return xavcHdProfileSettings(XavcHdProfileSettings.builder().applyMutation(xavcHdProfileSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String adaptiveQuantization;

        private String entropyEncoding;

        private String framerateControl;

        private String framerateConversionAlgorithm;

        private Integer framerateDenominator;

        private Integer framerateNumerator;

        private String profile;

        private String slowPal;

        private Integer softness;

        private String spatialAdaptiveQuantization;

        private String temporalAdaptiveQuantization;

        private Xavc4kIntraCbgProfileSettings xavc4kIntraCbgProfileSettings;

        private Xavc4kIntraVbrProfileSettings xavc4kIntraVbrProfileSettings;

        private Xavc4kProfileSettings xavc4kProfileSettings;

        private XavcHdIntraCbgProfileSettings xavcHdIntraCbgProfileSettings;

        private XavcHdProfileSettings xavcHdProfileSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(XavcSettings model) {
            adaptiveQuantization(model.adaptiveQuantization);
            entropyEncoding(model.entropyEncoding);
            framerateControl(model.framerateControl);
            framerateConversionAlgorithm(model.framerateConversionAlgorithm);
            framerateDenominator(model.framerateDenominator);
            framerateNumerator(model.framerateNumerator);
            profile(model.profile);
            slowPal(model.slowPal);
            softness(model.softness);
            spatialAdaptiveQuantization(model.spatialAdaptiveQuantization);
            temporalAdaptiveQuantization(model.temporalAdaptiveQuantization);
            xavc4kIntraCbgProfileSettings(model.xavc4kIntraCbgProfileSettings);
            xavc4kIntraVbrProfileSettings(model.xavc4kIntraVbrProfileSettings);
            xavc4kProfileSettings(model.xavc4kProfileSettings);
            xavcHdIntraCbgProfileSettings(model.xavcHdIntraCbgProfileSettings);
            xavcHdProfileSettings(model.xavcHdProfileSettings);
        }

        public final String getAdaptiveQuantization() {
            return adaptiveQuantization;
        }

        public final void setAdaptiveQuantization(String adaptiveQuantization) {
            this.adaptiveQuantization = adaptiveQuantization;
        }

        @Override
        public final Builder adaptiveQuantization(String adaptiveQuantization) {
            this.adaptiveQuantization = adaptiveQuantization;
            return this;
        }

        @Override
        public final Builder adaptiveQuantization(XavcAdaptiveQuantization adaptiveQuantization) {
            this.adaptiveQuantization(adaptiveQuantization == null ? null : adaptiveQuantization.toString());
            return this;
        }

        public final String getEntropyEncoding() {
            return entropyEncoding;
        }

        public final void setEntropyEncoding(String entropyEncoding) {
            this.entropyEncoding = entropyEncoding;
        }

        @Override
        public final Builder entropyEncoding(String entropyEncoding) {
            this.entropyEncoding = entropyEncoding;
            return this;
        }

        @Override
        public final Builder entropyEncoding(XavcEntropyEncoding entropyEncoding) {
            this.entropyEncoding(entropyEncoding == null ? null : entropyEncoding.toString());
            return this;
        }

        public final String getFramerateControl() {
            return framerateControl;
        }

        public final void setFramerateControl(String framerateControl) {
            this.framerateControl = framerateControl;
        }

        @Override
        public final Builder framerateControl(String framerateControl) {
            this.framerateControl = framerateControl;
            return this;
        }

        @Override
        public final Builder framerateControl(XavcFramerateControl framerateControl) {
            this.framerateControl(framerateControl == null ? null : framerateControl.toString());
            return this;
        }

        public final String getFramerateConversionAlgorithm() {
            return framerateConversionAlgorithm;
        }

        public final void setFramerateConversionAlgorithm(String framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm = framerateConversionAlgorithm;
        }

        @Override
        public final Builder framerateConversionAlgorithm(String framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm = framerateConversionAlgorithm;
            return this;
        }

        @Override
        public final Builder framerateConversionAlgorithm(XavcFramerateConversionAlgorithm framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm(framerateConversionAlgorithm == null ? null : framerateConversionAlgorithm
                    .toString());
            return this;
        }

        public final Integer getFramerateDenominator() {
            return framerateDenominator;
        }

        public final void setFramerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
        }

        @Override
        public final Builder framerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
            return this;
        }

        public final Integer getFramerateNumerator() {
            return framerateNumerator;
        }

        public final void setFramerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
        }

        @Override
        public final Builder framerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
            return this;
        }

        public final String getProfile() {
            return profile;
        }

        public final void setProfile(String profile) {
            this.profile = profile;
        }

        @Override
        public final Builder profile(String profile) {
            this.profile = profile;
            return this;
        }

        @Override
        public final Builder profile(XavcProfile profile) {
            this.profile(profile == null ? null : profile.toString());
            return this;
        }

        public final String getSlowPal() {
            return slowPal;
        }

        public final void setSlowPal(String slowPal) {
            this.slowPal = slowPal;
        }

        @Override
        public final Builder slowPal(String slowPal) {
            this.slowPal = slowPal;
            return this;
        }

        @Override
        public final Builder slowPal(XavcSlowPal slowPal) {
            this.slowPal(slowPal == null ? null : slowPal.toString());
            return this;
        }

        public final Integer getSoftness() {
            return softness;
        }

        public final void setSoftness(Integer softness) {
            this.softness = softness;
        }

        @Override
        public final Builder softness(Integer softness) {
            this.softness = softness;
            return this;
        }

        public final String getSpatialAdaptiveQuantization() {
            return spatialAdaptiveQuantization;
        }

        public final void setSpatialAdaptiveQuantization(String spatialAdaptiveQuantization) {
            this.spatialAdaptiveQuantization = spatialAdaptiveQuantization;
        }

        @Override
        public final Builder spatialAdaptiveQuantization(String spatialAdaptiveQuantization) {
            this.spatialAdaptiveQuantization = spatialAdaptiveQuantization;
            return this;
        }

        @Override
        public final Builder spatialAdaptiveQuantization(XavcSpatialAdaptiveQuantization spatialAdaptiveQuantization) {
            this.spatialAdaptiveQuantization(spatialAdaptiveQuantization == null ? null : spatialAdaptiveQuantization.toString());
            return this;
        }

        public final String getTemporalAdaptiveQuantization() {
            return temporalAdaptiveQuantization;
        }

        public final void setTemporalAdaptiveQuantization(String temporalAdaptiveQuantization) {
            this.temporalAdaptiveQuantization = temporalAdaptiveQuantization;
        }

        @Override
        public final Builder temporalAdaptiveQuantization(String temporalAdaptiveQuantization) {
            this.temporalAdaptiveQuantization = temporalAdaptiveQuantization;
            return this;
        }

        @Override
        public final Builder temporalAdaptiveQuantization(XavcTemporalAdaptiveQuantization temporalAdaptiveQuantization) {
            this.temporalAdaptiveQuantization(temporalAdaptiveQuantization == null ? null : temporalAdaptiveQuantization
                    .toString());
            return this;
        }

        public final Xavc4kIntraCbgProfileSettings.Builder getXavc4kIntraCbgProfileSettings() {
            return xavc4kIntraCbgProfileSettings != null ? xavc4kIntraCbgProfileSettings.toBuilder() : null;
        }

        public final void setXavc4kIntraCbgProfileSettings(Xavc4kIntraCbgProfileSettings.BuilderImpl xavc4kIntraCbgProfileSettings) {
            this.xavc4kIntraCbgProfileSettings = xavc4kIntraCbgProfileSettings != null ? xavc4kIntraCbgProfileSettings.build()
                    : null;
        }

        @Override
        public final Builder xavc4kIntraCbgProfileSettings(Xavc4kIntraCbgProfileSettings xavc4kIntraCbgProfileSettings) {
            this.xavc4kIntraCbgProfileSettings = xavc4kIntraCbgProfileSettings;
            return this;
        }

        public final Xavc4kIntraVbrProfileSettings.Builder getXavc4kIntraVbrProfileSettings() {
            return xavc4kIntraVbrProfileSettings != null ? xavc4kIntraVbrProfileSettings.toBuilder() : null;
        }

        public final void setXavc4kIntraVbrProfileSettings(Xavc4kIntraVbrProfileSettings.BuilderImpl xavc4kIntraVbrProfileSettings) {
            this.xavc4kIntraVbrProfileSettings = xavc4kIntraVbrProfileSettings != null ? xavc4kIntraVbrProfileSettings.build()
                    : null;
        }

        @Override
        public final Builder xavc4kIntraVbrProfileSettings(Xavc4kIntraVbrProfileSettings xavc4kIntraVbrProfileSettings) {
            this.xavc4kIntraVbrProfileSettings = xavc4kIntraVbrProfileSettings;
            return this;
        }

        public final Xavc4kProfileSettings.Builder getXavc4kProfileSettings() {
            return xavc4kProfileSettings != null ? xavc4kProfileSettings.toBuilder() : null;
        }

        public final void setXavc4kProfileSettings(Xavc4kProfileSettings.BuilderImpl xavc4kProfileSettings) {
            this.xavc4kProfileSettings = xavc4kProfileSettings != null ? xavc4kProfileSettings.build() : null;
        }

        @Override
        public final Builder xavc4kProfileSettings(Xavc4kProfileSettings xavc4kProfileSettings) {
            this.xavc4kProfileSettings = xavc4kProfileSettings;
            return this;
        }

        public final XavcHdIntraCbgProfileSettings.Builder getXavcHdIntraCbgProfileSettings() {
            return xavcHdIntraCbgProfileSettings != null ? xavcHdIntraCbgProfileSettings.toBuilder() : null;
        }

        public final void setXavcHdIntraCbgProfileSettings(XavcHdIntraCbgProfileSettings.BuilderImpl xavcHdIntraCbgProfileSettings) {
            this.xavcHdIntraCbgProfileSettings = xavcHdIntraCbgProfileSettings != null ? xavcHdIntraCbgProfileSettings.build()
                    : null;
        }

        @Override
        public final Builder xavcHdIntraCbgProfileSettings(XavcHdIntraCbgProfileSettings xavcHdIntraCbgProfileSettings) {
            this.xavcHdIntraCbgProfileSettings = xavcHdIntraCbgProfileSettings;
            return this;
        }

        public final XavcHdProfileSettings.Builder getXavcHdProfileSettings() {
            return xavcHdProfileSettings != null ? xavcHdProfileSettings.toBuilder() : null;
        }

        public final void setXavcHdProfileSettings(XavcHdProfileSettings.BuilderImpl xavcHdProfileSettings) {
            this.xavcHdProfileSettings = xavcHdProfileSettings != null ? xavcHdProfileSettings.build() : null;
        }

        @Override
        public final Builder xavcHdProfileSettings(XavcHdProfileSettings xavcHdProfileSettings) {
            this.xavcHdProfileSettings = xavcHdProfileSettings;
            return this;
        }

        @Override
        public XavcSettings build() {
            return new XavcSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
