/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Specify whether MediaConvert generates images for trick play. Keep the default value, None, to not generate any
 * images. Choose Thumbnail to generate tiled thumbnails. Choose Thumbnail and full frame to generate tiled thumbnails
 * and full-resolution images of single frames. MediaConvert creates a child manifest for each set of images that you
 * generate and adds corresponding entries to the parent manifest. A common application for these images is Roku trick
 * mode. The thumbnails and full-frame images that MediaConvert creates with this feature are compatible with this Roku
 * specification: https://developer.roku.com/docs/developer-program/media-playback/trick-mode/hls-and-dash.md
 */
@Generated("software.amazon.awssdk:codegen")
public enum HlsImageBasedTrickPlay {
    NONE("NONE"),

    THUMBNAIL("THUMBNAIL"),

    THUMBNAIL_AND_FULLFRAME("THUMBNAIL_AND_FULLFRAME"),

    ADVANCED("ADVANCED"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, HlsImageBasedTrickPlay> VALUE_MAP = EnumUtils.uniqueIndex(HlsImageBasedTrickPlay.class,
            HlsImageBasedTrickPlay::toString);

    private final String value;

    private HlsImageBasedTrickPlay(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return HlsImageBasedTrickPlay corresponding to the value
     */
    public static HlsImageBasedTrickPlay fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link HlsImageBasedTrickPlay}s
     */
    public static Set<HlsImageBasedTrickPlay> knownValues() {
        Set<HlsImageBasedTrickPlay> knownValues = EnumSet.allOf(HlsImageBasedTrickPlay.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
