/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Specify the alignment of your captions. If no explicit x_position is provided, setting alignment to centered will
 * placethe captions at the bottom center of the output. Similarly, setting a left alignment willalign captions to the
 * bottom left of the output. If x and y positions are given in conjunction with the alignment parameter, the font will
 * be justified (either left or centered) relative to those coordinates. Within your job settings, all of your DVB-Sub
 * settings must be identical.
 */
@Generated("software.amazon.awssdk:codegen")
public enum DvbSubtitleAlignment {
    CENTERED("CENTERED"),

    LEFT("LEFT"),

    AUTO("AUTO"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DvbSubtitleAlignment> VALUE_MAP = EnumUtils.uniqueIndex(DvbSubtitleAlignment.class,
            DvbSubtitleAlignment::toString);

    private final String value;

    private DvbSubtitleAlignment(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return DvbSubtitleAlignment corresponding to the value
     */
    public static DvbSubtitleAlignment fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link DvbSubtitleAlignment}s
     */
    public static Set<DvbSubtitleAlignment> knownValues() {
        Set<DvbSubtitleAlignment> knownValues = EnumSet.allOf(DvbSubtitleAlignment.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
