/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Settings related to your DASH output package. For more information, see
 * https://docs.aws.amazon.com/mediaconvert/latest/ug/outputs-file-ABR.html.
 */
@Generated("software.amazon.awssdk:codegen")
public final class DashIsoGroupSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<DashIsoGroupSettings.Builder, DashIsoGroupSettings> {
    private static final SdkField<List<DashAdditionalManifest>> ADDITIONAL_MANIFESTS_FIELD = SdkField
            .<List<DashAdditionalManifest>> builder(MarshallingType.LIST)
            .memberName("AdditionalManifests")
            .getter(getter(DashIsoGroupSettings::additionalManifests))
            .setter(setter(Builder::additionalManifests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalManifests").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DashAdditionalManifest> builder(MarshallingType.SDK_POJO)
                                            .constructor(DashAdditionalManifest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> AUDIO_CHANNEL_CONFIG_SCHEME_ID_URI_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AudioChannelConfigSchemeIdUri")
            .getter(getter(DashIsoGroupSettings::audioChannelConfigSchemeIdUriAsString))
            .setter(setter(Builder::audioChannelConfigSchemeIdUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioChannelConfigSchemeIdUri")
                    .build()).build();

    private static final SdkField<String> BASE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BaseUrl").getter(getter(DashIsoGroupSettings::baseUrl)).setter(setter(Builder::baseUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseUrl").build()).build();

    private static final SdkField<String> DASH_MANIFEST_STYLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DashManifestStyle").getter(getter(DashIsoGroupSettings::dashManifestStyleAsString))
            .setter(setter(Builder::dashManifestStyle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dashManifestStyle").build()).build();

    private static final SdkField<String> DESTINATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Destination").getter(getter(DashIsoGroupSettings::destination)).setter(setter(Builder::destination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()).build();

    private static final SdkField<DestinationSettings> DESTINATION_SETTINGS_FIELD = SdkField
            .<DestinationSettings> builder(MarshallingType.SDK_POJO).memberName("DestinationSettings")
            .getter(getter(DashIsoGroupSettings::destinationSettings)).setter(setter(Builder::destinationSettings))
            .constructor(DestinationSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationSettings").build())
            .build();

    private static final SdkField<DashIsoEncryptionSettings> ENCRYPTION_FIELD = SdkField
            .<DashIsoEncryptionSettings> builder(MarshallingType.SDK_POJO).memberName("Encryption")
            .getter(getter(DashIsoGroupSettings::encryption)).setter(setter(Builder::encryption))
            .constructor(DashIsoEncryptionSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryption").build()).build();

    private static final SdkField<Integer> FRAGMENT_LENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FragmentLength").getter(getter(DashIsoGroupSettings::fragmentLength))
            .setter(setter(Builder::fragmentLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fragmentLength").build()).build();

    private static final SdkField<String> HBBTV_COMPLIANCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HbbtvCompliance").getter(getter(DashIsoGroupSettings::hbbtvComplianceAsString))
            .setter(setter(Builder::hbbtvCompliance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hbbtvCompliance").build()).build();

    private static final SdkField<String> IMAGE_BASED_TRICK_PLAY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageBasedTrickPlay").getter(getter(DashIsoGroupSettings::imageBasedTrickPlayAsString))
            .setter(setter(Builder::imageBasedTrickPlay))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageBasedTrickPlay").build())
            .build();

    private static final SdkField<DashIsoImageBasedTrickPlaySettings> IMAGE_BASED_TRICK_PLAY_SETTINGS_FIELD = SdkField
            .<DashIsoImageBasedTrickPlaySettings> builder(MarshallingType.SDK_POJO)
            .memberName("ImageBasedTrickPlaySettings")
            .getter(getter(DashIsoGroupSettings::imageBasedTrickPlaySettings))
            .setter(setter(Builder::imageBasedTrickPlaySettings))
            .constructor(DashIsoImageBasedTrickPlaySettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageBasedTrickPlaySettings")
                    .build()).build();

    private static final SdkField<Integer> MIN_BUFFER_TIME_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinBufferTime").getter(getter(DashIsoGroupSettings::minBufferTime))
            .setter(setter(Builder::minBufferTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minBufferTime").build()).build();

    private static final SdkField<Double> MIN_FINAL_SEGMENT_LENGTH_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("MinFinalSegmentLength").getter(getter(DashIsoGroupSettings::minFinalSegmentLength))
            .setter(setter(Builder::minFinalSegmentLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minFinalSegmentLength").build())
            .build();

    private static final SdkField<String> MPD_MANIFEST_BANDWIDTH_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MpdManifestBandwidthType").getter(getter(DashIsoGroupSettings::mpdManifestBandwidthTypeAsString))
            .setter(setter(Builder::mpdManifestBandwidthType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mpdManifestBandwidthType").build())
            .build();

    private static final SdkField<String> MPD_PROFILE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MpdProfile").getter(getter(DashIsoGroupSettings::mpdProfileAsString))
            .setter(setter(Builder::mpdProfile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mpdProfile").build()).build();

    private static final SdkField<String> PTS_OFFSET_HANDLING_FOR_B_FRAMES_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PtsOffsetHandlingForBFrames")
            .getter(getter(DashIsoGroupSettings::ptsOffsetHandlingForBFramesAsString))
            .setter(setter(Builder::ptsOffsetHandlingForBFrames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ptsOffsetHandlingForBFrames")
                    .build()).build();

    private static final SdkField<String> SEGMENT_CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SegmentControl").getter(getter(DashIsoGroupSettings::segmentControlAsString))
            .setter(setter(Builder::segmentControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentControl").build()).build();

    private static final SdkField<Integer> SEGMENT_LENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SegmentLength").getter(getter(DashIsoGroupSettings::segmentLength))
            .setter(setter(Builder::segmentLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentLength").build()).build();

    private static final SdkField<String> SEGMENT_LENGTH_CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SegmentLengthControl").getter(getter(DashIsoGroupSettings::segmentLengthControlAsString))
            .setter(setter(Builder::segmentLengthControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentLengthControl").build())
            .build();

    private static final SdkField<String> VIDEO_COMPOSITION_OFFSETS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VideoCompositionOffsets").getter(getter(DashIsoGroupSettings::videoCompositionOffsetsAsString))
            .setter(setter(Builder::videoCompositionOffsets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoCompositionOffsets").build())
            .build();

    private static final SdkField<String> WRITE_SEGMENT_TIMELINE_IN_REPRESENTATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("WriteSegmentTimelineInRepresentation")
            .getter(getter(DashIsoGroupSettings::writeSegmentTimelineInRepresentationAsString))
            .setter(setter(Builder::writeSegmentTimelineInRepresentation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("writeSegmentTimelineInRepresentation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDITIONAL_MANIFESTS_FIELD,
            AUDIO_CHANNEL_CONFIG_SCHEME_ID_URI_FIELD, BASE_URL_FIELD, DASH_MANIFEST_STYLE_FIELD, DESTINATION_FIELD,
            DESTINATION_SETTINGS_FIELD, ENCRYPTION_FIELD, FRAGMENT_LENGTH_FIELD, HBBTV_COMPLIANCE_FIELD,
            IMAGE_BASED_TRICK_PLAY_FIELD, IMAGE_BASED_TRICK_PLAY_SETTINGS_FIELD, MIN_BUFFER_TIME_FIELD,
            MIN_FINAL_SEGMENT_LENGTH_FIELD, MPD_MANIFEST_BANDWIDTH_TYPE_FIELD, MPD_PROFILE_FIELD,
            PTS_OFFSET_HANDLING_FOR_B_FRAMES_FIELD, SEGMENT_CONTROL_FIELD, SEGMENT_LENGTH_FIELD, SEGMENT_LENGTH_CONTROL_FIELD,
            VIDEO_COMPOSITION_OFFSETS_FIELD, WRITE_SEGMENT_TIMELINE_IN_REPRESENTATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<DashAdditionalManifest> additionalManifests;

    private final String audioChannelConfigSchemeIdUri;

    private final String baseUrl;

    private final String dashManifestStyle;

    private final String destination;

    private final DestinationSettings destinationSettings;

    private final DashIsoEncryptionSettings encryption;

    private final Integer fragmentLength;

    private final String hbbtvCompliance;

    private final String imageBasedTrickPlay;

    private final DashIsoImageBasedTrickPlaySettings imageBasedTrickPlaySettings;

    private final Integer minBufferTime;

    private final Double minFinalSegmentLength;

    private final String mpdManifestBandwidthType;

    private final String mpdProfile;

    private final String ptsOffsetHandlingForBFrames;

    private final String segmentControl;

    private final Integer segmentLength;

    private final String segmentLengthControl;

    private final String videoCompositionOffsets;

    private final String writeSegmentTimelineInRepresentation;

    private DashIsoGroupSettings(BuilderImpl builder) {
        this.additionalManifests = builder.additionalManifests;
        this.audioChannelConfigSchemeIdUri = builder.audioChannelConfigSchemeIdUri;
        this.baseUrl = builder.baseUrl;
        this.dashManifestStyle = builder.dashManifestStyle;
        this.destination = builder.destination;
        this.destinationSettings = builder.destinationSettings;
        this.encryption = builder.encryption;
        this.fragmentLength = builder.fragmentLength;
        this.hbbtvCompliance = builder.hbbtvCompliance;
        this.imageBasedTrickPlay = builder.imageBasedTrickPlay;
        this.imageBasedTrickPlaySettings = builder.imageBasedTrickPlaySettings;
        this.minBufferTime = builder.minBufferTime;
        this.minFinalSegmentLength = builder.minFinalSegmentLength;
        this.mpdManifestBandwidthType = builder.mpdManifestBandwidthType;
        this.mpdProfile = builder.mpdProfile;
        this.ptsOffsetHandlingForBFrames = builder.ptsOffsetHandlingForBFrames;
        this.segmentControl = builder.segmentControl;
        this.segmentLength = builder.segmentLength;
        this.segmentLengthControl = builder.segmentLengthControl;
        this.videoCompositionOffsets = builder.videoCompositionOffsets;
        this.writeSegmentTimelineInRepresentation = builder.writeSegmentTimelineInRepresentation;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalManifests property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAdditionalManifests() {
        return additionalManifests != null && !(additionalManifests instanceof SdkAutoConstructList);
    }

    /**
     * By default, the service creates one .mpd DASH manifest for each DASH ISO output group in your job. This default
     * manifest references every output in the output group. To create additional DASH manifests that reference a subset
     * of the outputs in the output group, specify a list of them here.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalManifests} method.
     * </p>
     * 
     * @return By default, the service creates one .mpd DASH manifest for each DASH ISO output group in your job. This
     *         default manifest references every output in the output group. To create additional DASH manifests that
     *         reference a subset of the outputs in the output group, specify a list of them here.
     */
    public final List<DashAdditionalManifest> additionalManifests() {
        return additionalManifests;
    }

    /**
     * Use this setting only when your audio codec is a Dolby one (AC3, EAC3, or Atmos) and your downstream workflow
     * requires that your DASH manifest use the Dolby channel configuration tag, rather than the MPEG one. For example,
     * you might need to use this to make dynamic ad insertion work. Specify which audio channel configuration scheme ID
     * URI MediaConvert writes in your DASH manifest. Keep the default value, MPEG channel configuration, to have
     * MediaConvert write this: urn:mpeg:mpegB:cicp:ChannelConfiguration. Choose Dolby channel configuration to have
     * MediaConvert write this instead: tag:dolby.com,2014:dash:audio_channel_configuration:2011.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #audioChannelConfigSchemeIdUri} will return
     * {@link DashIsoGroupAudioChannelConfigSchemeIdUri#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #audioChannelConfigSchemeIdUriAsString}.
     * </p>
     * 
     * @return Use this setting only when your audio codec is a Dolby one (AC3, EAC3, or Atmos) and your downstream
     *         workflow requires that your DASH manifest use the Dolby channel configuration tag, rather than the MPEG
     *         one. For example, you might need to use this to make dynamic ad insertion work. Specify which audio
     *         channel configuration scheme ID URI MediaConvert writes in your DASH manifest. Keep the default value,
     *         MPEG channel configuration, to have MediaConvert write this: urn:mpeg:mpegB:cicp:ChannelConfiguration.
     *         Choose Dolby channel configuration to have MediaConvert write this instead:
     *         tag:dolby.com,2014:dash:audio_channel_configuration:2011.
     * @see DashIsoGroupAudioChannelConfigSchemeIdUri
     */
    public final DashIsoGroupAudioChannelConfigSchemeIdUri audioChannelConfigSchemeIdUri() {
        return DashIsoGroupAudioChannelConfigSchemeIdUri.fromValue(audioChannelConfigSchemeIdUri);
    }

    /**
     * Use this setting only when your audio codec is a Dolby one (AC3, EAC3, or Atmos) and your downstream workflow
     * requires that your DASH manifest use the Dolby channel configuration tag, rather than the MPEG one. For example,
     * you might need to use this to make dynamic ad insertion work. Specify which audio channel configuration scheme ID
     * URI MediaConvert writes in your DASH manifest. Keep the default value, MPEG channel configuration, to have
     * MediaConvert write this: urn:mpeg:mpegB:cicp:ChannelConfiguration. Choose Dolby channel configuration to have
     * MediaConvert write this instead: tag:dolby.com,2014:dash:audio_channel_configuration:2011.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #audioChannelConfigSchemeIdUri} will return
     * {@link DashIsoGroupAudioChannelConfigSchemeIdUri#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #audioChannelConfigSchemeIdUriAsString}.
     * </p>
     * 
     * @return Use this setting only when your audio codec is a Dolby one (AC3, EAC3, or Atmos) and your downstream
     *         workflow requires that your DASH manifest use the Dolby channel configuration tag, rather than the MPEG
     *         one. For example, you might need to use this to make dynamic ad insertion work. Specify which audio
     *         channel configuration scheme ID URI MediaConvert writes in your DASH manifest. Keep the default value,
     *         MPEG channel configuration, to have MediaConvert write this: urn:mpeg:mpegB:cicp:ChannelConfiguration.
     *         Choose Dolby channel configuration to have MediaConvert write this instead:
     *         tag:dolby.com,2014:dash:audio_channel_configuration:2011.
     * @see DashIsoGroupAudioChannelConfigSchemeIdUri
     */
    public final String audioChannelConfigSchemeIdUriAsString() {
        return audioChannelConfigSchemeIdUri;
    }

    /**
     * A partial URI prefix that will be put in the manifest (.mpd) file at the top level BaseURL element. Can be used
     * if streams are delivered from a different URL than the manifest file.
     * 
     * @return A partial URI prefix that will be put in the manifest (.mpd) file at the top level BaseURL element. Can
     *         be used if streams are delivered from a different URL than the manifest file.
     */
    public final String baseUrl() {
        return baseUrl;
    }

    /**
     * Specify how MediaConvert writes SegmentTimeline in your output DASH manifest. To write a SegmentTimeline in each
     * video Representation: Keep the default value, Basic. To write a common SegmentTimeline in the video
     * AdaptationSet: Choose Compact. Note that MediaConvert will still write a SegmentTimeline in any Representation
     * that does not share a common timeline. To write a video AdaptationSet for each different output framerate, and a
     * common SegmentTimeline in each AdaptationSet: Choose Distinct.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dashManifestStyle}
     * will return {@link DashManifestStyle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #dashManifestStyleAsString}.
     * </p>
     * 
     * @return Specify how MediaConvert writes SegmentTimeline in your output DASH manifest. To write a SegmentTimeline
     *         in each video Representation: Keep the default value, Basic. To write a common SegmentTimeline in the
     *         video AdaptationSet: Choose Compact. Note that MediaConvert will still write a SegmentTimeline in any
     *         Representation that does not share a common timeline. To write a video AdaptationSet for each different
     *         output framerate, and a common SegmentTimeline in each AdaptationSet: Choose Distinct.
     * @see DashManifestStyle
     */
    public final DashManifestStyle dashManifestStyle() {
        return DashManifestStyle.fromValue(dashManifestStyle);
    }

    /**
     * Specify how MediaConvert writes SegmentTimeline in your output DASH manifest. To write a SegmentTimeline in each
     * video Representation: Keep the default value, Basic. To write a common SegmentTimeline in the video
     * AdaptationSet: Choose Compact. Note that MediaConvert will still write a SegmentTimeline in any Representation
     * that does not share a common timeline. To write a video AdaptationSet for each different output framerate, and a
     * common SegmentTimeline in each AdaptationSet: Choose Distinct.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dashManifestStyle}
     * will return {@link DashManifestStyle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #dashManifestStyleAsString}.
     * </p>
     * 
     * @return Specify how MediaConvert writes SegmentTimeline in your output DASH manifest. To write a SegmentTimeline
     *         in each video Representation: Keep the default value, Basic. To write a common SegmentTimeline in the
     *         video AdaptationSet: Choose Compact. Note that MediaConvert will still write a SegmentTimeline in any
     *         Representation that does not share a common timeline. To write a video AdaptationSet for each different
     *         output framerate, and a common SegmentTimeline in each AdaptationSet: Choose Distinct.
     * @see DashManifestStyle
     */
    public final String dashManifestStyleAsString() {
        return dashManifestStyle;
    }

    /**
     * Use Destination to specify the S3 output location and the output filename base. Destination accepts format
     * identifiers. If you do not specify the base filename in the URI, the service will use the filename of the input
     * file. If your job has multiple inputs, the service uses the filename of the first input file.
     * 
     * @return Use Destination to specify the S3 output location and the output filename base. Destination accepts
     *         format identifiers. If you do not specify the base filename in the URI, the service will use the filename
     *         of the input file. If your job has multiple inputs, the service uses the filename of the first input
     *         file.
     */
    public final String destination() {
        return destination;
    }

    /**
     * Settings associated with the destination. Will vary based on the type of destination
     * 
     * @return Settings associated with the destination. Will vary based on the type of destination
     */
    public final DestinationSettings destinationSettings() {
        return destinationSettings;
    }

    /**
     * DRM settings.
     * 
     * @return DRM settings.
     */
    public final DashIsoEncryptionSettings encryption() {
        return encryption;
    }

    /**
     * Length of fragments to generate (in seconds). Fragment length must be compatible with GOP size and Framerate.
     * Note that fragments will end on the next keyframe after this number of seconds, so actual fragment length may be
     * longer. When Emit Single File is checked, the fragmentation is internal to a single output file and it does not
     * cause the creation of many output files as in other output types.
     * 
     * @return Length of fragments to generate (in seconds). Fragment length must be compatible with GOP size and
     *         Framerate. Note that fragments will end on the next keyframe after this number of seconds, so actual
     *         fragment length may be longer. When Emit Single File is checked, the fragmentation is internal to a
     *         single output file and it does not cause the creation of many output files as in other output types.
     */
    public final Integer fragmentLength() {
        return fragmentLength;
    }

    /**
     * Supports HbbTV specification as indicated
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hbbtvCompliance}
     * will return {@link DashIsoHbbtvCompliance#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #hbbtvComplianceAsString}.
     * </p>
     * 
     * @return Supports HbbTV specification as indicated
     * @see DashIsoHbbtvCompliance
     */
    public final DashIsoHbbtvCompliance hbbtvCompliance() {
        return DashIsoHbbtvCompliance.fromValue(hbbtvCompliance);
    }

    /**
     * Supports HbbTV specification as indicated
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hbbtvCompliance}
     * will return {@link DashIsoHbbtvCompliance#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #hbbtvComplianceAsString}.
     * </p>
     * 
     * @return Supports HbbTV specification as indicated
     * @see DashIsoHbbtvCompliance
     */
    public final String hbbtvComplianceAsString() {
        return hbbtvCompliance;
    }

    /**
     * Specify whether MediaConvert generates images for trick play. Keep the default value, None, to not generate any
     * images. Choose Thumbnail to generate tiled thumbnails. Choose Thumbnail and full frame to generate tiled
     * thumbnails and full-resolution images of single frames. MediaConvert adds an entry in the .mpd manifest for each
     * set of images that you generate. A common application for these images is Roku trick mode. The thumbnails and
     * full-frame images that MediaConvert creates with this feature are compatible with this Roku specification:
     * https://developer.roku.com/docs/developer-program/media-playback/trick-mode/hls-and-dash.md
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #imageBasedTrickPlay} will return {@link DashIsoImageBasedTrickPlay#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #imageBasedTrickPlayAsString}.
     * </p>
     * 
     * @return Specify whether MediaConvert generates images for trick play. Keep the default value, None, to not
     *         generate any images. Choose Thumbnail to generate tiled thumbnails. Choose Thumbnail and full frame to
     *         generate tiled thumbnails and full-resolution images of single frames. MediaConvert adds an entry in the
     *         .mpd manifest for each set of images that you generate. A common application for these images is Roku
     *         trick mode. The thumbnails and full-frame images that MediaConvert creates with this feature are
     *         compatible with this Roku specification:
     *         https://developer.roku.com/docs/developer-program/media-playback/trick-mode/hls-and-dash.md
     * @see DashIsoImageBasedTrickPlay
     */
    public final DashIsoImageBasedTrickPlay imageBasedTrickPlay() {
        return DashIsoImageBasedTrickPlay.fromValue(imageBasedTrickPlay);
    }

    /**
     * Specify whether MediaConvert generates images for trick play. Keep the default value, None, to not generate any
     * images. Choose Thumbnail to generate tiled thumbnails. Choose Thumbnail and full frame to generate tiled
     * thumbnails and full-resolution images of single frames. MediaConvert adds an entry in the .mpd manifest for each
     * set of images that you generate. A common application for these images is Roku trick mode. The thumbnails and
     * full-frame images that MediaConvert creates with this feature are compatible with this Roku specification:
     * https://developer.roku.com/docs/developer-program/media-playback/trick-mode/hls-and-dash.md
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #imageBasedTrickPlay} will return {@link DashIsoImageBasedTrickPlay#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #imageBasedTrickPlayAsString}.
     * </p>
     * 
     * @return Specify whether MediaConvert generates images for trick play. Keep the default value, None, to not
     *         generate any images. Choose Thumbnail to generate tiled thumbnails. Choose Thumbnail and full frame to
     *         generate tiled thumbnails and full-resolution images of single frames. MediaConvert adds an entry in the
     *         .mpd manifest for each set of images that you generate. A common application for these images is Roku
     *         trick mode. The thumbnails and full-frame images that MediaConvert creates with this feature are
     *         compatible with this Roku specification:
     *         https://developer.roku.com/docs/developer-program/media-playback/trick-mode/hls-and-dash.md
     * @see DashIsoImageBasedTrickPlay
     */
    public final String imageBasedTrickPlayAsString() {
        return imageBasedTrickPlay;
    }

    /**
     * Tile and thumbnail settings applicable when imageBasedTrickPlay is ADVANCED
     * 
     * @return Tile and thumbnail settings applicable when imageBasedTrickPlay is ADVANCED
     */
    public final DashIsoImageBasedTrickPlaySettings imageBasedTrickPlaySettings() {
        return imageBasedTrickPlaySettings;
    }

    /**
     * Minimum time of initially buffered media that is needed to ensure smooth playout.
     * 
     * @return Minimum time of initially buffered media that is needed to ensure smooth playout.
     */
    public final Integer minBufferTime() {
        return minBufferTime;
    }

    /**
     * Keep this setting at the default value of 0, unless you are troubleshooting a problem with how devices play back
     * the end of your video asset. If you know that player devices are hanging on the final segment of your video
     * because the length of your final segment is too short, use this setting to specify a minimum final segment
     * length, in seconds. Choose a value that is greater than or equal to 1 and less than your segment length. When you
     * specify a value for this setting, the encoder will combine any final segment that is shorter than the length that
     * you specify with the previous segment. For example, your segment length is 3 seconds and your final segment is .5
     * seconds without a minimum final segment length; when you set the minimum final segment length to 1, your final
     * segment is 3.5 seconds.
     * 
     * @return Keep this setting at the default value of 0, unless you are troubleshooting a problem with how devices
     *         play back the end of your video asset. If you know that player devices are hanging on the final segment
     *         of your video because the length of your final segment is too short, use this setting to specify a
     *         minimum final segment length, in seconds. Choose a value that is greater than or equal to 1 and less than
     *         your segment length. When you specify a value for this setting, the encoder will combine any final
     *         segment that is shorter than the length that you specify with the previous segment. For example, your
     *         segment length is 3 seconds and your final segment is .5 seconds without a minimum final segment length;
     *         when you set the minimum final segment length to 1, your final segment is 3.5 seconds.
     */
    public final Double minFinalSegmentLength() {
        return minFinalSegmentLength;
    }

    /**
     * Specify how the value for bandwidth is determined for each video Representation in your output MPD manifest. We
     * recommend that you choose a MPD manifest bandwidth type that is compatible with your downstream player
     * configuration. Max: Use the same value that you specify for Max bitrate in the video output, in bits per second.
     * Average: Use the calculated average bitrate of the encoded video output, in bits per second.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #mpdManifestBandwidthType} will return {@link DashIsoMpdManifestBandwidthType#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #mpdManifestBandwidthTypeAsString}.
     * </p>
     * 
     * @return Specify how the value for bandwidth is determined for each video Representation in your output MPD
     *         manifest. We recommend that you choose a MPD manifest bandwidth type that is compatible with your
     *         downstream player configuration. Max: Use the same value that you specify for Max bitrate in the video
     *         output, in bits per second. Average: Use the calculated average bitrate of the encoded video output, in
     *         bits per second.
     * @see DashIsoMpdManifestBandwidthType
     */
    public final DashIsoMpdManifestBandwidthType mpdManifestBandwidthType() {
        return DashIsoMpdManifestBandwidthType.fromValue(mpdManifestBandwidthType);
    }

    /**
     * Specify how the value for bandwidth is determined for each video Representation in your output MPD manifest. We
     * recommend that you choose a MPD manifest bandwidth type that is compatible with your downstream player
     * configuration. Max: Use the same value that you specify for Max bitrate in the video output, in bits per second.
     * Average: Use the calculated average bitrate of the encoded video output, in bits per second.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #mpdManifestBandwidthType} will return {@link DashIsoMpdManifestBandwidthType#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #mpdManifestBandwidthTypeAsString}.
     * </p>
     * 
     * @return Specify how the value for bandwidth is determined for each video Representation in your output MPD
     *         manifest. We recommend that you choose a MPD manifest bandwidth type that is compatible with your
     *         downstream player configuration. Max: Use the same value that you specify for Max bitrate in the video
     *         output, in bits per second. Average: Use the calculated average bitrate of the encoded video output, in
     *         bits per second.
     * @see DashIsoMpdManifestBandwidthType
     */
    public final String mpdManifestBandwidthTypeAsString() {
        return mpdManifestBandwidthType;
    }

    /**
     * Specify whether your DASH profile is on-demand or main. When you choose Main profile, the service signals
     * urn:mpeg:dash:profile:isoff-main:2011 in your .mpd DASH manifest. When you choose On-demand, the service signals
     * urn:mpeg:dash:profile:isoff-on-demand:2011 in your .mpd. When you choose On-demand, you must also set the output
     * group setting Segment control to Single file.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mpdProfile} will
     * return {@link DashIsoMpdProfile#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mpdProfileAsString}.
     * </p>
     * 
     * @return Specify whether your DASH profile is on-demand or main. When you choose Main profile, the service signals
     *         urn:mpeg:dash:profile:isoff-main:2011 in your .mpd DASH manifest. When you choose On-demand, the service
     *         signals urn:mpeg:dash:profile:isoff-on-demand:2011 in your .mpd. When you choose On-demand, you must also
     *         set the output group setting Segment control to Single file.
     * @see DashIsoMpdProfile
     */
    public final DashIsoMpdProfile mpdProfile() {
        return DashIsoMpdProfile.fromValue(mpdProfile);
    }

    /**
     * Specify whether your DASH profile is on-demand or main. When you choose Main profile, the service signals
     * urn:mpeg:dash:profile:isoff-main:2011 in your .mpd DASH manifest. When you choose On-demand, the service signals
     * urn:mpeg:dash:profile:isoff-on-demand:2011 in your .mpd. When you choose On-demand, you must also set the output
     * group setting Segment control to Single file.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mpdProfile} will
     * return {@link DashIsoMpdProfile#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mpdProfileAsString}.
     * </p>
     * 
     * @return Specify whether your DASH profile is on-demand or main. When you choose Main profile, the service signals
     *         urn:mpeg:dash:profile:isoff-main:2011 in your .mpd DASH manifest. When you choose On-demand, the service
     *         signals urn:mpeg:dash:profile:isoff-on-demand:2011 in your .mpd. When you choose On-demand, you must also
     *         set the output group setting Segment control to Single file.
     * @see DashIsoMpdProfile
     */
    public final String mpdProfileAsString() {
        return mpdProfile;
    }

    /**
     * Use this setting only when your output video stream has B-frames, which causes the initial presentation time
     * stamp (PTS) to be offset from the initial decode time stamp (DTS). Specify how MediaConvert handles PTS when
     * writing time stamps in output DASH manifests. Choose Match initial PTS when you want MediaConvert to use the
     * initial PTS as the first time stamp in the manifest. Choose Zero-based to have MediaConvert ignore the initial
     * PTS in the video stream and instead write the initial time stamp as zero in the manifest. For outputs that don't
     * have B-frames, the time stamps in your DASH manifests start at zero regardless of your choice here.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #ptsOffsetHandlingForBFrames} will return
     * {@link DashIsoPtsOffsetHandlingForBFrames#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #ptsOffsetHandlingForBFramesAsString}.
     * </p>
     * 
     * @return Use this setting only when your output video stream has B-frames, which causes the initial presentation
     *         time stamp (PTS) to be offset from the initial decode time stamp (DTS). Specify how MediaConvert handles
     *         PTS when writing time stamps in output DASH manifests. Choose Match initial PTS when you want
     *         MediaConvert to use the initial PTS as the first time stamp in the manifest. Choose Zero-based to have
     *         MediaConvert ignore the initial PTS in the video stream and instead write the initial time stamp as zero
     *         in the manifest. For outputs that don't have B-frames, the time stamps in your DASH manifests start at
     *         zero regardless of your choice here.
     * @see DashIsoPtsOffsetHandlingForBFrames
     */
    public final DashIsoPtsOffsetHandlingForBFrames ptsOffsetHandlingForBFrames() {
        return DashIsoPtsOffsetHandlingForBFrames.fromValue(ptsOffsetHandlingForBFrames);
    }

    /**
     * Use this setting only when your output video stream has B-frames, which causes the initial presentation time
     * stamp (PTS) to be offset from the initial decode time stamp (DTS). Specify how MediaConvert handles PTS when
     * writing time stamps in output DASH manifests. Choose Match initial PTS when you want MediaConvert to use the
     * initial PTS as the first time stamp in the manifest. Choose Zero-based to have MediaConvert ignore the initial
     * PTS in the video stream and instead write the initial time stamp as zero in the manifest. For outputs that don't
     * have B-frames, the time stamps in your DASH manifests start at zero regardless of your choice here.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #ptsOffsetHandlingForBFrames} will return
     * {@link DashIsoPtsOffsetHandlingForBFrames#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #ptsOffsetHandlingForBFramesAsString}.
     * </p>
     * 
     * @return Use this setting only when your output video stream has B-frames, which causes the initial presentation
     *         time stamp (PTS) to be offset from the initial decode time stamp (DTS). Specify how MediaConvert handles
     *         PTS when writing time stamps in output DASH manifests. Choose Match initial PTS when you want
     *         MediaConvert to use the initial PTS as the first time stamp in the manifest. Choose Zero-based to have
     *         MediaConvert ignore the initial PTS in the video stream and instead write the initial time stamp as zero
     *         in the manifest. For outputs that don't have B-frames, the time stamps in your DASH manifests start at
     *         zero regardless of your choice here.
     * @see DashIsoPtsOffsetHandlingForBFrames
     */
    public final String ptsOffsetHandlingForBFramesAsString() {
        return ptsOffsetHandlingForBFrames;
    }

    /**
     * When set to SINGLE_FILE, a single output file is generated, which is internally segmented using the Fragment
     * Length and Segment Length. When set to SEGMENTED_FILES, separate segment files will be created.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #segmentControl}
     * will return {@link DashIsoSegmentControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #segmentControlAsString}.
     * </p>
     * 
     * @return When set to SINGLE_FILE, a single output file is generated, which is internally segmented using the
     *         Fragment Length and Segment Length. When set to SEGMENTED_FILES, separate segment files will be created.
     * @see DashIsoSegmentControl
     */
    public final DashIsoSegmentControl segmentControl() {
        return DashIsoSegmentControl.fromValue(segmentControl);
    }

    /**
     * When set to SINGLE_FILE, a single output file is generated, which is internally segmented using the Fragment
     * Length and Segment Length. When set to SEGMENTED_FILES, separate segment files will be created.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #segmentControl}
     * will return {@link DashIsoSegmentControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #segmentControlAsString}.
     * </p>
     * 
     * @return When set to SINGLE_FILE, a single output file is generated, which is internally segmented using the
     *         Fragment Length and Segment Length. When set to SEGMENTED_FILES, separate segment files will be created.
     * @see DashIsoSegmentControl
     */
    public final String segmentControlAsString() {
        return segmentControl;
    }

    /**
     * Specify the length, in whole seconds, of each segment. When you don't specify a value, MediaConvert defaults to
     * 30. Related settings: Use Segment length control to specify whether the encoder enforces this value strictly. Use
     * Segment control to specify whether MediaConvert creates separate segment files or one content file that has
     * metadata to mark the segment boundaries.
     * 
     * @return Specify the length, in whole seconds, of each segment. When you don't specify a value, MediaConvert
     *         defaults to 30. Related settings: Use Segment length control to specify whether the encoder enforces this
     *         value strictly. Use Segment control to specify whether MediaConvert creates separate segment files or one
     *         content file that has metadata to mark the segment boundaries.
     */
    public final Integer segmentLength() {
        return segmentLength;
    }

    /**
     * Specify how you want MediaConvert to determine the segment length. Choose Exact to have the encoder use the exact
     * length that you specify with the setting Segment length. This might result in extra I-frames. Choose Multiple of
     * GOP to have the encoder round up the segment lengths to match the next GOP boundary.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #segmentLengthControl} will return {@link DashIsoSegmentLengthControl#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #segmentLengthControlAsString}.
     * </p>
     * 
     * @return Specify how you want MediaConvert to determine the segment length. Choose Exact to have the encoder use
     *         the exact length that you specify with the setting Segment length. This might result in extra I-frames.
     *         Choose Multiple of GOP to have the encoder round up the segment lengths to match the next GOP boundary.
     * @see DashIsoSegmentLengthControl
     */
    public final DashIsoSegmentLengthControl segmentLengthControl() {
        return DashIsoSegmentLengthControl.fromValue(segmentLengthControl);
    }

    /**
     * Specify how you want MediaConvert to determine the segment length. Choose Exact to have the encoder use the exact
     * length that you specify with the setting Segment length. This might result in extra I-frames. Choose Multiple of
     * GOP to have the encoder round up the segment lengths to match the next GOP boundary.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #segmentLengthControl} will return {@link DashIsoSegmentLengthControl#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #segmentLengthControlAsString}.
     * </p>
     * 
     * @return Specify how you want MediaConvert to determine the segment length. Choose Exact to have the encoder use
     *         the exact length that you specify with the setting Segment length. This might result in extra I-frames.
     *         Choose Multiple of GOP to have the encoder round up the segment lengths to match the next GOP boundary.
     * @see DashIsoSegmentLengthControl
     */
    public final String segmentLengthControlAsString() {
        return segmentLengthControl;
    }

    /**
     * Specify the video sample composition time offset mode in the output fMP4 TRUN box. For wider player
     * compatibility, set Video composition offsets to Unsigned or leave blank. The earliest presentation time may be
     * greater than zero, and sample composition time offsets will increment using unsigned integers. For strict fMP4
     * video and audio timing, set Video composition offsets to Signed. The earliest presentation time will be equal to
     * zero, and sample composition time offsets will increment using signed integers.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #videoCompositionOffsets} will return {@link DashIsoVideoCompositionOffsets#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #videoCompositionOffsetsAsString}.
     * </p>
     * 
     * @return Specify the video sample composition time offset mode in the output fMP4 TRUN box. For wider player
     *         compatibility, set Video composition offsets to Unsigned or leave blank. The earliest presentation time
     *         may be greater than zero, and sample composition time offsets will increment using unsigned integers. For
     *         strict fMP4 video and audio timing, set Video composition offsets to Signed. The earliest presentation
     *         time will be equal to zero, and sample composition time offsets will increment using signed integers.
     * @see DashIsoVideoCompositionOffsets
     */
    public final DashIsoVideoCompositionOffsets videoCompositionOffsets() {
        return DashIsoVideoCompositionOffsets.fromValue(videoCompositionOffsets);
    }

    /**
     * Specify the video sample composition time offset mode in the output fMP4 TRUN box. For wider player
     * compatibility, set Video composition offsets to Unsigned or leave blank. The earliest presentation time may be
     * greater than zero, and sample composition time offsets will increment using unsigned integers. For strict fMP4
     * video and audio timing, set Video composition offsets to Signed. The earliest presentation time will be equal to
     * zero, and sample composition time offsets will increment using signed integers.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #videoCompositionOffsets} will return {@link DashIsoVideoCompositionOffsets#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #videoCompositionOffsetsAsString}.
     * </p>
     * 
     * @return Specify the video sample composition time offset mode in the output fMP4 TRUN box. For wider player
     *         compatibility, set Video composition offsets to Unsigned or leave blank. The earliest presentation time
     *         may be greater than zero, and sample composition time offsets will increment using unsigned integers. For
     *         strict fMP4 video and audio timing, set Video composition offsets to Signed. The earliest presentation
     *         time will be equal to zero, and sample composition time offsets will increment using signed integers.
     * @see DashIsoVideoCompositionOffsets
     */
    public final String videoCompositionOffsetsAsString() {
        return videoCompositionOffsets;
    }

    /**
     * If you get an HTTP error in the 400 range when you play back your DASH output, enable this setting and run your
     * transcoding job again. When you enable this setting, the service writes precise segment durations in the DASH
     * manifest. The segment duration information appears inside the SegmentTimeline element, inside SegmentTemplate at
     * the Representation level. When you don't enable this setting, the service writes approximate segment durations in
     * your DASH manifest.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #writeSegmentTimelineInRepresentation} will return
     * {@link DashIsoWriteSegmentTimelineInRepresentation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #writeSegmentTimelineInRepresentationAsString}.
     * </p>
     * 
     * @return If you get an HTTP error in the 400 range when you play back your DASH output, enable this setting and
     *         run your transcoding job again. When you enable this setting, the service writes precise segment
     *         durations in the DASH manifest. The segment duration information appears inside the SegmentTimeline
     *         element, inside SegmentTemplate at the Representation level. When you don't enable this setting, the
     *         service writes approximate segment durations in your DASH manifest.
     * @see DashIsoWriteSegmentTimelineInRepresentation
     */
    public final DashIsoWriteSegmentTimelineInRepresentation writeSegmentTimelineInRepresentation() {
        return DashIsoWriteSegmentTimelineInRepresentation.fromValue(writeSegmentTimelineInRepresentation);
    }

    /**
     * If you get an HTTP error in the 400 range when you play back your DASH output, enable this setting and run your
     * transcoding job again. When you enable this setting, the service writes precise segment durations in the DASH
     * manifest. The segment duration information appears inside the SegmentTimeline element, inside SegmentTemplate at
     * the Representation level. When you don't enable this setting, the service writes approximate segment durations in
     * your DASH manifest.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #writeSegmentTimelineInRepresentation} will return
     * {@link DashIsoWriteSegmentTimelineInRepresentation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #writeSegmentTimelineInRepresentationAsString}.
     * </p>
     * 
     * @return If you get an HTTP error in the 400 range when you play back your DASH output, enable this setting and
     *         run your transcoding job again. When you enable this setting, the service writes precise segment
     *         durations in the DASH manifest. The segment duration information appears inside the SegmentTimeline
     *         element, inside SegmentTemplate at the Representation level. When you don't enable this setting, the
     *         service writes approximate segment durations in your DASH manifest.
     * @see DashIsoWriteSegmentTimelineInRepresentation
     */
    public final String writeSegmentTimelineInRepresentationAsString() {
        return writeSegmentTimelineInRepresentation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalManifests() ? additionalManifests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(audioChannelConfigSchemeIdUriAsString());
        hashCode = 31 * hashCode + Objects.hashCode(baseUrl());
        hashCode = 31 * hashCode + Objects.hashCode(dashManifestStyleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(destinationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(encryption());
        hashCode = 31 * hashCode + Objects.hashCode(fragmentLength());
        hashCode = 31 * hashCode + Objects.hashCode(hbbtvComplianceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(imageBasedTrickPlayAsString());
        hashCode = 31 * hashCode + Objects.hashCode(imageBasedTrickPlaySettings());
        hashCode = 31 * hashCode + Objects.hashCode(minBufferTime());
        hashCode = 31 * hashCode + Objects.hashCode(minFinalSegmentLength());
        hashCode = 31 * hashCode + Objects.hashCode(mpdManifestBandwidthTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(mpdProfileAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ptsOffsetHandlingForBFramesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(segmentControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(segmentLength());
        hashCode = 31 * hashCode + Objects.hashCode(segmentLengthControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(videoCompositionOffsetsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(writeSegmentTimelineInRepresentationAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DashIsoGroupSettings)) {
            return false;
        }
        DashIsoGroupSettings other = (DashIsoGroupSettings) obj;
        return hasAdditionalManifests() == other.hasAdditionalManifests()
                && Objects.equals(additionalManifests(), other.additionalManifests())
                && Objects.equals(audioChannelConfigSchemeIdUriAsString(), other.audioChannelConfigSchemeIdUriAsString())
                && Objects.equals(baseUrl(), other.baseUrl())
                && Objects.equals(dashManifestStyleAsString(), other.dashManifestStyleAsString())
                && Objects.equals(destination(), other.destination())
                && Objects.equals(destinationSettings(), other.destinationSettings())
                && Objects.equals(encryption(), other.encryption())
                && Objects.equals(fragmentLength(), other.fragmentLength())
                && Objects.equals(hbbtvComplianceAsString(), other.hbbtvComplianceAsString())
                && Objects.equals(imageBasedTrickPlayAsString(), other.imageBasedTrickPlayAsString())
                && Objects.equals(imageBasedTrickPlaySettings(), other.imageBasedTrickPlaySettings())
                && Objects.equals(minBufferTime(), other.minBufferTime())
                && Objects.equals(minFinalSegmentLength(), other.minFinalSegmentLength())
                && Objects.equals(mpdManifestBandwidthTypeAsString(), other.mpdManifestBandwidthTypeAsString())
                && Objects.equals(mpdProfileAsString(), other.mpdProfileAsString())
                && Objects.equals(ptsOffsetHandlingForBFramesAsString(), other.ptsOffsetHandlingForBFramesAsString())
                && Objects.equals(segmentControlAsString(), other.segmentControlAsString())
                && Objects.equals(segmentLength(), other.segmentLength())
                && Objects.equals(segmentLengthControlAsString(), other.segmentLengthControlAsString())
                && Objects.equals(videoCompositionOffsetsAsString(), other.videoCompositionOffsetsAsString())
                && Objects.equals(writeSegmentTimelineInRepresentationAsString(),
                        other.writeSegmentTimelineInRepresentationAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DashIsoGroupSettings")
                .add("AdditionalManifests", hasAdditionalManifests() ? additionalManifests() : null)
                .add("AudioChannelConfigSchemeIdUri", audioChannelConfigSchemeIdUriAsString()).add("BaseUrl", baseUrl())
                .add("DashManifestStyle", dashManifestStyleAsString()).add("Destination", destination())
                .add("DestinationSettings", destinationSettings()).add("Encryption", encryption())
                .add("FragmentLength", fragmentLength()).add("HbbtvCompliance", hbbtvComplianceAsString())
                .add("ImageBasedTrickPlay", imageBasedTrickPlayAsString())
                .add("ImageBasedTrickPlaySettings", imageBasedTrickPlaySettings()).add("MinBufferTime", minBufferTime())
                .add("MinFinalSegmentLength", minFinalSegmentLength())
                .add("MpdManifestBandwidthType", mpdManifestBandwidthTypeAsString()).add("MpdProfile", mpdProfileAsString())
                .add("PtsOffsetHandlingForBFrames", ptsOffsetHandlingForBFramesAsString())
                .add("SegmentControl", segmentControlAsString()).add("SegmentLength", segmentLength())
                .add("SegmentLengthControl", segmentLengthControlAsString())
                .add("VideoCompositionOffsets", videoCompositionOffsetsAsString())
                .add("WriteSegmentTimelineInRepresentation", writeSegmentTimelineInRepresentationAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdditionalManifests":
            return Optional.ofNullable(clazz.cast(additionalManifests()));
        case "AudioChannelConfigSchemeIdUri":
            return Optional.ofNullable(clazz.cast(audioChannelConfigSchemeIdUriAsString()));
        case "BaseUrl":
            return Optional.ofNullable(clazz.cast(baseUrl()));
        case "DashManifestStyle":
            return Optional.ofNullable(clazz.cast(dashManifestStyleAsString()));
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "DestinationSettings":
            return Optional.ofNullable(clazz.cast(destinationSettings()));
        case "Encryption":
            return Optional.ofNullable(clazz.cast(encryption()));
        case "FragmentLength":
            return Optional.ofNullable(clazz.cast(fragmentLength()));
        case "HbbtvCompliance":
            return Optional.ofNullable(clazz.cast(hbbtvComplianceAsString()));
        case "ImageBasedTrickPlay":
            return Optional.ofNullable(clazz.cast(imageBasedTrickPlayAsString()));
        case "ImageBasedTrickPlaySettings":
            return Optional.ofNullable(clazz.cast(imageBasedTrickPlaySettings()));
        case "MinBufferTime":
            return Optional.ofNullable(clazz.cast(minBufferTime()));
        case "MinFinalSegmentLength":
            return Optional.ofNullable(clazz.cast(minFinalSegmentLength()));
        case "MpdManifestBandwidthType":
            return Optional.ofNullable(clazz.cast(mpdManifestBandwidthTypeAsString()));
        case "MpdProfile":
            return Optional.ofNullable(clazz.cast(mpdProfileAsString()));
        case "PtsOffsetHandlingForBFrames":
            return Optional.ofNullable(clazz.cast(ptsOffsetHandlingForBFramesAsString()));
        case "SegmentControl":
            return Optional.ofNullable(clazz.cast(segmentControlAsString()));
        case "SegmentLength":
            return Optional.ofNullable(clazz.cast(segmentLength()));
        case "SegmentLengthControl":
            return Optional.ofNullable(clazz.cast(segmentLengthControlAsString()));
        case "VideoCompositionOffsets":
            return Optional.ofNullable(clazz.cast(videoCompositionOffsetsAsString()));
        case "WriteSegmentTimelineInRepresentation":
            return Optional.ofNullable(clazz.cast(writeSegmentTimelineInRepresentationAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DashIsoGroupSettings, T> g) {
        return obj -> g.apply((DashIsoGroupSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DashIsoGroupSettings> {
        /**
         * By default, the service creates one .mpd DASH manifest for each DASH ISO output group in your job. This
         * default manifest references every output in the output group. To create additional DASH manifests that
         * reference a subset of the outputs in the output group, specify a list of them here.
         * 
         * @param additionalManifests
         *        By default, the service creates one .mpd DASH manifest for each DASH ISO output group in your job.
         *        This default manifest references every output in the output group. To create additional DASH manifests
         *        that reference a subset of the outputs in the output group, specify a list of them here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalManifests(Collection<DashAdditionalManifest> additionalManifests);

        /**
         * By default, the service creates one .mpd DASH manifest for each DASH ISO output group in your job. This
         * default manifest references every output in the output group. To create additional DASH manifests that
         * reference a subset of the outputs in the output group, specify a list of them here.
         * 
         * @param additionalManifests
         *        By default, the service creates one .mpd DASH manifest for each DASH ISO output group in your job.
         *        This default manifest references every output in the output group. To create additional DASH manifests
         *        that reference a subset of the outputs in the output group, specify a list of them here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalManifests(DashAdditionalManifest... additionalManifests);

        /**
         * By default, the service creates one .mpd DASH manifest for each DASH ISO output group in your job. This
         * default manifest references every output in the output group. To create additional DASH manifests that
         * reference a subset of the outputs in the output group, specify a list of them here. This is a convenience
         * method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediaconvert.model.DashAdditionalManifest.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.mediaconvert.model.DashAdditionalManifest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediaconvert.model.DashAdditionalManifest.Builder#build()} is called
         * immediately and its result is passed to {@link #additionalManifests(List<DashAdditionalManifest>)}.
         * 
         * @param additionalManifests
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediaconvert.model.DashAdditionalManifest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #additionalManifests(java.util.Collection<DashAdditionalManifest>)
         */
        Builder additionalManifests(Consumer<DashAdditionalManifest.Builder>... additionalManifests);

        /**
         * Use this setting only when your audio codec is a Dolby one (AC3, EAC3, or Atmos) and your downstream workflow
         * requires that your DASH manifest use the Dolby channel configuration tag, rather than the MPEG one. For
         * example, you might need to use this to make dynamic ad insertion work. Specify which audio channel
         * configuration scheme ID URI MediaConvert writes in your DASH manifest. Keep the default value, MPEG channel
         * configuration, to have MediaConvert write this: urn:mpeg:mpegB:cicp:ChannelConfiguration. Choose Dolby
         * channel configuration to have MediaConvert write this instead:
         * tag:dolby.com,2014:dash:audio_channel_configuration:2011.
         * 
         * @param audioChannelConfigSchemeIdUri
         *        Use this setting only when your audio codec is a Dolby one (AC3, EAC3, or Atmos) and your downstream
         *        workflow requires that your DASH manifest use the Dolby channel configuration tag, rather than the
         *        MPEG one. For example, you might need to use this to make dynamic ad insertion work. Specify which
         *        audio channel configuration scheme ID URI MediaConvert writes in your DASH manifest. Keep the default
         *        value, MPEG channel configuration, to have MediaConvert write this:
         *        urn:mpeg:mpegB:cicp:ChannelConfiguration. Choose Dolby channel configuration to have MediaConvert
         *        write this instead: tag:dolby.com,2014:dash:audio_channel_configuration:2011.
         * @see DashIsoGroupAudioChannelConfigSchemeIdUri
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DashIsoGroupAudioChannelConfigSchemeIdUri
         */
        Builder audioChannelConfigSchemeIdUri(String audioChannelConfigSchemeIdUri);

        /**
         * Use this setting only when your audio codec is a Dolby one (AC3, EAC3, or Atmos) and your downstream workflow
         * requires that your DASH manifest use the Dolby channel configuration tag, rather than the MPEG one. For
         * example, you might need to use this to make dynamic ad insertion work. Specify which audio channel
         * configuration scheme ID URI MediaConvert writes in your DASH manifest. Keep the default value, MPEG channel
         * configuration, to have MediaConvert write this: urn:mpeg:mpegB:cicp:ChannelConfiguration. Choose Dolby
         * channel configuration to have MediaConvert write this instead:
         * tag:dolby.com,2014:dash:audio_channel_configuration:2011.
         * 
         * @param audioChannelConfigSchemeIdUri
         *        Use this setting only when your audio codec is a Dolby one (AC3, EAC3, or Atmos) and your downstream
         *        workflow requires that your DASH manifest use the Dolby channel configuration tag, rather than the
         *        MPEG one. For example, you might need to use this to make dynamic ad insertion work. Specify which
         *        audio channel configuration scheme ID URI MediaConvert writes in your DASH manifest. Keep the default
         *        value, MPEG channel configuration, to have MediaConvert write this:
         *        urn:mpeg:mpegB:cicp:ChannelConfiguration. Choose Dolby channel configuration to have MediaConvert
         *        write this instead: tag:dolby.com,2014:dash:audio_channel_configuration:2011.
         * @see DashIsoGroupAudioChannelConfigSchemeIdUri
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DashIsoGroupAudioChannelConfigSchemeIdUri
         */
        Builder audioChannelConfigSchemeIdUri(DashIsoGroupAudioChannelConfigSchemeIdUri audioChannelConfigSchemeIdUri);

        /**
         * A partial URI prefix that will be put in the manifest (.mpd) file at the top level BaseURL element. Can be
         * used if streams are delivered from a different URL than the manifest file.
         * 
         * @param baseUrl
         *        A partial URI prefix that will be put in the manifest (.mpd) file at the top level BaseURL element.
         *        Can be used if streams are delivered from a different URL than the manifest file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseUrl(String baseUrl);

        /**
         * Specify how MediaConvert writes SegmentTimeline in your output DASH manifest. To write a SegmentTimeline in
         * each video Representation: Keep the default value, Basic. To write a common SegmentTimeline in the video
         * AdaptationSet: Choose Compact. Note that MediaConvert will still write a SegmentTimeline in any
         * Representation that does not share a common timeline. To write a video AdaptationSet for each different
         * output framerate, and a common SegmentTimeline in each AdaptationSet: Choose Distinct.
         * 
         * @param dashManifestStyle
         *        Specify how MediaConvert writes SegmentTimeline in your output DASH manifest. To write a
         *        SegmentTimeline in each video Representation: Keep the default value, Basic. To write a common
         *        SegmentTimeline in the video AdaptationSet: Choose Compact. Note that MediaConvert will still write a
         *        SegmentTimeline in any Representation that does not share a common timeline. To write a video
         *        AdaptationSet for each different output framerate, and a common SegmentTimeline in each AdaptationSet:
         *        Choose Distinct.
         * @see DashManifestStyle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DashManifestStyle
         */
        Builder dashManifestStyle(String dashManifestStyle);

        /**
         * Specify how MediaConvert writes SegmentTimeline in your output DASH manifest. To write a SegmentTimeline in
         * each video Representation: Keep the default value, Basic. To write a common SegmentTimeline in the video
         * AdaptationSet: Choose Compact. Note that MediaConvert will still write a SegmentTimeline in any
         * Representation that does not share a common timeline. To write a video AdaptationSet for each different
         * output framerate, and a common SegmentTimeline in each AdaptationSet: Choose Distinct.
         * 
         * @param dashManifestStyle
         *        Specify how MediaConvert writes SegmentTimeline in your output DASH manifest. To write a
         *        SegmentTimeline in each video Representation: Keep the default value, Basic. To write a common
         *        SegmentTimeline in the video AdaptationSet: Choose Compact. Note that MediaConvert will still write a
         *        SegmentTimeline in any Representation that does not share a common timeline. To write a video
         *        AdaptationSet for each different output framerate, and a common SegmentTimeline in each AdaptationSet:
         *        Choose Distinct.
         * @see DashManifestStyle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DashManifestStyle
         */
        Builder dashManifestStyle(DashManifestStyle dashManifestStyle);

        /**
         * Use Destination to specify the S3 output location and the output filename base. Destination accepts format
         * identifiers. If you do not specify the base filename in the URI, the service will use the filename of the
         * input file. If your job has multiple inputs, the service uses the filename of the first input file.
         * 
         * @param destination
         *        Use Destination to specify the S3 output location and the output filename base. Destination accepts
         *        format identifiers. If you do not specify the base filename in the URI, the service will use the
         *        filename of the input file. If your job has multiple inputs, the service uses the filename of the
         *        first input file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(String destination);

        /**
         * Settings associated with the destination. Will vary based on the type of destination
         * 
         * @param destinationSettings
         *        Settings associated with the destination. Will vary based on the type of destination
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationSettings(DestinationSettings destinationSettings);

        /**
         * Settings associated with the destination. Will vary based on the type of destination This is a convenience
         * method that creates an instance of the {@link DestinationSettings.Builder} avoiding the need to create one
         * manually via {@link DestinationSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DestinationSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #destinationSettings(DestinationSettings)}.
         * 
         * @param destinationSettings
         *        a consumer that will call methods on {@link DestinationSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationSettings(DestinationSettings)
         */
        default Builder destinationSettings(Consumer<DestinationSettings.Builder> destinationSettings) {
            return destinationSettings(DestinationSettings.builder().applyMutation(destinationSettings).build());
        }

        /**
         * DRM settings.
         * 
         * @param encryption
         *        DRM settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryption(DashIsoEncryptionSettings encryption);

        /**
         * DRM settings. This is a convenience method that creates an instance of the
         * {@link DashIsoEncryptionSettings.Builder} avoiding the need to create one manually via
         * {@link DashIsoEncryptionSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DashIsoEncryptionSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #encryption(DashIsoEncryptionSettings)}.
         * 
         * @param encryption
         *        a consumer that will call methods on {@link DashIsoEncryptionSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryption(DashIsoEncryptionSettings)
         */
        default Builder encryption(Consumer<DashIsoEncryptionSettings.Builder> encryption) {
            return encryption(DashIsoEncryptionSettings.builder().applyMutation(encryption).build());
        }

        /**
         * Length of fragments to generate (in seconds). Fragment length must be compatible with GOP size and Framerate.
         * Note that fragments will end on the next keyframe after this number of seconds, so actual fragment length may
         * be longer. When Emit Single File is checked, the fragmentation is internal to a single output file and it
         * does not cause the creation of many output files as in other output types.
         * 
         * @param fragmentLength
         *        Length of fragments to generate (in seconds). Fragment length must be compatible with GOP size and
         *        Framerate. Note that fragments will end on the next keyframe after this number of seconds, so actual
         *        fragment length may be longer. When Emit Single File is checked, the fragmentation is internal to a
         *        single output file and it does not cause the creation of many output files as in other output types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fragmentLength(Integer fragmentLength);

        /**
         * Supports HbbTV specification as indicated
         * 
         * @param hbbtvCompliance
         *        Supports HbbTV specification as indicated
         * @see DashIsoHbbtvCompliance
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DashIsoHbbtvCompliance
         */
        Builder hbbtvCompliance(String hbbtvCompliance);

        /**
         * Supports HbbTV specification as indicated
         * 
         * @param hbbtvCompliance
         *        Supports HbbTV specification as indicated
         * @see DashIsoHbbtvCompliance
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DashIsoHbbtvCompliance
         */
        Builder hbbtvCompliance(DashIsoHbbtvCompliance hbbtvCompliance);

        /**
         * Specify whether MediaConvert generates images for trick play. Keep the default value, None, to not generate
         * any images. Choose Thumbnail to generate tiled thumbnails. Choose Thumbnail and full frame to generate tiled
         * thumbnails and full-resolution images of single frames. MediaConvert adds an entry in the .mpd manifest for
         * each set of images that you generate. A common application for these images is Roku trick mode. The
         * thumbnails and full-frame images that MediaConvert creates with this feature are compatible with this Roku
         * specification: https://developer.roku.com/docs/developer-program/media-playback/trick-mode/hls-and-dash.md
         * 
         * @param imageBasedTrickPlay
         *        Specify whether MediaConvert generates images for trick play. Keep the default value, None, to not
         *        generate any images. Choose Thumbnail to generate tiled thumbnails. Choose Thumbnail and full frame to
         *        generate tiled thumbnails and full-resolution images of single frames. MediaConvert adds an entry in
         *        the .mpd manifest for each set of images that you generate. A common application for these images is
         *        Roku trick mode. The thumbnails and full-frame images that MediaConvert creates with this feature are
         *        compatible with this Roku specification:
         *        https://developer.roku.com/docs/developer-program/media-playback/trick-mode/hls-and-dash.md
         * @see DashIsoImageBasedTrickPlay
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DashIsoImageBasedTrickPlay
         */
        Builder imageBasedTrickPlay(String imageBasedTrickPlay);

        /**
         * Specify whether MediaConvert generates images for trick play. Keep the default value, None, to not generate
         * any images. Choose Thumbnail to generate tiled thumbnails. Choose Thumbnail and full frame to generate tiled
         * thumbnails and full-resolution images of single frames. MediaConvert adds an entry in the .mpd manifest for
         * each set of images that you generate. A common application for these images is Roku trick mode. The
         * thumbnails and full-frame images that MediaConvert creates with this feature are compatible with this Roku
         * specification: https://developer.roku.com/docs/developer-program/media-playback/trick-mode/hls-and-dash.md
         * 
         * @param imageBasedTrickPlay
         *        Specify whether MediaConvert generates images for trick play. Keep the default value, None, to not
         *        generate any images. Choose Thumbnail to generate tiled thumbnails. Choose Thumbnail and full frame to
         *        generate tiled thumbnails and full-resolution images of single frames. MediaConvert adds an entry in
         *        the .mpd manifest for each set of images that you generate. A common application for these images is
         *        Roku trick mode. The thumbnails and full-frame images that MediaConvert creates with this feature are
         *        compatible with this Roku specification:
         *        https://developer.roku.com/docs/developer-program/media-playback/trick-mode/hls-and-dash.md
         * @see DashIsoImageBasedTrickPlay
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DashIsoImageBasedTrickPlay
         */
        Builder imageBasedTrickPlay(DashIsoImageBasedTrickPlay imageBasedTrickPlay);

        /**
         * Tile and thumbnail settings applicable when imageBasedTrickPlay is ADVANCED
         * 
         * @param imageBasedTrickPlaySettings
         *        Tile and thumbnail settings applicable when imageBasedTrickPlay is ADVANCED
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageBasedTrickPlaySettings(DashIsoImageBasedTrickPlaySettings imageBasedTrickPlaySettings);

        /**
         * Tile and thumbnail settings applicable when imageBasedTrickPlay is ADVANCED This is a convenience method that
         * creates an instance of the {@link DashIsoImageBasedTrickPlaySettings.Builder} avoiding the need to create one
         * manually via {@link DashIsoImageBasedTrickPlaySettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DashIsoImageBasedTrickPlaySettings.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #imageBasedTrickPlaySettings(DashIsoImageBasedTrickPlaySettings)}.
         * 
         * @param imageBasedTrickPlaySettings
         *        a consumer that will call methods on {@link DashIsoImageBasedTrickPlaySettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageBasedTrickPlaySettings(DashIsoImageBasedTrickPlaySettings)
         */
        default Builder imageBasedTrickPlaySettings(
                Consumer<DashIsoImageBasedTrickPlaySettings.Builder> imageBasedTrickPlaySettings) {
            return imageBasedTrickPlaySettings(DashIsoImageBasedTrickPlaySettings.builder()
                    .applyMutation(imageBasedTrickPlaySettings).build());
        }

        /**
         * Minimum time of initially buffered media that is needed to ensure smooth playout.
         * 
         * @param minBufferTime
         *        Minimum time of initially buffered media that is needed to ensure smooth playout.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minBufferTime(Integer minBufferTime);

        /**
         * Keep this setting at the default value of 0, unless you are troubleshooting a problem with how devices play
         * back the end of your video asset. If you know that player devices are hanging on the final segment of your
         * video because the length of your final segment is too short, use this setting to specify a minimum final
         * segment length, in seconds. Choose a value that is greater than or equal to 1 and less than your segment
         * length. When you specify a value for this setting, the encoder will combine any final segment that is shorter
         * than the length that you specify with the previous segment. For example, your segment length is 3 seconds and
         * your final segment is .5 seconds without a minimum final segment length; when you set the minimum final
         * segment length to 1, your final segment is 3.5 seconds.
         * 
         * @param minFinalSegmentLength
         *        Keep this setting at the default value of 0, unless you are troubleshooting a problem with how devices
         *        play back the end of your video asset. If you know that player devices are hanging on the final
         *        segment of your video because the length of your final segment is too short, use this setting to
         *        specify a minimum final segment length, in seconds. Choose a value that is greater than or equal to 1
         *        and less than your segment length. When you specify a value for this setting, the encoder will combine
         *        any final segment that is shorter than the length that you specify with the previous segment. For
         *        example, your segment length is 3 seconds and your final segment is .5 seconds without a minimum final
         *        segment length; when you set the minimum final segment length to 1, your final segment is 3.5 seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minFinalSegmentLength(Double minFinalSegmentLength);

        /**
         * Specify how the value for bandwidth is determined for each video Representation in your output MPD manifest.
         * We recommend that you choose a MPD manifest bandwidth type that is compatible with your downstream player
         * configuration. Max: Use the same value that you specify for Max bitrate in the video output, in bits per
         * second. Average: Use the calculated average bitrate of the encoded video output, in bits per second.
         * 
         * @param mpdManifestBandwidthType
         *        Specify how the value for bandwidth is determined for each video Representation in your output MPD
         *        manifest. We recommend that you choose a MPD manifest bandwidth type that is compatible with your
         *        downstream player configuration. Max: Use the same value that you specify for Max bitrate in the video
         *        output, in bits per second. Average: Use the calculated average bitrate of the encoded video output,
         *        in bits per second.
         * @see DashIsoMpdManifestBandwidthType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DashIsoMpdManifestBandwidthType
         */
        Builder mpdManifestBandwidthType(String mpdManifestBandwidthType);

        /**
         * Specify how the value for bandwidth is determined for each video Representation in your output MPD manifest.
         * We recommend that you choose a MPD manifest bandwidth type that is compatible with your downstream player
         * configuration. Max: Use the same value that you specify for Max bitrate in the video output, in bits per
         * second. Average: Use the calculated average bitrate of the encoded video output, in bits per second.
         * 
         * @param mpdManifestBandwidthType
         *        Specify how the value for bandwidth is determined for each video Representation in your output MPD
         *        manifest. We recommend that you choose a MPD manifest bandwidth type that is compatible with your
         *        downstream player configuration. Max: Use the same value that you specify for Max bitrate in the video
         *        output, in bits per second. Average: Use the calculated average bitrate of the encoded video output,
         *        in bits per second.
         * @see DashIsoMpdManifestBandwidthType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DashIsoMpdManifestBandwidthType
         */
        Builder mpdManifestBandwidthType(DashIsoMpdManifestBandwidthType mpdManifestBandwidthType);

        /**
         * Specify whether your DASH profile is on-demand or main. When you choose Main profile, the service signals
         * urn:mpeg:dash:profile:isoff-main:2011 in your .mpd DASH manifest. When you choose On-demand, the service
         * signals urn:mpeg:dash:profile:isoff-on-demand:2011 in your .mpd. When you choose On-demand, you must also set
         * the output group setting Segment control to Single file.
         * 
         * @param mpdProfile
         *        Specify whether your DASH profile is on-demand or main. When you choose Main profile, the service
         *        signals urn:mpeg:dash:profile:isoff-main:2011 in your .mpd DASH manifest. When you choose On-demand,
         *        the service signals urn:mpeg:dash:profile:isoff-on-demand:2011 in your .mpd. When you choose
         *        On-demand, you must also set the output group setting Segment control to Single file.
         * @see DashIsoMpdProfile
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DashIsoMpdProfile
         */
        Builder mpdProfile(String mpdProfile);

        /**
         * Specify whether your DASH profile is on-demand or main. When you choose Main profile, the service signals
         * urn:mpeg:dash:profile:isoff-main:2011 in your .mpd DASH manifest. When you choose On-demand, the service
         * signals urn:mpeg:dash:profile:isoff-on-demand:2011 in your .mpd. When you choose On-demand, you must also set
         * the output group setting Segment control to Single file.
         * 
         * @param mpdProfile
         *        Specify whether your DASH profile is on-demand or main. When you choose Main profile, the service
         *        signals urn:mpeg:dash:profile:isoff-main:2011 in your .mpd DASH manifest. When you choose On-demand,
         *        the service signals urn:mpeg:dash:profile:isoff-on-demand:2011 in your .mpd. When you choose
         *        On-demand, you must also set the output group setting Segment control to Single file.
         * @see DashIsoMpdProfile
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DashIsoMpdProfile
         */
        Builder mpdProfile(DashIsoMpdProfile mpdProfile);

        /**
         * Use this setting only when your output video stream has B-frames, which causes the initial presentation time
         * stamp (PTS) to be offset from the initial decode time stamp (DTS). Specify how MediaConvert handles PTS when
         * writing time stamps in output DASH manifests. Choose Match initial PTS when you want MediaConvert to use the
         * initial PTS as the first time stamp in the manifest. Choose Zero-based to have MediaConvert ignore the
         * initial PTS in the video stream and instead write the initial time stamp as zero in the manifest. For outputs
         * that don't have B-frames, the time stamps in your DASH manifests start at zero regardless of your choice
         * here.
         * 
         * @param ptsOffsetHandlingForBFrames
         *        Use this setting only when your output video stream has B-frames, which causes the initial
         *        presentation time stamp (PTS) to be offset from the initial decode time stamp (DTS). Specify how
         *        MediaConvert handles PTS when writing time stamps in output DASH manifests. Choose Match initial PTS
         *        when you want MediaConvert to use the initial PTS as the first time stamp in the manifest. Choose
         *        Zero-based to have MediaConvert ignore the initial PTS in the video stream and instead write the
         *        initial time stamp as zero in the manifest. For outputs that don't have B-frames, the time stamps in
         *        your DASH manifests start at zero regardless of your choice here.
         * @see DashIsoPtsOffsetHandlingForBFrames
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DashIsoPtsOffsetHandlingForBFrames
         */
        Builder ptsOffsetHandlingForBFrames(String ptsOffsetHandlingForBFrames);

        /**
         * Use this setting only when your output video stream has B-frames, which causes the initial presentation time
         * stamp (PTS) to be offset from the initial decode time stamp (DTS). Specify how MediaConvert handles PTS when
         * writing time stamps in output DASH manifests. Choose Match initial PTS when you want MediaConvert to use the
         * initial PTS as the first time stamp in the manifest. Choose Zero-based to have MediaConvert ignore the
         * initial PTS in the video stream and instead write the initial time stamp as zero in the manifest. For outputs
         * that don't have B-frames, the time stamps in your DASH manifests start at zero regardless of your choice
         * here.
         * 
         * @param ptsOffsetHandlingForBFrames
         *        Use this setting only when your output video stream has B-frames, which causes the initial
         *        presentation time stamp (PTS) to be offset from the initial decode time stamp (DTS). Specify how
         *        MediaConvert handles PTS when writing time stamps in output DASH manifests. Choose Match initial PTS
         *        when you want MediaConvert to use the initial PTS as the first time stamp in the manifest. Choose
         *        Zero-based to have MediaConvert ignore the initial PTS in the video stream and instead write the
         *        initial time stamp as zero in the manifest. For outputs that don't have B-frames, the time stamps in
         *        your DASH manifests start at zero regardless of your choice here.
         * @see DashIsoPtsOffsetHandlingForBFrames
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DashIsoPtsOffsetHandlingForBFrames
         */
        Builder ptsOffsetHandlingForBFrames(DashIsoPtsOffsetHandlingForBFrames ptsOffsetHandlingForBFrames);

        /**
         * When set to SINGLE_FILE, a single output file is generated, which is internally segmented using the Fragment
         * Length and Segment Length. When set to SEGMENTED_FILES, separate segment files will be created.
         * 
         * @param segmentControl
         *        When set to SINGLE_FILE, a single output file is generated, which is internally segmented using the
         *        Fragment Length and Segment Length. When set to SEGMENTED_FILES, separate segment files will be
         *        created.
         * @see DashIsoSegmentControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DashIsoSegmentControl
         */
        Builder segmentControl(String segmentControl);

        /**
         * When set to SINGLE_FILE, a single output file is generated, which is internally segmented using the Fragment
         * Length and Segment Length. When set to SEGMENTED_FILES, separate segment files will be created.
         * 
         * @param segmentControl
         *        When set to SINGLE_FILE, a single output file is generated, which is internally segmented using the
         *        Fragment Length and Segment Length. When set to SEGMENTED_FILES, separate segment files will be
         *        created.
         * @see DashIsoSegmentControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DashIsoSegmentControl
         */
        Builder segmentControl(DashIsoSegmentControl segmentControl);

        /**
         * Specify the length, in whole seconds, of each segment. When you don't specify a value, MediaConvert defaults
         * to 30. Related settings: Use Segment length control to specify whether the encoder enforces this value
         * strictly. Use Segment control to specify whether MediaConvert creates separate segment files or one content
         * file that has metadata to mark the segment boundaries.
         * 
         * @param segmentLength
         *        Specify the length, in whole seconds, of each segment. When you don't specify a value, MediaConvert
         *        defaults to 30. Related settings: Use Segment length control to specify whether the encoder enforces
         *        this value strictly. Use Segment control to specify whether MediaConvert creates separate segment
         *        files or one content file that has metadata to mark the segment boundaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentLength(Integer segmentLength);

        /**
         * Specify how you want MediaConvert to determine the segment length. Choose Exact to have the encoder use the
         * exact length that you specify with the setting Segment length. This might result in extra I-frames. Choose
         * Multiple of GOP to have the encoder round up the segment lengths to match the next GOP boundary.
         * 
         * @param segmentLengthControl
         *        Specify how you want MediaConvert to determine the segment length. Choose Exact to have the encoder
         *        use the exact length that you specify with the setting Segment length. This might result in extra
         *        I-frames. Choose Multiple of GOP to have the encoder round up the segment lengths to match the next
         *        GOP boundary.
         * @see DashIsoSegmentLengthControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DashIsoSegmentLengthControl
         */
        Builder segmentLengthControl(String segmentLengthControl);

        /**
         * Specify how you want MediaConvert to determine the segment length. Choose Exact to have the encoder use the
         * exact length that you specify with the setting Segment length. This might result in extra I-frames. Choose
         * Multiple of GOP to have the encoder round up the segment lengths to match the next GOP boundary.
         * 
         * @param segmentLengthControl
         *        Specify how you want MediaConvert to determine the segment length. Choose Exact to have the encoder
         *        use the exact length that you specify with the setting Segment length. This might result in extra
         *        I-frames. Choose Multiple of GOP to have the encoder round up the segment lengths to match the next
         *        GOP boundary.
         * @see DashIsoSegmentLengthControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DashIsoSegmentLengthControl
         */
        Builder segmentLengthControl(DashIsoSegmentLengthControl segmentLengthControl);

        /**
         * Specify the video sample composition time offset mode in the output fMP4 TRUN box. For wider player
         * compatibility, set Video composition offsets to Unsigned or leave blank. The earliest presentation time may
         * be greater than zero, and sample composition time offsets will increment using unsigned integers. For strict
         * fMP4 video and audio timing, set Video composition offsets to Signed. The earliest presentation time will be
         * equal to zero, and sample composition time offsets will increment using signed integers.
         * 
         * @param videoCompositionOffsets
         *        Specify the video sample composition time offset mode in the output fMP4 TRUN box. For wider player
         *        compatibility, set Video composition offsets to Unsigned or leave blank. The earliest presentation
         *        time may be greater than zero, and sample composition time offsets will increment using unsigned
         *        integers. For strict fMP4 video and audio timing, set Video composition offsets to Signed. The
         *        earliest presentation time will be equal to zero, and sample composition time offsets will increment
         *        using signed integers.
         * @see DashIsoVideoCompositionOffsets
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DashIsoVideoCompositionOffsets
         */
        Builder videoCompositionOffsets(String videoCompositionOffsets);

        /**
         * Specify the video sample composition time offset mode in the output fMP4 TRUN box. For wider player
         * compatibility, set Video composition offsets to Unsigned or leave blank. The earliest presentation time may
         * be greater than zero, and sample composition time offsets will increment using unsigned integers. For strict
         * fMP4 video and audio timing, set Video composition offsets to Signed. The earliest presentation time will be
         * equal to zero, and sample composition time offsets will increment using signed integers.
         * 
         * @param videoCompositionOffsets
         *        Specify the video sample composition time offset mode in the output fMP4 TRUN box. For wider player
         *        compatibility, set Video composition offsets to Unsigned or leave blank. The earliest presentation
         *        time may be greater than zero, and sample composition time offsets will increment using unsigned
         *        integers. For strict fMP4 video and audio timing, set Video composition offsets to Signed. The
         *        earliest presentation time will be equal to zero, and sample composition time offsets will increment
         *        using signed integers.
         * @see DashIsoVideoCompositionOffsets
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DashIsoVideoCompositionOffsets
         */
        Builder videoCompositionOffsets(DashIsoVideoCompositionOffsets videoCompositionOffsets);

        /**
         * If you get an HTTP error in the 400 range when you play back your DASH output, enable this setting and run
         * your transcoding job again. When you enable this setting, the service writes precise segment durations in the
         * DASH manifest. The segment duration information appears inside the SegmentTimeline element, inside
         * SegmentTemplate at the Representation level. When you don't enable this setting, the service writes
         * approximate segment durations in your DASH manifest.
         * 
         * @param writeSegmentTimelineInRepresentation
         *        If you get an HTTP error in the 400 range when you play back your DASH output, enable this setting and
         *        run your transcoding job again. When you enable this setting, the service writes precise segment
         *        durations in the DASH manifest. The segment duration information appears inside the SegmentTimeline
         *        element, inside SegmentTemplate at the Representation level. When you don't enable this setting, the
         *        service writes approximate segment durations in your DASH manifest.
         * @see DashIsoWriteSegmentTimelineInRepresentation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DashIsoWriteSegmentTimelineInRepresentation
         */
        Builder writeSegmentTimelineInRepresentation(String writeSegmentTimelineInRepresentation);

        /**
         * If you get an HTTP error in the 400 range when you play back your DASH output, enable this setting and run
         * your transcoding job again. When you enable this setting, the service writes precise segment durations in the
         * DASH manifest. The segment duration information appears inside the SegmentTimeline element, inside
         * SegmentTemplate at the Representation level. When you don't enable this setting, the service writes
         * approximate segment durations in your DASH manifest.
         * 
         * @param writeSegmentTimelineInRepresentation
         *        If you get an HTTP error in the 400 range when you play back your DASH output, enable this setting and
         *        run your transcoding job again. When you enable this setting, the service writes precise segment
         *        durations in the DASH manifest. The segment duration information appears inside the SegmentTimeline
         *        element, inside SegmentTemplate at the Representation level. When you don't enable this setting, the
         *        service writes approximate segment durations in your DASH manifest.
         * @see DashIsoWriteSegmentTimelineInRepresentation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DashIsoWriteSegmentTimelineInRepresentation
         */
        Builder writeSegmentTimelineInRepresentation(
                DashIsoWriteSegmentTimelineInRepresentation writeSegmentTimelineInRepresentation);
    }

    static final class BuilderImpl implements Builder {
        private List<DashAdditionalManifest> additionalManifests = DefaultSdkAutoConstructList.getInstance();

        private String audioChannelConfigSchemeIdUri;

        private String baseUrl;

        private String dashManifestStyle;

        private String destination;

        private DestinationSettings destinationSettings;

        private DashIsoEncryptionSettings encryption;

        private Integer fragmentLength;

        private String hbbtvCompliance;

        private String imageBasedTrickPlay;

        private DashIsoImageBasedTrickPlaySettings imageBasedTrickPlaySettings;

        private Integer minBufferTime;

        private Double minFinalSegmentLength;

        private String mpdManifestBandwidthType;

        private String mpdProfile;

        private String ptsOffsetHandlingForBFrames;

        private String segmentControl;

        private Integer segmentLength;

        private String segmentLengthControl;

        private String videoCompositionOffsets;

        private String writeSegmentTimelineInRepresentation;

        private BuilderImpl() {
        }

        private BuilderImpl(DashIsoGroupSettings model) {
            additionalManifests(model.additionalManifests);
            audioChannelConfigSchemeIdUri(model.audioChannelConfigSchemeIdUri);
            baseUrl(model.baseUrl);
            dashManifestStyle(model.dashManifestStyle);
            destination(model.destination);
            destinationSettings(model.destinationSettings);
            encryption(model.encryption);
            fragmentLength(model.fragmentLength);
            hbbtvCompliance(model.hbbtvCompliance);
            imageBasedTrickPlay(model.imageBasedTrickPlay);
            imageBasedTrickPlaySettings(model.imageBasedTrickPlaySettings);
            minBufferTime(model.minBufferTime);
            minFinalSegmentLength(model.minFinalSegmentLength);
            mpdManifestBandwidthType(model.mpdManifestBandwidthType);
            mpdProfile(model.mpdProfile);
            ptsOffsetHandlingForBFrames(model.ptsOffsetHandlingForBFrames);
            segmentControl(model.segmentControl);
            segmentLength(model.segmentLength);
            segmentLengthControl(model.segmentLengthControl);
            videoCompositionOffsets(model.videoCompositionOffsets);
            writeSegmentTimelineInRepresentation(model.writeSegmentTimelineInRepresentation);
        }

        public final List<DashAdditionalManifest.Builder> getAdditionalManifests() {
            List<DashAdditionalManifest.Builder> result = ___listOfDashAdditionalManifestCopier
                    .copyToBuilder(this.additionalManifests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdditionalManifests(Collection<DashAdditionalManifest.BuilderImpl> additionalManifests) {
            this.additionalManifests = ___listOfDashAdditionalManifestCopier.copyFromBuilder(additionalManifests);
        }

        @Override
        public final Builder additionalManifests(Collection<DashAdditionalManifest> additionalManifests) {
            this.additionalManifests = ___listOfDashAdditionalManifestCopier.copy(additionalManifests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalManifests(DashAdditionalManifest... additionalManifests) {
            additionalManifests(Arrays.asList(additionalManifests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalManifests(Consumer<DashAdditionalManifest.Builder>... additionalManifests) {
            additionalManifests(Stream.of(additionalManifests)
                    .map(c -> DashAdditionalManifest.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAudioChannelConfigSchemeIdUri() {
            return audioChannelConfigSchemeIdUri;
        }

        public final void setAudioChannelConfigSchemeIdUri(String audioChannelConfigSchemeIdUri) {
            this.audioChannelConfigSchemeIdUri = audioChannelConfigSchemeIdUri;
        }

        @Override
        public final Builder audioChannelConfigSchemeIdUri(String audioChannelConfigSchemeIdUri) {
            this.audioChannelConfigSchemeIdUri = audioChannelConfigSchemeIdUri;
            return this;
        }

        @Override
        public final Builder audioChannelConfigSchemeIdUri(DashIsoGroupAudioChannelConfigSchemeIdUri audioChannelConfigSchemeIdUri) {
            this.audioChannelConfigSchemeIdUri(audioChannelConfigSchemeIdUri == null ? null : audioChannelConfigSchemeIdUri
                    .toString());
            return this;
        }

        public final String getBaseUrl() {
            return baseUrl;
        }

        public final void setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
        }

        @Override
        public final Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public final String getDashManifestStyle() {
            return dashManifestStyle;
        }

        public final void setDashManifestStyle(String dashManifestStyle) {
            this.dashManifestStyle = dashManifestStyle;
        }

        @Override
        public final Builder dashManifestStyle(String dashManifestStyle) {
            this.dashManifestStyle = dashManifestStyle;
            return this;
        }

        @Override
        public final Builder dashManifestStyle(DashManifestStyle dashManifestStyle) {
            this.dashManifestStyle(dashManifestStyle == null ? null : dashManifestStyle.toString());
            return this;
        }

        public final String getDestination() {
            return destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final DestinationSettings.Builder getDestinationSettings() {
            return destinationSettings != null ? destinationSettings.toBuilder() : null;
        }

        public final void setDestinationSettings(DestinationSettings.BuilderImpl destinationSettings) {
            this.destinationSettings = destinationSettings != null ? destinationSettings.build() : null;
        }

        @Override
        public final Builder destinationSettings(DestinationSettings destinationSettings) {
            this.destinationSettings = destinationSettings;
            return this;
        }

        public final DashIsoEncryptionSettings.Builder getEncryption() {
            return encryption != null ? encryption.toBuilder() : null;
        }

        public final void setEncryption(DashIsoEncryptionSettings.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        @Override
        public final Builder encryption(DashIsoEncryptionSettings encryption) {
            this.encryption = encryption;
            return this;
        }

        public final Integer getFragmentLength() {
            return fragmentLength;
        }

        public final void setFragmentLength(Integer fragmentLength) {
            this.fragmentLength = fragmentLength;
        }

        @Override
        public final Builder fragmentLength(Integer fragmentLength) {
            this.fragmentLength = fragmentLength;
            return this;
        }

        public final String getHbbtvCompliance() {
            return hbbtvCompliance;
        }

        public final void setHbbtvCompliance(String hbbtvCompliance) {
            this.hbbtvCompliance = hbbtvCompliance;
        }

        @Override
        public final Builder hbbtvCompliance(String hbbtvCompliance) {
            this.hbbtvCompliance = hbbtvCompliance;
            return this;
        }

        @Override
        public final Builder hbbtvCompliance(DashIsoHbbtvCompliance hbbtvCompliance) {
            this.hbbtvCompliance(hbbtvCompliance == null ? null : hbbtvCompliance.toString());
            return this;
        }

        public final String getImageBasedTrickPlay() {
            return imageBasedTrickPlay;
        }

        public final void setImageBasedTrickPlay(String imageBasedTrickPlay) {
            this.imageBasedTrickPlay = imageBasedTrickPlay;
        }

        @Override
        public final Builder imageBasedTrickPlay(String imageBasedTrickPlay) {
            this.imageBasedTrickPlay = imageBasedTrickPlay;
            return this;
        }

        @Override
        public final Builder imageBasedTrickPlay(DashIsoImageBasedTrickPlay imageBasedTrickPlay) {
            this.imageBasedTrickPlay(imageBasedTrickPlay == null ? null : imageBasedTrickPlay.toString());
            return this;
        }

        public final DashIsoImageBasedTrickPlaySettings.Builder getImageBasedTrickPlaySettings() {
            return imageBasedTrickPlaySettings != null ? imageBasedTrickPlaySettings.toBuilder() : null;
        }

        public final void setImageBasedTrickPlaySettings(
                DashIsoImageBasedTrickPlaySettings.BuilderImpl imageBasedTrickPlaySettings) {
            this.imageBasedTrickPlaySettings = imageBasedTrickPlaySettings != null ? imageBasedTrickPlaySettings.build() : null;
        }

        @Override
        public final Builder imageBasedTrickPlaySettings(DashIsoImageBasedTrickPlaySettings imageBasedTrickPlaySettings) {
            this.imageBasedTrickPlaySettings = imageBasedTrickPlaySettings;
            return this;
        }

        public final Integer getMinBufferTime() {
            return minBufferTime;
        }

        public final void setMinBufferTime(Integer minBufferTime) {
            this.minBufferTime = minBufferTime;
        }

        @Override
        public final Builder minBufferTime(Integer minBufferTime) {
            this.minBufferTime = minBufferTime;
            return this;
        }

        public final Double getMinFinalSegmentLength() {
            return minFinalSegmentLength;
        }

        public final void setMinFinalSegmentLength(Double minFinalSegmentLength) {
            this.minFinalSegmentLength = minFinalSegmentLength;
        }

        @Override
        public final Builder minFinalSegmentLength(Double minFinalSegmentLength) {
            this.minFinalSegmentLength = minFinalSegmentLength;
            return this;
        }

        public final String getMpdManifestBandwidthType() {
            return mpdManifestBandwidthType;
        }

        public final void setMpdManifestBandwidthType(String mpdManifestBandwidthType) {
            this.mpdManifestBandwidthType = mpdManifestBandwidthType;
        }

        @Override
        public final Builder mpdManifestBandwidthType(String mpdManifestBandwidthType) {
            this.mpdManifestBandwidthType = mpdManifestBandwidthType;
            return this;
        }

        @Override
        public final Builder mpdManifestBandwidthType(DashIsoMpdManifestBandwidthType mpdManifestBandwidthType) {
            this.mpdManifestBandwidthType(mpdManifestBandwidthType == null ? null : mpdManifestBandwidthType.toString());
            return this;
        }

        public final String getMpdProfile() {
            return mpdProfile;
        }

        public final void setMpdProfile(String mpdProfile) {
            this.mpdProfile = mpdProfile;
        }

        @Override
        public final Builder mpdProfile(String mpdProfile) {
            this.mpdProfile = mpdProfile;
            return this;
        }

        @Override
        public final Builder mpdProfile(DashIsoMpdProfile mpdProfile) {
            this.mpdProfile(mpdProfile == null ? null : mpdProfile.toString());
            return this;
        }

        public final String getPtsOffsetHandlingForBFrames() {
            return ptsOffsetHandlingForBFrames;
        }

        public final void setPtsOffsetHandlingForBFrames(String ptsOffsetHandlingForBFrames) {
            this.ptsOffsetHandlingForBFrames = ptsOffsetHandlingForBFrames;
        }

        @Override
        public final Builder ptsOffsetHandlingForBFrames(String ptsOffsetHandlingForBFrames) {
            this.ptsOffsetHandlingForBFrames = ptsOffsetHandlingForBFrames;
            return this;
        }

        @Override
        public final Builder ptsOffsetHandlingForBFrames(DashIsoPtsOffsetHandlingForBFrames ptsOffsetHandlingForBFrames) {
            this.ptsOffsetHandlingForBFrames(ptsOffsetHandlingForBFrames == null ? null : ptsOffsetHandlingForBFrames.toString());
            return this;
        }

        public final String getSegmentControl() {
            return segmentControl;
        }

        public final void setSegmentControl(String segmentControl) {
            this.segmentControl = segmentControl;
        }

        @Override
        public final Builder segmentControl(String segmentControl) {
            this.segmentControl = segmentControl;
            return this;
        }

        @Override
        public final Builder segmentControl(DashIsoSegmentControl segmentControl) {
            this.segmentControl(segmentControl == null ? null : segmentControl.toString());
            return this;
        }

        public final Integer getSegmentLength() {
            return segmentLength;
        }

        public final void setSegmentLength(Integer segmentLength) {
            this.segmentLength = segmentLength;
        }

        @Override
        public final Builder segmentLength(Integer segmentLength) {
            this.segmentLength = segmentLength;
            return this;
        }

        public final String getSegmentLengthControl() {
            return segmentLengthControl;
        }

        public final void setSegmentLengthControl(String segmentLengthControl) {
            this.segmentLengthControl = segmentLengthControl;
        }

        @Override
        public final Builder segmentLengthControl(String segmentLengthControl) {
            this.segmentLengthControl = segmentLengthControl;
            return this;
        }

        @Override
        public final Builder segmentLengthControl(DashIsoSegmentLengthControl segmentLengthControl) {
            this.segmentLengthControl(segmentLengthControl == null ? null : segmentLengthControl.toString());
            return this;
        }

        public final String getVideoCompositionOffsets() {
            return videoCompositionOffsets;
        }

        public final void setVideoCompositionOffsets(String videoCompositionOffsets) {
            this.videoCompositionOffsets = videoCompositionOffsets;
        }

        @Override
        public final Builder videoCompositionOffsets(String videoCompositionOffsets) {
            this.videoCompositionOffsets = videoCompositionOffsets;
            return this;
        }

        @Override
        public final Builder videoCompositionOffsets(DashIsoVideoCompositionOffsets videoCompositionOffsets) {
            this.videoCompositionOffsets(videoCompositionOffsets == null ? null : videoCompositionOffsets.toString());
            return this;
        }

        public final String getWriteSegmentTimelineInRepresentation() {
            return writeSegmentTimelineInRepresentation;
        }

        public final void setWriteSegmentTimelineInRepresentation(String writeSegmentTimelineInRepresentation) {
            this.writeSegmentTimelineInRepresentation = writeSegmentTimelineInRepresentation;
        }

        @Override
        public final Builder writeSegmentTimelineInRepresentation(String writeSegmentTimelineInRepresentation) {
            this.writeSegmentTimelineInRepresentation = writeSegmentTimelineInRepresentation;
            return this;
        }

        @Override
        public final Builder writeSegmentTimelineInRepresentation(
                DashIsoWriteSegmentTimelineInRepresentation writeSegmentTimelineInRepresentation) {
            this.writeSegmentTimelineInRepresentation(writeSegmentTimelineInRepresentation == null ? null
                    : writeSegmentTimelineInRepresentation.toString());
            return this;
        }

        @Override
        public DashIsoGroupSettings build() {
            return new DashIsoGroupSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
