/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Choose Insert for this setting to include color metadata in this output. Choose Ignore to exclude color metadata from
 * this output. If you don't specify a value, the service sets this to Insert by default.
 */
@Generated("software.amazon.awssdk:codegen")
public enum ColorMetadata {
    IGNORE("IGNORE"),

    INSERT("INSERT"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ColorMetadata> VALUE_MAP = EnumUtils.uniqueIndex(ColorMetadata.class,
            ColorMetadata::toString);

    private final String value;

    private ColorMetadata(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return ColorMetadata corresponding to the value
     */
    public static ColorMetadata fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link ColorMetadata}s
     */
    public static Set<ColorMetadata> knownValues() {
        Set<ColorMetadata> knownValues = EnumSet.allOf(ColorMetadata.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
