/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Optional settings for Advanced input filter when you set Advanced input filter to Enabled.
 */
@Generated("software.amazon.awssdk:codegen")
public final class AdvancedInputFilterSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<AdvancedInputFilterSettings.Builder, AdvancedInputFilterSettings> {
    private static final SdkField<String> ADD_TEXTURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AddTexture").getter(getter(AdvancedInputFilterSettings::addTextureAsString))
            .setter(setter(Builder::addTexture))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addTexture").build()).build();

    private static final SdkField<String> SHARPENING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Sharpening").getter(getter(AdvancedInputFilterSettings::sharpeningAsString))
            .setter(setter(Builder::sharpening))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sharpening").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADD_TEXTURE_FIELD,
            SHARPENING_FIELD));

    private static final long serialVersionUID = 1L;

    private final String addTexture;

    private final String sharpening;

    private AdvancedInputFilterSettings(BuilderImpl builder) {
        this.addTexture = builder.addTexture;
        this.sharpening = builder.sharpening;
    }

    /**
     * Add texture and detail to areas of your input video content that were lost after applying the Advanced input
     * filter. To adaptively add texture and reduce softness: Choose Enabled. To not add any texture: Keep the default
     * value, Disabled. We recommend that you choose Disabled for input video content that doesn't have texture,
     * including screen recordings, computer graphics, or cartoons.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #addTexture} will
     * return {@link AdvancedInputFilterAddTexture#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #addTextureAsString}.
     * </p>
     * 
     * @return Add texture and detail to areas of your input video content that were lost after applying the Advanced
     *         input filter. To adaptively add texture and reduce softness: Choose Enabled. To not add any texture: Keep
     *         the default value, Disabled. We recommend that you choose Disabled for input video content that doesn't
     *         have texture, including screen recordings, computer graphics, or cartoons.
     * @see AdvancedInputFilterAddTexture
     */
    public final AdvancedInputFilterAddTexture addTexture() {
        return AdvancedInputFilterAddTexture.fromValue(addTexture);
    }

    /**
     * Add texture and detail to areas of your input video content that were lost after applying the Advanced input
     * filter. To adaptively add texture and reduce softness: Choose Enabled. To not add any texture: Keep the default
     * value, Disabled. We recommend that you choose Disabled for input video content that doesn't have texture,
     * including screen recordings, computer graphics, or cartoons.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #addTexture} will
     * return {@link AdvancedInputFilterAddTexture#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #addTextureAsString}.
     * </p>
     * 
     * @return Add texture and detail to areas of your input video content that were lost after applying the Advanced
     *         input filter. To adaptively add texture and reduce softness: Choose Enabled. To not add any texture: Keep
     *         the default value, Disabled. We recommend that you choose Disabled for input video content that doesn't
     *         have texture, including screen recordings, computer graphics, or cartoons.
     * @see AdvancedInputFilterAddTexture
     */
    public final String addTextureAsString() {
        return addTexture;
    }

    /**
     * Optionally specify the amount of sharpening to apply when you use the Advanced input filter. Sharpening adds
     * contrast to the edges of your video content and can reduce softness. To apply no sharpening: Keep the default
     * value, Off. To apply a minimal amount of sharpening choose Low, or for the maximum choose High.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sharpening} will
     * return {@link AdvancedInputFilterSharpen#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sharpeningAsString}.
     * </p>
     * 
     * @return Optionally specify the amount of sharpening to apply when you use the Advanced input filter. Sharpening
     *         adds contrast to the edges of your video content and can reduce softness. To apply no sharpening: Keep
     *         the default value, Off. To apply a minimal amount of sharpening choose Low, or for the maximum choose
     *         High.
     * @see AdvancedInputFilterSharpen
     */
    public final AdvancedInputFilterSharpen sharpening() {
        return AdvancedInputFilterSharpen.fromValue(sharpening);
    }

    /**
     * Optionally specify the amount of sharpening to apply when you use the Advanced input filter. Sharpening adds
     * contrast to the edges of your video content and can reduce softness. To apply no sharpening: Keep the default
     * value, Off. To apply a minimal amount of sharpening choose Low, or for the maximum choose High.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sharpening} will
     * return {@link AdvancedInputFilterSharpen#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sharpeningAsString}.
     * </p>
     * 
     * @return Optionally specify the amount of sharpening to apply when you use the Advanced input filter. Sharpening
     *         adds contrast to the edges of your video content and can reduce softness. To apply no sharpening: Keep
     *         the default value, Off. To apply a minimal amount of sharpening choose Low, or for the maximum choose
     *         High.
     * @see AdvancedInputFilterSharpen
     */
    public final String sharpeningAsString() {
        return sharpening;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(addTextureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sharpeningAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdvancedInputFilterSettings)) {
            return false;
        }
        AdvancedInputFilterSettings other = (AdvancedInputFilterSettings) obj;
        return Objects.equals(addTextureAsString(), other.addTextureAsString())
                && Objects.equals(sharpeningAsString(), other.sharpeningAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AdvancedInputFilterSettings").add("AddTexture", addTextureAsString())
                .add("Sharpening", sharpeningAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AddTexture":
            return Optional.ofNullable(clazz.cast(addTextureAsString()));
        case "Sharpening":
            return Optional.ofNullable(clazz.cast(sharpeningAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AdvancedInputFilterSettings, T> g) {
        return obj -> g.apply((AdvancedInputFilterSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AdvancedInputFilterSettings> {
        /**
         * Add texture and detail to areas of your input video content that were lost after applying the Advanced input
         * filter. To adaptively add texture and reduce softness: Choose Enabled. To not add any texture: Keep the
         * default value, Disabled. We recommend that you choose Disabled for input video content that doesn't have
         * texture, including screen recordings, computer graphics, or cartoons.
         * 
         * @param addTexture
         *        Add texture and detail to areas of your input video content that were lost after applying the Advanced
         *        input filter. To adaptively add texture and reduce softness: Choose Enabled. To not add any texture:
         *        Keep the default value, Disabled. We recommend that you choose Disabled for input video content that
         *        doesn't have texture, including screen recordings, computer graphics, or cartoons.
         * @see AdvancedInputFilterAddTexture
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AdvancedInputFilterAddTexture
         */
        Builder addTexture(String addTexture);

        /**
         * Add texture and detail to areas of your input video content that were lost after applying the Advanced input
         * filter. To adaptively add texture and reduce softness: Choose Enabled. To not add any texture: Keep the
         * default value, Disabled. We recommend that you choose Disabled for input video content that doesn't have
         * texture, including screen recordings, computer graphics, or cartoons.
         * 
         * @param addTexture
         *        Add texture and detail to areas of your input video content that were lost after applying the Advanced
         *        input filter. To adaptively add texture and reduce softness: Choose Enabled. To not add any texture:
         *        Keep the default value, Disabled. We recommend that you choose Disabled for input video content that
         *        doesn't have texture, including screen recordings, computer graphics, or cartoons.
         * @see AdvancedInputFilterAddTexture
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AdvancedInputFilterAddTexture
         */
        Builder addTexture(AdvancedInputFilterAddTexture addTexture);

        /**
         * Optionally specify the amount of sharpening to apply when you use the Advanced input filter. Sharpening adds
         * contrast to the edges of your video content and can reduce softness. To apply no sharpening: Keep the default
         * value, Off. To apply a minimal amount of sharpening choose Low, or for the maximum choose High.
         * 
         * @param sharpening
         *        Optionally specify the amount of sharpening to apply when you use the Advanced input filter.
         *        Sharpening adds contrast to the edges of your video content and can reduce softness. To apply no
         *        sharpening: Keep the default value, Off. To apply a minimal amount of sharpening choose Low, or for
         *        the maximum choose High.
         * @see AdvancedInputFilterSharpen
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AdvancedInputFilterSharpen
         */
        Builder sharpening(String sharpening);

        /**
         * Optionally specify the amount of sharpening to apply when you use the Advanced input filter. Sharpening adds
         * contrast to the edges of your video content and can reduce softness. To apply no sharpening: Keep the default
         * value, Off. To apply a minimal amount of sharpening choose Low, or for the maximum choose High.
         * 
         * @param sharpening
         *        Optionally specify the amount of sharpening to apply when you use the Advanced input filter.
         *        Sharpening adds contrast to the edges of your video content and can reduce softness. To apply no
         *        sharpening: Keep the default value, Off. To apply a minimal amount of sharpening choose Low, or for
         *        the maximum choose High.
         * @see AdvancedInputFilterSharpen
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AdvancedInputFilterSharpen
         */
        Builder sharpening(AdvancedInputFilterSharpen sharpening);
    }

    static final class BuilderImpl implements Builder {
        private String addTexture;

        private String sharpening;

        private BuilderImpl() {
        }

        private BuilderImpl(AdvancedInputFilterSettings model) {
            addTexture(model.addTexture);
            sharpening(model.sharpening);
        }

        public final String getAddTexture() {
            return addTexture;
        }

        public final void setAddTexture(String addTexture) {
            this.addTexture = addTexture;
        }

        @Override
        public final Builder addTexture(String addTexture) {
            this.addTexture = addTexture;
            return this;
        }

        @Override
        public final Builder addTexture(AdvancedInputFilterAddTexture addTexture) {
            this.addTexture(addTexture == null ? null : addTexture.toString());
            return this;
        }

        public final String getSharpening() {
            return sharpening;
        }

        public final void setSharpening(String sharpening) {
            this.sharpening = sharpening;
        }

        @Override
        public final Builder sharpening(String sharpening) {
            this.sharpening = sharpening;
            return this;
        }

        @Override
        public final Builder sharpening(AdvancedInputFilterSharpen sharpening) {
            this.sharpening(sharpening == null ? null : sharpening.toString());
            return this;
        }

        @Override
        public AdvancedInputFilterSettings build() {
            return new AdvancedInputFilterSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
