/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RemoveFlowMediaStreamRequest extends MediaConnectRequest implements
        ToCopyableBuilder<RemoveFlowMediaStreamRequest.Builder, RemoveFlowMediaStreamRequest> {
    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlowArn").getter(getter(RemoveFlowMediaStreamRequest::flowArn)).setter(setter(Builder::flowArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("flowArn").build()).build();

    private static final SdkField<String> MEDIA_STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MediaStreamName").getter(getter(RemoveFlowMediaStreamRequest::mediaStreamName))
            .setter(setter(Builder::mediaStreamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("mediaStreamName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_ARN_FIELD,
            MEDIA_STREAM_NAME_FIELD));

    private final String flowArn;

    private final String mediaStreamName;

    private RemoveFlowMediaStreamRequest(BuilderImpl builder) {
        super(builder);
        this.flowArn = builder.flowArn;
        this.mediaStreamName = builder.mediaStreamName;
    }

    /**
     * The Amazon Resource Name (ARN) of the flow.
     * 
     * @return The Amazon Resource Name (ARN) of the flow.
     */
    public final String flowArn() {
        return flowArn;
    }

    /**
     * The name of the media stream that you want to remove.
     * 
     * @return The name of the media stream that you want to remove.
     */
    public final String mediaStreamName() {
        return mediaStreamName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(flowArn());
        hashCode = 31 * hashCode + Objects.hashCode(mediaStreamName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveFlowMediaStreamRequest)) {
            return false;
        }
        RemoveFlowMediaStreamRequest other = (RemoveFlowMediaStreamRequest) obj;
        return Objects.equals(flowArn(), other.flowArn()) && Objects.equals(mediaStreamName(), other.mediaStreamName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RemoveFlowMediaStreamRequest").add("FlowArn", flowArn())
                .add("MediaStreamName", mediaStreamName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FlowArn":
            return Optional.ofNullable(clazz.cast(flowArn()));
        case "MediaStreamName":
            return Optional.ofNullable(clazz.cast(mediaStreamName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RemoveFlowMediaStreamRequest, T> g) {
        return obj -> g.apply((RemoveFlowMediaStreamRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, RemoveFlowMediaStreamRequest> {
        /**
         * The Amazon Resource Name (ARN) of the flow.
         * 
         * @param flowArn
         *        The Amazon Resource Name (ARN) of the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowArn(String flowArn);

        /**
         * The name of the media stream that you want to remove.
         * 
         * @param mediaStreamName
         *        The name of the media stream that you want to remove.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaStreamName(String mediaStreamName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaConnectRequest.BuilderImpl implements Builder {
        private String flowArn;

        private String mediaStreamName;

        private BuilderImpl() {
        }

        private BuilderImpl(RemoveFlowMediaStreamRequest model) {
            super(model);
            flowArn(model.flowArn);
            mediaStreamName(model.mediaStreamName);
        }

        public final String getFlowArn() {
            return flowArn;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        public final String getMediaStreamName() {
            return mediaStreamName;
        }

        public final void setMediaStreamName(String mediaStreamName) {
            this.mediaStreamName = mediaStreamName;
        }

        @Override
        public final Builder mediaStreamName(String mediaStreamName) {
            this.mediaStreamName = mediaStreamName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RemoveFlowMediaStreamRequest build() {
            return new RemoveFlowMediaStreamRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
