/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Attributes that are related to the media stream.
 */
@Generated("software.amazon.awssdk:codegen")
public final class MediaStreamAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<MediaStreamAttributes.Builder, MediaStreamAttributes> {
    private static final SdkField<Fmtp> FMTP_FIELD = SdkField.<Fmtp> builder(MarshallingType.SDK_POJO).memberName("Fmtp")
            .getter(getter(MediaStreamAttributes::fmtp)).setter(setter(Builder::fmtp)).constructor(Fmtp::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fmtp").build()).build();

    private static final SdkField<String> LANG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Lang")
            .getter(getter(MediaStreamAttributes::lang)).setter(setter(Builder::lang))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lang").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FMTP_FIELD, LANG_FIELD));

    private static final long serialVersionUID = 1L;

    private final Fmtp fmtp;

    private final String lang;

    private MediaStreamAttributes(BuilderImpl builder) {
        this.fmtp = builder.fmtp;
        this.lang = builder.lang;
    }

    /**
     * A set of parameters that define the media stream.
     * 
     * @return A set of parameters that define the media stream.
     */
    public final Fmtp fmtp() {
        return fmtp;
    }

    /**
     * The audio language, in a format that is recognized by the receiver.
     * 
     * @return The audio language, in a format that is recognized by the receiver.
     */
    public final String lang() {
        return lang;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fmtp());
        hashCode = 31 * hashCode + Objects.hashCode(lang());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaStreamAttributes)) {
            return false;
        }
        MediaStreamAttributes other = (MediaStreamAttributes) obj;
        return Objects.equals(fmtp(), other.fmtp()) && Objects.equals(lang(), other.lang());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MediaStreamAttributes").add("Fmtp", fmtp()).add("Lang", lang()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Fmtp":
            return Optional.ofNullable(clazz.cast(fmtp()));
        case "Lang":
            return Optional.ofNullable(clazz.cast(lang()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MediaStreamAttributes, T> g) {
        return obj -> g.apply((MediaStreamAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MediaStreamAttributes> {
        /**
         * A set of parameters that define the media stream.
         * 
         * @param fmtp
         *        A set of parameters that define the media stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fmtp(Fmtp fmtp);

        /**
         * A set of parameters that define the media stream. This is a convenience method that creates an instance of
         * the {@link Fmtp.Builder} avoiding the need to create one manually via {@link Fmtp#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Fmtp.Builder#build()} is called immediately and its result is
         * passed to {@link #fmtp(Fmtp)}.
         * 
         * @param fmtp
         *        a consumer that will call methods on {@link Fmtp.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fmtp(Fmtp)
         */
        default Builder fmtp(Consumer<Fmtp.Builder> fmtp) {
            return fmtp(Fmtp.builder().applyMutation(fmtp).build());
        }

        /**
         * The audio language, in a format that is recognized by the receiver.
         * 
         * @param lang
         *        The audio language, in a format that is recognized by the receiver.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lang(String lang);
    }

    static final class BuilderImpl implements Builder {
        private Fmtp fmtp;

        private String lang;

        private BuilderImpl() {
        }

        private BuilderImpl(MediaStreamAttributes model) {
            fmtp(model.fmtp);
            lang(model.lang);
        }

        public final Fmtp.Builder getFmtp() {
            return fmtp != null ? fmtp.toBuilder() : null;
        }

        public final void setFmtp(Fmtp.BuilderImpl fmtp) {
            this.fmtp = fmtp != null ? fmtp.build() : null;
        }

        @Override
        public final Builder fmtp(Fmtp fmtp) {
            this.fmtp = fmtp;
            return this;
        }

        public final String getLang() {
            return lang;
        }

        public final void setLang(String lang) {
            this.lang = lang;
        }

        @Override
        public final Builder lang(String lang) {
            this.lang = lang;
            return this;
        }

        @Override
        public MediaStreamAttributes build() {
            return new MediaStreamAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
