/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchain;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.managedblockchain.model.AccessDeniedException;
import software.amazon.awssdk.services.managedblockchain.model.CreateAccessorRequest;
import software.amazon.awssdk.services.managedblockchain.model.CreateAccessorResponse;
import software.amazon.awssdk.services.managedblockchain.model.CreateMemberRequest;
import software.amazon.awssdk.services.managedblockchain.model.CreateMemberResponse;
import software.amazon.awssdk.services.managedblockchain.model.CreateNetworkRequest;
import software.amazon.awssdk.services.managedblockchain.model.CreateNetworkResponse;
import software.amazon.awssdk.services.managedblockchain.model.CreateNodeRequest;
import software.amazon.awssdk.services.managedblockchain.model.CreateNodeResponse;
import software.amazon.awssdk.services.managedblockchain.model.CreateProposalRequest;
import software.amazon.awssdk.services.managedblockchain.model.CreateProposalResponse;
import software.amazon.awssdk.services.managedblockchain.model.DeleteAccessorRequest;
import software.amazon.awssdk.services.managedblockchain.model.DeleteAccessorResponse;
import software.amazon.awssdk.services.managedblockchain.model.DeleteMemberRequest;
import software.amazon.awssdk.services.managedblockchain.model.DeleteMemberResponse;
import software.amazon.awssdk.services.managedblockchain.model.DeleteNodeRequest;
import software.amazon.awssdk.services.managedblockchain.model.DeleteNodeResponse;
import software.amazon.awssdk.services.managedblockchain.model.GetAccessorRequest;
import software.amazon.awssdk.services.managedblockchain.model.GetAccessorResponse;
import software.amazon.awssdk.services.managedblockchain.model.GetMemberRequest;
import software.amazon.awssdk.services.managedblockchain.model.GetMemberResponse;
import software.amazon.awssdk.services.managedblockchain.model.GetNetworkRequest;
import software.amazon.awssdk.services.managedblockchain.model.GetNetworkResponse;
import software.amazon.awssdk.services.managedblockchain.model.GetNodeRequest;
import software.amazon.awssdk.services.managedblockchain.model.GetNodeResponse;
import software.amazon.awssdk.services.managedblockchain.model.GetProposalRequest;
import software.amazon.awssdk.services.managedblockchain.model.GetProposalResponse;
import software.amazon.awssdk.services.managedblockchain.model.IllegalActionException;
import software.amazon.awssdk.services.managedblockchain.model.InternalServiceErrorException;
import software.amazon.awssdk.services.managedblockchain.model.InvalidRequestException;
import software.amazon.awssdk.services.managedblockchain.model.ListAccessorsRequest;
import software.amazon.awssdk.services.managedblockchain.model.ListAccessorsResponse;
import software.amazon.awssdk.services.managedblockchain.model.ListInvitationsRequest;
import software.amazon.awssdk.services.managedblockchain.model.ListInvitationsResponse;
import software.amazon.awssdk.services.managedblockchain.model.ListMembersRequest;
import software.amazon.awssdk.services.managedblockchain.model.ListMembersResponse;
import software.amazon.awssdk.services.managedblockchain.model.ListNetworksRequest;
import software.amazon.awssdk.services.managedblockchain.model.ListNetworksResponse;
import software.amazon.awssdk.services.managedblockchain.model.ListNodesRequest;
import software.amazon.awssdk.services.managedblockchain.model.ListNodesResponse;
import software.amazon.awssdk.services.managedblockchain.model.ListProposalVotesRequest;
import software.amazon.awssdk.services.managedblockchain.model.ListProposalVotesResponse;
import software.amazon.awssdk.services.managedblockchain.model.ListProposalsRequest;
import software.amazon.awssdk.services.managedblockchain.model.ListProposalsResponse;
import software.amazon.awssdk.services.managedblockchain.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.managedblockchain.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.managedblockchain.model.ManagedBlockchainException;
import software.amazon.awssdk.services.managedblockchain.model.RejectInvitationRequest;
import software.amazon.awssdk.services.managedblockchain.model.RejectInvitationResponse;
import software.amazon.awssdk.services.managedblockchain.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.managedblockchain.model.ResourceLimitExceededException;
import software.amazon.awssdk.services.managedblockchain.model.ResourceNotFoundException;
import software.amazon.awssdk.services.managedblockchain.model.ResourceNotReadyException;
import software.amazon.awssdk.services.managedblockchain.model.TagResourceRequest;
import software.amazon.awssdk.services.managedblockchain.model.TagResourceResponse;
import software.amazon.awssdk.services.managedblockchain.model.ThrottlingException;
import software.amazon.awssdk.services.managedblockchain.model.TooManyTagsException;
import software.amazon.awssdk.services.managedblockchain.model.UntagResourceRequest;
import software.amazon.awssdk.services.managedblockchain.model.UntagResourceResponse;
import software.amazon.awssdk.services.managedblockchain.model.UpdateMemberRequest;
import software.amazon.awssdk.services.managedblockchain.model.UpdateMemberResponse;
import software.amazon.awssdk.services.managedblockchain.model.UpdateNodeRequest;
import software.amazon.awssdk.services.managedblockchain.model.UpdateNodeResponse;
import software.amazon.awssdk.services.managedblockchain.model.VoteOnProposalRequest;
import software.amazon.awssdk.services.managedblockchain.model.VoteOnProposalResponse;
import software.amazon.awssdk.services.managedblockchain.paginators.ListAccessorsIterable;
import software.amazon.awssdk.services.managedblockchain.paginators.ListInvitationsIterable;
import software.amazon.awssdk.services.managedblockchain.paginators.ListMembersIterable;
import software.amazon.awssdk.services.managedblockchain.paginators.ListNetworksIterable;
import software.amazon.awssdk.services.managedblockchain.paginators.ListNodesIterable;
import software.amazon.awssdk.services.managedblockchain.paginators.ListProposalVotesIterable;
import software.amazon.awssdk.services.managedblockchain.paginators.ListProposalsIterable;

/**
 * Service client for accessing ManagedBlockchain. This can be created using the static {@link #builder()} method.
 *
 * <p/>
 * <p>
 * Amazon Managed Blockchain is a fully managed service for creating and managing blockchain networks using open-source
 * frameworks. Blockchain allows you to build applications where multiple parties can securely and transparently run
 * transactions and share data without the need for a trusted, central authority.
 * </p>
 * <p>
 * Managed Blockchain supports the Hyperledger Fabric and Ethereum open-source frameworks. Because of fundamental
 * differences between the frameworks, some API actions or data types may only apply in the context of one framework and
 * not the other. For example, actions related to Hyperledger Fabric network members such as <code>CreateMember</code>
 * and <code>DeleteMember</code> don't apply to Ethereum.
 * </p>
 * <p>
 * The description for each action indicates the framework or frameworks to which it applies. Data types and properties
 * that apply only in the context of a particular framework are similarly indicated.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface ManagedBlockchainClient extends AwsClient {
    String SERVICE_NAME = "managedblockchain";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "managedblockchain";

    /**
     * <p>
     * Creates a new accessor for use with Managed Blockchain Ethereum nodes. An accessor contains information required
     * for token based access to your Ethereum nodes.
     * </p>
     *
     * @param createAccessorRequest
     * @return Result of the CreateAccessor operation returned by the service.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ResourceAlreadyExistsException
     *         A resource request is issued for a resource that already exists.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws ResourceLimitExceededException
     *         The maximum number of resources of that type already exist. Ensure the resources requested are within the
     *         boundaries of the service edition and your account limits.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws TooManyTagsException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.CreateAccessor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/CreateAccessor"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAccessorResponse createAccessor(CreateAccessorRequest createAccessorRequest) throws InvalidRequestException,
            AccessDeniedException, ResourceAlreadyExistsException, ThrottlingException, ResourceLimitExceededException,
            InternalServiceErrorException, TooManyTagsException, AwsServiceException, SdkClientException,
            ManagedBlockchainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new accessor for use with Managed Blockchain Ethereum nodes. An accessor contains information required
     * for token based access to your Ethereum nodes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAccessorRequest.Builder} avoiding the need to
     * create one manually via {@link CreateAccessorRequest#builder()}
     * </p>
     *
     * @param createAccessorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.managedblockchain.model.CreateAccessorRequest.Builder} to create a
     *        request.
     * @return Result of the CreateAccessor operation returned by the service.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ResourceAlreadyExistsException
     *         A resource request is issued for a resource that already exists.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws ResourceLimitExceededException
     *         The maximum number of resources of that type already exist. Ensure the resources requested are within the
     *         boundaries of the service edition and your account limits.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws TooManyTagsException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.CreateAccessor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/CreateAccessor"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAccessorResponse createAccessor(Consumer<CreateAccessorRequest.Builder> createAccessorRequest)
            throws InvalidRequestException, AccessDeniedException, ResourceAlreadyExistsException, ThrottlingException,
            ResourceLimitExceededException, InternalServiceErrorException, TooManyTagsException, AwsServiceException,
            SdkClientException, ManagedBlockchainException {
        return createAccessor(CreateAccessorRequest.builder().applyMutation(createAccessorRequest).build());
    }

    /**
     * <p>
     * Creates a member within a Managed Blockchain network.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     *
     * @param createMemberRequest
     * @return Result of the CreateMember operation returned by the service.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         A requested resource doesn't exist. It may have been deleted or referenced incorrectly.
     * @throws ResourceAlreadyExistsException
     *         A resource request is issued for a resource that already exists.
     * @throws ResourceNotReadyException
     *         The requested resource exists but isn't in a status that can complete the operation.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws ResourceLimitExceededException
     *         The maximum number of resources of that type already exist. Ensure the resources requested are within the
     *         boundaries of the service edition and your account limits.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws TooManyTagsException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.CreateMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/CreateMember"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateMemberResponse createMember(CreateMemberRequest createMemberRequest) throws InvalidRequestException,
            AccessDeniedException, ResourceNotFoundException, ResourceAlreadyExistsException, ResourceNotReadyException,
            ThrottlingException, ResourceLimitExceededException, InternalServiceErrorException, TooManyTagsException,
            AwsServiceException, SdkClientException, ManagedBlockchainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a member within a Managed Blockchain network.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMemberRequest.Builder} avoiding the need to
     * create one manually via {@link CreateMemberRequest#builder()}
     * </p>
     *
     * @param createMemberRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.managedblockchain.model.CreateMemberRequest.Builder} to create a
     *        request.
     * @return Result of the CreateMember operation returned by the service.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         A requested resource doesn't exist. It may have been deleted or referenced incorrectly.
     * @throws ResourceAlreadyExistsException
     *         A resource request is issued for a resource that already exists.
     * @throws ResourceNotReadyException
     *         The requested resource exists but isn't in a status that can complete the operation.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws ResourceLimitExceededException
     *         The maximum number of resources of that type already exist. Ensure the resources requested are within the
     *         boundaries of the service edition and your account limits.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws TooManyTagsException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.CreateMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/CreateMember"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateMemberResponse createMember(Consumer<CreateMemberRequest.Builder> createMemberRequest)
            throws InvalidRequestException, AccessDeniedException, ResourceNotFoundException, ResourceAlreadyExistsException,
            ResourceNotReadyException, ThrottlingException, ResourceLimitExceededException, InternalServiceErrorException,
            TooManyTagsException, AwsServiceException, SdkClientException, ManagedBlockchainException {
        return createMember(CreateMemberRequest.builder().applyMutation(createMemberRequest).build());
    }

    /**
     * <p>
     * Creates a new blockchain network using Amazon Managed Blockchain.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     *
     * @param createNetworkRequest
     * @return Result of the CreateNetwork operation returned by the service.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ResourceAlreadyExistsException
     *         A resource request is issued for a resource that already exists.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws ResourceLimitExceededException
     *         The maximum number of resources of that type already exist. Ensure the resources requested are within the
     *         boundaries of the service edition and your account limits.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws TooManyTagsException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.CreateNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/CreateNetwork"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateNetworkResponse createNetwork(CreateNetworkRequest createNetworkRequest) throws InvalidRequestException,
            AccessDeniedException, ResourceAlreadyExistsException, ThrottlingException, ResourceLimitExceededException,
            InternalServiceErrorException, TooManyTagsException, AwsServiceException, SdkClientException,
            ManagedBlockchainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new blockchain network using Amazon Managed Blockchain.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateNetworkRequest.Builder} avoiding the need to
     * create one manually via {@link CreateNetworkRequest#builder()}
     * </p>
     *
     * @param createNetworkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.managedblockchain.model.CreateNetworkRequest.Builder} to create a
     *        request.
     * @return Result of the CreateNetwork operation returned by the service.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ResourceAlreadyExistsException
     *         A resource request is issued for a resource that already exists.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws ResourceLimitExceededException
     *         The maximum number of resources of that type already exist. Ensure the resources requested are within the
     *         boundaries of the service edition and your account limits.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws TooManyTagsException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.CreateNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/CreateNetwork"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateNetworkResponse createNetwork(Consumer<CreateNetworkRequest.Builder> createNetworkRequest)
            throws InvalidRequestException, AccessDeniedException, ResourceAlreadyExistsException, ThrottlingException,
            ResourceLimitExceededException, InternalServiceErrorException, TooManyTagsException, AwsServiceException,
            SdkClientException, ManagedBlockchainException {
        return createNetwork(CreateNetworkRequest.builder().applyMutation(createNetworkRequest).build());
    }

    /**
     * <p>
     * Creates a node on the specified blockchain network.
     * </p>
     * <p>
     * Applies to Hyperledger Fabric and Ethereum.
     * </p>
     *
     * @param createNodeRequest
     * @return Result of the CreateNode operation returned by the service.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         A requested resource doesn't exist. It may have been deleted or referenced incorrectly.
     * @throws ResourceAlreadyExistsException
     *         A resource request is issued for a resource that already exists.
     * @throws ResourceNotReadyException
     *         The requested resource exists but isn't in a status that can complete the operation.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws ResourceLimitExceededException
     *         The maximum number of resources of that type already exist. Ensure the resources requested are within the
     *         boundaries of the service edition and your account limits.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws TooManyTagsException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.CreateNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/CreateNode" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateNodeResponse createNode(CreateNodeRequest createNodeRequest) throws InvalidRequestException,
            AccessDeniedException, ResourceNotFoundException, ResourceAlreadyExistsException, ResourceNotReadyException,
            ThrottlingException, ResourceLimitExceededException, InternalServiceErrorException, TooManyTagsException,
            AwsServiceException, SdkClientException, ManagedBlockchainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a node on the specified blockchain network.
     * </p>
     * <p>
     * Applies to Hyperledger Fabric and Ethereum.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateNodeRequest.Builder} avoiding the need to
     * create one manually via {@link CreateNodeRequest#builder()}
     * </p>
     *
     * @param createNodeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.managedblockchain.model.CreateNodeRequest.Builder} to create a
     *        request.
     * @return Result of the CreateNode operation returned by the service.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         A requested resource doesn't exist. It may have been deleted or referenced incorrectly.
     * @throws ResourceAlreadyExistsException
     *         A resource request is issued for a resource that already exists.
     * @throws ResourceNotReadyException
     *         The requested resource exists but isn't in a status that can complete the operation.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws ResourceLimitExceededException
     *         The maximum number of resources of that type already exist. Ensure the resources requested are within the
     *         boundaries of the service edition and your account limits.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws TooManyTagsException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.CreateNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/CreateNode" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateNodeResponse createNode(Consumer<CreateNodeRequest.Builder> createNodeRequest) throws InvalidRequestException,
            AccessDeniedException, ResourceNotFoundException, ResourceAlreadyExistsException, ResourceNotReadyException,
            ThrottlingException, ResourceLimitExceededException, InternalServiceErrorException, TooManyTagsException,
            AwsServiceException, SdkClientException, ManagedBlockchainException {
        return createNode(CreateNodeRequest.builder().applyMutation(createNodeRequest).build());
    }

    /**
     * <p>
     * Creates a proposal for a change to the network that other members of the network can vote on, for example, a
     * proposal to add a new member to the network. Any member can create a proposal.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     *
     * @param createProposalRequest
     * @return Result of the CreateProposal operation returned by the service.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         A requested resource doesn't exist. It may have been deleted or referenced incorrectly.
     * @throws ResourceNotReadyException
     *         The requested resource exists but isn't in a status that can complete the operation.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws TooManyTagsException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.CreateProposal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/CreateProposal"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateProposalResponse createProposal(CreateProposalRequest createProposalRequest) throws InvalidRequestException,
            AccessDeniedException, ResourceNotFoundException, ResourceNotReadyException, ThrottlingException,
            InternalServiceErrorException, TooManyTagsException, AwsServiceException, SdkClientException,
            ManagedBlockchainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a proposal for a change to the network that other members of the network can vote on, for example, a
     * proposal to add a new member to the network. Any member can create a proposal.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProposalRequest.Builder} avoiding the need to
     * create one manually via {@link CreateProposalRequest#builder()}
     * </p>
     *
     * @param createProposalRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.managedblockchain.model.CreateProposalRequest.Builder} to create a
     *        request.
     * @return Result of the CreateProposal operation returned by the service.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         A requested resource doesn't exist. It may have been deleted or referenced incorrectly.
     * @throws ResourceNotReadyException
     *         The requested resource exists but isn't in a status that can complete the operation.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws TooManyTagsException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.CreateProposal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/CreateProposal"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateProposalResponse createProposal(Consumer<CreateProposalRequest.Builder> createProposalRequest)
            throws InvalidRequestException, AccessDeniedException, ResourceNotFoundException, ResourceNotReadyException,
            ThrottlingException, InternalServiceErrorException, TooManyTagsException, AwsServiceException, SdkClientException,
            ManagedBlockchainException {
        return createProposal(CreateProposalRequest.builder().applyMutation(createProposalRequest).build());
    }

    /**
     * <p>
     * Deletes an accessor that your Amazon Web Services account owns. An accessor object is a container that has the
     * information required for token based access to your Ethereum nodes including, the <code>BILLING_TOKEN</code>.
     * After an accessor is deleted, the status of the accessor changes from <code>AVAILABLE</code> to
     * <code>PENDING_DELETION</code>. An accessor in the <code>PENDING_DELETION</code> state can’t be used for new
     * WebSocket requests or HTTP requests. However, WebSocket connections that were initiated while the accessor was in
     * the <code>AVAILABLE</code> state remain open until they expire (up to 2 hours).
     * </p>
     *
     * @param deleteAccessorRequest
     * @return Result of the DeleteAccessor operation returned by the service.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         A requested resource doesn't exist. It may have been deleted or referenced incorrectly.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.DeleteAccessor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/DeleteAccessor"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAccessorResponse deleteAccessor(DeleteAccessorRequest deleteAccessorRequest) throws InvalidRequestException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServiceErrorException,
            AwsServiceException, SdkClientException, ManagedBlockchainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an accessor that your Amazon Web Services account owns. An accessor object is a container that has the
     * information required for token based access to your Ethereum nodes including, the <code>BILLING_TOKEN</code>.
     * After an accessor is deleted, the status of the accessor changes from <code>AVAILABLE</code> to
     * <code>PENDING_DELETION</code>. An accessor in the <code>PENDING_DELETION</code> state can’t be used for new
     * WebSocket requests or HTTP requests. However, WebSocket connections that were initiated while the accessor was in
     * the <code>AVAILABLE</code> state remain open until they expire (up to 2 hours).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAccessorRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteAccessorRequest#builder()}
     * </p>
     *
     * @param deleteAccessorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.managedblockchain.model.DeleteAccessorRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteAccessor operation returned by the service.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         A requested resource doesn't exist. It may have been deleted or referenced incorrectly.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.DeleteAccessor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/DeleteAccessor"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAccessorResponse deleteAccessor(Consumer<DeleteAccessorRequest.Builder> deleteAccessorRequest)
            throws InvalidRequestException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServiceErrorException, AwsServiceException, SdkClientException, ManagedBlockchainException {
        return deleteAccessor(DeleteAccessorRequest.builder().applyMutation(deleteAccessorRequest).build());
    }

    /**
     * <p>
     * Deletes a member. Deleting a member removes the member and all associated resources from the network.
     * <code>DeleteMember</code> can only be called for a specified <code>MemberId</code> if the principal performing
     * the action is associated with the Amazon Web Services account that owns the member. In all other cases, the
     * <code>DeleteMember</code> action is carried out as the result of an approved proposal to remove a member. If
     * <code>MemberId</code> is the last member in a network specified by the last Amazon Web Services account, the
     * network is deleted also.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     *
     * @param deleteMemberRequest
     * @return Result of the DeleteMember operation returned by the service.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         A requested resource doesn't exist. It may have been deleted or referenced incorrectly.
     * @throws ResourceNotReadyException
     *         The requested resource exists but isn't in a status that can complete the operation.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.DeleteMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/DeleteMember"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteMemberResponse deleteMember(DeleteMemberRequest deleteMemberRequest) throws InvalidRequestException,
            AccessDeniedException, ResourceNotFoundException, ResourceNotReadyException, ThrottlingException,
            InternalServiceErrorException, AwsServiceException, SdkClientException, ManagedBlockchainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a member. Deleting a member removes the member and all associated resources from the network.
     * <code>DeleteMember</code> can only be called for a specified <code>MemberId</code> if the principal performing
     * the action is associated with the Amazon Web Services account that owns the member. In all other cases, the
     * <code>DeleteMember</code> action is carried out as the result of an approved proposal to remove a member. If
     * <code>MemberId</code> is the last member in a network specified by the last Amazon Web Services account, the
     * network is deleted also.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMemberRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteMemberRequest#builder()}
     * </p>
     *
     * @param deleteMemberRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.managedblockchain.model.DeleteMemberRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteMember operation returned by the service.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         A requested resource doesn't exist. It may have been deleted or referenced incorrectly.
     * @throws ResourceNotReadyException
     *         The requested resource exists but isn't in a status that can complete the operation.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.DeleteMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/DeleteMember"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteMemberResponse deleteMember(Consumer<DeleteMemberRequest.Builder> deleteMemberRequest)
            throws InvalidRequestException, AccessDeniedException, ResourceNotFoundException, ResourceNotReadyException,
            ThrottlingException, InternalServiceErrorException, AwsServiceException, SdkClientException,
            ManagedBlockchainException {
        return deleteMember(DeleteMemberRequest.builder().applyMutation(deleteMemberRequest).build());
    }

    /**
     * <p>
     * Deletes a node that your Amazon Web Services account owns. All data on the node is lost and cannot be recovered.
     * </p>
     * <p>
     * Applies to Hyperledger Fabric and Ethereum.
     * </p>
     *
     * @param deleteNodeRequest
     * @return Result of the DeleteNode operation returned by the service.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         A requested resource doesn't exist. It may have been deleted or referenced incorrectly.
     * @throws ResourceNotReadyException
     *         The requested resource exists but isn't in a status that can complete the operation.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.DeleteNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/DeleteNode" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteNodeResponse deleteNode(DeleteNodeRequest deleteNodeRequest) throws InvalidRequestException,
            AccessDeniedException, ResourceNotFoundException, ResourceNotReadyException, ThrottlingException,
            InternalServiceErrorException, AwsServiceException, SdkClientException, ManagedBlockchainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a node that your Amazon Web Services account owns. All data on the node is lost and cannot be recovered.
     * </p>
     * <p>
     * Applies to Hyperledger Fabric and Ethereum.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteNodeRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteNodeRequest#builder()}
     * </p>
     *
     * @param deleteNodeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.managedblockchain.model.DeleteNodeRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteNode operation returned by the service.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         A requested resource doesn't exist. It may have been deleted or referenced incorrectly.
     * @throws ResourceNotReadyException
     *         The requested resource exists but isn't in a status that can complete the operation.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.DeleteNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/DeleteNode" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteNodeResponse deleteNode(Consumer<DeleteNodeRequest.Builder> deleteNodeRequest) throws InvalidRequestException,
            AccessDeniedException, ResourceNotFoundException, ResourceNotReadyException, ThrottlingException,
            InternalServiceErrorException, AwsServiceException, SdkClientException, ManagedBlockchainException {
        return deleteNode(DeleteNodeRequest.builder().applyMutation(deleteNodeRequest).build());
    }

    /**
     * <p>
     * Returns detailed information about an accessor. An accessor object is a container that has the information
     * required for token based access to your Ethereum nodes.
     * </p>
     *
     * @param getAccessorRequest
     * @return Result of the GetAccessor operation returned by the service.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         A requested resource doesn't exist. It may have been deleted or referenced incorrectly.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.GetAccessor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/GetAccessor" target="_top">AWS
     *      API Documentation</a>
     */
    default GetAccessorResponse getAccessor(GetAccessorRequest getAccessorRequest) throws InvalidRequestException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServiceErrorException,
            AwsServiceException, SdkClientException, ManagedBlockchainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns detailed information about an accessor. An accessor object is a container that has the information
     * required for token based access to your Ethereum nodes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAccessorRequest.Builder} avoiding the need to
     * create one manually via {@link GetAccessorRequest#builder()}
     * </p>
     *
     * @param getAccessorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.managedblockchain.model.GetAccessorRequest.Builder} to create a
     *        request.
     * @return Result of the GetAccessor operation returned by the service.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         A requested resource doesn't exist. It may have been deleted or referenced incorrectly.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.GetAccessor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/GetAccessor" target="_top">AWS
     *      API Documentation</a>
     */
    default GetAccessorResponse getAccessor(Consumer<GetAccessorRequest.Builder> getAccessorRequest)
            throws InvalidRequestException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServiceErrorException, AwsServiceException, SdkClientException, ManagedBlockchainException {
        return getAccessor(GetAccessorRequest.builder().applyMutation(getAccessorRequest).build());
    }

    /**
     * <p>
     * Returns detailed information about a member.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     *
     * @param getMemberRequest
     * @return Result of the GetMember operation returned by the service.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         A requested resource doesn't exist. It may have been deleted or referenced incorrectly.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.GetMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/GetMember" target="_top">AWS
     *      API Documentation</a>
     */
    default GetMemberResponse getMember(GetMemberRequest getMemberRequest) throws InvalidRequestException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, InternalServiceErrorException, AwsServiceException,
            SdkClientException, ManagedBlockchainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns detailed information about a member.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMemberRequest.Builder} avoiding the need to
     * create one manually via {@link GetMemberRequest#builder()}
     * </p>
     *
     * @param getMemberRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.managedblockchain.model.GetMemberRequest.Builder} to create a
     *        request.
     * @return Result of the GetMember operation returned by the service.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         A requested resource doesn't exist. It may have been deleted or referenced incorrectly.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.GetMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/GetMember" target="_top">AWS
     *      API Documentation</a>
     */
    default GetMemberResponse getMember(Consumer<GetMemberRequest.Builder> getMemberRequest) throws InvalidRequestException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServiceErrorException,
            AwsServiceException, SdkClientException, ManagedBlockchainException {
        return getMember(GetMemberRequest.builder().applyMutation(getMemberRequest).build());
    }

    /**
     * <p>
     * Returns detailed information about a network.
     * </p>
     * <p>
     * Applies to Hyperledger Fabric and Ethereum.
     * </p>
     *
     * @param getNetworkRequest
     * @return Result of the GetNetwork operation returned by the service.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         A requested resource doesn't exist. It may have been deleted or referenced incorrectly.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.GetNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/GetNetwork" target="_top">AWS
     *      API Documentation</a>
     */
    default GetNetworkResponse getNetwork(GetNetworkRequest getNetworkRequest) throws InvalidRequestException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServiceErrorException,
            AwsServiceException, SdkClientException, ManagedBlockchainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns detailed information about a network.
     * </p>
     * <p>
     * Applies to Hyperledger Fabric and Ethereum.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetNetworkRequest.Builder} avoiding the need to
     * create one manually via {@link GetNetworkRequest#builder()}
     * </p>
     *
     * @param getNetworkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.managedblockchain.model.GetNetworkRequest.Builder} to create a
     *        request.
     * @return Result of the GetNetwork operation returned by the service.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         A requested resource doesn't exist. It may have been deleted or referenced incorrectly.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.GetNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/GetNetwork" target="_top">AWS
     *      API Documentation</a>
     */
    default GetNetworkResponse getNetwork(Consumer<GetNetworkRequest.Builder> getNetworkRequest) throws InvalidRequestException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServiceErrorException,
            AwsServiceException, SdkClientException, ManagedBlockchainException {
        return getNetwork(GetNetworkRequest.builder().applyMutation(getNetworkRequest).build());
    }

    /**
     * <p>
     * Returns detailed information about a node.
     * </p>
     * <p>
     * Applies to Hyperledger Fabric and Ethereum.
     * </p>
     *
     * @param getNodeRequest
     * @return Result of the GetNode operation returned by the service.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         A requested resource doesn't exist. It may have been deleted or referenced incorrectly.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.GetNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/GetNode" target="_top">AWS API
     *      Documentation</a>
     */
    default GetNodeResponse getNode(GetNodeRequest getNodeRequest) throws InvalidRequestException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, InternalServiceErrorException, AwsServiceException,
            SdkClientException, ManagedBlockchainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns detailed information about a node.
     * </p>
     * <p>
     * Applies to Hyperledger Fabric and Ethereum.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetNodeRequest.Builder} avoiding the need to create
     * one manually via {@link GetNodeRequest#builder()}
     * </p>
     *
     * @param getNodeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.managedblockchain.model.GetNodeRequest.Builder} to create a
     *        request.
     * @return Result of the GetNode operation returned by the service.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         A requested resource doesn't exist. It may have been deleted or referenced incorrectly.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.GetNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/GetNode" target="_top">AWS API
     *      Documentation</a>
     */
    default GetNodeResponse getNode(Consumer<GetNodeRequest.Builder> getNodeRequest) throws InvalidRequestException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServiceErrorException,
            AwsServiceException, SdkClientException, ManagedBlockchainException {
        return getNode(GetNodeRequest.builder().applyMutation(getNodeRequest).build());
    }

    /**
     * <p>
     * Returns detailed information about a proposal.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     *
     * @param getProposalRequest
     * @return Result of the GetProposal operation returned by the service.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         A requested resource doesn't exist. It may have been deleted or referenced incorrectly.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.GetProposal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/GetProposal" target="_top">AWS
     *      API Documentation</a>
     */
    default GetProposalResponse getProposal(GetProposalRequest getProposalRequest) throws InvalidRequestException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServiceErrorException,
            AwsServiceException, SdkClientException, ManagedBlockchainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns detailed information about a proposal.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetProposalRequest.Builder} avoiding the need to
     * create one manually via {@link GetProposalRequest#builder()}
     * </p>
     *
     * @param getProposalRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.managedblockchain.model.GetProposalRequest.Builder} to create a
     *        request.
     * @return Result of the GetProposal operation returned by the service.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         A requested resource doesn't exist. It may have been deleted or referenced incorrectly.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.GetProposal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/GetProposal" target="_top">AWS
     *      API Documentation</a>
     */
    default GetProposalResponse getProposal(Consumer<GetProposalRequest.Builder> getProposalRequest)
            throws InvalidRequestException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServiceErrorException, AwsServiceException, SdkClientException, ManagedBlockchainException {
        return getProposal(GetProposalRequest.builder().applyMutation(getProposalRequest).build());
    }

    /**
     * <p>
     * Returns a list of the accessors and their properties. Accessor objects are containers that have the information
     * required for token based access to your Ethereum nodes.
     * </p>
     *
     * @param listAccessorsRequest
     * @return Result of the ListAccessors operation returned by the service.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.ListAccessors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListAccessors"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccessorsResponse listAccessors(ListAccessorsRequest listAccessorsRequest) throws InvalidRequestException,
            AccessDeniedException, ThrottlingException, InternalServiceErrorException, AwsServiceException, SdkClientException,
            ManagedBlockchainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the accessors and their properties. Accessor objects are containers that have the information
     * required for token based access to your Ethereum nodes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccessorsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAccessorsRequest#builder()}
     * </p>
     *
     * @param listAccessorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.managedblockchain.model.ListAccessorsRequest.Builder} to create a
     *        request.
     * @return Result of the ListAccessors operation returned by the service.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.ListAccessors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListAccessors"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccessorsResponse listAccessors(Consumer<ListAccessorsRequest.Builder> listAccessorsRequest)
            throws InvalidRequestException, AccessDeniedException, ThrottlingException, InternalServiceErrorException,
            AwsServiceException, SdkClientException, ManagedBlockchainException {
        return listAccessors(ListAccessorsRequest.builder().applyMutation(listAccessorsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the accessors and their properties. Accessor objects are containers that have the information
     * required for token based access to your Ethereum nodes.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAccessors(software.amazon.awssdk.services.managedblockchain.model.ListAccessorsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchain.paginators.ListAccessorsIterable responses = client.listAccessorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.managedblockchain.paginators.ListAccessorsIterable responses = client
     *             .listAccessorsPaginator(request);
     *     for (software.amazon.awssdk.services.managedblockchain.model.ListAccessorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchain.paginators.ListAccessorsIterable responses = client.listAccessorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccessors(software.amazon.awssdk.services.managedblockchain.model.ListAccessorsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAccessorsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.ListAccessors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListAccessors"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccessorsIterable listAccessorsPaginator(ListAccessorsRequest listAccessorsRequest)
            throws InvalidRequestException, AccessDeniedException, ThrottlingException, InternalServiceErrorException,
            AwsServiceException, SdkClientException, ManagedBlockchainException {
        return new ListAccessorsIterable(this, listAccessorsRequest);
    }

    /**
     * <p>
     * Returns a list of the accessors and their properties. Accessor objects are containers that have the information
     * required for token based access to your Ethereum nodes.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAccessors(software.amazon.awssdk.services.managedblockchain.model.ListAccessorsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchain.paginators.ListAccessorsIterable responses = client.listAccessorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.managedblockchain.paginators.ListAccessorsIterable responses = client
     *             .listAccessorsPaginator(request);
     *     for (software.amazon.awssdk.services.managedblockchain.model.ListAccessorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchain.paginators.ListAccessorsIterable responses = client.listAccessorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccessors(software.amazon.awssdk.services.managedblockchain.model.ListAccessorsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccessorsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAccessorsRequest#builder()}
     * </p>
     *
     * @param listAccessorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.managedblockchain.model.ListAccessorsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.ListAccessors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListAccessors"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccessorsIterable listAccessorsPaginator(Consumer<ListAccessorsRequest.Builder> listAccessorsRequest)
            throws InvalidRequestException, AccessDeniedException, ThrottlingException, InternalServiceErrorException,
            AwsServiceException, SdkClientException, ManagedBlockchainException {
        return listAccessorsPaginator(ListAccessorsRequest.builder().applyMutation(listAccessorsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all invitations for the current Amazon Web Services account.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     *
     * @param listInvitationsRequest
     * @return Result of the ListInvitations operation returned by the service.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         A requested resource doesn't exist. It may have been deleted or referenced incorrectly.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws ResourceLimitExceededException
     *         The maximum number of resources of that type already exist. Ensure the resources requested are within the
     *         boundaries of the service edition and your account limits.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.ListInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListInvitations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInvitationsResponse listInvitations(ListInvitationsRequest listInvitationsRequest)
            throws InvalidRequestException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            ResourceLimitExceededException, InternalServiceErrorException, AwsServiceException, SdkClientException,
            ManagedBlockchainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all invitations for the current Amazon Web Services account.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInvitationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListInvitationsRequest#builder()}
     * </p>
     *
     * @param listInvitationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.managedblockchain.model.ListInvitationsRequest.Builder} to create a
     *        request.
     * @return Result of the ListInvitations operation returned by the service.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         A requested resource doesn't exist. It may have been deleted or referenced incorrectly.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws ResourceLimitExceededException
     *         The maximum number of resources of that type already exist. Ensure the resources requested are within the
     *         boundaries of the service edition and your account limits.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.ListInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListInvitations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInvitationsResponse listInvitations(Consumer<ListInvitationsRequest.Builder> listInvitationsRequest)
            throws InvalidRequestException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            ResourceLimitExceededException, InternalServiceErrorException, AwsServiceException, SdkClientException,
            ManagedBlockchainException {
        return listInvitations(ListInvitationsRequest.builder().applyMutation(listInvitationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all invitations for the current Amazon Web Services account.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listInvitations(software.amazon.awssdk.services.managedblockchain.model.ListInvitationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchain.paginators.ListInvitationsIterable responses = client.listInvitationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.managedblockchain.paginators.ListInvitationsIterable responses = client
     *             .listInvitationsPaginator(request);
     *     for (software.amazon.awssdk.services.managedblockchain.model.ListInvitationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchain.paginators.ListInvitationsIterable responses = client.listInvitationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInvitations(software.amazon.awssdk.services.managedblockchain.model.ListInvitationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listInvitationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         A requested resource doesn't exist. It may have been deleted or referenced incorrectly.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws ResourceLimitExceededException
     *         The maximum number of resources of that type already exist. Ensure the resources requested are within the
     *         boundaries of the service edition and your account limits.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.ListInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListInvitations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInvitationsIterable listInvitationsPaginator(ListInvitationsRequest listInvitationsRequest)
            throws InvalidRequestException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            ResourceLimitExceededException, InternalServiceErrorException, AwsServiceException, SdkClientException,
            ManagedBlockchainException {
        return new ListInvitationsIterable(this, listInvitationsRequest);
    }

    /**
     * <p>
     * Returns a list of all invitations for the current Amazon Web Services account.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listInvitations(software.amazon.awssdk.services.managedblockchain.model.ListInvitationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchain.paginators.ListInvitationsIterable responses = client.listInvitationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.managedblockchain.paginators.ListInvitationsIterable responses = client
     *             .listInvitationsPaginator(request);
     *     for (software.amazon.awssdk.services.managedblockchain.model.ListInvitationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchain.paginators.ListInvitationsIterable responses = client.listInvitationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInvitations(software.amazon.awssdk.services.managedblockchain.model.ListInvitationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInvitationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListInvitationsRequest#builder()}
     * </p>
     *
     * @param listInvitationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.managedblockchain.model.ListInvitationsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         A requested resource doesn't exist. It may have been deleted or referenced incorrectly.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws ResourceLimitExceededException
     *         The maximum number of resources of that type already exist. Ensure the resources requested are within the
     *         boundaries of the service edition and your account limits.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.ListInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListInvitations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInvitationsIterable listInvitationsPaginator(Consumer<ListInvitationsRequest.Builder> listInvitationsRequest)
            throws InvalidRequestException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            ResourceLimitExceededException, InternalServiceErrorException, AwsServiceException, SdkClientException,
            ManagedBlockchainException {
        return listInvitationsPaginator(ListInvitationsRequest.builder().applyMutation(listInvitationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the members in a network and properties of their configurations.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     *
     * @param listMembersRequest
     * @return Result of the ListMembers operation returned by the service.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.ListMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListMembers" target="_top">AWS
     *      API Documentation</a>
     */
    default ListMembersResponse listMembers(ListMembersRequest listMembersRequest) throws InvalidRequestException,
            AccessDeniedException, ThrottlingException, InternalServiceErrorException, AwsServiceException, SdkClientException,
            ManagedBlockchainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the members in a network and properties of their configurations.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMembersRequest.Builder} avoiding the need to
     * create one manually via {@link ListMembersRequest#builder()}
     * </p>
     *
     * @param listMembersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.managedblockchain.model.ListMembersRequest.Builder} to create a
     *        request.
     * @return Result of the ListMembers operation returned by the service.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.ListMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListMembers" target="_top">AWS
     *      API Documentation</a>
     */
    default ListMembersResponse listMembers(Consumer<ListMembersRequest.Builder> listMembersRequest)
            throws InvalidRequestException, AccessDeniedException, ThrottlingException, InternalServiceErrorException,
            AwsServiceException, SdkClientException, ManagedBlockchainException {
        return listMembers(ListMembersRequest.builder().applyMutation(listMembersRequest).build());
    }

    /**
     * <p>
     * Returns a list of the members in a network and properties of their configurations.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMembers(software.amazon.awssdk.services.managedblockchain.model.ListMembersRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchain.paginators.ListMembersIterable responses = client.listMembersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.managedblockchain.paginators.ListMembersIterable responses = client
     *             .listMembersPaginator(request);
     *     for (software.amazon.awssdk.services.managedblockchain.model.ListMembersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchain.paginators.ListMembersIterable responses = client.listMembersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMembers(software.amazon.awssdk.services.managedblockchain.model.ListMembersRequest)} operation.</b>
     * </p>
     *
     * @param listMembersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.ListMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListMembers" target="_top">AWS
     *      API Documentation</a>
     */
    default ListMembersIterable listMembersPaginator(ListMembersRequest listMembersRequest) throws InvalidRequestException,
            AccessDeniedException, ThrottlingException, InternalServiceErrorException, AwsServiceException, SdkClientException,
            ManagedBlockchainException {
        return new ListMembersIterable(this, listMembersRequest);
    }

    /**
     * <p>
     * Returns a list of the members in a network and properties of their configurations.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMembers(software.amazon.awssdk.services.managedblockchain.model.ListMembersRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchain.paginators.ListMembersIterable responses = client.listMembersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.managedblockchain.paginators.ListMembersIterable responses = client
     *             .listMembersPaginator(request);
     *     for (software.amazon.awssdk.services.managedblockchain.model.ListMembersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchain.paginators.ListMembersIterable responses = client.listMembersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMembers(software.amazon.awssdk.services.managedblockchain.model.ListMembersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMembersRequest.Builder} avoiding the need to
     * create one manually via {@link ListMembersRequest#builder()}
     * </p>
     *
     * @param listMembersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.managedblockchain.model.ListMembersRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.ListMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListMembers" target="_top">AWS
     *      API Documentation</a>
     */
    default ListMembersIterable listMembersPaginator(Consumer<ListMembersRequest.Builder> listMembersRequest)
            throws InvalidRequestException, AccessDeniedException, ThrottlingException, InternalServiceErrorException,
            AwsServiceException, SdkClientException, ManagedBlockchainException {
        return listMembersPaginator(ListMembersRequest.builder().applyMutation(listMembersRequest).build());
    }

    /**
     * <p>
     * Returns information about the networks in which the current Amazon Web Services account participates.
     * </p>
     * <p>
     * Applies to Hyperledger Fabric and Ethereum.
     * </p>
     *
     * @param listNetworksRequest
     * @return Result of the ListNetworks operation returned by the service.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.ListNetworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListNetworks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNetworksResponse listNetworks(ListNetworksRequest listNetworksRequest) throws InvalidRequestException,
            AccessDeniedException, ThrottlingException, InternalServiceErrorException, AwsServiceException, SdkClientException,
            ManagedBlockchainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the networks in which the current Amazon Web Services account participates.
     * </p>
     * <p>
     * Applies to Hyperledger Fabric and Ethereum.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNetworksRequest.Builder} avoiding the need to
     * create one manually via {@link ListNetworksRequest#builder()}
     * </p>
     *
     * @param listNetworksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.managedblockchain.model.ListNetworksRequest.Builder} to create a
     *        request.
     * @return Result of the ListNetworks operation returned by the service.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.ListNetworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListNetworks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNetworksResponse listNetworks(Consumer<ListNetworksRequest.Builder> listNetworksRequest)
            throws InvalidRequestException, AccessDeniedException, ThrottlingException, InternalServiceErrorException,
            AwsServiceException, SdkClientException, ManagedBlockchainException {
        return listNetworks(ListNetworksRequest.builder().applyMutation(listNetworksRequest).build());
    }

    /**
     * <p>
     * Returns information about the networks in which the current Amazon Web Services account participates.
     * </p>
     * <p>
     * Applies to Hyperledger Fabric and Ethereum.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listNetworks(software.amazon.awssdk.services.managedblockchain.model.ListNetworksRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchain.paginators.ListNetworksIterable responses = client.listNetworksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.managedblockchain.paginators.ListNetworksIterable responses = client
     *             .listNetworksPaginator(request);
     *     for (software.amazon.awssdk.services.managedblockchain.model.ListNetworksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchain.paginators.ListNetworksIterable responses = client.listNetworksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNetworks(software.amazon.awssdk.services.managedblockchain.model.ListNetworksRequest)} operation.</b>
     * </p>
     *
     * @param listNetworksRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.ListNetworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListNetworks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNetworksIterable listNetworksPaginator(ListNetworksRequest listNetworksRequest) throws InvalidRequestException,
            AccessDeniedException, ThrottlingException, InternalServiceErrorException, AwsServiceException, SdkClientException,
            ManagedBlockchainException {
        return new ListNetworksIterable(this, listNetworksRequest);
    }

    /**
     * <p>
     * Returns information about the networks in which the current Amazon Web Services account participates.
     * </p>
     * <p>
     * Applies to Hyperledger Fabric and Ethereum.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listNetworks(software.amazon.awssdk.services.managedblockchain.model.ListNetworksRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchain.paginators.ListNetworksIterable responses = client.listNetworksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.managedblockchain.paginators.ListNetworksIterable responses = client
     *             .listNetworksPaginator(request);
     *     for (software.amazon.awssdk.services.managedblockchain.model.ListNetworksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchain.paginators.ListNetworksIterable responses = client.listNetworksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNetworks(software.amazon.awssdk.services.managedblockchain.model.ListNetworksRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNetworksRequest.Builder} avoiding the need to
     * create one manually via {@link ListNetworksRequest#builder()}
     * </p>
     *
     * @param listNetworksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.managedblockchain.model.ListNetworksRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.ListNetworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListNetworks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNetworksIterable listNetworksPaginator(Consumer<ListNetworksRequest.Builder> listNetworksRequest)
            throws InvalidRequestException, AccessDeniedException, ThrottlingException, InternalServiceErrorException,
            AwsServiceException, SdkClientException, ManagedBlockchainException {
        return listNetworksPaginator(ListNetworksRequest.builder().applyMutation(listNetworksRequest).build());
    }

    /**
     * <p>
     * Returns information about the nodes within a network.
     * </p>
     * <p>
     * Applies to Hyperledger Fabric and Ethereum.
     * </p>
     *
     * @param listNodesRequest
     * @return Result of the ListNodes operation returned by the service.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.ListNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListNodes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListNodesResponse listNodes(ListNodesRequest listNodesRequest) throws InvalidRequestException, AccessDeniedException,
            ThrottlingException, InternalServiceErrorException, AwsServiceException, SdkClientException,
            ManagedBlockchainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the nodes within a network.
     * </p>
     * <p>
     * Applies to Hyperledger Fabric and Ethereum.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNodesRequest.Builder} avoiding the need to
     * create one manually via {@link ListNodesRequest#builder()}
     * </p>
     *
     * @param listNodesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.managedblockchain.model.ListNodesRequest.Builder} to create a
     *        request.
     * @return Result of the ListNodes operation returned by the service.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.ListNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListNodes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListNodesResponse listNodes(Consumer<ListNodesRequest.Builder> listNodesRequest) throws InvalidRequestException,
            AccessDeniedException, ThrottlingException, InternalServiceErrorException, AwsServiceException, SdkClientException,
            ManagedBlockchainException {
        return listNodes(ListNodesRequest.builder().applyMutation(listNodesRequest).build());
    }

    /**
     * <p>
     * Returns information about the nodes within a network.
     * </p>
     * <p>
     * Applies to Hyperledger Fabric and Ethereum.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listNodes(software.amazon.awssdk.services.managedblockchain.model.ListNodesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchain.paginators.ListNodesIterable responses = client.listNodesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.managedblockchain.paginators.ListNodesIterable responses = client.listNodesPaginator(request);
     *     for (software.amazon.awssdk.services.managedblockchain.model.ListNodesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchain.paginators.ListNodesIterable responses = client.listNodesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNodes(software.amazon.awssdk.services.managedblockchain.model.ListNodesRequest)} operation.</b>
     * </p>
     *
     * @param listNodesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.ListNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListNodes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListNodesIterable listNodesPaginator(ListNodesRequest listNodesRequest) throws InvalidRequestException,
            AccessDeniedException, ThrottlingException, InternalServiceErrorException, AwsServiceException, SdkClientException,
            ManagedBlockchainException {
        return new ListNodesIterable(this, listNodesRequest);
    }

    /**
     * <p>
     * Returns information about the nodes within a network.
     * </p>
     * <p>
     * Applies to Hyperledger Fabric and Ethereum.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listNodes(software.amazon.awssdk.services.managedblockchain.model.ListNodesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchain.paginators.ListNodesIterable responses = client.listNodesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.managedblockchain.paginators.ListNodesIterable responses = client.listNodesPaginator(request);
     *     for (software.amazon.awssdk.services.managedblockchain.model.ListNodesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchain.paginators.ListNodesIterable responses = client.listNodesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNodes(software.amazon.awssdk.services.managedblockchain.model.ListNodesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNodesRequest.Builder} avoiding the need to
     * create one manually via {@link ListNodesRequest#builder()}
     * </p>
     *
     * @param listNodesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.managedblockchain.model.ListNodesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.ListNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListNodes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListNodesIterable listNodesPaginator(Consumer<ListNodesRequest.Builder> listNodesRequest)
            throws InvalidRequestException, AccessDeniedException, ThrottlingException, InternalServiceErrorException,
            AwsServiceException, SdkClientException, ManagedBlockchainException {
        return listNodesPaginator(ListNodesRequest.builder().applyMutation(listNodesRequest).build());
    }

    /**
     * <p>
     * Returns the list of votes for a specified proposal, including the value of each vote and the unique identifier of
     * the member that cast the vote.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     *
     * @param listProposalVotesRequest
     * @return Result of the ListProposalVotes operation returned by the service.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.ListProposalVotes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListProposalVotes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProposalVotesResponse listProposalVotes(ListProposalVotesRequest listProposalVotesRequest)
            throws InvalidRequestException, AccessDeniedException, ThrottlingException, InternalServiceErrorException,
            AwsServiceException, SdkClientException, ManagedBlockchainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the list of votes for a specified proposal, including the value of each vote and the unique identifier of
     * the member that cast the vote.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProposalVotesRequest.Builder} avoiding the need
     * to create one manually via {@link ListProposalVotesRequest#builder()}
     * </p>
     *
     * @param listProposalVotesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.managedblockchain.model.ListProposalVotesRequest.Builder} to create
     *        a request.
     * @return Result of the ListProposalVotes operation returned by the service.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.ListProposalVotes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListProposalVotes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProposalVotesResponse listProposalVotes(Consumer<ListProposalVotesRequest.Builder> listProposalVotesRequest)
            throws InvalidRequestException, AccessDeniedException, ThrottlingException, InternalServiceErrorException,
            AwsServiceException, SdkClientException, ManagedBlockchainException {
        return listProposalVotes(ListProposalVotesRequest.builder().applyMutation(listProposalVotesRequest).build());
    }

    /**
     * <p>
     * Returns the list of votes for a specified proposal, including the value of each vote and the unique identifier of
     * the member that cast the vote.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProposalVotes(software.amazon.awssdk.services.managedblockchain.model.ListProposalVotesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchain.paginators.ListProposalVotesIterable responses = client.listProposalVotesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.managedblockchain.paginators.ListProposalVotesIterable responses = client
     *             .listProposalVotesPaginator(request);
     *     for (software.amazon.awssdk.services.managedblockchain.model.ListProposalVotesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchain.paginators.ListProposalVotesIterable responses = client.listProposalVotesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProposalVotes(software.amazon.awssdk.services.managedblockchain.model.ListProposalVotesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listProposalVotesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.ListProposalVotes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListProposalVotes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProposalVotesIterable listProposalVotesPaginator(ListProposalVotesRequest listProposalVotesRequest)
            throws InvalidRequestException, AccessDeniedException, ThrottlingException, InternalServiceErrorException,
            AwsServiceException, SdkClientException, ManagedBlockchainException {
        return new ListProposalVotesIterable(this, listProposalVotesRequest);
    }

    /**
     * <p>
     * Returns the list of votes for a specified proposal, including the value of each vote and the unique identifier of
     * the member that cast the vote.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProposalVotes(software.amazon.awssdk.services.managedblockchain.model.ListProposalVotesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchain.paginators.ListProposalVotesIterable responses = client.listProposalVotesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.managedblockchain.paginators.ListProposalVotesIterable responses = client
     *             .listProposalVotesPaginator(request);
     *     for (software.amazon.awssdk.services.managedblockchain.model.ListProposalVotesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchain.paginators.ListProposalVotesIterable responses = client.listProposalVotesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProposalVotes(software.amazon.awssdk.services.managedblockchain.model.ListProposalVotesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProposalVotesRequest.Builder} avoiding the need
     * to create one manually via {@link ListProposalVotesRequest#builder()}
     * </p>
     *
     * @param listProposalVotesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.managedblockchain.model.ListProposalVotesRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.ListProposalVotes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListProposalVotes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProposalVotesIterable listProposalVotesPaginator(
            Consumer<ListProposalVotesRequest.Builder> listProposalVotesRequest) throws InvalidRequestException,
            AccessDeniedException, ThrottlingException, InternalServiceErrorException, AwsServiceException, SdkClientException,
            ManagedBlockchainException {
        return listProposalVotesPaginator(ListProposalVotesRequest.builder().applyMutation(listProposalVotesRequest).build());
    }

    /**
     * <p>
     * Returns a list of proposals for the network.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     *
     * @param listProposalsRequest
     * @return Result of the ListProposals operation returned by the service.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws ResourceNotFoundException
     *         A requested resource doesn't exist. It may have been deleted or referenced incorrectly.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.ListProposals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListProposals"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProposalsResponse listProposals(ListProposalsRequest listProposalsRequest) throws InvalidRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServiceErrorException,
            AwsServiceException, SdkClientException, ManagedBlockchainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of proposals for the network.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProposalsRequest.Builder} avoiding the need to
     * create one manually via {@link ListProposalsRequest#builder()}
     * </p>
     *
     * @param listProposalsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.managedblockchain.model.ListProposalsRequest.Builder} to create a
     *        request.
     * @return Result of the ListProposals operation returned by the service.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws ResourceNotFoundException
     *         A requested resource doesn't exist. It may have been deleted or referenced incorrectly.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.ListProposals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListProposals"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProposalsResponse listProposals(Consumer<ListProposalsRequest.Builder> listProposalsRequest)
            throws InvalidRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServiceErrorException, AwsServiceException, SdkClientException, ManagedBlockchainException {
        return listProposals(ListProposalsRequest.builder().applyMutation(listProposalsRequest).build());
    }

    /**
     * <p>
     * Returns a list of proposals for the network.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProposals(software.amazon.awssdk.services.managedblockchain.model.ListProposalsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchain.paginators.ListProposalsIterable responses = client.listProposalsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.managedblockchain.paginators.ListProposalsIterable responses = client
     *             .listProposalsPaginator(request);
     *     for (software.amazon.awssdk.services.managedblockchain.model.ListProposalsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchain.paginators.ListProposalsIterable responses = client.listProposalsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProposals(software.amazon.awssdk.services.managedblockchain.model.ListProposalsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listProposalsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws ResourceNotFoundException
     *         A requested resource doesn't exist. It may have been deleted or referenced incorrectly.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.ListProposals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListProposals"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProposalsIterable listProposalsPaginator(ListProposalsRequest listProposalsRequest)
            throws InvalidRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServiceErrorException, AwsServiceException, SdkClientException, ManagedBlockchainException {
        return new ListProposalsIterable(this, listProposalsRequest);
    }

    /**
     * <p>
     * Returns a list of proposals for the network.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProposals(software.amazon.awssdk.services.managedblockchain.model.ListProposalsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchain.paginators.ListProposalsIterable responses = client.listProposalsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.managedblockchain.paginators.ListProposalsIterable responses = client
     *             .listProposalsPaginator(request);
     *     for (software.amazon.awssdk.services.managedblockchain.model.ListProposalsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchain.paginators.ListProposalsIterable responses = client.listProposalsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProposals(software.amazon.awssdk.services.managedblockchain.model.ListProposalsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProposalsRequest.Builder} avoiding the need to
     * create one manually via {@link ListProposalsRequest#builder()}
     * </p>
     *
     * @param listProposalsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.managedblockchain.model.ListProposalsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws ResourceNotFoundException
     *         A requested resource doesn't exist. It may have been deleted or referenced incorrectly.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.ListProposals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListProposals"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProposalsIterable listProposalsPaginator(Consumer<ListProposalsRequest.Builder> listProposalsRequest)
            throws InvalidRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServiceErrorException, AwsServiceException, SdkClientException, ManagedBlockchainException {
        return listProposalsPaginator(ListProposalsRequest.builder().applyMutation(listProposalsRequest).build());
    }

    /**
     * <p>
     * Returns a list of tags for the specified resource. Each tag consists of a key and optional value.
     * </p>
     * <p>
     * For more information about tags, see <a
     * href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging
     * Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a
     * href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html"
     * >Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws ResourceNotFoundException
     *         A requested resource doesn't exist. It may have been deleted or referenced incorrectly.
     * @throws ResourceNotReadyException
     *         The requested resource exists but isn't in a status that can complete the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InternalServiceErrorException, InvalidRequestException, ResourceNotFoundException, ResourceNotReadyException,
            AwsServiceException, SdkClientException, ManagedBlockchainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of tags for the specified resource. Each tag consists of a key and optional value.
     * </p>
     * <p>
     * For more information about tags, see <a
     * href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging
     * Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a
     * href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html"
     * >Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.managedblockchain.model.ListTagsForResourceRequest.Builder} to
     *        create a request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws ResourceNotFoundException
     *         A requested resource doesn't exist. It may have been deleted or referenced incorrectly.
     * @throws ResourceNotReadyException
     *         The requested resource exists but isn't in a status that can complete the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InternalServiceErrorException,
            InvalidRequestException, ResourceNotFoundException, ResourceNotReadyException, AwsServiceException,
            SdkClientException, ManagedBlockchainException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Rejects an invitation to join a network. This action can be called by a principal in an Amazon Web Services
     * account that has received an invitation to create a member and join a network.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     *
     * @param rejectInvitationRequest
     * @return Result of the RejectInvitation operation returned by the service.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws IllegalActionException
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         A requested resource doesn't exist. It may have been deleted or referenced incorrectly.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.RejectInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/RejectInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    default RejectInvitationResponse rejectInvitation(RejectInvitationRequest rejectInvitationRequest)
            throws InvalidRequestException, IllegalActionException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, InternalServiceErrorException, AwsServiceException, SdkClientException,
            ManagedBlockchainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Rejects an invitation to join a network. This action can be called by a principal in an Amazon Web Services
     * account that has received an invitation to create a member and join a network.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RejectInvitationRequest.Builder} avoiding the need
     * to create one manually via {@link RejectInvitationRequest#builder()}
     * </p>
     *
     * @param rejectInvitationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.managedblockchain.model.RejectInvitationRequest.Builder} to create
     *        a request.
     * @return Result of the RejectInvitation operation returned by the service.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws IllegalActionException
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         A requested resource doesn't exist. It may have been deleted or referenced incorrectly.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.RejectInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/RejectInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    default RejectInvitationResponse rejectInvitation(Consumer<RejectInvitationRequest.Builder> rejectInvitationRequest)
            throws InvalidRequestException, IllegalActionException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, InternalServiceErrorException, AwsServiceException, SdkClientException,
            ManagedBlockchainException {
        return rejectInvitation(RejectInvitationRequest.builder().applyMutation(rejectInvitationRequest).build());
    }

    /**
     * <p>
     * Adds or overwrites the specified tags for the specified Amazon Managed Blockchain resource. Each tag consists of
     * a key and optional value.
     * </p>
     * <p>
     * When you specify a tag key that already exists, the tag value is overwritten with the new value. Use
     * <code>UntagResource</code> to remove tag keys.
     * </p>
     * <p>
     * A resource can have up to 50 tags. If you try to create more than 50 tags for a resource, your request fails and
     * returns an error.
     * </p>
     * <p>
     * For more information about tags, see <a
     * href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging
     * Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a
     * href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html"
     * >Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws ResourceNotFoundException
     *         A requested resource doesn't exist. It may have been deleted or referenced incorrectly.
     * @throws TooManyTagsException
     * @throws ResourceNotReadyException
     *         The requested resource exists but isn't in a status that can complete the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServiceErrorException,
            InvalidRequestException, ResourceNotFoundException, TooManyTagsException, ResourceNotReadyException,
            AwsServiceException, SdkClientException, ManagedBlockchainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or overwrites the specified tags for the specified Amazon Managed Blockchain resource. Each tag consists of
     * a key and optional value.
     * </p>
     * <p>
     * When you specify a tag key that already exists, the tag value is overwritten with the new value. Use
     * <code>UntagResource</code> to remove tag keys.
     * </p>
     * <p>
     * A resource can have up to 50 tags. If you try to create more than 50 tags for a resource, your request fails and
     * returns an error.
     * </p>
     * <p>
     * For more information about tags, see <a
     * href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging
     * Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a
     * href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html"
     * >Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.managedblockchain.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws ResourceNotFoundException
     *         A requested resource doesn't exist. It may have been deleted or referenced incorrectly.
     * @throws TooManyTagsException
     * @throws ResourceNotReadyException
     *         The requested resource exists but isn't in a status that can complete the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws InternalServiceErrorException, InvalidRequestException, ResourceNotFoundException, TooManyTagsException,
            ResourceNotReadyException, AwsServiceException, SdkClientException, ManagedBlockchainException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes the specified tags from the Amazon Managed Blockchain resource.
     * </p>
     * <p>
     * For more information about tags, see <a
     * href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging
     * Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a
     * href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html"
     * >Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws ResourceNotFoundException
     *         A requested resource doesn't exist. It may have been deleted or referenced incorrectly.
     * @throws ResourceNotReadyException
     *         The requested resource exists but isn't in a status that can complete the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServiceErrorException,
            InvalidRequestException, ResourceNotFoundException, ResourceNotReadyException, AwsServiceException,
            SdkClientException, ManagedBlockchainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified tags from the Amazon Managed Blockchain resource.
     * </p>
     * <p>
     * For more information about tags, see <a
     * href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging
     * Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a
     * href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html"
     * >Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.managedblockchain.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws ResourceNotFoundException
     *         A requested resource doesn't exist. It may have been deleted or referenced incorrectly.
     * @throws ResourceNotReadyException
     *         The requested resource exists but isn't in a status that can complete the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws InternalServiceErrorException, InvalidRequestException, ResourceNotFoundException, ResourceNotReadyException,
            AwsServiceException, SdkClientException, ManagedBlockchainException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates a member configuration with new parameters.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     *
     * @param updateMemberRequest
     * @return Result of the UpdateMember operation returned by the service.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         A requested resource doesn't exist. It may have been deleted or referenced incorrectly.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.UpdateMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/UpdateMember"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateMemberResponse updateMember(UpdateMemberRequest updateMemberRequest) throws InvalidRequestException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServiceErrorException,
            AwsServiceException, SdkClientException, ManagedBlockchainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a member configuration with new parameters.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateMemberRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateMemberRequest#builder()}
     * </p>
     *
     * @param updateMemberRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.managedblockchain.model.UpdateMemberRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateMember operation returned by the service.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         A requested resource doesn't exist. It may have been deleted or referenced incorrectly.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.UpdateMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/UpdateMember"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateMemberResponse updateMember(Consumer<UpdateMemberRequest.Builder> updateMemberRequest)
            throws InvalidRequestException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServiceErrorException, AwsServiceException, SdkClientException, ManagedBlockchainException {
        return updateMember(UpdateMemberRequest.builder().applyMutation(updateMemberRequest).build());
    }

    /**
     * <p>
     * Updates a node configuration with new parameters.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     *
     * @param updateNodeRequest
     * @return Result of the UpdateNode operation returned by the service.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         A requested resource doesn't exist. It may have been deleted or referenced incorrectly.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.UpdateNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/UpdateNode" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateNodeResponse updateNode(UpdateNodeRequest updateNodeRequest) throws InvalidRequestException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServiceErrorException,
            AwsServiceException, SdkClientException, ManagedBlockchainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a node configuration with new parameters.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateNodeRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateNodeRequest#builder()}
     * </p>
     *
     * @param updateNodeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.managedblockchain.model.UpdateNodeRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateNode operation returned by the service.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         A requested resource doesn't exist. It may have been deleted or referenced incorrectly.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.UpdateNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/UpdateNode" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateNodeResponse updateNode(Consumer<UpdateNodeRequest.Builder> updateNodeRequest) throws InvalidRequestException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServiceErrorException,
            AwsServiceException, SdkClientException, ManagedBlockchainException {
        return updateNode(UpdateNodeRequest.builder().applyMutation(updateNodeRequest).build());
    }

    /**
     * <p>
     * Casts a vote for a specified <code>ProposalId</code> on behalf of a member. The member to vote as, specified by
     * <code>VoterMemberId</code>, must be in the same Amazon Web Services account as the principal that calls the
     * action.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     *
     * @param voteOnProposalRequest
     * @return Result of the VoteOnProposal operation returned by the service.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws IllegalActionException
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         A requested resource doesn't exist. It may have been deleted or referenced incorrectly.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.VoteOnProposal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/VoteOnProposal"
     *      target="_top">AWS API Documentation</a>
     */
    default VoteOnProposalResponse voteOnProposal(VoteOnProposalRequest voteOnProposalRequest) throws InvalidRequestException,
            IllegalActionException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServiceErrorException, AwsServiceException, SdkClientException, ManagedBlockchainException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Casts a vote for a specified <code>ProposalId</code> on behalf of a member. The member to vote as, specified by
     * <code>VoterMemberId</code>, must be in the same Amazon Web Services account as the principal that calls the
     * action.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link VoteOnProposalRequest.Builder} avoiding the need to
     * create one manually via {@link VoteOnProposalRequest#builder()}
     * </p>
     *
     * @param voteOnProposalRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.managedblockchain.model.VoteOnProposalRequest.Builder} to create a
     *        request.
     * @return Result of the VoteOnProposal operation returned by the service.
     * @throws InvalidRequestException
     *         The action or operation requested is invalid. Verify that the action is typed correctly.
     * @throws IllegalActionException
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         A requested resource doesn't exist. It may have been deleted or referenced incorrectly.
     * @throws ThrottlingException
     *         The request or operation couldn't be performed because a service is throttling requests. The most common
     *         source of throttling errors is creating resources that exceed your service limit for this resource type.
     *         Request a limit increase or delete unused resources if possible.
     * @throws InternalServiceErrorException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ManagedBlockchainException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ManagedBlockchainClient.VoteOnProposal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/VoteOnProposal"
     *      target="_top">AWS API Documentation</a>
     */
    default VoteOnProposalResponse voteOnProposal(Consumer<VoteOnProposalRequest.Builder> voteOnProposalRequest)
            throws InvalidRequestException, IllegalActionException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, InternalServiceErrorException, AwsServiceException, SdkClientException,
            ManagedBlockchainException {
        return voteOnProposal(VoteOnProposalRequest.builder().applyMutation(voteOnProposalRequest).build());
    }

    /**
     * Create a {@link ManagedBlockchainClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ManagedBlockchainClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ManagedBlockchainClient}.
     */
    static ManagedBlockchainClientBuilder builder() {
        return new DefaultManagedBlockchainClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default ManagedBlockchainServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
