/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetContainerServiceDeploymentsResponse extends LightsailResponse implements
        ToCopyableBuilder<GetContainerServiceDeploymentsResponse.Builder, GetContainerServiceDeploymentsResponse> {
    private static final SdkField<List<ContainerServiceDeployment>> DEPLOYMENTS_FIELD = SdkField
            .<List<ContainerServiceDeployment>> builder(MarshallingType.LIST)
            .memberName("deployments")
            .getter(getter(GetContainerServiceDeploymentsResponse::deployments))
            .setter(setter(Builder::deployments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deployments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ContainerServiceDeployment> builder(MarshallingType.SDK_POJO)
                                            .constructor(ContainerServiceDeployment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENTS_FIELD));

    private final List<ContainerServiceDeployment> deployments;

    private GetContainerServiceDeploymentsResponse(BuilderImpl builder) {
        super(builder);
        this.deployments = builder.deployments;
    }

    /**
     * For responses, this returns true if the service returned a value for the Deployments property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDeployments() {
        return deployments != null && !(deployments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that describe deployments for a container service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeployments} method.
     * </p>
     * 
     * @return An array of objects that describe deployments for a container service.
     */
    public final List<ContainerServiceDeployment> deployments() {
        return deployments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDeployments() ? deployments() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetContainerServiceDeploymentsResponse)) {
            return false;
        }
        GetContainerServiceDeploymentsResponse other = (GetContainerServiceDeploymentsResponse) obj;
        return hasDeployments() == other.hasDeployments() && Objects.equals(deployments(), other.deployments());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetContainerServiceDeploymentsResponse")
                .add("Deployments", hasDeployments() ? deployments() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deployments":
            return Optional.ofNullable(clazz.cast(deployments()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetContainerServiceDeploymentsResponse, T> g) {
        return obj -> g.apply((GetContainerServiceDeploymentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetContainerServiceDeploymentsResponse> {
        /**
         * <p>
         * An array of objects that describe deployments for a container service.
         * </p>
         * 
         * @param deployments
         *        An array of objects that describe deployments for a container service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deployments(Collection<ContainerServiceDeployment> deployments);

        /**
         * <p>
         * An array of objects that describe deployments for a container service.
         * </p>
         * 
         * @param deployments
         *        An array of objects that describe deployments for a container service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deployments(ContainerServiceDeployment... deployments);

        /**
         * <p>
         * An array of objects that describe deployments for a container service.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lightsail.model.ContainerServiceDeployment.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.lightsail.model.ContainerServiceDeployment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lightsail.model.ContainerServiceDeployment.Builder#build()} is called
         * immediately and its result is passed to {@link #deployments(List<ContainerServiceDeployment>)}.
         * 
         * @param deployments
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lightsail.model.ContainerServiceDeployment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deployments(java.util.Collection<ContainerServiceDeployment>)
         */
        Builder deployments(Consumer<ContainerServiceDeployment.Builder>... deployments);
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private List<ContainerServiceDeployment> deployments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetContainerServiceDeploymentsResponse model) {
            super(model);
            deployments(model.deployments);
        }

        public final List<ContainerServiceDeployment.Builder> getDeployments() {
            List<ContainerServiceDeployment.Builder> result = ContainerServiceDeploymentListCopier
                    .copyToBuilder(this.deployments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeployments(Collection<ContainerServiceDeployment.BuilderImpl> deployments) {
            this.deployments = ContainerServiceDeploymentListCopier.copyFromBuilder(deployments);
        }

        @Override
        public final Builder deployments(Collection<ContainerServiceDeployment> deployments) {
            this.deployments = ContainerServiceDeploymentListCopier.copy(deployments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deployments(ContainerServiceDeployment... deployments) {
            deployments(Arrays.asList(deployments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deployments(Consumer<ContainerServiceDeployment.Builder>... deployments) {
            deployments(Stream.of(deployments).map(c -> ContainerServiceDeployment.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetContainerServiceDeploymentsResponse build() {
            return new GetContainerServiceDeploymentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
