/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a request to enable, modify, or disable an add-on for an Amazon Lightsail resource.
 * </p>
 * <note>
 * <p>
 * An additional cost may be associated with enabling add-ons. For more information, see the <a
 * href="https://aws.amazon.com/lightsail/pricing/">Lightsail pricing page</a>.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddOnRequest implements SdkPojo, Serializable, ToCopyableBuilder<AddOnRequest.Builder, AddOnRequest> {
    private static final SdkField<String> ADD_ON_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("addOnType").getter(getter(AddOnRequest::addOnTypeAsString)).setter(setter(Builder::addOnType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addOnType").build()).build();

    private static final SdkField<AutoSnapshotAddOnRequest> AUTO_SNAPSHOT_ADD_ON_REQUEST_FIELD = SdkField
            .<AutoSnapshotAddOnRequest> builder(MarshallingType.SDK_POJO).memberName("autoSnapshotAddOnRequest")
            .getter(getter(AddOnRequest::autoSnapshotAddOnRequest)).setter(setter(Builder::autoSnapshotAddOnRequest))
            .constructor(AutoSnapshotAddOnRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoSnapshotAddOnRequest").build())
            .build();

    private static final SdkField<StopInstanceOnIdleRequest> STOP_INSTANCE_ON_IDLE_REQUEST_FIELD = SdkField
            .<StopInstanceOnIdleRequest> builder(MarshallingType.SDK_POJO).memberName("stopInstanceOnIdleRequest")
            .getter(getter(AddOnRequest::stopInstanceOnIdleRequest)).setter(setter(Builder::stopInstanceOnIdleRequest))
            .constructor(StopInstanceOnIdleRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopInstanceOnIdleRequest").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADD_ON_TYPE_FIELD,
            AUTO_SNAPSHOT_ADD_ON_REQUEST_FIELD, STOP_INSTANCE_ON_IDLE_REQUEST_FIELD));

    private static final long serialVersionUID = 1L;

    private final String addOnType;

    private final AutoSnapshotAddOnRequest autoSnapshotAddOnRequest;

    private final StopInstanceOnIdleRequest stopInstanceOnIdleRequest;

    private AddOnRequest(BuilderImpl builder) {
        this.addOnType = builder.addOnType;
        this.autoSnapshotAddOnRequest = builder.autoSnapshotAddOnRequest;
        this.stopInstanceOnIdleRequest = builder.stopInstanceOnIdleRequest;
    }

    /**
     * <p>
     * The add-on type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #addOnType} will
     * return {@link AddOnType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #addOnTypeAsString}.
     * </p>
     * 
     * @return The add-on type.
     * @see AddOnType
     */
    public final AddOnType addOnType() {
        return AddOnType.fromValue(addOnType);
    }

    /**
     * <p>
     * The add-on type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #addOnType} will
     * return {@link AddOnType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #addOnTypeAsString}.
     * </p>
     * 
     * @return The add-on type.
     * @see AddOnType
     */
    public final String addOnTypeAsString() {
        return addOnType;
    }

    /**
     * <p>
     * An object that represents additional parameters when enabling or modifying the automatic snapshot add-on.
     * </p>
     * 
     * @return An object that represents additional parameters when enabling or modifying the automatic snapshot add-on.
     */
    public final AutoSnapshotAddOnRequest autoSnapshotAddOnRequest() {
        return autoSnapshotAddOnRequest;
    }

    /**
     * <p>
     * An object that represents additional parameters when enabling or modifying the <code>StopInstanceOnIdle</code>
     * add-on.
     * </p>
     * <important>
     * <p>
     * This object only applies to Lightsail for Research resources.
     * </p>
     * </important>
     * 
     * @return An object that represents additional parameters when enabling or modifying the
     *         <code>StopInstanceOnIdle</code> add-on.</p> <important>
     *         <p>
     *         This object only applies to Lightsail for Research resources.
     *         </p>
     */
    public final StopInstanceOnIdleRequest stopInstanceOnIdleRequest() {
        return stopInstanceOnIdleRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(addOnTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(autoSnapshotAddOnRequest());
        hashCode = 31 * hashCode + Objects.hashCode(stopInstanceOnIdleRequest());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddOnRequest)) {
            return false;
        }
        AddOnRequest other = (AddOnRequest) obj;
        return Objects.equals(addOnTypeAsString(), other.addOnTypeAsString())
                && Objects.equals(autoSnapshotAddOnRequest(), other.autoSnapshotAddOnRequest())
                && Objects.equals(stopInstanceOnIdleRequest(), other.stopInstanceOnIdleRequest());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AddOnRequest").add("AddOnType", addOnTypeAsString())
                .add("AutoSnapshotAddOnRequest", autoSnapshotAddOnRequest())
                .add("StopInstanceOnIdleRequest", stopInstanceOnIdleRequest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "addOnType":
            return Optional.ofNullable(clazz.cast(addOnTypeAsString()));
        case "autoSnapshotAddOnRequest":
            return Optional.ofNullable(clazz.cast(autoSnapshotAddOnRequest()));
        case "stopInstanceOnIdleRequest":
            return Optional.ofNullable(clazz.cast(stopInstanceOnIdleRequest()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddOnRequest, T> g) {
        return obj -> g.apply((AddOnRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AddOnRequest> {
        /**
         * <p>
         * The add-on type.
         * </p>
         * 
         * @param addOnType
         *        The add-on type.
         * @see AddOnType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AddOnType
         */
        Builder addOnType(String addOnType);

        /**
         * <p>
         * The add-on type.
         * </p>
         * 
         * @param addOnType
         *        The add-on type.
         * @see AddOnType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AddOnType
         */
        Builder addOnType(AddOnType addOnType);

        /**
         * <p>
         * An object that represents additional parameters when enabling or modifying the automatic snapshot add-on.
         * </p>
         * 
         * @param autoSnapshotAddOnRequest
         *        An object that represents additional parameters when enabling or modifying the automatic snapshot
         *        add-on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoSnapshotAddOnRequest(AutoSnapshotAddOnRequest autoSnapshotAddOnRequest);

        /**
         * <p>
         * An object that represents additional parameters when enabling or modifying the automatic snapshot add-on.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoSnapshotAddOnRequest.Builder}
         * avoiding the need to create one manually via {@link AutoSnapshotAddOnRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoSnapshotAddOnRequest.Builder#build()} is called immediately
         * and its result is passed to {@link #autoSnapshotAddOnRequest(AutoSnapshotAddOnRequest)}.
         * 
         * @param autoSnapshotAddOnRequest
         *        a consumer that will call methods on {@link AutoSnapshotAddOnRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoSnapshotAddOnRequest(AutoSnapshotAddOnRequest)
         */
        default Builder autoSnapshotAddOnRequest(Consumer<AutoSnapshotAddOnRequest.Builder> autoSnapshotAddOnRequest) {
            return autoSnapshotAddOnRequest(AutoSnapshotAddOnRequest.builder().applyMutation(autoSnapshotAddOnRequest).build());
        }

        /**
         * <p>
         * An object that represents additional parameters when enabling or modifying the
         * <code>StopInstanceOnIdle</code> add-on.
         * </p>
         * <important>
         * <p>
         * This object only applies to Lightsail for Research resources.
         * </p>
         * </important>
         * 
         * @param stopInstanceOnIdleRequest
         *        An object that represents additional parameters when enabling or modifying the
         *        <code>StopInstanceOnIdle</code> add-on.</p> <important>
         *        <p>
         *        This object only applies to Lightsail for Research resources.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopInstanceOnIdleRequest(StopInstanceOnIdleRequest stopInstanceOnIdleRequest);

        /**
         * <p>
         * An object that represents additional parameters when enabling or modifying the
         * <code>StopInstanceOnIdle</code> add-on.
         * </p>
         * <important>
         * <p>
         * This object only applies to Lightsail for Research resources.
         * </p>
         * </important> This is a convenience method that creates an instance of the
         * {@link StopInstanceOnIdleRequest.Builder} avoiding the need to create one manually via
         * {@link StopInstanceOnIdleRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StopInstanceOnIdleRequest.Builder#build()} is called immediately
         * and its result is passed to {@link #stopInstanceOnIdleRequest(StopInstanceOnIdleRequest)}.
         * 
         * @param stopInstanceOnIdleRequest
         *        a consumer that will call methods on {@link StopInstanceOnIdleRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stopInstanceOnIdleRequest(StopInstanceOnIdleRequest)
         */
        default Builder stopInstanceOnIdleRequest(Consumer<StopInstanceOnIdleRequest.Builder> stopInstanceOnIdleRequest) {
            return stopInstanceOnIdleRequest(StopInstanceOnIdleRequest.builder().applyMutation(stopInstanceOnIdleRequest).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String addOnType;

        private AutoSnapshotAddOnRequest autoSnapshotAddOnRequest;

        private StopInstanceOnIdleRequest stopInstanceOnIdleRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(AddOnRequest model) {
            addOnType(model.addOnType);
            autoSnapshotAddOnRequest(model.autoSnapshotAddOnRequest);
            stopInstanceOnIdleRequest(model.stopInstanceOnIdleRequest);
        }

        public final String getAddOnType() {
            return addOnType;
        }

        public final void setAddOnType(String addOnType) {
            this.addOnType = addOnType;
        }

        @Override
        public final Builder addOnType(String addOnType) {
            this.addOnType = addOnType;
            return this;
        }

        @Override
        public final Builder addOnType(AddOnType addOnType) {
            this.addOnType(addOnType == null ? null : addOnType.toString());
            return this;
        }

        public final AutoSnapshotAddOnRequest.Builder getAutoSnapshotAddOnRequest() {
            return autoSnapshotAddOnRequest != null ? autoSnapshotAddOnRequest.toBuilder() : null;
        }

        public final void setAutoSnapshotAddOnRequest(AutoSnapshotAddOnRequest.BuilderImpl autoSnapshotAddOnRequest) {
            this.autoSnapshotAddOnRequest = autoSnapshotAddOnRequest != null ? autoSnapshotAddOnRequest.build() : null;
        }

        @Override
        public final Builder autoSnapshotAddOnRequest(AutoSnapshotAddOnRequest autoSnapshotAddOnRequest) {
            this.autoSnapshotAddOnRequest = autoSnapshotAddOnRequest;
            return this;
        }

        public final StopInstanceOnIdleRequest.Builder getStopInstanceOnIdleRequest() {
            return stopInstanceOnIdleRequest != null ? stopInstanceOnIdleRequest.toBuilder() : null;
        }

        public final void setStopInstanceOnIdleRequest(StopInstanceOnIdleRequest.BuilderImpl stopInstanceOnIdleRequest) {
            this.stopInstanceOnIdleRequest = stopInstanceOnIdleRequest != null ? stopInstanceOnIdleRequest.build() : null;
        }

        @Override
        public final Builder stopInstanceOnIdleRequest(StopInstanceOnIdleRequest stopInstanceOnIdleRequest) {
            this.stopInstanceOnIdleRequest = stopInstanceOnIdleRequest;
            return this;
        }

        @Override
        public AddOnRequest build() {
            return new AddOnRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
