/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLicenseConversionTaskForResourceRequest extends LicenseManagerRequest implements
        ToCopyableBuilder<CreateLicenseConversionTaskForResourceRequest.Builder, CreateLicenseConversionTaskForResourceRequest> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(CreateLicenseConversionTaskForResourceRequest::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<LicenseConversionContext> SOURCE_LICENSE_CONTEXT_FIELD = SdkField
            .<LicenseConversionContext> builder(MarshallingType.SDK_POJO).memberName("SourceLicenseContext")
            .getter(getter(CreateLicenseConversionTaskForResourceRequest::sourceLicenseContext))
            .setter(setter(Builder::sourceLicenseContext)).constructor(LicenseConversionContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceLicenseContext").build())
            .build();

    private static final SdkField<LicenseConversionContext> DESTINATION_LICENSE_CONTEXT_FIELD = SdkField
            .<LicenseConversionContext> builder(MarshallingType.SDK_POJO).memberName("DestinationLicenseContext")
            .getter(getter(CreateLicenseConversionTaskForResourceRequest::destinationLicenseContext))
            .setter(setter(Builder::destinationLicenseContext)).constructor(LicenseConversionContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationLicenseContext").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD,
            SOURCE_LICENSE_CONTEXT_FIELD, DESTINATION_LICENSE_CONTEXT_FIELD));

    private final String resourceArn;

    private final LicenseConversionContext sourceLicenseContext;

    private final LicenseConversionContext destinationLicenseContext;

    private CreateLicenseConversionTaskForResourceRequest(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.sourceLicenseContext = builder.sourceLicenseContext;
        this.destinationLicenseContext = builder.destinationLicenseContext;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the resource you are converting the license type for.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the resource you are converting the license type for.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * Information that identifies the license type you are converting from. For the structure of the source license,
     * see <a
     * href="https://docs.aws.amazon.com/license-manager/latest/userguide/conversion-procedures.html#conversion-cli"
     * >Convert a license type using the CLI </a> in the <i>License Manager User Guide</i>.
     * </p>
     * 
     * @return Information that identifies the license type you are converting from. For the structure of the source
     *         license, see <a href=
     *         "https://docs.aws.amazon.com/license-manager/latest/userguide/conversion-procedures.html#conversion-cli"
     *         >Convert a license type using the CLI </a> in the <i>License Manager User Guide</i>.
     */
    public final LicenseConversionContext sourceLicenseContext() {
        return sourceLicenseContext;
    }

    /**
     * <p>
     * Information that identifies the license type you are converting to. For the structure of the destination license,
     * see <a
     * href="https://docs.aws.amazon.com/license-manager/latest/userguide/conversion-procedures.html#conversion-cli"
     * >Convert a license type using the CLI </a> in the <i>License Manager User Guide</i>.
     * </p>
     * 
     * @return Information that identifies the license type you are converting to. For the structure of the destination
     *         license, see <a href=
     *         "https://docs.aws.amazon.com/license-manager/latest/userguide/conversion-procedures.html#conversion-cli"
     *         >Convert a license type using the CLI </a> in the <i>License Manager User Guide</i>.
     */
    public final LicenseConversionContext destinationLicenseContext() {
        return destinationLicenseContext;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(sourceLicenseContext());
        hashCode = 31 * hashCode + Objects.hashCode(destinationLicenseContext());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLicenseConversionTaskForResourceRequest)) {
            return false;
        }
        CreateLicenseConversionTaskForResourceRequest other = (CreateLicenseConversionTaskForResourceRequest) obj;
        return Objects.equals(resourceArn(), other.resourceArn())
                && Objects.equals(sourceLicenseContext(), other.sourceLicenseContext())
                && Objects.equals(destinationLicenseContext(), other.destinationLicenseContext());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateLicenseConversionTaskForResourceRequest").add("ResourceArn", resourceArn())
                .add("SourceLicenseContext", sourceLicenseContext())
                .add("DestinationLicenseContext", destinationLicenseContext()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "SourceLicenseContext":
            return Optional.ofNullable(clazz.cast(sourceLicenseContext()));
        case "DestinationLicenseContext":
            return Optional.ofNullable(clazz.cast(destinationLicenseContext()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLicenseConversionTaskForResourceRequest, T> g) {
        return obj -> g.apply((CreateLicenseConversionTaskForResourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LicenseManagerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateLicenseConversionTaskForResourceRequest> {
        /**
         * <p>
         * Amazon Resource Name (ARN) of the resource you are converting the license type for.
         * </p>
         * 
         * @param resourceArn
         *        Amazon Resource Name (ARN) of the resource you are converting the license type for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * Information that identifies the license type you are converting from. For the structure of the source
         * license, see <a href=
         * "https://docs.aws.amazon.com/license-manager/latest/userguide/conversion-procedures.html#conversion-cli"
         * >Convert a license type using the CLI </a> in the <i>License Manager User Guide</i>.
         * </p>
         * 
         * @param sourceLicenseContext
         *        Information that identifies the license type you are converting from. For the structure of the source
         *        license, see <a href=
         *        "https://docs.aws.amazon.com/license-manager/latest/userguide/conversion-procedures.html#conversion-cli"
         *        >Convert a license type using the CLI </a> in the <i>License Manager User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceLicenseContext(LicenseConversionContext sourceLicenseContext);

        /**
         * <p>
         * Information that identifies the license type you are converting from. For the structure of the source
         * license, see <a href=
         * "https://docs.aws.amazon.com/license-manager/latest/userguide/conversion-procedures.html#conversion-cli"
         * >Convert a license type using the CLI </a> in the <i>License Manager User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link LicenseConversionContext.Builder}
         * avoiding the need to create one manually via {@link LicenseConversionContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LicenseConversionContext.Builder#build()} is called immediately
         * and its result is passed to {@link #sourceLicenseContext(LicenseConversionContext)}.
         * 
         * @param sourceLicenseContext
         *        a consumer that will call methods on {@link LicenseConversionContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceLicenseContext(LicenseConversionContext)
         */
        default Builder sourceLicenseContext(Consumer<LicenseConversionContext.Builder> sourceLicenseContext) {
            return sourceLicenseContext(LicenseConversionContext.builder().applyMutation(sourceLicenseContext).build());
        }

        /**
         * <p>
         * Information that identifies the license type you are converting to. For the structure of the destination
         * license, see <a href=
         * "https://docs.aws.amazon.com/license-manager/latest/userguide/conversion-procedures.html#conversion-cli"
         * >Convert a license type using the CLI </a> in the <i>License Manager User Guide</i>.
         * </p>
         * 
         * @param destinationLicenseContext
         *        Information that identifies the license type you are converting to. For the structure of the
         *        destination license, see <a href=
         *        "https://docs.aws.amazon.com/license-manager/latest/userguide/conversion-procedures.html#conversion-cli"
         *        >Convert a license type using the CLI </a> in the <i>License Manager User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationLicenseContext(LicenseConversionContext destinationLicenseContext);

        /**
         * <p>
         * Information that identifies the license type you are converting to. For the structure of the destination
         * license, see <a href=
         * "https://docs.aws.amazon.com/license-manager/latest/userguide/conversion-procedures.html#conversion-cli"
         * >Convert a license type using the CLI </a> in the <i>License Manager User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link LicenseConversionContext.Builder}
         * avoiding the need to create one manually via {@link LicenseConversionContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LicenseConversionContext.Builder#build()} is called immediately
         * and its result is passed to {@link #destinationLicenseContext(LicenseConversionContext)}.
         * 
         * @param destinationLicenseContext
         *        a consumer that will call methods on {@link LicenseConversionContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationLicenseContext(LicenseConversionContext)
         */
        default Builder destinationLicenseContext(Consumer<LicenseConversionContext.Builder> destinationLicenseContext) {
            return destinationLicenseContext(LicenseConversionContext.builder().applyMutation(destinationLicenseContext).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LicenseManagerRequest.BuilderImpl implements Builder {
        private String resourceArn;

        private LicenseConversionContext sourceLicenseContext;

        private LicenseConversionContext destinationLicenseContext;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLicenseConversionTaskForResourceRequest model) {
            super(model);
            resourceArn(model.resourceArn);
            sourceLicenseContext(model.sourceLicenseContext);
            destinationLicenseContext(model.destinationLicenseContext);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final LicenseConversionContext.Builder getSourceLicenseContext() {
            return sourceLicenseContext != null ? sourceLicenseContext.toBuilder() : null;
        }

        public final void setSourceLicenseContext(LicenseConversionContext.BuilderImpl sourceLicenseContext) {
            this.sourceLicenseContext = sourceLicenseContext != null ? sourceLicenseContext.build() : null;
        }

        @Override
        public final Builder sourceLicenseContext(LicenseConversionContext sourceLicenseContext) {
            this.sourceLicenseContext = sourceLicenseContext;
            return this;
        }

        public final LicenseConversionContext.Builder getDestinationLicenseContext() {
            return destinationLicenseContext != null ? destinationLicenseContext.toBuilder() : null;
        }

        public final void setDestinationLicenseContext(LicenseConversionContext.BuilderImpl destinationLicenseContext) {
            this.destinationLicenseContext = destinationLicenseContext != null ? destinationLicenseContext.build() : null;
        }

        @Override
        public final Builder destinationLicenseContext(LicenseConversionContext destinationLicenseContext) {
            this.destinationLicenseContext = destinationLicenseContext;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLicenseConversionTaskForResourceRequest build() {
            return new CreateLicenseConversionTaskForResourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
