/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListScramSecretsResponse extends KafkaResponse implements
        ToCopyableBuilder<ListScramSecretsResponse.Builder, ListScramSecretsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListScramSecretsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<String>> SECRET_ARN_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecretArnList")
            .getter(getter(ListScramSecretsResponse::secretArnList))
            .setter(setter(Builder::secretArnList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretArnList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            SECRET_ARN_LIST_FIELD));

    private final String nextToken;

    private final List<String> secretArnList;

    private ListScramSecretsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.secretArnList = builder.secretArnList;
    }

    /**
     *
     * <p>
     * Paginated results marker.
     * </p>
     * 
     * @return <p>
     *         Paginated results marker.
     *         </p>
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecretArnList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecretArnList() {
        return secretArnList != null && !(secretArnList instanceof SdkAutoConstructList);
    }

    /**
     *
     * <p>
     * The list of scram secrets associated with the cluster.
     * </p>
     * 
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecretArnList} method.
     * </p>
     * 
     * @return <p>
     *         The list of scram secrets associated with the cluster.
     *         </p>
     */
    public final List<String> secretArnList() {
        return secretArnList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecretArnList() ? secretArnList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListScramSecretsResponse)) {
            return false;
        }
        ListScramSecretsResponse other = (ListScramSecretsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasSecretArnList() == other.hasSecretArnList()
                && Objects.equals(secretArnList(), other.secretArnList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListScramSecretsResponse").add("NextToken", nextToken())
                .add("SecretArnList", hasSecretArnList() ? secretArnList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "SecretArnList":
            return Optional.ofNullable(clazz.cast(secretArnList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListScramSecretsResponse, T> g) {
        return obj -> g.apply((ListScramSecretsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KafkaResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListScramSecretsResponse> {
        /**
         *
         * <p>
         * Paginated results marker.
         * </p>
         * 
         * @param nextToken
         *        <p>
         *        Paginated results marker.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         *
         * <p>
         * The list of scram secrets associated with the cluster.
         * </p>
         * 
         * @param secretArnList
         *        <p>
         *        The list of scram secrets associated with the cluster.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretArnList(Collection<String> secretArnList);

        /**
         *
         * <p>
         * The list of scram secrets associated with the cluster.
         * </p>
         * 
         * @param secretArnList
         *        <p>
         *        The list of scram secrets associated with the cluster.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretArnList(String... secretArnList);
    }

    static final class BuilderImpl extends KafkaResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<String> secretArnList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListScramSecretsResponse model) {
            super(model);
            nextToken(model.nextToken);
            secretArnList(model.secretArnList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Collection<String> getSecretArnList() {
            if (secretArnList instanceof SdkAutoConstructList) {
                return null;
            }
            return secretArnList;
        }

        public final void setSecretArnList(Collection<String> secretArnList) {
            this.secretArnList = ___listOf__stringCopier.copy(secretArnList);
        }

        @Override
        public final Builder secretArnList(Collection<String> secretArnList) {
            this.secretArnList = ___listOf__stringCopier.copy(secretArnList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secretArnList(String... secretArnList) {
            secretArnList(Arrays.asList(secretArnList));
            return this;
        }

        @Override
        public ListScramSecretsResponse build() {
            return new ListScramSecretsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
