/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An activity that runs a Lambda function to modify the message.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LambdaActivity implements SdkPojo, Serializable, ToCopyableBuilder<LambdaActivity.Builder, LambdaActivity> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(LambdaActivity::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> LAMBDA_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lambdaName").getter(getter(LambdaActivity::lambdaName)).setter(setter(Builder::lambdaName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaName").build()).build();

    private static final SdkField<Integer> BATCH_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("batchSize").getter(getter(LambdaActivity::batchSize)).setter(setter(Builder::batchSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("batchSize").build()).build();

    private static final SdkField<String> NEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("next")
            .getter(getter(LambdaActivity::next)).setter(setter(Builder::next))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("next").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, LAMBDA_NAME_FIELD,
            BATCH_SIZE_FIELD, NEXT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String lambdaName;

    private final Integer batchSize;

    private final String next;

    private LambdaActivity(BuilderImpl builder) {
        this.name = builder.name;
        this.lambdaName = builder.lambdaName;
        this.batchSize = builder.batchSize;
        this.next = builder.next;
    }

    /**
     * <p>
     * The name of the lambda activity.
     * </p>
     * 
     * @return The name of the lambda activity.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The name of the Lambda function that is run on the message.
     * </p>
     * 
     * @return The name of the Lambda function that is run on the message.
     */
    public final String lambdaName() {
        return lambdaName;
    }

    /**
     * <p>
     * The number of messages passed to the Lambda function for processing.
     * </p>
     * <p>
     * The Lambda function must be able to process all of these messages within five minutes, which is the maximum
     * timeout duration for Lambda functions.
     * </p>
     * 
     * @return The number of messages passed to the Lambda function for processing.</p>
     *         <p>
     *         The Lambda function must be able to process all of these messages within five minutes, which is the
     *         maximum timeout duration for Lambda functions.
     */
    public final Integer batchSize() {
        return batchSize;
    }

    /**
     * <p>
     * The next activity in the pipeline.
     * </p>
     * 
     * @return The next activity in the pipeline.
     */
    public final String next() {
        return next;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaName());
        hashCode = 31 * hashCode + Objects.hashCode(batchSize());
        hashCode = 31 * hashCode + Objects.hashCode(next());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaActivity)) {
            return false;
        }
        LambdaActivity other = (LambdaActivity) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(lambdaName(), other.lambdaName())
                && Objects.equals(batchSize(), other.batchSize()) && Objects.equals(next(), other.next());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LambdaActivity").add("Name", name()).add("LambdaName", lambdaName())
                .add("BatchSize", batchSize()).add("Next", next()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "lambdaName":
            return Optional.ofNullable(clazz.cast(lambdaName()));
        case "batchSize":
            return Optional.ofNullable(clazz.cast(batchSize()));
        case "next":
            return Optional.ofNullable(clazz.cast(next()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LambdaActivity, T> g) {
        return obj -> g.apply((LambdaActivity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LambdaActivity> {
        /**
         * <p>
         * The name of the lambda activity.
         * </p>
         * 
         * @param name
         *        The name of the lambda activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the Lambda function that is run on the message.
         * </p>
         * 
         * @param lambdaName
         *        The name of the Lambda function that is run on the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaName(String lambdaName);

        /**
         * <p>
         * The number of messages passed to the Lambda function for processing.
         * </p>
         * <p>
         * The Lambda function must be able to process all of these messages within five minutes, which is the maximum
         * timeout duration for Lambda functions.
         * </p>
         * 
         * @param batchSize
         *        The number of messages passed to the Lambda function for processing.</p>
         *        <p>
         *        The Lambda function must be able to process all of these messages within five minutes, which is the
         *        maximum timeout duration for Lambda functions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchSize(Integer batchSize);

        /**
         * <p>
         * The next activity in the pipeline.
         * </p>
         * 
         * @param next
         *        The next activity in the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder next(String next);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String lambdaName;

        private Integer batchSize;

        private String next;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaActivity model) {
            name(model.name);
            lambdaName(model.lambdaName);
            batchSize(model.batchSize);
            next(model.next);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getLambdaName() {
            return lambdaName;
        }

        public final void setLambdaName(String lambdaName) {
            this.lambdaName = lambdaName;
        }

        @Override
        public final Builder lambdaName(String lambdaName) {
            this.lambdaName = lambdaName;
            return this;
        }

        public final Integer getBatchSize() {
            return batchSize;
        }

        public final void setBatchSize(Integer batchSize) {
            this.batchSize = batchSize;
        }

        @Override
        public final Builder batchSize(Integer batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public final String getNext() {
            return next;
        }

        public final void setNext(String next) {
            this.next = next;
        }

        @Override
        public final Builder next(String next) {
            this.next = next;
            return this;
        }

        @Override
        public LambdaActivity build() {
            return new LambdaActivity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
