/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of information about a data store.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatastoreSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<DatastoreSummary.Builder, DatastoreSummary> {
    private static final SdkField<String> DATASTORE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datastoreName").getter(getter(DatastoreSummary::datastoreName)).setter(setter(Builder::datastoreName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datastoreName").build()).build();

    private static final SdkField<DatastoreStorageSummary> DATASTORE_STORAGE_FIELD = SdkField
            .<DatastoreStorageSummary> builder(MarshallingType.SDK_POJO).memberName("datastoreStorage")
            .getter(getter(DatastoreSummary::datastoreStorage)).setter(setter(Builder::datastoreStorage))
            .constructor(DatastoreStorageSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datastoreStorage").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DatastoreSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(DatastoreSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdateTime").getter(getter(DatastoreSummary::lastUpdateTime))
            .setter(setter(Builder::lastUpdateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateTime").build()).build();

    private static final SdkField<Instant> LAST_MESSAGE_ARRIVAL_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastMessageArrivalTime").getter(getter(DatastoreSummary::lastMessageArrivalTime))
            .setter(setter(Builder::lastMessageArrivalTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastMessageArrivalTime").build())
            .build();

    private static final SdkField<String> FILE_FORMAT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fileFormatType").getter(getter(DatastoreSummary::fileFormatTypeAsString))
            .setter(setter(Builder::fileFormatType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileFormatType").build()).build();

    private static final SdkField<DatastorePartitions> DATASTORE_PARTITIONS_FIELD = SdkField
            .<DatastorePartitions> builder(MarshallingType.SDK_POJO).memberName("datastorePartitions")
            .getter(getter(DatastoreSummary::datastorePartitions)).setter(setter(Builder::datastorePartitions))
            .constructor(DatastorePartitions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datastorePartitions").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASTORE_NAME_FIELD,
            DATASTORE_STORAGE_FIELD, STATUS_FIELD, CREATION_TIME_FIELD, LAST_UPDATE_TIME_FIELD, LAST_MESSAGE_ARRIVAL_TIME_FIELD,
            FILE_FORMAT_TYPE_FIELD, DATASTORE_PARTITIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String datastoreName;

    private final DatastoreStorageSummary datastoreStorage;

    private final String status;

    private final Instant creationTime;

    private final Instant lastUpdateTime;

    private final Instant lastMessageArrivalTime;

    private final String fileFormatType;

    private final DatastorePartitions datastorePartitions;

    private DatastoreSummary(BuilderImpl builder) {
        this.datastoreName = builder.datastoreName;
        this.datastoreStorage = builder.datastoreStorage;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.lastUpdateTime = builder.lastUpdateTime;
        this.lastMessageArrivalTime = builder.lastMessageArrivalTime;
        this.fileFormatType = builder.fileFormatType;
        this.datastorePartitions = builder.datastorePartitions;
    }

    /**
     * <p>
     * The name of the data store.
     * </p>
     * 
     * @return The name of the data store.
     */
    public final String datastoreName() {
        return datastoreName;
    }

    /**
     * <p>
     * Where data in a data store is stored.
     * </p>
     * 
     * @return Where data in a data store is stored.
     */
    public final DatastoreStorageSummary datastoreStorage() {
        return datastoreStorage;
    }

    /**
     * <p>
     * The status of the data store.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DatastoreStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the data store.
     * @see DatastoreStatus
     */
    public final DatastoreStatus status() {
        return DatastoreStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the data store.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DatastoreStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the data store.
     * @see DatastoreStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * When the data store was created.
     * </p>
     * 
     * @return When the data store was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The last time the data store was updated.
     * </p>
     * 
     * @return The last time the data store was updated.
     */
    public final Instant lastUpdateTime() {
        return lastUpdateTime;
    }

    /**
     * <p>
     * The last time when a new message arrived in the data store.
     * </p>
     * <p>
     * IoT Analytics updates this value at most once per minute for Amazon Simple Storage Service one data store. Hence,
     * the <code>lastMessageArrivalTime</code> value is an approximation.
     * </p>
     * <p>
     * This feature only applies to messages that arrived in the data store after October 23, 2020.
     * </p>
     * 
     * @return The last time when a new message arrived in the data store.</p>
     *         <p>
     *         IoT Analytics updates this value at most once per minute for Amazon Simple Storage Service one data
     *         store. Hence, the <code>lastMessageArrivalTime</code> value is an approximation.
     *         </p>
     *         <p>
     *         This feature only applies to messages that arrived in the data store after October 23, 2020.
     */
    public final Instant lastMessageArrivalTime() {
        return lastMessageArrivalTime;
    }

    /**
     * <p>
     * The file format of the data in the data store.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileFormatType}
     * will return {@link FileFormatType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #fileFormatTypeAsString}.
     * </p>
     * 
     * @return The file format of the data in the data store.
     * @see FileFormatType
     */
    public final FileFormatType fileFormatType() {
        return FileFormatType.fromValue(fileFormatType);
    }

    /**
     * <p>
     * The file format of the data in the data store.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileFormatType}
     * will return {@link FileFormatType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #fileFormatTypeAsString}.
     * </p>
     * 
     * @return The file format of the data in the data store.
     * @see FileFormatType
     */
    public final String fileFormatTypeAsString() {
        return fileFormatType;
    }

    /**
     * <p>
     * Contains information about the partition dimensions in a data store.
     * </p>
     * 
     * @return Contains information about the partition dimensions in a data store.
     */
    public final DatastorePartitions datastorePartitions() {
        return datastorePartitions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(datastoreName());
        hashCode = 31 * hashCode + Objects.hashCode(datastoreStorage());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastMessageArrivalTime());
        hashCode = 31 * hashCode + Objects.hashCode(fileFormatTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(datastorePartitions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatastoreSummary)) {
            return false;
        }
        DatastoreSummary other = (DatastoreSummary) obj;
        return Objects.equals(datastoreName(), other.datastoreName())
                && Objects.equals(datastoreStorage(), other.datastoreStorage())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastUpdateTime(), other.lastUpdateTime())
                && Objects.equals(lastMessageArrivalTime(), other.lastMessageArrivalTime())
                && Objects.equals(fileFormatTypeAsString(), other.fileFormatTypeAsString())
                && Objects.equals(datastorePartitions(), other.datastorePartitions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatastoreSummary").add("DatastoreName", datastoreName())
                .add("DatastoreStorage", datastoreStorage()).add("Status", statusAsString()).add("CreationTime", creationTime())
                .add("LastUpdateTime", lastUpdateTime()).add("LastMessageArrivalTime", lastMessageArrivalTime())
                .add("FileFormatType", fileFormatTypeAsString()).add("DatastorePartitions", datastorePartitions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "datastoreName":
            return Optional.ofNullable(clazz.cast(datastoreName()));
        case "datastoreStorage":
            return Optional.ofNullable(clazz.cast(datastoreStorage()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "lastUpdateTime":
            return Optional.ofNullable(clazz.cast(lastUpdateTime()));
        case "lastMessageArrivalTime":
            return Optional.ofNullable(clazz.cast(lastMessageArrivalTime()));
        case "fileFormatType":
            return Optional.ofNullable(clazz.cast(fileFormatTypeAsString()));
        case "datastorePartitions":
            return Optional.ofNullable(clazz.cast(datastorePartitions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatastoreSummary, T> g) {
        return obj -> g.apply((DatastoreSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatastoreSummary> {
        /**
         * <p>
         * The name of the data store.
         * </p>
         * 
         * @param datastoreName
         *        The name of the data store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datastoreName(String datastoreName);

        /**
         * <p>
         * Where data in a data store is stored.
         * </p>
         * 
         * @param datastoreStorage
         *        Where data in a data store is stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datastoreStorage(DatastoreStorageSummary datastoreStorage);

        /**
         * <p>
         * Where data in a data store is stored.
         * </p>
         * This is a convenience method that creates an instance of the {@link DatastoreStorageSummary.Builder} avoiding
         * the need to create one manually via {@link DatastoreStorageSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DatastoreStorageSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #datastoreStorage(DatastoreStorageSummary)}.
         * 
         * @param datastoreStorage
         *        a consumer that will call methods on {@link DatastoreStorageSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #datastoreStorage(DatastoreStorageSummary)
         */
        default Builder datastoreStorage(Consumer<DatastoreStorageSummary.Builder> datastoreStorage) {
            return datastoreStorage(DatastoreStorageSummary.builder().applyMutation(datastoreStorage).build());
        }

        /**
         * <p>
         * The status of the data store.
         * </p>
         * 
         * @param status
         *        The status of the data store.
         * @see DatastoreStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatastoreStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the data store.
         * </p>
         * 
         * @param status
         *        The status of the data store.
         * @see DatastoreStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatastoreStatus
         */
        Builder status(DatastoreStatus status);

        /**
         * <p>
         * When the data store was created.
         * </p>
         * 
         * @param creationTime
         *        When the data store was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The last time the data store was updated.
         * </p>
         * 
         * @param lastUpdateTime
         *        The last time the data store was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTime(Instant lastUpdateTime);

        /**
         * <p>
         * The last time when a new message arrived in the data store.
         * </p>
         * <p>
         * IoT Analytics updates this value at most once per minute for Amazon Simple Storage Service one data store.
         * Hence, the <code>lastMessageArrivalTime</code> value is an approximation.
         * </p>
         * <p>
         * This feature only applies to messages that arrived in the data store after October 23, 2020.
         * </p>
         * 
         * @param lastMessageArrivalTime
         *        The last time when a new message arrived in the data store.</p>
         *        <p>
         *        IoT Analytics updates this value at most once per minute for Amazon Simple Storage Service one data
         *        store. Hence, the <code>lastMessageArrivalTime</code> value is an approximation.
         *        </p>
         *        <p>
         *        This feature only applies to messages that arrived in the data store after October 23, 2020.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastMessageArrivalTime(Instant lastMessageArrivalTime);

        /**
         * <p>
         * The file format of the data in the data store.
         * </p>
         * 
         * @param fileFormatType
         *        The file format of the data in the data store.
         * @see FileFormatType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileFormatType
         */
        Builder fileFormatType(String fileFormatType);

        /**
         * <p>
         * The file format of the data in the data store.
         * </p>
         * 
         * @param fileFormatType
         *        The file format of the data in the data store.
         * @see FileFormatType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileFormatType
         */
        Builder fileFormatType(FileFormatType fileFormatType);

        /**
         * <p>
         * Contains information about the partition dimensions in a data store.
         * </p>
         * 
         * @param datastorePartitions
         *        Contains information about the partition dimensions in a data store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datastorePartitions(DatastorePartitions datastorePartitions);

        /**
         * <p>
         * Contains information about the partition dimensions in a data store.
         * </p>
         * This is a convenience method that creates an instance of the {@link DatastorePartitions.Builder} avoiding the
         * need to create one manually via {@link DatastorePartitions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DatastorePartitions.Builder#build()} is called immediately and
         * its result is passed to {@link #datastorePartitions(DatastorePartitions)}.
         * 
         * @param datastorePartitions
         *        a consumer that will call methods on {@link DatastorePartitions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #datastorePartitions(DatastorePartitions)
         */
        default Builder datastorePartitions(Consumer<DatastorePartitions.Builder> datastorePartitions) {
            return datastorePartitions(DatastorePartitions.builder().applyMutation(datastorePartitions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String datastoreName;

        private DatastoreStorageSummary datastoreStorage;

        private String status;

        private Instant creationTime;

        private Instant lastUpdateTime;

        private Instant lastMessageArrivalTime;

        private String fileFormatType;

        private DatastorePartitions datastorePartitions;

        private BuilderImpl() {
        }

        private BuilderImpl(DatastoreSummary model) {
            datastoreName(model.datastoreName);
            datastoreStorage(model.datastoreStorage);
            status(model.status);
            creationTime(model.creationTime);
            lastUpdateTime(model.lastUpdateTime);
            lastMessageArrivalTime(model.lastMessageArrivalTime);
            fileFormatType(model.fileFormatType);
            datastorePartitions(model.datastorePartitions);
        }

        public final String getDatastoreName() {
            return datastoreName;
        }

        public final void setDatastoreName(String datastoreName) {
            this.datastoreName = datastoreName;
        }

        @Override
        public final Builder datastoreName(String datastoreName) {
            this.datastoreName = datastoreName;
            return this;
        }

        public final DatastoreStorageSummary.Builder getDatastoreStorage() {
            return datastoreStorage != null ? datastoreStorage.toBuilder() : null;
        }

        public final void setDatastoreStorage(DatastoreStorageSummary.BuilderImpl datastoreStorage) {
            this.datastoreStorage = datastoreStorage != null ? datastoreStorage.build() : null;
        }

        @Override
        public final Builder datastoreStorage(DatastoreStorageSummary datastoreStorage) {
            this.datastoreStorage = datastoreStorage;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DatastoreStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdateTime() {
            return lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final Instant getLastMessageArrivalTime() {
            return lastMessageArrivalTime;
        }

        public final void setLastMessageArrivalTime(Instant lastMessageArrivalTime) {
            this.lastMessageArrivalTime = lastMessageArrivalTime;
        }

        @Override
        public final Builder lastMessageArrivalTime(Instant lastMessageArrivalTime) {
            this.lastMessageArrivalTime = lastMessageArrivalTime;
            return this;
        }

        public final String getFileFormatType() {
            return fileFormatType;
        }

        public final void setFileFormatType(String fileFormatType) {
            this.fileFormatType = fileFormatType;
        }

        @Override
        public final Builder fileFormatType(String fileFormatType) {
            this.fileFormatType = fileFormatType;
            return this;
        }

        @Override
        public final Builder fileFormatType(FileFormatType fileFormatType) {
            this.fileFormatType(fileFormatType == null ? null : fileFormatType.toString());
            return this;
        }

        public final DatastorePartitions.Builder getDatastorePartitions() {
            return datastorePartitions != null ? datastorePartitions.toBuilder() : null;
        }

        public final void setDatastorePartitions(DatastorePartitions.BuilderImpl datastorePartitions) {
            this.datastorePartitions = datastorePartitions != null ? datastorePartitions.build() : null;
        }

        @Override
        public final Builder datastorePartitions(DatastorePartitions datastorePartitions) {
            this.datastorePartitions = datastorePartitions;
            return this;
        }

        @Override
        public DatastoreSummary build() {
            return new DatastoreSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
