/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a file to stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StreamFile implements SdkPojo, Serializable, ToCopyableBuilder<StreamFile.Builder, StreamFile> {
    private static final SdkField<Integer> FILE_ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("fileId").getter(getter(StreamFile::fileId)).setter(setter(Builder::fileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileId").build()).build();

    private static final SdkField<S3Location> S3_LOCATION_FIELD = SdkField.<S3Location> builder(MarshallingType.SDK_POJO)
            .memberName("s3Location").getter(getter(StreamFile::s3Location)).setter(setter(Builder::s3Location))
            .constructor(S3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Location").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_ID_FIELD,
            S3_LOCATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer fileId;

    private final S3Location s3Location;

    private StreamFile(BuilderImpl builder) {
        this.fileId = builder.fileId;
        this.s3Location = builder.s3Location;
    }

    /**
     * <p>
     * The file ID.
     * </p>
     * 
     * @return The file ID.
     */
    public final Integer fileId() {
        return fileId;
    }

    /**
     * <p>
     * The location of the file in S3.
     * </p>
     * 
     * @return The location of the file in S3.
     */
    public final S3Location s3Location() {
        return s3Location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fileId());
        hashCode = 31 * hashCode + Objects.hashCode(s3Location());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamFile)) {
            return false;
        }
        StreamFile other = (StreamFile) obj;
        return Objects.equals(fileId(), other.fileId()) && Objects.equals(s3Location(), other.s3Location());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StreamFile").add("FileId", fileId()).add("S3Location", s3Location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fileId":
            return Optional.ofNullable(clazz.cast(fileId()));
        case "s3Location":
            return Optional.ofNullable(clazz.cast(s3Location()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StreamFile, T> g) {
        return obj -> g.apply((StreamFile) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StreamFile> {
        /**
         * <p>
         * The file ID.
         * </p>
         * 
         * @param fileId
         *        The file ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileId(Integer fileId);

        /**
         * <p>
         * The location of the file in S3.
         * </p>
         * 
         * @param s3Location
         *        The location of the file in S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Location(S3Location s3Location);

        /**
         * <p>
         * The location of the file in S3.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3Location.Builder} avoiding the need to
         * create one manually via {@link S3Location#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Location.Builder#build()} is called immediately and its result
         * is passed to {@link #s3Location(S3Location)}.
         * 
         * @param s3Location
         *        a consumer that will call methods on {@link S3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Location(S3Location)
         */
        default Builder s3Location(Consumer<S3Location.Builder> s3Location) {
            return s3Location(S3Location.builder().applyMutation(s3Location).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer fileId;

        private S3Location s3Location;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamFile model) {
            fileId(model.fileId);
            s3Location(model.s3Location);
        }

        public final Integer getFileId() {
            return fileId;
        }

        public final void setFileId(Integer fileId) {
            this.fileId = fileId;
        }

        @Override
        public final Builder fileId(Integer fileId) {
            this.fileId = fileId;
            return this;
        }

        public final S3Location.Builder getS3Location() {
            return s3Location != null ? s3Location.toBuilder() : null;
        }

        public final void setS3Location(S3Location.BuilderImpl s3Location) {
            this.s3Location = s3Location != null ? s3Location.build() : null;
        }

        @Override
        public final Builder s3Location(S3Location s3Location) {
            this.s3Location = s3Location;
            return this;
        }

        @Override
        public StreamFile build() {
            return new StreamFile(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
