/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCustomMetricResponse extends IotResponse implements
        ToCopyableBuilder<DescribeCustomMetricResponse.Builder, DescribeCustomMetricResponse> {
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("metricName").getter(getter(DescribeCustomMetricResponse::metricName))
            .setter(setter(Builder::metricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricName").build()).build();

    private static final SdkField<String> METRIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("metricArn").getter(getter(DescribeCustomMetricResponse::metricArn)).setter(setter(Builder::metricArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricArn").build()).build();

    private static final SdkField<String> METRIC_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("metricType").getter(getter(DescribeCustomMetricResponse::metricTypeAsString))
            .setter(setter(Builder::metricType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricType").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(DescribeCustomMetricResponse::displayName))
            .setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDate").getter(getter(DescribeCustomMetricResponse::creationDate))
            .setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedDate").getter(getter(DescribeCustomMetricResponse::lastModifiedDate))
            .setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_NAME_FIELD,
            METRIC_ARN_FIELD, METRIC_TYPE_FIELD, DISPLAY_NAME_FIELD, CREATION_DATE_FIELD, LAST_MODIFIED_DATE_FIELD));

    private final String metricName;

    private final String metricArn;

    private final String metricType;

    private final String displayName;

    private final Instant creationDate;

    private final Instant lastModifiedDate;

    private DescribeCustomMetricResponse(BuilderImpl builder) {
        super(builder);
        this.metricName = builder.metricName;
        this.metricArn = builder.metricArn;
        this.metricType = builder.metricType;
        this.displayName = builder.displayName;
        this.creationDate = builder.creationDate;
        this.lastModifiedDate = builder.lastModifiedDate;
    }

    /**
     * <p>
     * The name of the custom metric.
     * </p>
     * 
     * @return The name of the custom metric.
     */
    public final String metricName() {
        return metricName;
    }

    /**
     * <p>
     * The Amazon Resource Number (ARN) of the custom metric.
     * </p>
     * 
     * @return The Amazon Resource Number (ARN) of the custom metric.
     */
    public final String metricArn() {
        return metricArn;
    }

    /**
     * <p>
     * The type of the custom metric.
     * </p>
     * <important>
     * <p>
     * The type <code>number</code> only takes a single metric value as an input, but while submitting the metrics value
     * in the DeviceMetrics report, it must be passed as an array with a single value.
     * </p>
     * </important>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metricType} will
     * return {@link CustomMetricType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #metricTypeAsString}.
     * </p>
     * 
     * @return The type of the custom metric. </p> <important>
     *         <p>
     *         The type <code>number</code> only takes a single metric value as an input, but while submitting the
     *         metrics value in the DeviceMetrics report, it must be passed as an array with a single value.
     *         </p>
     * @see CustomMetricType
     */
    public final CustomMetricType metricType() {
        return CustomMetricType.fromValue(metricType);
    }

    /**
     * <p>
     * The type of the custom metric.
     * </p>
     * <important>
     * <p>
     * The type <code>number</code> only takes a single metric value as an input, but while submitting the metrics value
     * in the DeviceMetrics report, it must be passed as an array with a single value.
     * </p>
     * </important>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metricType} will
     * return {@link CustomMetricType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #metricTypeAsString}.
     * </p>
     * 
     * @return The type of the custom metric. </p> <important>
     *         <p>
     *         The type <code>number</code> only takes a single metric value as an input, but while submitting the
     *         metrics value in the DeviceMetrics report, it must be passed as an array with a single value.
     *         </p>
     * @see CustomMetricType
     */
    public final String metricTypeAsString() {
        return metricType;
    }

    /**
     * <p>
     * Field represents a friendly name in the console for the custom metric; doesn't have to be unique. Don't use this
     * name as the metric identifier in the device metric report. Can be updated.
     * </p>
     * 
     * @return Field represents a friendly name in the console for the custom metric; doesn't have to be unique. Don't
     *         use this name as the metric identifier in the device metric report. Can be updated.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The creation date of the custom metric in milliseconds since epoch.
     * </p>
     * 
     * @return The creation date of the custom metric in milliseconds since epoch.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The time the custom metric was last modified in milliseconds since epoch.
     * </p>
     * 
     * @return The time the custom metric was last modified in milliseconds since epoch.
     */
    public final Instant lastModifiedDate() {
        return lastModifiedDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(metricName());
        hashCode = 31 * hashCode + Objects.hashCode(metricArn());
        hashCode = 31 * hashCode + Objects.hashCode(metricTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCustomMetricResponse)) {
            return false;
        }
        DescribeCustomMetricResponse other = (DescribeCustomMetricResponse) obj;
        return Objects.equals(metricName(), other.metricName()) && Objects.equals(metricArn(), other.metricArn())
                && Objects.equals(metricTypeAsString(), other.metricTypeAsString())
                && Objects.equals(displayName(), other.displayName()) && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeCustomMetricResponse").add("MetricName", metricName()).add("MetricArn", metricArn())
                .add("MetricType", metricTypeAsString()).add("DisplayName", displayName()).add("CreationDate", creationDate())
                .add("LastModifiedDate", lastModifiedDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "metricName":
            return Optional.ofNullable(clazz.cast(metricName()));
        case "metricArn":
            return Optional.ofNullable(clazz.cast(metricArn()));
        case "metricType":
            return Optional.ofNullable(clazz.cast(metricTypeAsString()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "creationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "lastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCustomMetricResponse, T> g) {
        return obj -> g.apply((DescribeCustomMetricResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeCustomMetricResponse> {
        /**
         * <p>
         * The name of the custom metric.
         * </p>
         * 
         * @param metricName
         *        The name of the custom metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * The Amazon Resource Number (ARN) of the custom metric.
         * </p>
         * 
         * @param metricArn
         *        The Amazon Resource Number (ARN) of the custom metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricArn(String metricArn);

        /**
         * <p>
         * The type of the custom metric.
         * </p>
         * <important>
         * <p>
         * The type <code>number</code> only takes a single metric value as an input, but while submitting the metrics
         * value in the DeviceMetrics report, it must be passed as an array with a single value.
         * </p>
         * </important>
         * 
         * @param metricType
         *        The type of the custom metric. </p> <important>
         *        <p>
         *        The type <code>number</code> only takes a single metric value as an input, but while submitting the
         *        metrics value in the DeviceMetrics report, it must be passed as an array with a single value.
         *        </p>
         * @see CustomMetricType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomMetricType
         */
        Builder metricType(String metricType);

        /**
         * <p>
         * The type of the custom metric.
         * </p>
         * <important>
         * <p>
         * The type <code>number</code> only takes a single metric value as an input, but while submitting the metrics
         * value in the DeviceMetrics report, it must be passed as an array with a single value.
         * </p>
         * </important>
         * 
         * @param metricType
         *        The type of the custom metric. </p> <important>
         *        <p>
         *        The type <code>number</code> only takes a single metric value as an input, but while submitting the
         *        metrics value in the DeviceMetrics report, it must be passed as an array with a single value.
         *        </p>
         * @see CustomMetricType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomMetricType
         */
        Builder metricType(CustomMetricType metricType);

        /**
         * <p>
         * Field represents a friendly name in the console for the custom metric; doesn't have to be unique. Don't use
         * this name as the metric identifier in the device metric report. Can be updated.
         * </p>
         * 
         * @param displayName
         *        Field represents a friendly name in the console for the custom metric; doesn't have to be unique.
         *        Don't use this name as the metric identifier in the device metric report. Can be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The creation date of the custom metric in milliseconds since epoch.
         * </p>
         * 
         * @param creationDate
         *        The creation date of the custom metric in milliseconds since epoch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The time the custom metric was last modified in milliseconds since epoch.
         * </p>
         * 
         * @param lastModifiedDate
         *        The time the custom metric was last modified in milliseconds since epoch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Instant lastModifiedDate);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private String metricName;

        private String metricArn;

        private String metricType;

        private String displayName;

        private Instant creationDate;

        private Instant lastModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCustomMetricResponse model) {
            super(model);
            metricName(model.metricName);
            metricArn(model.metricArn);
            metricType(model.metricType);
            displayName(model.displayName);
            creationDate(model.creationDate);
            lastModifiedDate(model.lastModifiedDate);
        }

        public final String getMetricName() {
            return metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final String getMetricArn() {
            return metricArn;
        }

        public final void setMetricArn(String metricArn) {
            this.metricArn = metricArn;
        }

        @Override
        public final Builder metricArn(String metricArn) {
            this.metricArn = metricArn;
            return this;
        }

        public final String getMetricType() {
            return metricType;
        }

        public final void setMetricType(String metricType) {
            this.metricType = metricType;
        }

        @Override
        public final Builder metricType(String metricType) {
            this.metricType = metricType;
            return this;
        }

        @Override
        public final Builder metricType(CustomMetricType metricType) {
            this.metricType(metricType == null ? null : metricType.toString());
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Instant getLastModifiedDate() {
            return lastModifiedDate;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        @Override
        public DescribeCustomMetricResponse build() {
            return new DescribeCustomMetricResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
