/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.globalaccelerator.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAcceleratorResponse extends GlobalAcceleratorResponse implements
        ToCopyableBuilder<CreateAcceleratorResponse.Builder, CreateAcceleratorResponse> {
    private static final SdkField<Accelerator> ACCELERATOR_FIELD = SdkField.<Accelerator> builder(MarshallingType.SDK_POJO)
            .memberName("Accelerator").getter(getter(CreateAcceleratorResponse::accelerator))
            .setter(setter(Builder::accelerator)).constructor(Accelerator::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Accelerator").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCELERATOR_FIELD));

    private final Accelerator accelerator;

    private CreateAcceleratorResponse(BuilderImpl builder) {
        super(builder);
        this.accelerator = builder.accelerator;
    }

    /**
     * <p>
     * The accelerator that is created by specifying a listener and the supported IP address types.
     * </p>
     * 
     * @return The accelerator that is created by specifying a listener and the supported IP address types.
     */
    public final Accelerator accelerator() {
        return accelerator;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accelerator());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAcceleratorResponse)) {
            return false;
        }
        CreateAcceleratorResponse other = (CreateAcceleratorResponse) obj;
        return Objects.equals(accelerator(), other.accelerator());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAcceleratorResponse").add("Accelerator", accelerator()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Accelerator":
            return Optional.ofNullable(clazz.cast(accelerator()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAcceleratorResponse, T> g) {
        return obj -> g.apply((CreateAcceleratorResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlobalAcceleratorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateAcceleratorResponse> {
        /**
         * <p>
         * The accelerator that is created by specifying a listener and the supported IP address types.
         * </p>
         * 
         * @param accelerator
         *        The accelerator that is created by specifying a listener and the supported IP address types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accelerator(Accelerator accelerator);

        /**
         * <p>
         * The accelerator that is created by specifying a listener and the supported IP address types.
         * </p>
         * This is a convenience method that creates an instance of the {@link Accelerator.Builder} avoiding the need to
         * create one manually via {@link Accelerator#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Accelerator.Builder#build()} is called immediately and its result
         * is passed to {@link #accelerator(Accelerator)}.
         * 
         * @param accelerator
         *        a consumer that will call methods on {@link Accelerator.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accelerator(Accelerator)
         */
        default Builder accelerator(Consumer<Accelerator.Builder> accelerator) {
            return accelerator(Accelerator.builder().applyMutation(accelerator).build());
        }
    }

    static final class BuilderImpl extends GlobalAcceleratorResponse.BuilderImpl implements Builder {
        private Accelerator accelerator;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAcceleratorResponse model) {
            super(model);
            accelerator(model.accelerator);
        }

        public final Accelerator.Builder getAccelerator() {
            return accelerator != null ? accelerator.toBuilder() : null;
        }

        public final void setAccelerator(Accelerator.BuilderImpl accelerator) {
            this.accelerator = accelerator != null ? accelerator.build() : null;
        }

        @Override
        public final Builder accelerator(Accelerator accelerator) {
            this.accelerator = accelerator;
            return this;
        }

        @Override
        public CreateAcceleratorResponse build() {
            return new CreateAcceleratorResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
