/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class FleetCapacityListCopier {
    static List<FleetCapacity> copy(Collection<? extends FleetCapacity> fleetCapacityListParam) {
        List<FleetCapacity> list;
        if (fleetCapacityListParam == null || fleetCapacityListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<FleetCapacity> modifiableList = new ArrayList<>();
            fleetCapacityListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<FleetCapacity> copyFromBuilder(Collection<? extends FleetCapacity.Builder> fleetCapacityListParam) {
        List<FleetCapacity> list;
        if (fleetCapacityListParam == null || fleetCapacityListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<FleetCapacity> modifiableList = new ArrayList<>();
            fleetCapacityListParam.forEach(entry -> {
                FleetCapacity member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<FleetCapacity.Builder> copyToBuilder(Collection<? extends FleetCapacity> fleetCapacityListParam) {
        List<FleetCapacity.Builder> list;
        if (fleetCapacityListParam == null || fleetCapacityListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<FleetCapacity.Builder> modifiableList = new ArrayList<>();
            fleetCapacityListParam.forEach(entry -> {
                FleetCapacity.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
