/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeFleetPortSettingsResponse extends GameLiftResponse implements
        ToCopyableBuilder<DescribeFleetPortSettingsResponse.Builder, DescribeFleetPortSettingsResponse> {
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FleetId").getter(getter(DescribeFleetPortSettingsResponse::fleetId)).setter(setter(Builder::fleetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()).build();

    private static final SdkField<String> FLEET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FleetArn").getter(getter(DescribeFleetPortSettingsResponse::fleetArn)).setter(setter(Builder::fleetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetArn").build()).build();

    private static final SdkField<List<IpPermission>> INBOUND_PERMISSIONS_FIELD = SdkField
            .<List<IpPermission>> builder(MarshallingType.LIST)
            .memberName("InboundPermissions")
            .getter(getter(DescribeFleetPortSettingsResponse::inboundPermissions))
            .setter(setter(Builder::inboundPermissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InboundPermissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IpPermission> builder(MarshallingType.SDK_POJO)
                                            .constructor(IpPermission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> UPDATE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpdateStatus").getter(getter(DescribeFleetPortSettingsResponse::updateStatusAsString))
            .setter(setter(Builder::updateStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateStatus").build()).build();

    private static final SdkField<String> LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Location").getter(getter(DescribeFleetPortSettingsResponse::location)).setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ID_FIELD,
            FLEET_ARN_FIELD, INBOUND_PERMISSIONS_FIELD, UPDATE_STATUS_FIELD, LOCATION_FIELD));

    private final String fleetId;

    private final String fleetArn;

    private final List<IpPermission> inboundPermissions;

    private final String updateStatus;

    private final String location;

    private DescribeFleetPortSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.fleetId = builder.fleetId;
        this.fleetArn = builder.fleetArn;
        this.inboundPermissions = builder.inboundPermissions;
        this.updateStatus = builder.updateStatus;
        this.location = builder.location;
    }

    /**
     * <p>
     * A unique identifier for the fleet that was requested.
     * </p>
     * 
     * @return A unique identifier for the fleet that was requested.
     */
    public final String fleetId() {
        return fleetId;
    }

    /**
     * <p>
     * The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>)
     * that is assigned to a Amazon GameLift fleet resource and uniquely identifies it. ARNs are unique across all
     * Regions. Format is <code>arn:aws:gamelift:&lt;region&gt;::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912</code>
     * .
     * </p>
     * 
     * @return The Amazon Resource Name (<a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a
     *         Amazon GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is
     *         <code>arn:aws:gamelift:&lt;region&gt;::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912</code>.
     */
    public final String fleetArn() {
        return fleetArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the InboundPermissions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInboundPermissions() {
        return inboundPermissions != null && !(inboundPermissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The port settings for the requested fleet ID.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInboundPermissions} method.
     * </p>
     * 
     * @return The port settings for the requested fleet ID.
     */
    public final List<IpPermission> inboundPermissions() {
        return inboundPermissions;
    }

    /**
     * <p>
     * The current status of updates to the fleet's port settings in the requested fleet location. A status of
     * <code>PENDING_UPDATE</code> indicates that an update was requested for the fleet but has not yet been completed
     * for the location.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #updateStatus} will
     * return {@link LocationUpdateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #updateStatusAsString}.
     * </p>
     * 
     * @return The current status of updates to the fleet's port settings in the requested fleet location. A status of
     *         <code>PENDING_UPDATE</code> indicates that an update was requested for the fleet but has not yet been
     *         completed for the location.
     * @see LocationUpdateStatus
     */
    public final LocationUpdateStatus updateStatus() {
        return LocationUpdateStatus.fromValue(updateStatus);
    }

    /**
     * <p>
     * The current status of updates to the fleet's port settings in the requested fleet location. A status of
     * <code>PENDING_UPDATE</code> indicates that an update was requested for the fleet but has not yet been completed
     * for the location.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #updateStatus} will
     * return {@link LocationUpdateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #updateStatusAsString}.
     * </p>
     * 
     * @return The current status of updates to the fleet's port settings in the requested fleet location. A status of
     *         <code>PENDING_UPDATE</code> indicates that an update was requested for the fleet but has not yet been
     *         completed for the location.
     * @see LocationUpdateStatus
     */
    public final String updateStatusAsString() {
        return updateStatus;
    }

    /**
     * <p>
     * The requested fleet location, expressed as an Amazon Web Services Region code, such as <code>us-west-2</code>.
     * </p>
     * 
     * @return The requested fleet location, expressed as an Amazon Web Services Region code, such as
     *         <code>us-west-2</code>.
     */
    public final String location() {
        return location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(fleetArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasInboundPermissions() ? inboundPermissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(updateStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFleetPortSettingsResponse)) {
            return false;
        }
        DescribeFleetPortSettingsResponse other = (DescribeFleetPortSettingsResponse) obj;
        return Objects.equals(fleetId(), other.fleetId()) && Objects.equals(fleetArn(), other.fleetArn())
                && hasInboundPermissions() == other.hasInboundPermissions()
                && Objects.equals(inboundPermissions(), other.inboundPermissions())
                && Objects.equals(updateStatusAsString(), other.updateStatusAsString())
                && Objects.equals(location(), other.location());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeFleetPortSettingsResponse").add("FleetId", fleetId()).add("FleetArn", fleetArn())
                .add("InboundPermissions", hasInboundPermissions() ? inboundPermissions() : null)
                .add("UpdateStatus", updateStatusAsString()).add("Location", location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FleetId":
            return Optional.ofNullable(clazz.cast(fleetId()));
        case "FleetArn":
            return Optional.ofNullable(clazz.cast(fleetArn()));
        case "InboundPermissions":
            return Optional.ofNullable(clazz.cast(inboundPermissions()));
        case "UpdateStatus":
            return Optional.ofNullable(clazz.cast(updateStatusAsString()));
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFleetPortSettingsResponse, T> g) {
        return obj -> g.apply((DescribeFleetPortSettingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeFleetPortSettingsResponse> {
        /**
         * <p>
         * A unique identifier for the fleet that was requested.
         * </p>
         * 
         * @param fleetId
         *        A unique identifier for the fleet that was requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetId(String fleetId);

        /**
         * <p>
         * The Amazon Resource Name (<a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a
         * Amazon GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is
         * <code>arn:aws:gamelift:&lt;region&gt;::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912</code>.
         * </p>
         * 
         * @param fleetArn
         *        The Amazon Resource Name (<a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to
         *        a Amazon GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions.
         *        Format is
         *        <code>arn:aws:gamelift:&lt;region&gt;::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetArn(String fleetArn);

        /**
         * <p>
         * The port settings for the requested fleet ID.
         * </p>
         * 
         * @param inboundPermissions
         *        The port settings for the requested fleet ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inboundPermissions(Collection<IpPermission> inboundPermissions);

        /**
         * <p>
         * The port settings for the requested fleet ID.
         * </p>
         * 
         * @param inboundPermissions
         *        The port settings for the requested fleet ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inboundPermissions(IpPermission... inboundPermissions);

        /**
         * <p>
         * The port settings for the requested fleet ID.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.gamelift.model.IpPermission.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.gamelift.model.IpPermission#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.gamelift.model.IpPermission.Builder#build()} is called immediately and
         * its result is passed to {@link #inboundPermissions(List<IpPermission>)}.
         * 
         * @param inboundPermissions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.gamelift.model.IpPermission.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inboundPermissions(java.util.Collection<IpPermission>)
         */
        Builder inboundPermissions(Consumer<IpPermission.Builder>... inboundPermissions);

        /**
         * <p>
         * The current status of updates to the fleet's port settings in the requested fleet location. A status of
         * <code>PENDING_UPDATE</code> indicates that an update was requested for the fleet but has not yet been
         * completed for the location.
         * </p>
         * 
         * @param updateStatus
         *        The current status of updates to the fleet's port settings in the requested fleet location. A status
         *        of <code>PENDING_UPDATE</code> indicates that an update was requested for the fleet but has not yet
         *        been completed for the location.
         * @see LocationUpdateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LocationUpdateStatus
         */
        Builder updateStatus(String updateStatus);

        /**
         * <p>
         * The current status of updates to the fleet's port settings in the requested fleet location. A status of
         * <code>PENDING_UPDATE</code> indicates that an update was requested for the fleet but has not yet been
         * completed for the location.
         * </p>
         * 
         * @param updateStatus
         *        The current status of updates to the fleet's port settings in the requested fleet location. A status
         *        of <code>PENDING_UPDATE</code> indicates that an update was requested for the fleet but has not yet
         *        been completed for the location.
         * @see LocationUpdateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LocationUpdateStatus
         */
        Builder updateStatus(LocationUpdateStatus updateStatus);

        /**
         * <p>
         * The requested fleet location, expressed as an Amazon Web Services Region code, such as <code>us-west-2</code>
         * .
         * </p>
         * 
         * @param location
         *        The requested fleet location, expressed as an Amazon Web Services Region code, such as
         *        <code>us-west-2</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);
    }

    static final class BuilderImpl extends GameLiftResponse.BuilderImpl implements Builder {
        private String fleetId;

        private String fleetArn;

        private List<IpPermission> inboundPermissions = DefaultSdkAutoConstructList.getInstance();

        private String updateStatus;

        private String location;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFleetPortSettingsResponse model) {
            super(model);
            fleetId(model.fleetId);
            fleetArn(model.fleetArn);
            inboundPermissions(model.inboundPermissions);
            updateStatus(model.updateStatus);
            location(model.location);
        }

        public final String getFleetId() {
            return fleetId;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final String getFleetArn() {
            return fleetArn;
        }

        public final void setFleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
        }

        @Override
        public final Builder fleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
            return this;
        }

        public final List<IpPermission.Builder> getInboundPermissions() {
            List<IpPermission.Builder> result = IpPermissionsListCopier.copyToBuilder(this.inboundPermissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInboundPermissions(Collection<IpPermission.BuilderImpl> inboundPermissions) {
            this.inboundPermissions = IpPermissionsListCopier.copyFromBuilder(inboundPermissions);
        }

        @Override
        public final Builder inboundPermissions(Collection<IpPermission> inboundPermissions) {
            this.inboundPermissions = IpPermissionsListCopier.copy(inboundPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inboundPermissions(IpPermission... inboundPermissions) {
            inboundPermissions(Arrays.asList(inboundPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inboundPermissions(Consumer<IpPermission.Builder>... inboundPermissions) {
            inboundPermissions(Stream.of(inboundPermissions).map(c -> IpPermission.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getUpdateStatus() {
            return updateStatus;
        }

        public final void setUpdateStatus(String updateStatus) {
            this.updateStatus = updateStatus;
        }

        @Override
        public final Builder updateStatus(String updateStatus) {
            this.updateStatus = updateStatus;
            return this;
        }

        @Override
        public final Builder updateStatus(LocationUpdateStatus updateStatus) {
            this.updateStatus(updateStatus == null ? null : updateStatus.toString());
            return this;
        }

        public final String getLocation() {
            return location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        @Override
        public DescribeFleetPortSettingsResponse build() {
            return new DescribeFleetPortSettingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
