/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteVpcPeeringConnectionRequest extends GameLiftRequest implements
        ToCopyableBuilder<DeleteVpcPeeringConnectionRequest.Builder, DeleteVpcPeeringConnectionRequest> {
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FleetId").getter(getter(DeleteVpcPeeringConnectionRequest::fleetId)).setter(setter(Builder::fleetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()).build();

    private static final SdkField<String> VPC_PEERING_CONNECTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpcPeeringConnectionId").getter(getter(DeleteVpcPeeringConnectionRequest::vpcPeeringConnectionId))
            .setter(setter(Builder::vpcPeeringConnectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcPeeringConnectionId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ID_FIELD,
            VPC_PEERING_CONNECTION_ID_FIELD));

    private final String fleetId;

    private final String vpcPeeringConnectionId;

    private DeleteVpcPeeringConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.fleetId = builder.fleetId;
        this.vpcPeeringConnectionId = builder.vpcPeeringConnectionId;
    }

    /**
     * <p>
     * A unique identifier for the fleet. This fleet specified must match the fleet referenced in the VPC peering
     * connection record. You can use either the fleet ID or ARN value.
     * </p>
     * 
     * @return A unique identifier for the fleet. This fleet specified must match the fleet referenced in the VPC
     *         peering connection record. You can use either the fleet ID or ARN value.
     */
    public final String fleetId() {
        return fleetId;
    }

    /**
     * <p>
     * A unique identifier for a VPC peering connection.
     * </p>
     * 
     * @return A unique identifier for a VPC peering connection.
     */
    public final String vpcPeeringConnectionId() {
        return vpcPeeringConnectionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcPeeringConnectionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteVpcPeeringConnectionRequest)) {
            return false;
        }
        DeleteVpcPeeringConnectionRequest other = (DeleteVpcPeeringConnectionRequest) obj;
        return Objects.equals(fleetId(), other.fleetId())
                && Objects.equals(vpcPeeringConnectionId(), other.vpcPeeringConnectionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteVpcPeeringConnectionRequest").add("FleetId", fleetId())
                .add("VpcPeeringConnectionId", vpcPeeringConnectionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FleetId":
            return Optional.ofNullable(clazz.cast(fleetId()));
        case "VpcPeeringConnectionId":
            return Optional.ofNullable(clazz.cast(vpcPeeringConnectionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteVpcPeeringConnectionRequest, T> g) {
        return obj -> g.apply((DeleteVpcPeeringConnectionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteVpcPeeringConnectionRequest> {
        /**
         * <p>
         * A unique identifier for the fleet. This fleet specified must match the fleet referenced in the VPC peering
         * connection record. You can use either the fleet ID or ARN value.
         * </p>
         * 
         * @param fleetId
         *        A unique identifier for the fleet. This fleet specified must match the fleet referenced in the VPC
         *        peering connection record. You can use either the fleet ID or ARN value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetId(String fleetId);

        /**
         * <p>
         * A unique identifier for a VPC peering connection.
         * </p>
         * 
         * @param vpcPeeringConnectionId
         *        A unique identifier for a VPC peering connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcPeeringConnectionId(String vpcPeeringConnectionId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftRequest.BuilderImpl implements Builder {
        private String fleetId;

        private String vpcPeeringConnectionId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteVpcPeeringConnectionRequest model) {
            super(model);
            fleetId(model.fleetId);
            vpcPeeringConnectionId(model.vpcPeeringConnectionId);
        }

        public final String getFleetId() {
            return fleetId;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final String getVpcPeeringConnectionId() {
            return vpcPeeringConnectionId;
        }

        public final void setVpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
        }

        @Override
        public final Builder vpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteVpcPeeringConnectionRequest build() {
            return new DeleteVpcPeeringConnectionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
