/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLocationResponse extends GameLiftResponse implements
        ToCopyableBuilder<CreateLocationResponse.Builder, CreateLocationResponse> {
    private static final SdkField<LocationModel> LOCATION_FIELD = SdkField.<LocationModel> builder(MarshallingType.SDK_POJO)
            .memberName("Location").getter(getter(CreateLocationResponse::location)).setter(setter(Builder::location))
            .constructor(LocationModel::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_FIELD));

    private final LocationModel location;

    private CreateLocationResponse(BuilderImpl builder) {
        super(builder);
        this.location = builder.location;
    }

    /**
     * <p>
     * The details of the custom location you created.
     * </p>
     * 
     * @return The details of the custom location you created.
     */
    public final LocationModel location() {
        return location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(location());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLocationResponse)) {
            return false;
        }
        CreateLocationResponse other = (CreateLocationResponse) obj;
        return Objects.equals(location(), other.location());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateLocationResponse").add("Location", location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLocationResponse, T> g) {
        return obj -> g.apply((CreateLocationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateLocationResponse> {
        /**
         * <p>
         * The details of the custom location you created.
         * </p>
         * 
         * @param location
         *        The details of the custom location you created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(LocationModel location);

        /**
         * <p>
         * The details of the custom location you created.
         * </p>
         * This is a convenience method that creates an instance of the {@link LocationModel.Builder} avoiding the need
         * to create one manually via {@link LocationModel#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LocationModel.Builder#build()} is called immediately and its
         * result is passed to {@link #location(LocationModel)}.
         * 
         * @param location
         *        a consumer that will call methods on {@link LocationModel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #location(LocationModel)
         */
        default Builder location(Consumer<LocationModel.Builder> location) {
            return location(LocationModel.builder().applyMutation(location).build());
        }
    }

    static final class BuilderImpl extends GameLiftResponse.BuilderImpl implements Builder {
        private LocationModel location;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLocationResponse model) {
            super(model);
            location(model.location);
        }

        public final LocationModel.Builder getLocation() {
            return location != null ? location.toBuilder() : null;
        }

        public final void setLocation(LocationModel.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        @Override
        public final Builder location(LocationModel location) {
            this.location = location;
            return this;
        }

        @Override
        public CreateLocationResponse build() {
            return new CreateLocationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
