/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutAdminAccountRequest extends FmsRequest implements
        ToCopyableBuilder<PutAdminAccountRequest.Builder, PutAdminAccountRequest> {
    private static final SdkField<String> ADMIN_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AdminAccount").getter(getter(PutAdminAccountRequest::adminAccount))
            .setter(setter(Builder::adminAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdminAccount").build()).build();

    private static final SdkField<AdminScope> ADMIN_SCOPE_FIELD = SdkField.<AdminScope> builder(MarshallingType.SDK_POJO)
            .memberName("AdminScope").getter(getter(PutAdminAccountRequest::adminScope)).setter(setter(Builder::adminScope))
            .constructor(AdminScope::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdminScope").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADMIN_ACCOUNT_FIELD,
            ADMIN_SCOPE_FIELD));

    private final String adminAccount;

    private final AdminScope adminScope;

    private PutAdminAccountRequest(BuilderImpl builder) {
        super(builder);
        this.adminAccount = builder.adminAccount;
        this.adminScope = builder.adminScope;
    }

    /**
     * <p>
     * The Amazon Web Services account ID to add as an Firewall Manager administrator account. The account must be a
     * member of the organization that was onboarded to Firewall Manager by <a>AssociateAdminAccount</a>. For more
     * information about Organizations, see <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts.html">Managing the Amazon
     * Web Services Accounts in Your Organization</a>.
     * </p>
     * 
     * @return The Amazon Web Services account ID to add as an Firewall Manager administrator account. The account must
     *         be a member of the organization that was onboarded to Firewall Manager by <a>AssociateAdminAccount</a>.
     *         For more information about Organizations, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts.html">Managing the
     *         Amazon Web Services Accounts in Your Organization</a>.
     */
    public final String adminAccount() {
        return adminAccount;
    }

    /**
     * <p>
     * Configures the resources that the specified Firewall Manager administrator can manage. As a best practice, set
     * the administrative scope according to the principles of least privilege. Only grant the administrator the
     * specific resources or permissions that they need to perform the duties of their role.
     * </p>
     * 
     * @return Configures the resources that the specified Firewall Manager administrator can manage. As a best
     *         practice, set the administrative scope according to the principles of least privilege. Only grant the
     *         administrator the specific resources or permissions that they need to perform the duties of their role.
     */
    public final AdminScope adminScope() {
        return adminScope;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(adminAccount());
        hashCode = 31 * hashCode + Objects.hashCode(adminScope());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAdminAccountRequest)) {
            return false;
        }
        PutAdminAccountRequest other = (PutAdminAccountRequest) obj;
        return Objects.equals(adminAccount(), other.adminAccount()) && Objects.equals(adminScope(), other.adminScope());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutAdminAccountRequest").add("AdminAccount", adminAccount()).add("AdminScope", adminScope())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdminAccount":
            return Optional.ofNullable(clazz.cast(adminAccount()));
        case "AdminScope":
            return Optional.ofNullable(clazz.cast(adminScope()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutAdminAccountRequest, T> g) {
        return obj -> g.apply((PutAdminAccountRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FmsRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutAdminAccountRequest> {
        /**
         * <p>
         * The Amazon Web Services account ID to add as an Firewall Manager administrator account. The account must be a
         * member of the organization that was onboarded to Firewall Manager by <a>AssociateAdminAccount</a>. For more
         * information about Organizations, see <a
         * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts.html">Managing the
         * Amazon Web Services Accounts in Your Organization</a>.
         * </p>
         * 
         * @param adminAccount
         *        The Amazon Web Services account ID to add as an Firewall Manager administrator account. The account
         *        must be a member of the organization that was onboarded to Firewall Manager by
         *        <a>AssociateAdminAccount</a>. For more information about Organizations, see <a
         *        href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts.html">Managing
         *        the Amazon Web Services Accounts in Your Organization</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adminAccount(String adminAccount);

        /**
         * <p>
         * Configures the resources that the specified Firewall Manager administrator can manage. As a best practice,
         * set the administrative scope according to the principles of least privilege. Only grant the administrator the
         * specific resources or permissions that they need to perform the duties of their role.
         * </p>
         * 
         * @param adminScope
         *        Configures the resources that the specified Firewall Manager administrator can manage. As a best
         *        practice, set the administrative scope according to the principles of least privilege. Only grant the
         *        administrator the specific resources or permissions that they need to perform the duties of their
         *        role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adminScope(AdminScope adminScope);

        /**
         * <p>
         * Configures the resources that the specified Firewall Manager administrator can manage. As a best practice,
         * set the administrative scope according to the principles of least privilege. Only grant the administrator the
         * specific resources or permissions that they need to perform the duties of their role.
         * </p>
         * This is a convenience method that creates an instance of the {@link AdminScope.Builder} avoiding the need to
         * create one manually via {@link AdminScope#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AdminScope.Builder#build()} is called immediately and its result
         * is passed to {@link #adminScope(AdminScope)}.
         * 
         * @param adminScope
         *        a consumer that will call methods on {@link AdminScope.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #adminScope(AdminScope)
         */
        default Builder adminScope(Consumer<AdminScope.Builder> adminScope) {
            return adminScope(AdminScope.builder().applyMutation(adminScope).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FmsRequest.BuilderImpl implements Builder {
        private String adminAccount;

        private AdminScope adminScope;

        private BuilderImpl() {
        }

        private BuilderImpl(PutAdminAccountRequest model) {
            super(model);
            adminAccount(model.adminAccount);
            adminScope(model.adminScope);
        }

        public final String getAdminAccount() {
            return adminAccount;
        }

        public final void setAdminAccount(String adminAccount) {
            this.adminAccount = adminAccount;
        }

        @Override
        public final Builder adminAccount(String adminAccount) {
            this.adminAccount = adminAccount;
            return this;
        }

        public final AdminScope.Builder getAdminScope() {
            return adminScope != null ? adminScope.toBuilder() : null;
        }

        public final void setAdminScope(AdminScope.BuilderImpl adminScope) {
            this.adminScope = adminScope != null ? adminScope.build() : null;
        }

        @Override
        public final Builder adminScope(AdminScope adminScope) {
            this.adminScope = adminScope;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutAdminAccountRequest build() {
            return new PutAdminAccountRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
