/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum DeliveryStreamFailureType {
    RETIRE_KMS_GRANT_FAILED("RETIRE_KMS_GRANT_FAILED"),

    CREATE_KMS_GRANT_FAILED("CREATE_KMS_GRANT_FAILED"),

    KMS_ACCESS_DENIED("KMS_ACCESS_DENIED"),

    DISABLED_KMS_KEY("DISABLED_KMS_KEY"),

    INVALID_KMS_KEY("INVALID_KMS_KEY"),

    KMS_KEY_NOT_FOUND("KMS_KEY_NOT_FOUND"),

    KMS_OPT_IN_REQUIRED("KMS_OPT_IN_REQUIRED"),

    CREATE_ENI_FAILED("CREATE_ENI_FAILED"),

    DELETE_ENI_FAILED("DELETE_ENI_FAILED"),

    SUBNET_NOT_FOUND("SUBNET_NOT_FOUND"),

    SECURITY_GROUP_NOT_FOUND("SECURITY_GROUP_NOT_FOUND"),

    ENI_ACCESS_DENIED("ENI_ACCESS_DENIED"),

    SUBNET_ACCESS_DENIED("SUBNET_ACCESS_DENIED"),

    SECURITY_GROUP_ACCESS_DENIED("SECURITY_GROUP_ACCESS_DENIED"),

    UNKNOWN_ERROR("UNKNOWN_ERROR"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DeliveryStreamFailureType> VALUE_MAP = EnumUtils.uniqueIndex(
            DeliveryStreamFailureType.class, DeliveryStreamFailureType::toString);

    private final String value;

    private DeliveryStreamFailureType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return DeliveryStreamFailureType corresponding to the value
     */
    public static DeliveryStreamFailureType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link DeliveryStreamFailureType}s
     */
    public static Set<DeliveryStreamFailureType> knownValues() {
        Set<DeliveryStreamFailureType> knownValues = EnumSet.allOf(DeliveryStreamFailureType.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
