/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateClusterRequest extends EksRequest implements
        ToCopyableBuilder<CreateClusterRequest.Builder, CreateClusterRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateClusterRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(CreateClusterRequest::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(CreateClusterRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<VpcConfigRequest> RESOURCES_VPC_CONFIG_FIELD = SdkField
            .<VpcConfigRequest> builder(MarshallingType.SDK_POJO).memberName("resourcesVpcConfig")
            .getter(getter(CreateClusterRequest::resourcesVpcConfig)).setter(setter(Builder::resourcesVpcConfig))
            .constructor(VpcConfigRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourcesVpcConfig").build())
            .build();

    private static final SdkField<KubernetesNetworkConfigRequest> KUBERNETES_NETWORK_CONFIG_FIELD = SdkField
            .<KubernetesNetworkConfigRequest> builder(MarshallingType.SDK_POJO).memberName("kubernetesNetworkConfig")
            .getter(getter(CreateClusterRequest::kubernetesNetworkConfig)).setter(setter(Builder::kubernetesNetworkConfig))
            .constructor(KubernetesNetworkConfigRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kubernetesNetworkConfig").build())
            .build();

    private static final SdkField<Logging> LOGGING_FIELD = SdkField.<Logging> builder(MarshallingType.SDK_POJO)
            .memberName("logging").getter(getter(CreateClusterRequest::logging)).setter(setter(Builder::logging))
            .constructor(Logging::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logging").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientRequestToken")
            .getter(getter(CreateClusterRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateClusterRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<EncryptionConfig>> ENCRYPTION_CONFIG_FIELD = SdkField
            .<List<EncryptionConfig>> builder(MarshallingType.LIST)
            .memberName("encryptionConfig")
            .getter(getter(CreateClusterRequest::encryptionConfig))
            .setter(setter(Builder::encryptionConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionConfig").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EncryptionConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(EncryptionConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<OutpostConfigRequest> OUTPOST_CONFIG_FIELD = SdkField
            .<OutpostConfigRequest> builder(MarshallingType.SDK_POJO).memberName("outpostConfig")
            .getter(getter(CreateClusterRequest::outpostConfig)).setter(setter(Builder::outpostConfig))
            .constructor(OutpostConfigRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outpostConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VERSION_FIELD,
            ROLE_ARN_FIELD, RESOURCES_VPC_CONFIG_FIELD, KUBERNETES_NETWORK_CONFIG_FIELD, LOGGING_FIELD,
            CLIENT_REQUEST_TOKEN_FIELD, TAGS_FIELD, ENCRYPTION_CONFIG_FIELD, OUTPOST_CONFIG_FIELD));

    private final String name;

    private final String version;

    private final String roleArn;

    private final VpcConfigRequest resourcesVpcConfig;

    private final KubernetesNetworkConfigRequest kubernetesNetworkConfig;

    private final Logging logging;

    private final String clientRequestToken;

    private final Map<String, String> tags;

    private final List<EncryptionConfig> encryptionConfig;

    private final OutpostConfigRequest outpostConfig;

    private CreateClusterRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.version = builder.version;
        this.roleArn = builder.roleArn;
        this.resourcesVpcConfig = builder.resourcesVpcConfig;
        this.kubernetesNetworkConfig = builder.kubernetesNetworkConfig;
        this.logging = builder.logging;
        this.clientRequestToken = builder.clientRequestToken;
        this.tags = builder.tags;
        this.encryptionConfig = builder.encryptionConfig;
        this.outpostConfig = builder.outpostConfig;
    }

    /**
     * <p>
     * The unique name to give to your cluster.
     * </p>
     * 
     * @return The unique name to give to your cluster.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The desired Kubernetes version for your cluster. If you don't specify a value here, the default version available
     * in Amazon EKS is used.
     * </p>
     * <note>
     * <p>
     * The default version might not be the latest version available.
     * </p>
     * </note>
     * 
     * @return The desired Kubernetes version for your cluster. If you don't specify a value here, the default version
     *         available in Amazon EKS is used.</p> <note>
     *         <p>
     *         The default version might not be the latest version available.
     *         </p>
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that provides permissions for the Kubernetes control plane to make
     * calls to Amazon Web Services API operations on your behalf. For more information, see <a
     * href="https://docs.aws.amazon.com/eks/latest/userguide/service_IAM_role.html">Amazon EKS Service IAM Role</a> in
     * the <i> <i>Amazon EKS User Guide</i> </i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role that provides permissions for the Kubernetes control plane
     *         to make calls to Amazon Web Services API operations on your behalf. For more information, see <a
     *         href="https://docs.aws.amazon.com/eks/latest/userguide/service_IAM_role.html">Amazon EKS Service IAM
     *         Role</a> in the <i> <i>Amazon EKS User Guide</i> </i>.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The VPC configuration that's used by the cluster control plane. Amazon EKS VPC resources have specific
     * requirements to work properly with Kubernetes. For more information, see <a
     * href="https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html">Cluster VPC Considerations</a> and <a
     * href="https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html">Cluster Security Group
     * Considerations</a> in the <i>Amazon EKS User Guide</i>. You must specify at least two subnets. You can specify up
     * to five security groups. However, we recommend that you use a dedicated security group for your cluster control
     * plane.
     * </p>
     * 
     * @return The VPC configuration that's used by the cluster control plane. Amazon EKS VPC resources have specific
     *         requirements to work properly with Kubernetes. For more information, see <a
     *         href="https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html">Cluster VPC Considerations</a>
     *         and <a href="https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html">Cluster Security Group
     *         Considerations</a> in the <i>Amazon EKS User Guide</i>. You must specify at least two subnets. You can
     *         specify up to five security groups. However, we recommend that you use a dedicated security group for
     *         your cluster control plane.
     */
    public final VpcConfigRequest resourcesVpcConfig() {
        return resourcesVpcConfig;
    }

    /**
     * <p>
     * The Kubernetes network configuration for the cluster.
     * </p>
     * 
     * @return The Kubernetes network configuration for the cluster.
     */
    public final KubernetesNetworkConfigRequest kubernetesNetworkConfig() {
        return kubernetesNetworkConfig;
    }

    /**
     * <p>
     * Enable or disable exporting the Kubernetes control plane logs for your cluster to CloudWatch Logs. By default,
     * cluster control plane logs aren't exported to CloudWatch Logs. For more information, see <a
     * href="https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html">Amazon EKS Cluster control plane
     * logs</a> in the <i> <i>Amazon EKS User Guide</i> </i>.
     * </p>
     * <note>
     * <p>
     * CloudWatch Logs ingestion, archive storage, and data scanning rates apply to exported control plane logs. For
     * more information, see <a href="http://aws.amazon.com/cloudwatch/pricing/">CloudWatch Pricing</a>.
     * </p>
     * </note>
     * 
     * @return Enable or disable exporting the Kubernetes control plane logs for your cluster to CloudWatch Logs. By
     *         default, cluster control plane logs aren't exported to CloudWatch Logs. For more information, see <a
     *         href="https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html">Amazon EKS Cluster
     *         control plane logs</a> in the <i> <i>Amazon EKS User Guide</i> </i>.</p> <note>
     *         <p>
     *         CloudWatch Logs ingestion, archive storage, and data scanning rates apply to exported control plane logs.
     *         For more information, see <a href="http://aws.amazon.com/cloudwatch/pricing/">CloudWatch Pricing</a>.
     *         </p>
     */
    public final Logging logging() {
        return logging;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The metadata to apply to the cluster to assist with categorization and organization. Each tag consists of a key
     * and an optional value. You define both.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The metadata to apply to the cluster to assist with categorization and organization. Each tag consists of
     *         a key and an optional value. You define both.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the EncryptionConfig property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEncryptionConfig() {
        return encryptionConfig != null && !(encryptionConfig instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The encryption configuration for the cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEncryptionConfig} method.
     * </p>
     * 
     * @return The encryption configuration for the cluster.
     */
    public final List<EncryptionConfig> encryptionConfig() {
        return encryptionConfig;
    }

    /**
     * <p>
     * An object representing the configuration of your local Amazon EKS cluster on an Amazon Web Services Outpost.
     * Before creating a local cluster on an Outpost, review <a
     * href="https://docs.aws.amazon.com/eks/latest/userguide/eks-outposts-local-cluster-overview.html">Local clusters
     * for Amazon EKS on Amazon Web Services Outposts</a> in the <i>Amazon EKS User Guide</i>. This object isn't
     * available for creating Amazon EKS clusters on the Amazon Web Services cloud.
     * </p>
     * 
     * @return An object representing the configuration of your local Amazon EKS cluster on an Amazon Web Services
     *         Outpost. Before creating a local cluster on an Outpost, review <a
     *         href="https://docs.aws.amazon.com/eks/latest/userguide/eks-outposts-local-cluster-overview.html">Local
     *         clusters for Amazon EKS on Amazon Web Services Outposts</a> in the <i>Amazon EKS User Guide</i>. This
     *         object isn't available for creating Amazon EKS clusters on the Amazon Web Services cloud.
     */
    public final OutpostConfigRequest outpostConfig() {
        return outpostConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourcesVpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(kubernetesNetworkConfig());
        hashCode = 31 * hashCode + Objects.hashCode(logging());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEncryptionConfig() ? encryptionConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(outpostConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateClusterRequest)) {
            return false;
        }
        CreateClusterRequest other = (CreateClusterRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(version(), other.version())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(resourcesVpcConfig(), other.resourcesVpcConfig())
                && Objects.equals(kubernetesNetworkConfig(), other.kubernetesNetworkConfig())
                && Objects.equals(logging(), other.logging()) && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && hasEncryptionConfig() == other.hasEncryptionConfig()
                && Objects.equals(encryptionConfig(), other.encryptionConfig())
                && Objects.equals(outpostConfig(), other.outpostConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateClusterRequest").add("Name", name()).add("Version", version()).add("RoleArn", roleArn())
                .add("ResourcesVpcConfig", resourcesVpcConfig()).add("KubernetesNetworkConfig", kubernetesNetworkConfig())
                .add("Logging", logging()).add("ClientRequestToken", clientRequestToken()).add("Tags", hasTags() ? tags() : null)
                .add("EncryptionConfig", hasEncryptionConfig() ? encryptionConfig() : null).add("OutpostConfig", outpostConfig())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "resourcesVpcConfig":
            return Optional.ofNullable(clazz.cast(resourcesVpcConfig()));
        case "kubernetesNetworkConfig":
            return Optional.ofNullable(clazz.cast(kubernetesNetworkConfig()));
        case "logging":
            return Optional.ofNullable(clazz.cast(logging()));
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "encryptionConfig":
            return Optional.ofNullable(clazz.cast(encryptionConfig()));
        case "outpostConfig":
            return Optional.ofNullable(clazz.cast(outpostConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateClusterRequest, T> g) {
        return obj -> g.apply((CreateClusterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EksRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateClusterRequest> {
        /**
         * <p>
         * The unique name to give to your cluster.
         * </p>
         * 
         * @param name
         *        The unique name to give to your cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The desired Kubernetes version for your cluster. If you don't specify a value here, the default version
         * available in Amazon EKS is used.
         * </p>
         * <note>
         * <p>
         * The default version might not be the latest version available.
         * </p>
         * </note>
         * 
         * @param version
         *        The desired Kubernetes version for your cluster. If you don't specify a value here, the default
         *        version available in Amazon EKS is used.</p> <note>
         *        <p>
         *        The default version might not be the latest version available.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role that provides permissions for the Kubernetes control plane to
         * make calls to Amazon Web Services API operations on your behalf. For more information, see <a
         * href="https://docs.aws.amazon.com/eks/latest/userguide/service_IAM_role.html">Amazon EKS Service IAM Role</a>
         * in the <i> <i>Amazon EKS User Guide</i> </i>.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role that provides permissions for the Kubernetes control
         *        plane to make calls to Amazon Web Services API operations on your behalf. For more information, see <a
         *        href="https://docs.aws.amazon.com/eks/latest/userguide/service_IAM_role.html">Amazon EKS Service IAM
         *        Role</a> in the <i> <i>Amazon EKS User Guide</i> </i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The VPC configuration that's used by the cluster control plane. Amazon EKS VPC resources have specific
         * requirements to work properly with Kubernetes. For more information, see <a
         * href="https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html">Cluster VPC Considerations</a> and
         * <a href="https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html">Cluster Security Group
         * Considerations</a> in the <i>Amazon EKS User Guide</i>. You must specify at least two subnets. You can
         * specify up to five security groups. However, we recommend that you use a dedicated security group for your
         * cluster control plane.
         * </p>
         * 
         * @param resourcesVpcConfig
         *        The VPC configuration that's used by the cluster control plane. Amazon EKS VPC resources have specific
         *        requirements to work properly with Kubernetes. For more information, see <a
         *        href="https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html">Cluster VPC
         *        Considerations</a> and <a
         *        href="https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html">Cluster Security Group
         *        Considerations</a> in the <i>Amazon EKS User Guide</i>. You must specify at least two subnets. You can
         *        specify up to five security groups. However, we recommend that you use a dedicated security group for
         *        your cluster control plane.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcesVpcConfig(VpcConfigRequest resourcesVpcConfig);

        /**
         * <p>
         * The VPC configuration that's used by the cluster control plane. Amazon EKS VPC resources have specific
         * requirements to work properly with Kubernetes. For more information, see <a
         * href="https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html">Cluster VPC Considerations</a> and
         * <a href="https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html">Cluster Security Group
         * Considerations</a> in the <i>Amazon EKS User Guide</i>. You must specify at least two subnets. You can
         * specify up to five security groups. However, we recommend that you use a dedicated security group for your
         * cluster control plane.
         * </p>
         * This is a convenience method that creates an instance of the {@link VpcConfigRequest.Builder} avoiding the
         * need to create one manually via {@link VpcConfigRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcConfigRequest.Builder#build()} is called immediately and its
         * result is passed to {@link #resourcesVpcConfig(VpcConfigRequest)}.
         * 
         * @param resourcesVpcConfig
         *        a consumer that will call methods on {@link VpcConfigRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourcesVpcConfig(VpcConfigRequest)
         */
        default Builder resourcesVpcConfig(Consumer<VpcConfigRequest.Builder> resourcesVpcConfig) {
            return resourcesVpcConfig(VpcConfigRequest.builder().applyMutation(resourcesVpcConfig).build());
        }

        /**
         * <p>
         * The Kubernetes network configuration for the cluster.
         * </p>
         * 
         * @param kubernetesNetworkConfig
         *        The Kubernetes network configuration for the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kubernetesNetworkConfig(KubernetesNetworkConfigRequest kubernetesNetworkConfig);

        /**
         * <p>
         * The Kubernetes network configuration for the cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link KubernetesNetworkConfigRequest.Builder}
         * avoiding the need to create one manually via {@link KubernetesNetworkConfigRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KubernetesNetworkConfigRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #kubernetesNetworkConfig(KubernetesNetworkConfigRequest)}.
         * 
         * @param kubernetesNetworkConfig
         *        a consumer that will call methods on {@link KubernetesNetworkConfigRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kubernetesNetworkConfig(KubernetesNetworkConfigRequest)
         */
        default Builder kubernetesNetworkConfig(Consumer<KubernetesNetworkConfigRequest.Builder> kubernetesNetworkConfig) {
            return kubernetesNetworkConfig(KubernetesNetworkConfigRequest.builder().applyMutation(kubernetesNetworkConfig)
                    .build());
        }

        /**
         * <p>
         * Enable or disable exporting the Kubernetes control plane logs for your cluster to CloudWatch Logs. By
         * default, cluster control plane logs aren't exported to CloudWatch Logs. For more information, see <a
         * href="https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html">Amazon EKS Cluster control
         * plane logs</a> in the <i> <i>Amazon EKS User Guide</i> </i>.
         * </p>
         * <note>
         * <p>
         * CloudWatch Logs ingestion, archive storage, and data scanning rates apply to exported control plane logs. For
         * more information, see <a href="http://aws.amazon.com/cloudwatch/pricing/">CloudWatch Pricing</a>.
         * </p>
         * </note>
         * 
         * @param logging
         *        Enable or disable exporting the Kubernetes control plane logs for your cluster to CloudWatch Logs. By
         *        default, cluster control plane logs aren't exported to CloudWatch Logs. For more information, see <a
         *        href="https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html">Amazon EKS Cluster
         *        control plane logs</a> in the <i> <i>Amazon EKS User Guide</i> </i>.</p> <note>
         *        <p>
         *        CloudWatch Logs ingestion, archive storage, and data scanning rates apply to exported control plane
         *        logs. For more information, see <a href="http://aws.amazon.com/cloudwatch/pricing/">CloudWatch
         *        Pricing</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logging(Logging logging);

        /**
         * <p>
         * Enable or disable exporting the Kubernetes control plane logs for your cluster to CloudWatch Logs. By
         * default, cluster control plane logs aren't exported to CloudWatch Logs. For more information, see <a
         * href="https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html">Amazon EKS Cluster control
         * plane logs</a> in the <i> <i>Amazon EKS User Guide</i> </i>.
         * </p>
         * <note>
         * <p>
         * CloudWatch Logs ingestion, archive storage, and data scanning rates apply to exported control plane logs. For
         * more information, see <a href="http://aws.amazon.com/cloudwatch/pricing/">CloudWatch Pricing</a>.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link Logging.Builder} avoiding the
         * need to create one manually via {@link Logging#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Logging.Builder#build()} is called immediately and its result is
         * passed to {@link #logging(Logging)}.
         * 
         * @param logging
         *        a consumer that will call methods on {@link Logging.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logging(Logging)
         */
        default Builder logging(Consumer<Logging.Builder> logging) {
            return logging(Logging.builder().applyMutation(logging).build());
        }

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientRequestToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The metadata to apply to the cluster to assist with categorization and organization. Each tag consists of a
         * key and an optional value. You define both.
         * </p>
         * 
         * @param tags
         *        The metadata to apply to the cluster to assist with categorization and organization. Each tag consists
         *        of a key and an optional value. You define both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The encryption configuration for the cluster.
         * </p>
         * 
         * @param encryptionConfig
         *        The encryption configuration for the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionConfig(Collection<EncryptionConfig> encryptionConfig);

        /**
         * <p>
         * The encryption configuration for the cluster.
         * </p>
         * 
         * @param encryptionConfig
         *        The encryption configuration for the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionConfig(EncryptionConfig... encryptionConfig);

        /**
         * <p>
         * The encryption configuration for the cluster.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.eks.model.EncryptionConfig.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.eks.model.EncryptionConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.eks.model.EncryptionConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #encryptionConfig(List<EncryptionConfig>)}.
         * 
         * @param encryptionConfig
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.eks.model.EncryptionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionConfig(java.util.Collection<EncryptionConfig>)
         */
        Builder encryptionConfig(Consumer<EncryptionConfig.Builder>... encryptionConfig);

        /**
         * <p>
         * An object representing the configuration of your local Amazon EKS cluster on an Amazon Web Services Outpost.
         * Before creating a local cluster on an Outpost, review <a
         * href="https://docs.aws.amazon.com/eks/latest/userguide/eks-outposts-local-cluster-overview.html">Local
         * clusters for Amazon EKS on Amazon Web Services Outposts</a> in the <i>Amazon EKS User Guide</i>. This object
         * isn't available for creating Amazon EKS clusters on the Amazon Web Services cloud.
         * </p>
         * 
         * @param outpostConfig
         *        An object representing the configuration of your local Amazon EKS cluster on an Amazon Web Services
         *        Outpost. Before creating a local cluster on an Outpost, review <a
         *        href="https://docs.aws.amazon.com/eks/latest/userguide/eks-outposts-local-cluster-overview.html">Local
         *        clusters for Amazon EKS on Amazon Web Services Outposts</a> in the <i>Amazon EKS User Guide</i>. This
         *        object isn't available for creating Amazon EKS clusters on the Amazon Web Services cloud.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outpostConfig(OutpostConfigRequest outpostConfig);

        /**
         * <p>
         * An object representing the configuration of your local Amazon EKS cluster on an Amazon Web Services Outpost.
         * Before creating a local cluster on an Outpost, review <a
         * href="https://docs.aws.amazon.com/eks/latest/userguide/eks-outposts-local-cluster-overview.html">Local
         * clusters for Amazon EKS on Amazon Web Services Outposts</a> in the <i>Amazon EKS User Guide</i>. This object
         * isn't available for creating Amazon EKS clusters on the Amazon Web Services cloud.
         * </p>
         * This is a convenience method that creates an instance of the {@link OutpostConfigRequest.Builder} avoiding
         * the need to create one manually via {@link OutpostConfigRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OutpostConfigRequest.Builder#build()} is called immediately and
         * its result is passed to {@link #outpostConfig(OutpostConfigRequest)}.
         * 
         * @param outpostConfig
         *        a consumer that will call methods on {@link OutpostConfigRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outpostConfig(OutpostConfigRequest)
         */
        default Builder outpostConfig(Consumer<OutpostConfigRequest.Builder> outpostConfig) {
            return outpostConfig(OutpostConfigRequest.builder().applyMutation(outpostConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EksRequest.BuilderImpl implements Builder {
        private String name;

        private String version;

        private String roleArn;

        private VpcConfigRequest resourcesVpcConfig;

        private KubernetesNetworkConfigRequest kubernetesNetworkConfig;

        private Logging logging;

        private String clientRequestToken;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private List<EncryptionConfig> encryptionConfig = DefaultSdkAutoConstructList.getInstance();

        private OutpostConfigRequest outpostConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateClusterRequest model) {
            super(model);
            name(model.name);
            version(model.version);
            roleArn(model.roleArn);
            resourcesVpcConfig(model.resourcesVpcConfig);
            kubernetesNetworkConfig(model.kubernetesNetworkConfig);
            logging(model.logging);
            clientRequestToken(model.clientRequestToken);
            tags(model.tags);
            encryptionConfig(model.encryptionConfig);
            outpostConfig(model.outpostConfig);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final VpcConfigRequest.Builder getResourcesVpcConfig() {
            return resourcesVpcConfig != null ? resourcesVpcConfig.toBuilder() : null;
        }

        public final void setResourcesVpcConfig(VpcConfigRequest.BuilderImpl resourcesVpcConfig) {
            this.resourcesVpcConfig = resourcesVpcConfig != null ? resourcesVpcConfig.build() : null;
        }

        @Override
        public final Builder resourcesVpcConfig(VpcConfigRequest resourcesVpcConfig) {
            this.resourcesVpcConfig = resourcesVpcConfig;
            return this;
        }

        public final KubernetesNetworkConfigRequest.Builder getKubernetesNetworkConfig() {
            return kubernetesNetworkConfig != null ? kubernetesNetworkConfig.toBuilder() : null;
        }

        public final void setKubernetesNetworkConfig(KubernetesNetworkConfigRequest.BuilderImpl kubernetesNetworkConfig) {
            this.kubernetesNetworkConfig = kubernetesNetworkConfig != null ? kubernetesNetworkConfig.build() : null;
        }

        @Override
        public final Builder kubernetesNetworkConfig(KubernetesNetworkConfigRequest kubernetesNetworkConfig) {
            this.kubernetesNetworkConfig = kubernetesNetworkConfig;
            return this;
        }

        public final Logging.Builder getLogging() {
            return logging != null ? logging.toBuilder() : null;
        }

        public final void setLogging(Logging.BuilderImpl logging) {
            this.logging = logging != null ? logging.build() : null;
        }

        @Override
        public final Builder logging(Logging logging) {
            this.logging = logging;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final List<EncryptionConfig.Builder> getEncryptionConfig() {
            List<EncryptionConfig.Builder> result = EncryptionConfigListCopier.copyToBuilder(this.encryptionConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEncryptionConfig(Collection<EncryptionConfig.BuilderImpl> encryptionConfig) {
            this.encryptionConfig = EncryptionConfigListCopier.copyFromBuilder(encryptionConfig);
        }

        @Override
        public final Builder encryptionConfig(Collection<EncryptionConfig> encryptionConfig) {
            this.encryptionConfig = EncryptionConfigListCopier.copy(encryptionConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder encryptionConfig(EncryptionConfig... encryptionConfig) {
            encryptionConfig(Arrays.asList(encryptionConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder encryptionConfig(Consumer<EncryptionConfig.Builder>... encryptionConfig) {
            encryptionConfig(Stream.of(encryptionConfig).map(c -> EncryptionConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final OutpostConfigRequest.Builder getOutpostConfig() {
            return outpostConfig != null ? outpostConfig.toBuilder() : null;
        }

        public final void setOutpostConfig(OutpostConfigRequest.BuilderImpl outpostConfig) {
            this.outpostConfig = outpostConfig != null ? outpostConfig.build() : null;
        }

        @Override
        public final Builder outpostConfig(OutpostConfigRequest outpostConfig) {
            this.outpostConfig = outpostConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateClusterRequest build() {
            return new CreateClusterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
