/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for ModifyNetworkInterfaceAttribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyNetworkInterfaceAttributeRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyNetworkInterfaceAttributeRequest.Builder, ModifyNetworkInterfaceAttributeRequest> {
    private static final SdkField<NetworkInterfaceAttachmentChanges> ATTACHMENT_FIELD = SdkField
            .<NetworkInterfaceAttachmentChanges> builder(MarshallingType.SDK_POJO)
            .memberName("Attachment")
            .getter(getter(ModifyNetworkInterfaceAttributeRequest::attachment))
            .setter(setter(Builder::attachment))
            .constructor(NetworkInterfaceAttachmentChanges::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attachment")
                    .unmarshallLocationName("attachment").build()).build();

    private static final SdkField<AttributeValue> DESCRIPTION_FIELD = SdkField
            .<AttributeValue> builder(MarshallingType.SDK_POJO)
            .memberName("Description")
            .getter(getter(ModifyNetworkInterfaceAttributeRequest::description))
            .setter(setter(Builder::description))
            .constructor(AttributeValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("description").build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(ModifyNetworkInterfaceAttributeRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("dryRun").build()).build();

    private static final SdkField<List<String>> GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Groups")
            .getter(getter(ModifyNetworkInterfaceAttributeRequest::groups))
            .setter(setter(Builder::groups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupId")
                    .unmarshallLocationName("SecurityGroupId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("SecurityGroupId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("SecurityGroupId").unmarshallLocationName("SecurityGroupId")
                                                    .build()).build()).build()).build();

    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkInterfaceId")
            .getter(getter(ModifyNetworkInterfaceAttributeRequest::networkInterfaceId))
            .setter(setter(Builder::networkInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId")
                    .unmarshallLocationName("networkInterfaceId").build()).build();

    private static final SdkField<AttributeBooleanValue> SOURCE_DEST_CHECK_FIELD = SdkField
            .<AttributeBooleanValue> builder(MarshallingType.SDK_POJO)
            .memberName("SourceDestCheck")
            .getter(getter(ModifyNetworkInterfaceAttributeRequest::sourceDestCheck))
            .setter(setter(Builder::sourceDestCheck))
            .constructor(AttributeBooleanValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDestCheck")
                    .unmarshallLocationName("sourceDestCheck").build()).build();

    private static final SdkField<EnaSrdSpecification> ENA_SRD_SPECIFICATION_FIELD = SdkField
            .<EnaSrdSpecification> builder(MarshallingType.SDK_POJO)
            .memberName("EnaSrdSpecification")
            .getter(getter(ModifyNetworkInterfaceAttributeRequest::enaSrdSpecification))
            .setter(setter(Builder::enaSrdSpecification))
            .constructor(EnaSrdSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnaSrdSpecification")
                    .unmarshallLocationName("EnaSrdSpecification").build()).build();

    private static final SdkField<Boolean> ENABLE_PRIMARY_IPV6_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnablePrimaryIpv6")
            .getter(getter(ModifyNetworkInterfaceAttributeRequest::enablePrimaryIpv6))
            .setter(setter(Builder::enablePrimaryIpv6))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnablePrimaryIpv6")
                    .unmarshallLocationName("EnablePrimaryIpv6").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENT_FIELD,
            DESCRIPTION_FIELD, DRY_RUN_FIELD, GROUPS_FIELD, NETWORK_INTERFACE_ID_FIELD, SOURCE_DEST_CHECK_FIELD,
            ENA_SRD_SPECIFICATION_FIELD, ENABLE_PRIMARY_IPV6_FIELD));

    private final NetworkInterfaceAttachmentChanges attachment;

    private final AttributeValue description;

    private final Boolean dryRun;

    private final List<String> groups;

    private final String networkInterfaceId;

    private final AttributeBooleanValue sourceDestCheck;

    private final EnaSrdSpecification enaSrdSpecification;

    private final Boolean enablePrimaryIpv6;

    private ModifyNetworkInterfaceAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.attachment = builder.attachment;
        this.description = builder.description;
        this.dryRun = builder.dryRun;
        this.groups = builder.groups;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.sourceDestCheck = builder.sourceDestCheck;
        this.enaSrdSpecification = builder.enaSrdSpecification;
        this.enablePrimaryIpv6 = builder.enablePrimaryIpv6;
    }

    /**
     * <p>
     * Information about the interface attachment. If modifying the <code>delete on termination</code> attribute, you
     * must specify the ID of the interface attachment.
     * </p>
     * 
     * @return Information about the interface attachment. If modifying the <code>delete on termination</code>
     *         attribute, you must specify the ID of the interface attachment.
     */
    public final NetworkInterfaceAttachmentChanges attachment() {
        return attachment;
    }

    /**
     * <p>
     * A description for the network interface.
     * </p>
     * 
     * @return A description for the network interface.
     */
    public final AttributeValue description() {
        return description;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * For responses, this returns true if the service returned a value for the Groups property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasGroups() {
        return groups != null && !(groups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Changes the security groups for the network interface. The new set of groups you specify replaces the current
     * set. You must specify at least one group, even if it's just the default security group in the VPC. You must
     * specify the ID of the security group, not the name.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroups} method.
     * </p>
     * 
     * @return Changes the security groups for the network interface. The new set of groups you specify replaces the
     *         current set. You must specify at least one group, even if it's just the default security group in the
     *         VPC. You must specify the ID of the security group, not the name.
     */
    public final List<String> groups() {
        return groups;
    }

    /**
     * <p>
     * The ID of the network interface.
     * </p>
     * 
     * @return The ID of the network interface.
     */
    public final String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * <p>
     * Enable or disable source/destination checks, which ensure that the instance is either the source or the
     * destination of any traffic that it receives. If the value is <code>true</code>, source/destination checks are
     * enabled; otherwise, they are disabled. The default value is <code>true</code>. You must disable
     * source/destination checks if the instance runs services such as network address translation, routing, or
     * firewalls.
     * </p>
     * 
     * @return Enable or disable source/destination checks, which ensure that the instance is either the source or the
     *         destination of any traffic that it receives. If the value is <code>true</code>, source/destination checks
     *         are enabled; otherwise, they are disabled. The default value is <code>true</code>. You must disable
     *         source/destination checks if the instance runs services such as network address translation, routing, or
     *         firewalls.
     */
    public final AttributeBooleanValue sourceDestCheck() {
        return sourceDestCheck;
    }

    /**
     * <p>
     * Updates the ENA Express configuration for the network interface that’s attached to the instance.
     * </p>
     * 
     * @return Updates the ENA Express configuration for the network interface that’s attached to the instance.
     */
    public final EnaSrdSpecification enaSrdSpecification() {
        return enaSrdSpecification;
    }

    /**
     * <p>
     * If you’re modifying a network interface in a dual-stack or IPv6-only subnet, you have the option to assign a
     * primary IPv6 IP address. A primary IPv6 address is an IPv6 GUA address associated with an ENI that you have
     * enabled to use a primary IPv6 address. Use this option if the instance that this ENI will be attached to relies
     * on its IPv6 address not changing. Amazon Web Services will automatically assign an IPv6 address associated with
     * the ENI attached to your instance to be the primary IPv6 address. Once you enable an IPv6 GUA address to be a
     * primary IPv6, you cannot disable it. When you enable an IPv6 GUA address to be a primary IPv6, the first IPv6 GUA
     * will be made the primary IPv6 address until the instance is terminated or the network interface is detached. If
     * you have multiple IPv6 addresses associated with an ENI attached to your instance and you enable a primary IPv6
     * address, the first IPv6 GUA address associated with the ENI becomes the primary IPv6 address.
     * </p>
     * 
     * @return If you’re modifying a network interface in a dual-stack or IPv6-only subnet, you have the option to
     *         assign a primary IPv6 IP address. A primary IPv6 address is an IPv6 GUA address associated with an ENI
     *         that you have enabled to use a primary IPv6 address. Use this option if the instance that this ENI will
     *         be attached to relies on its IPv6 address not changing. Amazon Web Services will automatically assign an
     *         IPv6 address associated with the ENI attached to your instance to be the primary IPv6 address. Once you
     *         enable an IPv6 GUA address to be a primary IPv6, you cannot disable it. When you enable an IPv6 GUA
     *         address to be a primary IPv6, the first IPv6 GUA will be made the primary IPv6 address until the instance
     *         is terminated or the network interface is detached. If you have multiple IPv6 addresses associated with
     *         an ENI attached to your instance and you enable a primary IPv6 address, the first IPv6 GUA address
     *         associated with the ENI becomes the primary IPv6 address.
     */
    public final Boolean enablePrimaryIpv6() {
        return enablePrimaryIpv6;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(attachment());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(hasGroups() ? groups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(sourceDestCheck());
        hashCode = 31 * hashCode + Objects.hashCode(enaSrdSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(enablePrimaryIpv6());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyNetworkInterfaceAttributeRequest)) {
            return false;
        }
        ModifyNetworkInterfaceAttributeRequest other = (ModifyNetworkInterfaceAttributeRequest) obj;
        return Objects.equals(attachment(), other.attachment()) && Objects.equals(description(), other.description())
                && Objects.equals(dryRun(), other.dryRun()) && hasGroups() == other.hasGroups()
                && Objects.equals(groups(), other.groups()) && Objects.equals(networkInterfaceId(), other.networkInterfaceId())
                && Objects.equals(sourceDestCheck(), other.sourceDestCheck())
                && Objects.equals(enaSrdSpecification(), other.enaSrdSpecification())
                && Objects.equals(enablePrimaryIpv6(), other.enablePrimaryIpv6());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyNetworkInterfaceAttributeRequest").add("Attachment", attachment())
                .add("Description", description()).add("DryRun", dryRun()).add("Groups", hasGroups() ? groups() : null)
                .add("NetworkInterfaceId", networkInterfaceId()).add("SourceDestCheck", sourceDestCheck())
                .add("EnaSrdSpecification", enaSrdSpecification()).add("EnablePrimaryIpv6", enablePrimaryIpv6()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attachment":
            return Optional.ofNullable(clazz.cast(attachment()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "Groups":
            return Optional.ofNullable(clazz.cast(groups()));
        case "NetworkInterfaceId":
            return Optional.ofNullable(clazz.cast(networkInterfaceId()));
        case "SourceDestCheck":
            return Optional.ofNullable(clazz.cast(sourceDestCheck()));
        case "EnaSrdSpecification":
            return Optional.ofNullable(clazz.cast(enaSrdSpecification()));
        case "EnablePrimaryIpv6":
            return Optional.ofNullable(clazz.cast(enablePrimaryIpv6()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyNetworkInterfaceAttributeRequest, T> g) {
        return obj -> g.apply((ModifyNetworkInterfaceAttributeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyNetworkInterfaceAttributeRequest> {
        /**
         * <p>
         * Information about the interface attachment. If modifying the <code>delete on termination</code> attribute,
         * you must specify the ID of the interface attachment.
         * </p>
         * 
         * @param attachment
         *        Information about the interface attachment. If modifying the <code>delete on termination</code>
         *        attribute, you must specify the ID of the interface attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachment(NetworkInterfaceAttachmentChanges attachment);

        /**
         * <p>
         * Information about the interface attachment. If modifying the <code>delete on termination</code> attribute,
         * you must specify the ID of the interface attachment.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link NetworkInterfaceAttachmentChanges.Builder} avoiding the need to create one manually via
         * {@link NetworkInterfaceAttachmentChanges#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NetworkInterfaceAttachmentChanges.Builder#build()} is called
         * immediately and its result is passed to {@link #attachment(NetworkInterfaceAttachmentChanges)}.
         * 
         * @param attachment
         *        a consumer that will call methods on {@link NetworkInterfaceAttachmentChanges.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachment(NetworkInterfaceAttachmentChanges)
         */
        default Builder attachment(Consumer<NetworkInterfaceAttachmentChanges.Builder> attachment) {
            return attachment(NetworkInterfaceAttachmentChanges.builder().applyMutation(attachment).build());
        }

        /**
         * <p>
         * A description for the network interface.
         * </p>
         * 
         * @param description
         *        A description for the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(AttributeValue description);

        /**
         * <p>
         * A description for the network interface.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttributeValue.Builder} avoiding the need
         * to create one manually via {@link AttributeValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttributeValue.Builder#build()} is called immediately and its
         * result is passed to {@link #description(AttributeValue)}.
         * 
         * @param description
         *        a consumer that will call methods on {@link AttributeValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #description(AttributeValue)
         */
        default Builder description(Consumer<AttributeValue.Builder> description) {
            return description(AttributeValue.builder().applyMutation(description).build());
        }

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * Changes the security groups for the network interface. The new set of groups you specify replaces the current
         * set. You must specify at least one group, even if it's just the default security group in the VPC. You must
         * specify the ID of the security group, not the name.
         * </p>
         * 
         * @param groups
         *        Changes the security groups for the network interface. The new set of groups you specify replaces the
         *        current set. You must specify at least one group, even if it's just the default security group in the
         *        VPC. You must specify the ID of the security group, not the name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(Collection<String> groups);

        /**
         * <p>
         * Changes the security groups for the network interface. The new set of groups you specify replaces the current
         * set. You must specify at least one group, even if it's just the default security group in the VPC. You must
         * specify the ID of the security group, not the name.
         * </p>
         * 
         * @param groups
         *        Changes the security groups for the network interface. The new set of groups you specify replaces the
         *        current set. You must specify at least one group, even if it's just the default security group in the
         *        VPC. You must specify the ID of the security group, not the name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(String... groups);

        /**
         * <p>
         * The ID of the network interface.
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * Enable or disable source/destination checks, which ensure that the instance is either the source or the
         * destination of any traffic that it receives. If the value is <code>true</code>, source/destination checks are
         * enabled; otherwise, they are disabled. The default value is <code>true</code>. You must disable
         * source/destination checks if the instance runs services such as network address translation, routing, or
         * firewalls.
         * </p>
         * 
         * @param sourceDestCheck
         *        Enable or disable source/destination checks, which ensure that the instance is either the source or
         *        the destination of any traffic that it receives. If the value is <code>true</code>, source/destination
         *        checks are enabled; otherwise, they are disabled. The default value is <code>true</code>. You must
         *        disable source/destination checks if the instance runs services such as network address translation,
         *        routing, or firewalls.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDestCheck(AttributeBooleanValue sourceDestCheck);

        /**
         * <p>
         * Enable or disable source/destination checks, which ensure that the instance is either the source or the
         * destination of any traffic that it receives. If the value is <code>true</code>, source/destination checks are
         * enabled; otherwise, they are disabled. The default value is <code>true</code>. You must disable
         * source/destination checks if the instance runs services such as network address translation, routing, or
         * firewalls.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttributeBooleanValue.Builder} avoiding
         * the need to create one manually via {@link AttributeBooleanValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttributeBooleanValue.Builder#build()} is called immediately and
         * its result is passed to {@link #sourceDestCheck(AttributeBooleanValue)}.
         * 
         * @param sourceDestCheck
         *        a consumer that will call methods on {@link AttributeBooleanValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceDestCheck(AttributeBooleanValue)
         */
        default Builder sourceDestCheck(Consumer<AttributeBooleanValue.Builder> sourceDestCheck) {
            return sourceDestCheck(AttributeBooleanValue.builder().applyMutation(sourceDestCheck).build());
        }

        /**
         * <p>
         * Updates the ENA Express configuration for the network interface that’s attached to the instance.
         * </p>
         * 
         * @param enaSrdSpecification
         *        Updates the ENA Express configuration for the network interface that’s attached to the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enaSrdSpecification(EnaSrdSpecification enaSrdSpecification);

        /**
         * <p>
         * Updates the ENA Express configuration for the network interface that’s attached to the instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link EnaSrdSpecification.Builder} avoiding the
         * need to create one manually via {@link EnaSrdSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EnaSrdSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #enaSrdSpecification(EnaSrdSpecification)}.
         * 
         * @param enaSrdSpecification
         *        a consumer that will call methods on {@link EnaSrdSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #enaSrdSpecification(EnaSrdSpecification)
         */
        default Builder enaSrdSpecification(Consumer<EnaSrdSpecification.Builder> enaSrdSpecification) {
            return enaSrdSpecification(EnaSrdSpecification.builder().applyMutation(enaSrdSpecification).build());
        }

        /**
         * <p>
         * If you’re modifying a network interface in a dual-stack or IPv6-only subnet, you have the option to assign a
         * primary IPv6 IP address. A primary IPv6 address is an IPv6 GUA address associated with an ENI that you have
         * enabled to use a primary IPv6 address. Use this option if the instance that this ENI will be attached to
         * relies on its IPv6 address not changing. Amazon Web Services will automatically assign an IPv6 address
         * associated with the ENI attached to your instance to be the primary IPv6 address. Once you enable an IPv6 GUA
         * address to be a primary IPv6, you cannot disable it. When you enable an IPv6 GUA address to be a primary
         * IPv6, the first IPv6 GUA will be made the primary IPv6 address until the instance is terminated or the
         * network interface is detached. If you have multiple IPv6 addresses associated with an ENI attached to your
         * instance and you enable a primary IPv6 address, the first IPv6 GUA address associated with the ENI becomes
         * the primary IPv6 address.
         * </p>
         * 
         * @param enablePrimaryIpv6
         *        If you’re modifying a network interface in a dual-stack or IPv6-only subnet, you have the option to
         *        assign a primary IPv6 IP address. A primary IPv6 address is an IPv6 GUA address associated with an ENI
         *        that you have enabled to use a primary IPv6 address. Use this option if the instance that this ENI
         *        will be attached to relies on its IPv6 address not changing. Amazon Web Services will automatically
         *        assign an IPv6 address associated with the ENI attached to your instance to be the primary IPv6
         *        address. Once you enable an IPv6 GUA address to be a primary IPv6, you cannot disable it. When you
         *        enable an IPv6 GUA address to be a primary IPv6, the first IPv6 GUA will be made the primary IPv6
         *        address until the instance is terminated or the network interface is detached. If you have multiple
         *        IPv6 addresses associated with an ENI attached to your instance and you enable a primary IPv6 address,
         *        the first IPv6 GUA address associated with the ENI becomes the primary IPv6 address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enablePrimaryIpv6(Boolean enablePrimaryIpv6);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private NetworkInterfaceAttachmentChanges attachment;

        private AttributeValue description;

        private Boolean dryRun;

        private List<String> groups = DefaultSdkAutoConstructList.getInstance();

        private String networkInterfaceId;

        private AttributeBooleanValue sourceDestCheck;

        private EnaSrdSpecification enaSrdSpecification;

        private Boolean enablePrimaryIpv6;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyNetworkInterfaceAttributeRequest model) {
            super(model);
            attachment(model.attachment);
            description(model.description);
            dryRun(model.dryRun);
            groups(model.groups);
            networkInterfaceId(model.networkInterfaceId);
            sourceDestCheck(model.sourceDestCheck);
            enaSrdSpecification(model.enaSrdSpecification);
            enablePrimaryIpv6(model.enablePrimaryIpv6);
        }

        public final NetworkInterfaceAttachmentChanges.Builder getAttachment() {
            return attachment != null ? attachment.toBuilder() : null;
        }

        public final void setAttachment(NetworkInterfaceAttachmentChanges.BuilderImpl attachment) {
            this.attachment = attachment != null ? attachment.build() : null;
        }

        @Override
        public final Builder attachment(NetworkInterfaceAttachmentChanges attachment) {
            this.attachment = attachment;
            return this;
        }

        public final AttributeValue.Builder getDescription() {
            return description != null ? description.toBuilder() : null;
        }

        public final void setDescription(AttributeValue.BuilderImpl description) {
            this.description = description != null ? description.build() : null;
        }

        @Override
        public final Builder description(AttributeValue description) {
            this.description = description;
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final Collection<String> getGroups() {
            if (groups instanceof SdkAutoConstructList) {
                return null;
            }
            return groups;
        }

        public final void setGroups(Collection<String> groups) {
            this.groups = SecurityGroupIdStringListCopier.copy(groups);
        }

        @Override
        public final Builder groups(Collection<String> groups) {
            this.groups = SecurityGroupIdStringListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(String... groups) {
            groups(Arrays.asList(groups));
            return this;
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final AttributeBooleanValue.Builder getSourceDestCheck() {
            return sourceDestCheck != null ? sourceDestCheck.toBuilder() : null;
        }

        public final void setSourceDestCheck(AttributeBooleanValue.BuilderImpl sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck != null ? sourceDestCheck.build() : null;
        }

        @Override
        public final Builder sourceDestCheck(AttributeBooleanValue sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
            return this;
        }

        public final EnaSrdSpecification.Builder getEnaSrdSpecification() {
            return enaSrdSpecification != null ? enaSrdSpecification.toBuilder() : null;
        }

        public final void setEnaSrdSpecification(EnaSrdSpecification.BuilderImpl enaSrdSpecification) {
            this.enaSrdSpecification = enaSrdSpecification != null ? enaSrdSpecification.build() : null;
        }

        @Override
        public final Builder enaSrdSpecification(EnaSrdSpecification enaSrdSpecification) {
            this.enaSrdSpecification = enaSrdSpecification;
            return this;
        }

        public final Boolean getEnablePrimaryIpv6() {
            return enablePrimaryIpv6;
        }

        public final void setEnablePrimaryIpv6(Boolean enablePrimaryIpv6) {
            this.enablePrimaryIpv6 = enablePrimaryIpv6;
        }

        @Override
        public final Builder enablePrimaryIpv6(Boolean enablePrimaryIpv6) {
            this.enablePrimaryIpv6 = enablePrimaryIpv6;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyNetworkInterfaceAttributeRequest build() {
            return new ModifyNetworkInterfaceAttributeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
