/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A JSON object that specifies the paths where the artifacts generated by the customer's tests, on the device or in the
 * test environment, are pulled from.
 * </p>
 * <p>
 * Specify <code>deviceHostPaths</code> and optionally specify either <code>iosPaths</code> or <code>androidPaths</code>
 * .
 * </p>
 * <p>
 * For web app tests, you can specify both <code>iosPaths</code> and <code>androidPaths</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomerArtifactPaths implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomerArtifactPaths.Builder, CustomerArtifactPaths> {
    private static final SdkField<List<String>> IOS_PATHS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("iosPaths")
            .getter(getter(CustomerArtifactPaths::iosPaths))
            .setter(setter(Builder::iosPaths))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iosPaths").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ANDROID_PATHS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("androidPaths")
            .getter(getter(CustomerArtifactPaths::androidPaths))
            .setter(setter(Builder::androidPaths))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("androidPaths").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> DEVICE_HOST_PATHS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("deviceHostPaths")
            .getter(getter(CustomerArtifactPaths::deviceHostPaths))
            .setter(setter(Builder::deviceHostPaths))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceHostPaths").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IOS_PATHS_FIELD,
            ANDROID_PATHS_FIELD, DEVICE_HOST_PATHS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> iosPaths;

    private final List<String> androidPaths;

    private final List<String> deviceHostPaths;

    private CustomerArtifactPaths(BuilderImpl builder) {
        this.iosPaths = builder.iosPaths;
        this.androidPaths = builder.androidPaths;
        this.deviceHostPaths = builder.deviceHostPaths;
    }

    /**
     * For responses, this returns true if the service returned a value for the IosPaths property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasIosPaths() {
        return iosPaths != null && !(iosPaths instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Comma-separated list of paths on the iOS device where the artifacts generated by the customer's tests are pulled
     * from.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIosPaths} method.
     * </p>
     * 
     * @return Comma-separated list of paths on the iOS device where the artifacts generated by the customer's tests are
     *         pulled from.
     */
    public final List<String> iosPaths() {
        return iosPaths;
    }

    /**
     * For responses, this returns true if the service returned a value for the AndroidPaths property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAndroidPaths() {
        return androidPaths != null && !(androidPaths instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Comma-separated list of paths on the Android device where the artifacts generated by the customer's tests are
     * pulled from.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAndroidPaths} method.
     * </p>
     * 
     * @return Comma-separated list of paths on the Android device where the artifacts generated by the customer's tests
     *         are pulled from.
     */
    public final List<String> androidPaths() {
        return androidPaths;
    }

    /**
     * For responses, this returns true if the service returned a value for the DeviceHostPaths property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDeviceHostPaths() {
        return deviceHostPaths != null && !(deviceHostPaths instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Comma-separated list of paths in the test execution environment where the artifacts generated by the customer's
     * tests are pulled from.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeviceHostPaths} method.
     * </p>
     * 
     * @return Comma-separated list of paths in the test execution environment where the artifacts generated by the
     *         customer's tests are pulled from.
     */
    public final List<String> deviceHostPaths() {
        return deviceHostPaths;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasIosPaths() ? iosPaths() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAndroidPaths() ? androidPaths() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDeviceHostPaths() ? deviceHostPaths() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomerArtifactPaths)) {
            return false;
        }
        CustomerArtifactPaths other = (CustomerArtifactPaths) obj;
        return hasIosPaths() == other.hasIosPaths() && Objects.equals(iosPaths(), other.iosPaths())
                && hasAndroidPaths() == other.hasAndroidPaths() && Objects.equals(androidPaths(), other.androidPaths())
                && hasDeviceHostPaths() == other.hasDeviceHostPaths()
                && Objects.equals(deviceHostPaths(), other.deviceHostPaths());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomerArtifactPaths").add("IosPaths", hasIosPaths() ? iosPaths() : null)
                .add("AndroidPaths", hasAndroidPaths() ? androidPaths() : null)
                .add("DeviceHostPaths", hasDeviceHostPaths() ? deviceHostPaths() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "iosPaths":
            return Optional.ofNullable(clazz.cast(iosPaths()));
        case "androidPaths":
            return Optional.ofNullable(clazz.cast(androidPaths()));
        case "deviceHostPaths":
            return Optional.ofNullable(clazz.cast(deviceHostPaths()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomerArtifactPaths, T> g) {
        return obj -> g.apply((CustomerArtifactPaths) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomerArtifactPaths> {
        /**
         * <p>
         * Comma-separated list of paths on the iOS device where the artifacts generated by the customer's tests are
         * pulled from.
         * </p>
         * 
         * @param iosPaths
         *        Comma-separated list of paths on the iOS device where the artifacts generated by the customer's tests
         *        are pulled from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iosPaths(Collection<String> iosPaths);

        /**
         * <p>
         * Comma-separated list of paths on the iOS device where the artifacts generated by the customer's tests are
         * pulled from.
         * </p>
         * 
         * @param iosPaths
         *        Comma-separated list of paths on the iOS device where the artifacts generated by the customer's tests
         *        are pulled from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iosPaths(String... iosPaths);

        /**
         * <p>
         * Comma-separated list of paths on the Android device where the artifacts generated by the customer's tests are
         * pulled from.
         * </p>
         * 
         * @param androidPaths
         *        Comma-separated list of paths on the Android device where the artifacts generated by the customer's
         *        tests are pulled from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder androidPaths(Collection<String> androidPaths);

        /**
         * <p>
         * Comma-separated list of paths on the Android device where the artifacts generated by the customer's tests are
         * pulled from.
         * </p>
         * 
         * @param androidPaths
         *        Comma-separated list of paths on the Android device where the artifacts generated by the customer's
         *        tests are pulled from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder androidPaths(String... androidPaths);

        /**
         * <p>
         * Comma-separated list of paths in the test execution environment where the artifacts generated by the
         * customer's tests are pulled from.
         * </p>
         * 
         * @param deviceHostPaths
         *        Comma-separated list of paths in the test execution environment where the artifacts generated by the
         *        customer's tests are pulled from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceHostPaths(Collection<String> deviceHostPaths);

        /**
         * <p>
         * Comma-separated list of paths in the test execution environment where the artifacts generated by the
         * customer's tests are pulled from.
         * </p>
         * 
         * @param deviceHostPaths
         *        Comma-separated list of paths in the test execution environment where the artifacts generated by the
         *        customer's tests are pulled from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceHostPaths(String... deviceHostPaths);
    }

    static final class BuilderImpl implements Builder {
        private List<String> iosPaths = DefaultSdkAutoConstructList.getInstance();

        private List<String> androidPaths = DefaultSdkAutoConstructList.getInstance();

        private List<String> deviceHostPaths = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CustomerArtifactPaths model) {
            iosPaths(model.iosPaths);
            androidPaths(model.androidPaths);
            deviceHostPaths(model.deviceHostPaths);
        }

        public final Collection<String> getIosPaths() {
            if (iosPaths instanceof SdkAutoConstructList) {
                return null;
            }
            return iosPaths;
        }

        public final void setIosPaths(Collection<String> iosPaths) {
            this.iosPaths = IosPathsCopier.copy(iosPaths);
        }

        @Override
        public final Builder iosPaths(Collection<String> iosPaths) {
            this.iosPaths = IosPathsCopier.copy(iosPaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder iosPaths(String... iosPaths) {
            iosPaths(Arrays.asList(iosPaths));
            return this;
        }

        public final Collection<String> getAndroidPaths() {
            if (androidPaths instanceof SdkAutoConstructList) {
                return null;
            }
            return androidPaths;
        }

        public final void setAndroidPaths(Collection<String> androidPaths) {
            this.androidPaths = AndroidPathsCopier.copy(androidPaths);
        }

        @Override
        public final Builder androidPaths(Collection<String> androidPaths) {
            this.androidPaths = AndroidPathsCopier.copy(androidPaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder androidPaths(String... androidPaths) {
            androidPaths(Arrays.asList(androidPaths));
            return this;
        }

        public final Collection<String> getDeviceHostPaths() {
            if (deviceHostPaths instanceof SdkAutoConstructList) {
                return null;
            }
            return deviceHostPaths;
        }

        public final void setDeviceHostPaths(Collection<String> deviceHostPaths) {
            this.deviceHostPaths = DeviceHostPathsCopier.copy(deviceHostPaths);
        }

        @Override
        public final Builder deviceHostPaths(Collection<String> deviceHostPaths) {
            this.deviceHostPaths = DeviceHostPathsCopier.copy(deviceHostPaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceHostPaths(String... deviceHostPaths) {
            deviceHostPaths(Arrays.asList(deviceHostPaths));
            return this;
        }

        @Override
        public CustomerArtifactPaths build() {
            return new CustomerArtifactPaths(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
