/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * In response to a request by the <code>DescribeReplicationTasks</code> operation, this object provides a collection of
 * statistics about a replication task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplicationTaskStats implements SdkPojo, Serializable,
        ToCopyableBuilder<ReplicationTaskStats.Builder, ReplicationTaskStats> {
    private static final SdkField<Integer> FULL_LOAD_PROGRESS_PERCENT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FullLoadProgressPercent").getter(getter(ReplicationTaskStats::fullLoadProgressPercent))
            .setter(setter(Builder::fullLoadProgressPercent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FullLoadProgressPercent").build())
            .build();

    private static final SdkField<Long> ELAPSED_TIME_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ElapsedTimeMillis").getter(getter(ReplicationTaskStats::elapsedTimeMillis))
            .setter(setter(Builder::elapsedTimeMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElapsedTimeMillis").build()).build();

    private static final SdkField<Integer> TABLES_LOADED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TablesLoaded").getter(getter(ReplicationTaskStats::tablesLoaded)).setter(setter(Builder::tablesLoaded))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TablesLoaded").build()).build();

    private static final SdkField<Integer> TABLES_LOADING_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TablesLoading").getter(getter(ReplicationTaskStats::tablesLoading))
            .setter(setter(Builder::tablesLoading))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TablesLoading").build()).build();

    private static final SdkField<Integer> TABLES_QUEUED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TablesQueued").getter(getter(ReplicationTaskStats::tablesQueued)).setter(setter(Builder::tablesQueued))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TablesQueued").build()).build();

    private static final SdkField<Integer> TABLES_ERRORED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TablesErrored").getter(getter(ReplicationTaskStats::tablesErrored))
            .setter(setter(Builder::tablesErrored))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TablesErrored").build()).build();

    private static final SdkField<Instant> FRESH_START_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("FreshStartDate").getter(getter(ReplicationTaskStats::freshStartDate))
            .setter(setter(Builder::freshStartDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FreshStartDate").build()).build();

    private static final SdkField<Instant> START_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartDate").getter(getter(ReplicationTaskStats::startDate)).setter(setter(Builder::startDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDate").build()).build();

    private static final SdkField<Instant> STOP_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StopDate").getter(getter(ReplicationTaskStats::stopDate)).setter(setter(Builder::stopDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StopDate").build()).build();

    private static final SdkField<Instant> FULL_LOAD_START_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("FullLoadStartDate").getter(getter(ReplicationTaskStats::fullLoadStartDate))
            .setter(setter(Builder::fullLoadStartDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FullLoadStartDate").build()).build();

    private static final SdkField<Instant> FULL_LOAD_FINISH_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("FullLoadFinishDate").getter(getter(ReplicationTaskStats::fullLoadFinishDate))
            .setter(setter(Builder::fullLoadFinishDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FullLoadFinishDate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            FULL_LOAD_PROGRESS_PERCENT_FIELD, ELAPSED_TIME_MILLIS_FIELD, TABLES_LOADED_FIELD, TABLES_LOADING_FIELD,
            TABLES_QUEUED_FIELD, TABLES_ERRORED_FIELD, FRESH_START_DATE_FIELD, START_DATE_FIELD, STOP_DATE_FIELD,
            FULL_LOAD_START_DATE_FIELD, FULL_LOAD_FINISH_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer fullLoadProgressPercent;

    private final Long elapsedTimeMillis;

    private final Integer tablesLoaded;

    private final Integer tablesLoading;

    private final Integer tablesQueued;

    private final Integer tablesErrored;

    private final Instant freshStartDate;

    private final Instant startDate;

    private final Instant stopDate;

    private final Instant fullLoadStartDate;

    private final Instant fullLoadFinishDate;

    private ReplicationTaskStats(BuilderImpl builder) {
        this.fullLoadProgressPercent = builder.fullLoadProgressPercent;
        this.elapsedTimeMillis = builder.elapsedTimeMillis;
        this.tablesLoaded = builder.tablesLoaded;
        this.tablesLoading = builder.tablesLoading;
        this.tablesQueued = builder.tablesQueued;
        this.tablesErrored = builder.tablesErrored;
        this.freshStartDate = builder.freshStartDate;
        this.startDate = builder.startDate;
        this.stopDate = builder.stopDate;
        this.fullLoadStartDate = builder.fullLoadStartDate;
        this.fullLoadFinishDate = builder.fullLoadFinishDate;
    }

    /**
     * <p>
     * The percent complete for the full load migration task.
     * </p>
     * 
     * @return The percent complete for the full load migration task.
     */
    public final Integer fullLoadProgressPercent() {
        return fullLoadProgressPercent;
    }

    /**
     * <p>
     * The elapsed time of the task, in milliseconds.
     * </p>
     * 
     * @return The elapsed time of the task, in milliseconds.
     */
    public final Long elapsedTimeMillis() {
        return elapsedTimeMillis;
    }

    /**
     * <p>
     * The number of tables loaded for this task.
     * </p>
     * 
     * @return The number of tables loaded for this task.
     */
    public final Integer tablesLoaded() {
        return tablesLoaded;
    }

    /**
     * <p>
     * The number of tables currently loading for this task.
     * </p>
     * 
     * @return The number of tables currently loading for this task.
     */
    public final Integer tablesLoading() {
        return tablesLoading;
    }

    /**
     * <p>
     * The number of tables queued for this task.
     * </p>
     * 
     * @return The number of tables queued for this task.
     */
    public final Integer tablesQueued() {
        return tablesQueued;
    }

    /**
     * <p>
     * The number of errors that have occurred during this task.
     * </p>
     * 
     * @return The number of errors that have occurred during this task.
     */
    public final Integer tablesErrored() {
        return tablesErrored;
    }

    /**
     * <p>
     * The date the replication task was started either with a fresh start or a target reload.
     * </p>
     * 
     * @return The date the replication task was started either with a fresh start or a target reload.
     */
    public final Instant freshStartDate() {
        return freshStartDate;
    }

    /**
     * <p>
     * The date the replication task was started either with a fresh start or a resume. For more information, see <a
     * href=
     * "https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html#DMS-StartReplicationTask-request-StartReplicationTaskType"
     * >StartReplicationTaskType</a>.
     * </p>
     * 
     * @return The date the replication task was started either with a fresh start or a resume. For more information,
     *         see <a href=
     *         "https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html#DMS-StartReplicationTask-request-StartReplicationTaskType"
     *         >StartReplicationTaskType</a>.
     */
    public final Instant startDate() {
        return startDate;
    }

    /**
     * <p>
     * The date the replication task was stopped.
     * </p>
     * 
     * @return The date the replication task was stopped.
     */
    public final Instant stopDate() {
        return stopDate;
    }

    /**
     * <p>
     * The date the replication task full load was started.
     * </p>
     * 
     * @return The date the replication task full load was started.
     */
    public final Instant fullLoadStartDate() {
        return fullLoadStartDate;
    }

    /**
     * <p>
     * The date the replication task full load was completed.
     * </p>
     * 
     * @return The date the replication task full load was completed.
     */
    public final Instant fullLoadFinishDate() {
        return fullLoadFinishDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fullLoadProgressPercent());
        hashCode = 31 * hashCode + Objects.hashCode(elapsedTimeMillis());
        hashCode = 31 * hashCode + Objects.hashCode(tablesLoaded());
        hashCode = 31 * hashCode + Objects.hashCode(tablesLoading());
        hashCode = 31 * hashCode + Objects.hashCode(tablesQueued());
        hashCode = 31 * hashCode + Objects.hashCode(tablesErrored());
        hashCode = 31 * hashCode + Objects.hashCode(freshStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(startDate());
        hashCode = 31 * hashCode + Objects.hashCode(stopDate());
        hashCode = 31 * hashCode + Objects.hashCode(fullLoadStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(fullLoadFinishDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationTaskStats)) {
            return false;
        }
        ReplicationTaskStats other = (ReplicationTaskStats) obj;
        return Objects.equals(fullLoadProgressPercent(), other.fullLoadProgressPercent())
                && Objects.equals(elapsedTimeMillis(), other.elapsedTimeMillis())
                && Objects.equals(tablesLoaded(), other.tablesLoaded()) && Objects.equals(tablesLoading(), other.tablesLoading())
                && Objects.equals(tablesQueued(), other.tablesQueued()) && Objects.equals(tablesErrored(), other.tablesErrored())
                && Objects.equals(freshStartDate(), other.freshStartDate()) && Objects.equals(startDate(), other.startDate())
                && Objects.equals(stopDate(), other.stopDate()) && Objects.equals(fullLoadStartDate(), other.fullLoadStartDate())
                && Objects.equals(fullLoadFinishDate(), other.fullLoadFinishDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReplicationTaskStats").add("FullLoadProgressPercent", fullLoadProgressPercent())
                .add("ElapsedTimeMillis", elapsedTimeMillis()).add("TablesLoaded", tablesLoaded())
                .add("TablesLoading", tablesLoading()).add("TablesQueued", tablesQueued()).add("TablesErrored", tablesErrored())
                .add("FreshStartDate", freshStartDate()).add("StartDate", startDate()).add("StopDate", stopDate())
                .add("FullLoadStartDate", fullLoadStartDate()).add("FullLoadFinishDate", fullLoadFinishDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FullLoadProgressPercent":
            return Optional.ofNullable(clazz.cast(fullLoadProgressPercent()));
        case "ElapsedTimeMillis":
            return Optional.ofNullable(clazz.cast(elapsedTimeMillis()));
        case "TablesLoaded":
            return Optional.ofNullable(clazz.cast(tablesLoaded()));
        case "TablesLoading":
            return Optional.ofNullable(clazz.cast(tablesLoading()));
        case "TablesQueued":
            return Optional.ofNullable(clazz.cast(tablesQueued()));
        case "TablesErrored":
            return Optional.ofNullable(clazz.cast(tablesErrored()));
        case "FreshStartDate":
            return Optional.ofNullable(clazz.cast(freshStartDate()));
        case "StartDate":
            return Optional.ofNullable(clazz.cast(startDate()));
        case "StopDate":
            return Optional.ofNullable(clazz.cast(stopDate()));
        case "FullLoadStartDate":
            return Optional.ofNullable(clazz.cast(fullLoadStartDate()));
        case "FullLoadFinishDate":
            return Optional.ofNullable(clazz.cast(fullLoadFinishDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplicationTaskStats, T> g) {
        return obj -> g.apply((ReplicationTaskStats) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReplicationTaskStats> {
        /**
         * <p>
         * The percent complete for the full load migration task.
         * </p>
         * 
         * @param fullLoadProgressPercent
         *        The percent complete for the full load migration task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fullLoadProgressPercent(Integer fullLoadProgressPercent);

        /**
         * <p>
         * The elapsed time of the task, in milliseconds.
         * </p>
         * 
         * @param elapsedTimeMillis
         *        The elapsed time of the task, in milliseconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elapsedTimeMillis(Long elapsedTimeMillis);

        /**
         * <p>
         * The number of tables loaded for this task.
         * </p>
         * 
         * @param tablesLoaded
         *        The number of tables loaded for this task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tablesLoaded(Integer tablesLoaded);

        /**
         * <p>
         * The number of tables currently loading for this task.
         * </p>
         * 
         * @param tablesLoading
         *        The number of tables currently loading for this task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tablesLoading(Integer tablesLoading);

        /**
         * <p>
         * The number of tables queued for this task.
         * </p>
         * 
         * @param tablesQueued
         *        The number of tables queued for this task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tablesQueued(Integer tablesQueued);

        /**
         * <p>
         * The number of errors that have occurred during this task.
         * </p>
         * 
         * @param tablesErrored
         *        The number of errors that have occurred during this task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tablesErrored(Integer tablesErrored);

        /**
         * <p>
         * The date the replication task was started either with a fresh start or a target reload.
         * </p>
         * 
         * @param freshStartDate
         *        The date the replication task was started either with a fresh start or a target reload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder freshStartDate(Instant freshStartDate);

        /**
         * <p>
         * The date the replication task was started either with a fresh start or a resume. For more information, see <a
         * href=
         * "https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html#DMS-StartReplicationTask-request-StartReplicationTaskType"
         * >StartReplicationTaskType</a>.
         * </p>
         * 
         * @param startDate
         *        The date the replication task was started either with a fresh start or a resume. For more information,
         *        see <a href=
         *        "https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html#DMS-StartReplicationTask-request-StartReplicationTaskType"
         *        >StartReplicationTaskType</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startDate(Instant startDate);

        /**
         * <p>
         * The date the replication task was stopped.
         * </p>
         * 
         * @param stopDate
         *        The date the replication task was stopped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopDate(Instant stopDate);

        /**
         * <p>
         * The date the replication task full load was started.
         * </p>
         * 
         * @param fullLoadStartDate
         *        The date the replication task full load was started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fullLoadStartDate(Instant fullLoadStartDate);

        /**
         * <p>
         * The date the replication task full load was completed.
         * </p>
         * 
         * @param fullLoadFinishDate
         *        The date the replication task full load was completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fullLoadFinishDate(Instant fullLoadFinishDate);
    }

    static final class BuilderImpl implements Builder {
        private Integer fullLoadProgressPercent;

        private Long elapsedTimeMillis;

        private Integer tablesLoaded;

        private Integer tablesLoading;

        private Integer tablesQueued;

        private Integer tablesErrored;

        private Instant freshStartDate;

        private Instant startDate;

        private Instant stopDate;

        private Instant fullLoadStartDate;

        private Instant fullLoadFinishDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationTaskStats model) {
            fullLoadProgressPercent(model.fullLoadProgressPercent);
            elapsedTimeMillis(model.elapsedTimeMillis);
            tablesLoaded(model.tablesLoaded);
            tablesLoading(model.tablesLoading);
            tablesQueued(model.tablesQueued);
            tablesErrored(model.tablesErrored);
            freshStartDate(model.freshStartDate);
            startDate(model.startDate);
            stopDate(model.stopDate);
            fullLoadStartDate(model.fullLoadStartDate);
            fullLoadFinishDate(model.fullLoadFinishDate);
        }

        public final Integer getFullLoadProgressPercent() {
            return fullLoadProgressPercent;
        }

        public final void setFullLoadProgressPercent(Integer fullLoadProgressPercent) {
            this.fullLoadProgressPercent = fullLoadProgressPercent;
        }

        @Override
        public final Builder fullLoadProgressPercent(Integer fullLoadProgressPercent) {
            this.fullLoadProgressPercent = fullLoadProgressPercent;
            return this;
        }

        public final Long getElapsedTimeMillis() {
            return elapsedTimeMillis;
        }

        public final void setElapsedTimeMillis(Long elapsedTimeMillis) {
            this.elapsedTimeMillis = elapsedTimeMillis;
        }

        @Override
        public final Builder elapsedTimeMillis(Long elapsedTimeMillis) {
            this.elapsedTimeMillis = elapsedTimeMillis;
            return this;
        }

        public final Integer getTablesLoaded() {
            return tablesLoaded;
        }

        public final void setTablesLoaded(Integer tablesLoaded) {
            this.tablesLoaded = tablesLoaded;
        }

        @Override
        public final Builder tablesLoaded(Integer tablesLoaded) {
            this.tablesLoaded = tablesLoaded;
            return this;
        }

        public final Integer getTablesLoading() {
            return tablesLoading;
        }

        public final void setTablesLoading(Integer tablesLoading) {
            this.tablesLoading = tablesLoading;
        }

        @Override
        public final Builder tablesLoading(Integer tablesLoading) {
            this.tablesLoading = tablesLoading;
            return this;
        }

        public final Integer getTablesQueued() {
            return tablesQueued;
        }

        public final void setTablesQueued(Integer tablesQueued) {
            this.tablesQueued = tablesQueued;
        }

        @Override
        public final Builder tablesQueued(Integer tablesQueued) {
            this.tablesQueued = tablesQueued;
            return this;
        }

        public final Integer getTablesErrored() {
            return tablesErrored;
        }

        public final void setTablesErrored(Integer tablesErrored) {
            this.tablesErrored = tablesErrored;
        }

        @Override
        public final Builder tablesErrored(Integer tablesErrored) {
            this.tablesErrored = tablesErrored;
            return this;
        }

        public final Instant getFreshStartDate() {
            return freshStartDate;
        }

        public final void setFreshStartDate(Instant freshStartDate) {
            this.freshStartDate = freshStartDate;
        }

        @Override
        public final Builder freshStartDate(Instant freshStartDate) {
            this.freshStartDate = freshStartDate;
            return this;
        }

        public final Instant getStartDate() {
            return startDate;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final Instant getStopDate() {
            return stopDate;
        }

        public final void setStopDate(Instant stopDate) {
            this.stopDate = stopDate;
        }

        @Override
        public final Builder stopDate(Instant stopDate) {
            this.stopDate = stopDate;
            return this;
        }

        public final Instant getFullLoadStartDate() {
            return fullLoadStartDate;
        }

        public final void setFullLoadStartDate(Instant fullLoadStartDate) {
            this.fullLoadStartDate = fullLoadStartDate;
        }

        @Override
        public final Builder fullLoadStartDate(Instant fullLoadStartDate) {
            this.fullLoadStartDate = fullLoadStartDate;
            return this;
        }

        public final Instant getFullLoadFinishDate() {
            return fullLoadFinishDate;
        }

        public final void setFullLoadFinishDate(Instant fullLoadFinishDate) {
            this.fullLoadFinishDate = fullLoadFinishDate;
        }

        @Override
        public final Builder fullLoadFinishDate(Instant fullLoadFinishDate) {
            this.fullLoadFinishDate = fullLoadFinishDate;
            return this;
        }

        @Override
        public ReplicationTaskStats build() {
            return new ReplicationTaskStats(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
