/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeReplicationTaskAssessmentRunsResponse extends DatabaseMigrationResponse implements
        ToCopyableBuilder<DescribeReplicationTaskAssessmentRunsResponse.Builder, DescribeReplicationTaskAssessmentRunsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeReplicationTaskAssessmentRunsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<ReplicationTaskAssessmentRun>> REPLICATION_TASK_ASSESSMENT_RUNS_FIELD = SdkField
            .<List<ReplicationTaskAssessmentRun>> builder(MarshallingType.LIST)
            .memberName("ReplicationTaskAssessmentRuns")
            .getter(getter(DescribeReplicationTaskAssessmentRunsResponse::replicationTaskAssessmentRuns))
            .setter(setter(Builder::replicationTaskAssessmentRuns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationTaskAssessmentRuns")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReplicationTaskAssessmentRun> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReplicationTaskAssessmentRun::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            REPLICATION_TASK_ASSESSMENT_RUNS_FIELD));

    private final String marker;

    private final List<ReplicationTaskAssessmentRun> replicationTaskAssessmentRuns;

    private DescribeReplicationTaskAssessmentRunsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.replicationTaskAssessmentRuns = builder.replicationTaskAssessmentRuns;
    }

    /**
     * <p>
     * A pagination token returned for you to pass to a subsequent request. If you pass this token as the
     * <code>Marker</code> value in a subsequent request, the response includes only records beyond the marker, up to
     * the value specified in the request by <code>MaxRecords</code>.
     * </p>
     * 
     * @return A pagination token returned for you to pass to a subsequent request. If you pass this token as the
     *         <code>Marker</code> value in a subsequent request, the response includes only records beyond the marker,
     *         up to the value specified in the request by <code>MaxRecords</code>.
     */
    public final String marker() {
        return marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReplicationTaskAssessmentRuns property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasReplicationTaskAssessmentRuns() {
        return replicationTaskAssessmentRuns != null && !(replicationTaskAssessmentRuns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more premigration assessment runs as specified by <code>Filters</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReplicationTaskAssessmentRuns} method.
     * </p>
     * 
     * @return One or more premigration assessment runs as specified by <code>Filters</code>.
     */
    public final List<ReplicationTaskAssessmentRun> replicationTaskAssessmentRuns() {
        return replicationTaskAssessmentRuns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(hasReplicationTaskAssessmentRuns() ? replicationTaskAssessmentRuns() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReplicationTaskAssessmentRunsResponse)) {
            return false;
        }
        DescribeReplicationTaskAssessmentRunsResponse other = (DescribeReplicationTaskAssessmentRunsResponse) obj;
        return Objects.equals(marker(), other.marker())
                && hasReplicationTaskAssessmentRuns() == other.hasReplicationTaskAssessmentRuns()
                && Objects.equals(replicationTaskAssessmentRuns(), other.replicationTaskAssessmentRuns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DescribeReplicationTaskAssessmentRunsResponse")
                .add("Marker", marker())
                .add("ReplicationTaskAssessmentRuns", hasReplicationTaskAssessmentRuns() ? replicationTaskAssessmentRuns() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "ReplicationTaskAssessmentRuns":
            return Optional.ofNullable(clazz.cast(replicationTaskAssessmentRuns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReplicationTaskAssessmentRunsResponse, T> g) {
        return obj -> g.apply((DescribeReplicationTaskAssessmentRunsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DatabaseMigrationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeReplicationTaskAssessmentRunsResponse> {
        /**
         * <p>
         * A pagination token returned for you to pass to a subsequent request. If you pass this token as the
         * <code>Marker</code> value in a subsequent request, the response includes only records beyond the marker, up
         * to the value specified in the request by <code>MaxRecords</code>.
         * </p>
         * 
         * @param marker
         *        A pagination token returned for you to pass to a subsequent request. If you pass this token as the
         *        <code>Marker</code> value in a subsequent request, the response includes only records beyond the
         *        marker, up to the value specified in the request by <code>MaxRecords</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * One or more premigration assessment runs as specified by <code>Filters</code>.
         * </p>
         * 
         * @param replicationTaskAssessmentRuns
         *        One or more premigration assessment runs as specified by <code>Filters</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationTaskAssessmentRuns(Collection<ReplicationTaskAssessmentRun> replicationTaskAssessmentRuns);

        /**
         * <p>
         * One or more premigration assessment runs as specified by <code>Filters</code>.
         * </p>
         * 
         * @param replicationTaskAssessmentRuns
         *        One or more premigration assessment runs as specified by <code>Filters</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationTaskAssessmentRuns(ReplicationTaskAssessmentRun... replicationTaskAssessmentRuns);

        /**
         * <p>
         * One or more premigration assessment runs as specified by <code>Filters</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.databasemigration.model.ReplicationTaskAssessmentRun.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.databasemigration.model.ReplicationTaskAssessmentRun#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.databasemigration.model.ReplicationTaskAssessmentRun.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #replicationTaskAssessmentRuns(List<ReplicationTaskAssessmentRun>)}.
         * 
         * @param replicationTaskAssessmentRuns
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.databasemigration.model.ReplicationTaskAssessmentRun.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicationTaskAssessmentRuns(java.util.Collection<ReplicationTaskAssessmentRun>)
         */
        Builder replicationTaskAssessmentRuns(Consumer<ReplicationTaskAssessmentRun.Builder>... replicationTaskAssessmentRuns);
    }

    static final class BuilderImpl extends DatabaseMigrationResponse.BuilderImpl implements Builder {
        private String marker;

        private List<ReplicationTaskAssessmentRun> replicationTaskAssessmentRuns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReplicationTaskAssessmentRunsResponse model) {
            super(model);
            marker(model.marker);
            replicationTaskAssessmentRuns(model.replicationTaskAssessmentRuns);
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final List<ReplicationTaskAssessmentRun.Builder> getReplicationTaskAssessmentRuns() {
            List<ReplicationTaskAssessmentRun.Builder> result = ReplicationTaskAssessmentRunListCopier
                    .copyToBuilder(this.replicationTaskAssessmentRuns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplicationTaskAssessmentRuns(
                Collection<ReplicationTaskAssessmentRun.BuilderImpl> replicationTaskAssessmentRuns) {
            this.replicationTaskAssessmentRuns = ReplicationTaskAssessmentRunListCopier
                    .copyFromBuilder(replicationTaskAssessmentRuns);
        }

        @Override
        public final Builder replicationTaskAssessmentRuns(Collection<ReplicationTaskAssessmentRun> replicationTaskAssessmentRuns) {
            this.replicationTaskAssessmentRuns = ReplicationTaskAssessmentRunListCopier.copy(replicationTaskAssessmentRuns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationTaskAssessmentRuns(ReplicationTaskAssessmentRun... replicationTaskAssessmentRuns) {
            replicationTaskAssessmentRuns(Arrays.asList(replicationTaskAssessmentRuns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationTaskAssessmentRuns(
                Consumer<ReplicationTaskAssessmentRun.Builder>... replicationTaskAssessmentRuns) {
            replicationTaskAssessmentRuns(Stream.of(replicationTaskAssessmentRuns)
                    .map(c -> ReplicationTaskAssessmentRun.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeReplicationTaskAssessmentRunsResponse build() {
            return new DescribeReplicationTaskAssessmentRunsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
