/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration parameters for provisioning an DMS Serverless replication.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComputeConfig implements SdkPojo, Serializable, ToCopyableBuilder<ComputeConfig.Builder, ComputeConfig> {
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone").getter(getter(ComputeConfig::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()).build();

    private static final SdkField<String> DNS_NAME_SERVERS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DnsNameServers").getter(getter(ComputeConfig::dnsNameServers)).setter(setter(Builder::dnsNameServers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsNameServers").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(ComputeConfig::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<Integer> MAX_CAPACITY_UNITS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxCapacityUnits").getter(getter(ComputeConfig::maxCapacityUnits))
            .setter(setter(Builder::maxCapacityUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCapacityUnits").build()).build();

    private static final SdkField<Integer> MIN_CAPACITY_UNITS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinCapacityUnits").getter(getter(ComputeConfig::minCapacityUnits))
            .setter(setter(Builder::minCapacityUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinCapacityUnits").build()).build();

    private static final SdkField<Boolean> MULTI_AZ_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("MultiAZ").getter(getter(ComputeConfig::multiAZ)).setter(setter(Builder::multiAZ))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiAZ").build()).build();

    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PreferredMaintenanceWindow")
            .getter(getter(ComputeConfig::preferredMaintenanceWindow))
            .setter(setter(Builder::preferredMaintenanceWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build())
            .build();

    private static final SdkField<String> REPLICATION_SUBNET_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicationSubnetGroupId").getter(getter(ComputeConfig::replicationSubnetGroupId))
            .setter(setter(Builder::replicationSubnetGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationSubnetGroupId").build())
            .build();

    private static final SdkField<List<String>> VPC_SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("VpcSecurityGroupIds")
            .getter(getter(ComputeConfig::vpcSecurityGroupIds))
            .setter(setter(Builder::vpcSecurityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONE_FIELD,
            DNS_NAME_SERVERS_FIELD, KMS_KEY_ID_FIELD, MAX_CAPACITY_UNITS_FIELD, MIN_CAPACITY_UNITS_FIELD, MULTI_AZ_FIELD,
            PREFERRED_MAINTENANCE_WINDOW_FIELD, REPLICATION_SUBNET_GROUP_ID_FIELD, VPC_SECURITY_GROUP_IDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String availabilityZone;

    private final String dnsNameServers;

    private final String kmsKeyId;

    private final Integer maxCapacityUnits;

    private final Integer minCapacityUnits;

    private final Boolean multiAZ;

    private final String preferredMaintenanceWindow;

    private final String replicationSubnetGroupId;

    private final List<String> vpcSecurityGroupIds;

    private ComputeConfig(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.dnsNameServers = builder.dnsNameServers;
        this.kmsKeyId = builder.kmsKeyId;
        this.maxCapacityUnits = builder.maxCapacityUnits;
        this.minCapacityUnits = builder.minCapacityUnits;
        this.multiAZ = builder.multiAZ;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.replicationSubnetGroupId = builder.replicationSubnetGroupId;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
    }

    /**
     * <p>
     * The Availability Zone where the DMS Serverless replication using this configuration will run. The default value
     * is a random, system-chosen Availability Zone in the configuration's Amazon Web Services Region, for example,
     * <code>"us-west-2"</code>. You can't set this parameter if the <code>MultiAZ</code> parameter is set to
     * <code>true</code>.
     * </p>
     * 
     * @return The Availability Zone where the DMS Serverless replication using this configuration will run. The default
     *         value is a random, system-chosen Availability Zone in the configuration's Amazon Web Services Region, for
     *         example, <code>"us-west-2"</code>. You can't set this parameter if the <code>MultiAZ</code> parameter is
     *         set to <code>true</code>.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * A list of custom DNS name servers supported for the DMS Serverless replication to access your source or target
     * database. This list overrides the default name servers supported by the DMS Serverless replication. You can
     * specify a comma-separated list of internet addresses for up to four DNS name servers. For example:
     * <code>"1.1.1.1,2.2.2.2,3.3.3.3,4.4.4.4"</code>
     * </p>
     * 
     * @return A list of custom DNS name servers supported for the DMS Serverless replication to access your source or
     *         target database. This list overrides the default name servers supported by the DMS Serverless
     *         replication. You can specify a comma-separated list of internet addresses for up to four DNS name
     *         servers. For example: <code>"1.1.1.1,2.2.2.2,3.3.3.3,4.4.4.4"</code>
     */
    public final String dnsNameServers() {
        return dnsNameServers;
    }

    /**
     * <p>
     * An Key Management Service (KMS) key Amazon Resource Name (ARN) that is used to encrypt the data during DMS
     * Serverless replication.
     * </p>
     * <p>
     * If you don't specify a value for the <code>KmsKeyId</code> parameter, DMS uses your default encryption key.
     * </p>
     * <p>
     * KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services account has
     * a different default encryption key for each Amazon Web Services Region.
     * </p>
     * 
     * @return An Key Management Service (KMS) key Amazon Resource Name (ARN) that is used to encrypt the data during
     *         DMS Serverless replication.</p>
     *         <p>
     *         If you don't specify a value for the <code>KmsKeyId</code> parameter, DMS uses your default encryption
     *         key.
     *         </p>
     *         <p>
     *         KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services
     *         account has a different default encryption key for each Amazon Web Services Region.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * Specifies the maximum value of the DMS capacity units (DCUs) for which a given DMS Serverless replication can be
     * provisioned. A single DCU is 2GB of RAM, with 1 DCU as the minimum value allowed. The list of valid DCU values
     * includes 1, 2, 4, 8, 16, 32, 64, 128, 192, 256, and 384. So, the maximum value that you can specify for DMS
     * Serverless is 384. The <code>MaxCapacityUnits</code> parameter is the only DCU parameter you are required to
     * specify.
     * </p>
     * 
     * @return Specifies the maximum value of the DMS capacity units (DCUs) for which a given DMS Serverless replication
     *         can be provisioned. A single DCU is 2GB of RAM, with 1 DCU as the minimum value allowed. The list of
     *         valid DCU values includes 1, 2, 4, 8, 16, 32, 64, 128, 192, 256, and 384. So, the maximum value that you
     *         can specify for DMS Serverless is 384. The <code>MaxCapacityUnits</code> parameter is the only DCU
     *         parameter you are required to specify.
     */
    public final Integer maxCapacityUnits() {
        return maxCapacityUnits;
    }

    /**
     * <p>
     * Specifies the minimum value of the DMS capacity units (DCUs) for which a given DMS Serverless replication can be
     * provisioned. A single DCU is 2GB of RAM, with 1 DCU as the minimum value allowed. The list of valid DCU values
     * includes 1, 2, 4, 8, 16, 32, 64, 128, 192, 256, and 384. So, the minimum DCU value that you can specify for DMS
     * Serverless is 1. You don't have to specify a value for the <code>MinCapacityUnits</code> parameter. If you don't
     * set this value, DMS scans the current activity of available source tables to identify an optimum setting for this
     * parameter. If there is no current source activity or DMS can't otherwise identify a more appropriate value, it
     * sets this parameter to the minimum DCU value allowed, 1.
     * </p>
     * 
     * @return Specifies the minimum value of the DMS capacity units (DCUs) for which a given DMS Serverless replication
     *         can be provisioned. A single DCU is 2GB of RAM, with 1 DCU as the minimum value allowed. The list of
     *         valid DCU values includes 1, 2, 4, 8, 16, 32, 64, 128, 192, 256, and 384. So, the minimum DCU value that
     *         you can specify for DMS Serverless is 1. You don't have to specify a value for the
     *         <code>MinCapacityUnits</code> parameter. If you don't set this value, DMS scans the current activity of
     *         available source tables to identify an optimum setting for this parameter. If there is no current source
     *         activity or DMS can't otherwise identify a more appropriate value, it sets this parameter to the minimum
     *         DCU value allowed, 1.
     */
    public final Integer minCapacityUnits() {
        return minCapacityUnits;
    }

    /**
     * <p>
     * Specifies whether the DMS Serverless replication is a Multi-AZ deployment. You can't set the
     * <code>AvailabilityZone</code> parameter if the <code>MultiAZ</code> parameter is set to <code>true</code>.
     * </p>
     * 
     * @return Specifies whether the DMS Serverless replication is a Multi-AZ deployment. You can't set the
     *         <code>AvailabilityZone</code> parameter if the <code>MultiAZ</code> parameter is set to <code>true</code>
     *         .
     */
    public final Boolean multiAZ() {
        return multiAZ;
    }

    /**
     * <p>
     * The weekly time range during which system maintenance can occur for the DMS Serverless replication, in Universal
     * Coordinated Time (UTC). The format is <code>ddd:hh24:mi-ddd:hh24:mi</code>.
     * </p>
     * <p>
     * The default is a 30-minute window selected at random from an 8-hour block of time per Amazon Web Services Region.
     * This maintenance occurs on a random day of the week. Valid values for days of the week include <code>Mon</code>,
     * <code>Tue</code>, <code>Wed</code>, <code>Thu</code>, <code>Fri</code>, <code>Sat</code>, and <code>Sun</code>.
     * </p>
     * <p>
     * Constraints include a minimum 30-minute window.
     * </p>
     * 
     * @return The weekly time range during which system maintenance can occur for the DMS Serverless replication, in
     *         Universal Coordinated Time (UTC). The format is <code>ddd:hh24:mi-ddd:hh24:mi</code>.</p>
     *         <p>
     *         The default is a 30-minute window selected at random from an 8-hour block of time per Amazon Web Services
     *         Region. This maintenance occurs on a random day of the week. Valid values for days of the week include
     *         <code>Mon</code>, <code>Tue</code>, <code>Wed</code>, <code>Thu</code>, <code>Fri</code>,
     *         <code>Sat</code>, and <code>Sun</code>.
     *         </p>
     *         <p>
     *         Constraints include a minimum 30-minute window.
     */
    public final String preferredMaintenanceWindow() {
        return preferredMaintenanceWindow;
    }

    /**
     * <p>
     * Specifies a subnet group identifier to associate with the DMS Serverless replication.
     * </p>
     * 
     * @return Specifies a subnet group identifier to associate with the DMS Serverless replication.
     */
    public final String replicationSubnetGroupId() {
        return replicationSubnetGroupId;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcSecurityGroupIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVpcSecurityGroupIds() {
        return vpcSecurityGroupIds != null && !(vpcSecurityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the virtual private cloud (VPC) security group to use with the DMS Serverless replication. The VPC
     * security group must work with the VPC containing the replication.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcSecurityGroupIds} method.
     * </p>
     * 
     * @return Specifies the virtual private cloud (VPC) security group to use with the DMS Serverless replication. The
     *         VPC security group must work with the VPC containing the replication.
     */
    public final List<String> vpcSecurityGroupIds() {
        return vpcSecurityGroupIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(dnsNameServers());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(maxCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(minCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(multiAZ());
        hashCode = 31 * hashCode + Objects.hashCode(preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(replicationSubnetGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcSecurityGroupIds() ? vpcSecurityGroupIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputeConfig)) {
            return false;
        }
        ComputeConfig other = (ComputeConfig) obj;
        return Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(dnsNameServers(), other.dnsNameServers()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(maxCapacityUnits(), other.maxCapacityUnits())
                && Objects.equals(minCapacityUnits(), other.minCapacityUnits()) && Objects.equals(multiAZ(), other.multiAZ())
                && Objects.equals(preferredMaintenanceWindow(), other.preferredMaintenanceWindow())
                && Objects.equals(replicationSubnetGroupId(), other.replicationSubnetGroupId())
                && hasVpcSecurityGroupIds() == other.hasVpcSecurityGroupIds()
                && Objects.equals(vpcSecurityGroupIds(), other.vpcSecurityGroupIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComputeConfig").add("AvailabilityZone", availabilityZone())
                .add("DnsNameServers", dnsNameServers()).add("KmsKeyId", kmsKeyId()).add("MaxCapacityUnits", maxCapacityUnits())
                .add("MinCapacityUnits", minCapacityUnits()).add("MultiAZ", multiAZ())
                .add("PreferredMaintenanceWindow", preferredMaintenanceWindow())
                .add("ReplicationSubnetGroupId", replicationSubnetGroupId())
                .add("VpcSecurityGroupIds", hasVpcSecurityGroupIds() ? vpcSecurityGroupIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "DnsNameServers":
            return Optional.ofNullable(clazz.cast(dnsNameServers()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "MaxCapacityUnits":
            return Optional.ofNullable(clazz.cast(maxCapacityUnits()));
        case "MinCapacityUnits":
            return Optional.ofNullable(clazz.cast(minCapacityUnits()));
        case "MultiAZ":
            return Optional.ofNullable(clazz.cast(multiAZ()));
        case "PreferredMaintenanceWindow":
            return Optional.ofNullable(clazz.cast(preferredMaintenanceWindow()));
        case "ReplicationSubnetGroupId":
            return Optional.ofNullable(clazz.cast(replicationSubnetGroupId()));
        case "VpcSecurityGroupIds":
            return Optional.ofNullable(clazz.cast(vpcSecurityGroupIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComputeConfig, T> g) {
        return obj -> g.apply((ComputeConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComputeConfig> {
        /**
         * <p>
         * The Availability Zone where the DMS Serverless replication using this configuration will run. The default
         * value is a random, system-chosen Availability Zone in the configuration's Amazon Web Services Region, for
         * example, <code>"us-west-2"</code>. You can't set this parameter if the <code>MultiAZ</code> parameter is set
         * to <code>true</code>.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone where the DMS Serverless replication using this configuration will run. The
         *        default value is a random, system-chosen Availability Zone in the configuration's Amazon Web Services
         *        Region, for example, <code>"us-west-2"</code>. You can't set this parameter if the
         *        <code>MultiAZ</code> parameter is set to <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * A list of custom DNS name servers supported for the DMS Serverless replication to access your source or
         * target database. This list overrides the default name servers supported by the DMS Serverless replication.
         * You can specify a comma-separated list of internet addresses for up to four DNS name servers. For example:
         * <code>"1.1.1.1,2.2.2.2,3.3.3.3,4.4.4.4"</code>
         * </p>
         * 
         * @param dnsNameServers
         *        A list of custom DNS name servers supported for the DMS Serverless replication to access your source
         *        or target database. This list overrides the default name servers supported by the DMS Serverless
         *        replication. You can specify a comma-separated list of internet addresses for up to four DNS name
         *        servers. For example: <code>"1.1.1.1,2.2.2.2,3.3.3.3,4.4.4.4"</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsNameServers(String dnsNameServers);

        /**
         * <p>
         * An Key Management Service (KMS) key Amazon Resource Name (ARN) that is used to encrypt the data during DMS
         * Serverless replication.
         * </p>
         * <p>
         * If you don't specify a value for the <code>KmsKeyId</code> parameter, DMS uses your default encryption key.
         * </p>
         * <p>
         * KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services account
         * has a different default encryption key for each Amazon Web Services Region.
         * </p>
         * 
         * @param kmsKeyId
         *        An Key Management Service (KMS) key Amazon Resource Name (ARN) that is used to encrypt the data during
         *        DMS Serverless replication.</p>
         *        <p>
         *        If you don't specify a value for the <code>KmsKeyId</code> parameter, DMS uses your default encryption
         *        key.
         *        </p>
         *        <p>
         *        KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services
         *        account has a different default encryption key for each Amazon Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * Specifies the maximum value of the DMS capacity units (DCUs) for which a given DMS Serverless replication can
         * be provisioned. A single DCU is 2GB of RAM, with 1 DCU as the minimum value allowed. The list of valid DCU
         * values includes 1, 2, 4, 8, 16, 32, 64, 128, 192, 256, and 384. So, the maximum value that you can specify
         * for DMS Serverless is 384. The <code>MaxCapacityUnits</code> parameter is the only DCU parameter you are
         * required to specify.
         * </p>
         * 
         * @param maxCapacityUnits
         *        Specifies the maximum value of the DMS capacity units (DCUs) for which a given DMS Serverless
         *        replication can be provisioned. A single DCU is 2GB of RAM, with 1 DCU as the minimum value allowed.
         *        The list of valid DCU values includes 1, 2, 4, 8, 16, 32, 64, 128, 192, 256, and 384. So, the maximum
         *        value that you can specify for DMS Serverless is 384. The <code>MaxCapacityUnits</code> parameter is
         *        the only DCU parameter you are required to specify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxCapacityUnits(Integer maxCapacityUnits);

        /**
         * <p>
         * Specifies the minimum value of the DMS capacity units (DCUs) for which a given DMS Serverless replication can
         * be provisioned. A single DCU is 2GB of RAM, with 1 DCU as the minimum value allowed. The list of valid DCU
         * values includes 1, 2, 4, 8, 16, 32, 64, 128, 192, 256, and 384. So, the minimum DCU value that you can
         * specify for DMS Serverless is 1. You don't have to specify a value for the <code>MinCapacityUnits</code>
         * parameter. If you don't set this value, DMS scans the current activity of available source tables to identify
         * an optimum setting for this parameter. If there is no current source activity or DMS can't otherwise identify
         * a more appropriate value, it sets this parameter to the minimum DCU value allowed, 1.
         * </p>
         * 
         * @param minCapacityUnits
         *        Specifies the minimum value of the DMS capacity units (DCUs) for which a given DMS Serverless
         *        replication can be provisioned. A single DCU is 2GB of RAM, with 1 DCU as the minimum value allowed.
         *        The list of valid DCU values includes 1, 2, 4, 8, 16, 32, 64, 128, 192, 256, and 384. So, the minimum
         *        DCU value that you can specify for DMS Serverless is 1. You don't have to specify a value for the
         *        <code>MinCapacityUnits</code> parameter. If you don't set this value, DMS scans the current activity
         *        of available source tables to identify an optimum setting for this parameter. If there is no current
         *        source activity or DMS can't otherwise identify a more appropriate value, it sets this parameter to
         *        the minimum DCU value allowed, 1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minCapacityUnits(Integer minCapacityUnits);

        /**
         * <p>
         * Specifies whether the DMS Serverless replication is a Multi-AZ deployment. You can't set the
         * <code>AvailabilityZone</code> parameter if the <code>MultiAZ</code> parameter is set to <code>true</code>.
         * </p>
         * 
         * @param multiAZ
         *        Specifies whether the DMS Serverless replication is a Multi-AZ deployment. You can't set the
         *        <code>AvailabilityZone</code> parameter if the <code>MultiAZ</code> parameter is set to
         *        <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiAZ(Boolean multiAZ);

        /**
         * <p>
         * The weekly time range during which system maintenance can occur for the DMS Serverless replication, in
         * Universal Coordinated Time (UTC). The format is <code>ddd:hh24:mi-ddd:hh24:mi</code>.
         * </p>
         * <p>
         * The default is a 30-minute window selected at random from an 8-hour block of time per Amazon Web Services
         * Region. This maintenance occurs on a random day of the week. Valid values for days of the week include
         * <code>Mon</code>, <code>Tue</code>, <code>Wed</code>, <code>Thu</code>, <code>Fri</code>, <code>Sat</code>,
         * and <code>Sun</code>.
         * </p>
         * <p>
         * Constraints include a minimum 30-minute window.
         * </p>
         * 
         * @param preferredMaintenanceWindow
         *        The weekly time range during which system maintenance can occur for the DMS Serverless replication, in
         *        Universal Coordinated Time (UTC). The format is <code>ddd:hh24:mi-ddd:hh24:mi</code>.</p>
         *        <p>
         *        The default is a 30-minute window selected at random from an 8-hour block of time per Amazon Web
         *        Services Region. This maintenance occurs on a random day of the week. Valid values for days of the
         *        week include <code>Mon</code>, <code>Tue</code>, <code>Wed</code>, <code>Thu</code>, <code>Fri</code>,
         *        <code>Sat</code>, and <code>Sun</code>.
         *        </p>
         *        <p>
         *        Constraints include a minimum 30-minute window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredMaintenanceWindow(String preferredMaintenanceWindow);

        /**
         * <p>
         * Specifies a subnet group identifier to associate with the DMS Serverless replication.
         * </p>
         * 
         * @param replicationSubnetGroupId
         *        Specifies a subnet group identifier to associate with the DMS Serverless replication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationSubnetGroupId(String replicationSubnetGroupId);

        /**
         * <p>
         * Specifies the virtual private cloud (VPC) security group to use with the DMS Serverless replication. The VPC
         * security group must work with the VPC containing the replication.
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        Specifies the virtual private cloud (VPC) security group to use with the DMS Serverless replication.
         *        The VPC security group must work with the VPC containing the replication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds);

        /**
         * <p>
         * Specifies the virtual private cloud (VPC) security group to use with the DMS Serverless replication. The VPC
         * security group must work with the VPC containing the replication.
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        Specifies the virtual private cloud (VPC) security group to use with the DMS Serverless replication.
         *        The VPC security group must work with the VPC containing the replication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds);
    }

    static final class BuilderImpl implements Builder {
        private String availabilityZone;

        private String dnsNameServers;

        private String kmsKeyId;

        private Integer maxCapacityUnits;

        private Integer minCapacityUnits;

        private Boolean multiAZ;

        private String preferredMaintenanceWindow;

        private String replicationSubnetGroupId;

        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ComputeConfig model) {
            availabilityZone(model.availabilityZone);
            dnsNameServers(model.dnsNameServers);
            kmsKeyId(model.kmsKeyId);
            maxCapacityUnits(model.maxCapacityUnits);
            minCapacityUnits(model.minCapacityUnits);
            multiAZ(model.multiAZ);
            preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            replicationSubnetGroupId(model.replicationSubnetGroupId);
            vpcSecurityGroupIds(model.vpcSecurityGroupIds);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getDnsNameServers() {
            return dnsNameServers;
        }

        public final void setDnsNameServers(String dnsNameServers) {
            this.dnsNameServers = dnsNameServers;
        }

        @Override
        public final Builder dnsNameServers(String dnsNameServers) {
            this.dnsNameServers = dnsNameServers;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Integer getMaxCapacityUnits() {
            return maxCapacityUnits;
        }

        public final void setMaxCapacityUnits(Integer maxCapacityUnits) {
            this.maxCapacityUnits = maxCapacityUnits;
        }

        @Override
        public final Builder maxCapacityUnits(Integer maxCapacityUnits) {
            this.maxCapacityUnits = maxCapacityUnits;
            return this;
        }

        public final Integer getMinCapacityUnits() {
            return minCapacityUnits;
        }

        public final void setMinCapacityUnits(Integer minCapacityUnits) {
            this.minCapacityUnits = minCapacityUnits;
        }

        @Override
        public final Builder minCapacityUnits(Integer minCapacityUnits) {
            this.minCapacityUnits = minCapacityUnits;
            return this;
        }

        public final Boolean getMultiAZ() {
            return multiAZ;
        }

        public final void setMultiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
        }

        @Override
        public final Builder multiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
            return this;
        }

        public final String getPreferredMaintenanceWindow() {
            return preferredMaintenanceWindow;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final String getReplicationSubnetGroupId() {
            return replicationSubnetGroupId;
        }

        public final void setReplicationSubnetGroupId(String replicationSubnetGroupId) {
            this.replicationSubnetGroupId = replicationSubnetGroupId;
        }

        @Override
        public final Builder replicationSubnetGroupId(String replicationSubnetGroupId) {
            this.replicationSubnetGroupId = replicationSubnetGroupId;
            return this;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            if (vpcSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return vpcSecurityGroupIds;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = StringListCopier.copy(vpcSecurityGroupIds);
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = StringListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds) {
            vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        @Override
        public ComputeConfig build() {
            return new ComputeConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
