/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The amortized amount of Savings Plans purchased in a specific account during a specific time interval.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SavingsPlansAmortizedCommitment implements SdkPojo, Serializable,
        ToCopyableBuilder<SavingsPlansAmortizedCommitment.Builder, SavingsPlansAmortizedCommitment> {
    private static final SdkField<String> AMORTIZED_RECURRING_COMMITMENT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AmortizedRecurringCommitment")
            .getter(getter(SavingsPlansAmortizedCommitment::amortizedRecurringCommitment))
            .setter(setter(Builder::amortizedRecurringCommitment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmortizedRecurringCommitment")
                    .build()).build();

    private static final SdkField<String> AMORTIZED_UPFRONT_COMMITMENT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AmortizedUpfrontCommitment")
            .getter(getter(SavingsPlansAmortizedCommitment::amortizedUpfrontCommitment))
            .setter(setter(Builder::amortizedUpfrontCommitment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmortizedUpfrontCommitment").build())
            .build();

    private static final SdkField<String> TOTAL_AMORTIZED_COMMITMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TotalAmortizedCommitment").getter(getter(SavingsPlansAmortizedCommitment::totalAmortizedCommitment))
            .setter(setter(Builder::totalAmortizedCommitment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalAmortizedCommitment").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AMORTIZED_RECURRING_COMMITMENT_FIELD, AMORTIZED_UPFRONT_COMMITMENT_FIELD, TOTAL_AMORTIZED_COMMITMENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String amortizedRecurringCommitment;

    private final String amortizedUpfrontCommitment;

    private final String totalAmortizedCommitment;

    private SavingsPlansAmortizedCommitment(BuilderImpl builder) {
        this.amortizedRecurringCommitment = builder.amortizedRecurringCommitment;
        this.amortizedUpfrontCommitment = builder.amortizedUpfrontCommitment;
        this.totalAmortizedCommitment = builder.totalAmortizedCommitment;
    }

    /**
     * <p>
     * The amortized amount of your Savings Plans commitment that was purchased with either a <code>Partial</code> or a
     * <code>NoUpfront</code>.
     * </p>
     * 
     * @return The amortized amount of your Savings Plans commitment that was purchased with either a
     *         <code>Partial</code> or a <code>NoUpfront</code>.
     */
    public final String amortizedRecurringCommitment() {
        return amortizedRecurringCommitment;
    }

    /**
     * <p>
     * The amortized amount of your Savings Plans commitment that was purchased with an <code>Upfront</code> or
     * <code>PartialUpfront</code> Savings Plans.
     * </p>
     * 
     * @return The amortized amount of your Savings Plans commitment that was purchased with an <code>Upfront</code> or
     *         <code>PartialUpfront</code> Savings Plans.
     */
    public final String amortizedUpfrontCommitment() {
        return amortizedUpfrontCommitment;
    }

    /**
     * <p>
     * The total amortized amount of your Savings Plans commitment, regardless of your Savings Plans purchase method.
     * </p>
     * 
     * @return The total amortized amount of your Savings Plans commitment, regardless of your Savings Plans purchase
     *         method.
     */
    public final String totalAmortizedCommitment() {
        return totalAmortizedCommitment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(amortizedRecurringCommitment());
        hashCode = 31 * hashCode + Objects.hashCode(amortizedUpfrontCommitment());
        hashCode = 31 * hashCode + Objects.hashCode(totalAmortizedCommitment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SavingsPlansAmortizedCommitment)) {
            return false;
        }
        SavingsPlansAmortizedCommitment other = (SavingsPlansAmortizedCommitment) obj;
        return Objects.equals(amortizedRecurringCommitment(), other.amortizedRecurringCommitment())
                && Objects.equals(amortizedUpfrontCommitment(), other.amortizedUpfrontCommitment())
                && Objects.equals(totalAmortizedCommitment(), other.totalAmortizedCommitment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SavingsPlansAmortizedCommitment")
                .add("AmortizedRecurringCommitment", amortizedRecurringCommitment())
                .add("AmortizedUpfrontCommitment", amortizedUpfrontCommitment())
                .add("TotalAmortizedCommitment", totalAmortizedCommitment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AmortizedRecurringCommitment":
            return Optional.ofNullable(clazz.cast(amortizedRecurringCommitment()));
        case "AmortizedUpfrontCommitment":
            return Optional.ofNullable(clazz.cast(amortizedUpfrontCommitment()));
        case "TotalAmortizedCommitment":
            return Optional.ofNullable(clazz.cast(totalAmortizedCommitment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SavingsPlansAmortizedCommitment, T> g) {
        return obj -> g.apply((SavingsPlansAmortizedCommitment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SavingsPlansAmortizedCommitment> {
        /**
         * <p>
         * The amortized amount of your Savings Plans commitment that was purchased with either a <code>Partial</code>
         * or a <code>NoUpfront</code>.
         * </p>
         * 
         * @param amortizedRecurringCommitment
         *        The amortized amount of your Savings Plans commitment that was purchased with either a
         *        <code>Partial</code> or a <code>NoUpfront</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amortizedRecurringCommitment(String amortizedRecurringCommitment);

        /**
         * <p>
         * The amortized amount of your Savings Plans commitment that was purchased with an <code>Upfront</code> or
         * <code>PartialUpfront</code> Savings Plans.
         * </p>
         * 
         * @param amortizedUpfrontCommitment
         *        The amortized amount of your Savings Plans commitment that was purchased with an <code>Upfront</code>
         *        or <code>PartialUpfront</code> Savings Plans.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amortizedUpfrontCommitment(String amortizedUpfrontCommitment);

        /**
         * <p>
         * The total amortized amount of your Savings Plans commitment, regardless of your Savings Plans purchase
         * method.
         * </p>
         * 
         * @param totalAmortizedCommitment
         *        The total amortized amount of your Savings Plans commitment, regardless of your Savings Plans purchase
         *        method.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalAmortizedCommitment(String totalAmortizedCommitment);
    }

    static final class BuilderImpl implements Builder {
        private String amortizedRecurringCommitment;

        private String amortizedUpfrontCommitment;

        private String totalAmortizedCommitment;

        private BuilderImpl() {
        }

        private BuilderImpl(SavingsPlansAmortizedCommitment model) {
            amortizedRecurringCommitment(model.amortizedRecurringCommitment);
            amortizedUpfrontCommitment(model.amortizedUpfrontCommitment);
            totalAmortizedCommitment(model.totalAmortizedCommitment);
        }

        public final String getAmortizedRecurringCommitment() {
            return amortizedRecurringCommitment;
        }

        public final void setAmortizedRecurringCommitment(String amortizedRecurringCommitment) {
            this.amortizedRecurringCommitment = amortizedRecurringCommitment;
        }

        @Override
        public final Builder amortizedRecurringCommitment(String amortizedRecurringCommitment) {
            this.amortizedRecurringCommitment = amortizedRecurringCommitment;
            return this;
        }

        public final String getAmortizedUpfrontCommitment() {
            return amortizedUpfrontCommitment;
        }

        public final void setAmortizedUpfrontCommitment(String amortizedUpfrontCommitment) {
            this.amortizedUpfrontCommitment = amortizedUpfrontCommitment;
        }

        @Override
        public final Builder amortizedUpfrontCommitment(String amortizedUpfrontCommitment) {
            this.amortizedUpfrontCommitment = amortizedUpfrontCommitment;
            return this;
        }

        public final String getTotalAmortizedCommitment() {
            return totalAmortizedCommitment;
        }

        public final void setTotalAmortizedCommitment(String totalAmortizedCommitment) {
            this.totalAmortizedCommitment = totalAmortizedCommitment;
        }

        @Override
        public final Builder totalAmortizedCommitment(String totalAmortizedCommitment) {
            this.totalAmortizedCommitment = totalAmortizedCommitment;
            return this;
        }

        @Override
        public SavingsPlansAmortizedCommitment build() {
            return new SavingsPlansAmortizedCommitment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
