/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteCostCategoryDefinitionResponse extends CostExplorerResponse implements
        ToCopyableBuilder<DeleteCostCategoryDefinitionResponse.Builder, DeleteCostCategoryDefinitionResponse> {
    private static final SdkField<String> COST_CATEGORY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CostCategoryArn").getter(getter(DeleteCostCategoryDefinitionResponse::costCategoryArn))
            .setter(setter(Builder::costCategoryArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CostCategoryArn").build()).build();

    private static final SdkField<String> EFFECTIVE_END_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EffectiveEnd").getter(getter(DeleteCostCategoryDefinitionResponse::effectiveEnd))
            .setter(setter(Builder::effectiveEnd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EffectiveEnd").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COST_CATEGORY_ARN_FIELD,
            EFFECTIVE_END_FIELD));

    private final String costCategoryArn;

    private final String effectiveEnd;

    private DeleteCostCategoryDefinitionResponse(BuilderImpl builder) {
        super(builder);
        this.costCategoryArn = builder.costCategoryArn;
        this.effectiveEnd = builder.effectiveEnd;
    }

    /**
     * <p>
     * The unique identifier for your Cost Category.
     * </p>
     * 
     * @return The unique identifier for your Cost Category.
     */
    public final String costCategoryArn() {
        return costCategoryArn;
    }

    /**
     * <p>
     * The effective end date of the Cost Category as a result of deleting it. No costs after this date is categorized
     * by the deleted Cost Category.
     * </p>
     * 
     * @return The effective end date of the Cost Category as a result of deleting it. No costs after this date is
     *         categorized by the deleted Cost Category.
     */
    public final String effectiveEnd() {
        return effectiveEnd;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(costCategoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(effectiveEnd());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteCostCategoryDefinitionResponse)) {
            return false;
        }
        DeleteCostCategoryDefinitionResponse other = (DeleteCostCategoryDefinitionResponse) obj;
        return Objects.equals(costCategoryArn(), other.costCategoryArn()) && Objects.equals(effectiveEnd(), other.effectiveEnd());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteCostCategoryDefinitionResponse").add("CostCategoryArn", costCategoryArn())
                .add("EffectiveEnd", effectiveEnd()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CostCategoryArn":
            return Optional.ofNullable(clazz.cast(costCategoryArn()));
        case "EffectiveEnd":
            return Optional.ofNullable(clazz.cast(effectiveEnd()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteCostCategoryDefinitionResponse, T> g) {
        return obj -> g.apply((DeleteCostCategoryDefinitionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CostExplorerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteCostCategoryDefinitionResponse> {
        /**
         * <p>
         * The unique identifier for your Cost Category.
         * </p>
         * 
         * @param costCategoryArn
         *        The unique identifier for your Cost Category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder costCategoryArn(String costCategoryArn);

        /**
         * <p>
         * The effective end date of the Cost Category as a result of deleting it. No costs after this date is
         * categorized by the deleted Cost Category.
         * </p>
         * 
         * @param effectiveEnd
         *        The effective end date of the Cost Category as a result of deleting it. No costs after this date is
         *        categorized by the deleted Cost Category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder effectiveEnd(String effectiveEnd);
    }

    static final class BuilderImpl extends CostExplorerResponse.BuilderImpl implements Builder {
        private String costCategoryArn;

        private String effectiveEnd;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteCostCategoryDefinitionResponse model) {
            super(model);
            costCategoryArn(model.costCategoryArn);
            effectiveEnd(model.effectiveEnd);
        }

        public final String getCostCategoryArn() {
            return costCategoryArn;
        }

        public final void setCostCategoryArn(String costCategoryArn) {
            this.costCategoryArn = costCategoryArn;
        }

        @Override
        public final Builder costCategoryArn(String costCategoryArn) {
            this.costCategoryArn = costCategoryArn;
            return this;
        }

        public final String getEffectiveEnd() {
            return effectiveEnd;
        }

        public final void setEffectiveEnd(String effectiveEnd) {
            this.effectiveEnd = effectiveEnd;
        }

        @Override
        public final Builder effectiveEnd(String effectiveEnd) {
            this.effectiveEnd = effectiveEnd;
            return this;
        }

        @Override
        public DeleteCostCategoryDefinitionResponse build() {
            return new DeleteCostCategoryDefinitionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
