/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateViewContentRequest extends ConnectRequest implements
        ToCopyableBuilder<UpdateViewContentRequest.Builder, UpdateViewContentRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(UpdateViewContentRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<String> VIEW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ViewId")
            .getter(getter(UpdateViewContentRequest::viewId)).setter(setter(Builder::viewId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ViewId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(UpdateViewContentRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<ViewInputContent> CONTENT_FIELD = SdkField.<ViewInputContent> builder(MarshallingType.SDK_POJO)
            .memberName("Content").getter(getter(UpdateViewContentRequest::content)).setter(setter(Builder::content))
            .constructor(ViewInputContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            VIEW_ID_FIELD, STATUS_FIELD, CONTENT_FIELD));

    private final String instanceId;

    private final String viewId;

    private final String status;

    private final ViewInputContent content;

    private UpdateViewContentRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.viewId = builder.viewId;
        this.status = builder.status;
        this.content = builder.content;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The identifier of the view. Both <code>ViewArn</code> and <code>ViewId</code> can be used.
     * </p>
     * 
     * @return The identifier of the view. Both <code>ViewArn</code> and <code>ViewId</code> can be used.
     */
    public final String viewId() {
        return viewId;
    }

    /**
     * <p>
     * Indicates the view status as either <code>SAVED</code> or <code>PUBLISHED</code>. The <code>PUBLISHED</code>
     * status will initiate validation on the content.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ViewStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates the view status as either <code>SAVED</code> or <code>PUBLISHED</code>. The
     *         <code>PUBLISHED</code> status will initiate validation on the content.
     * @see ViewStatus
     */
    public final ViewStatus status() {
        return ViewStatus.fromValue(status);
    }

    /**
     * <p>
     * Indicates the view status as either <code>SAVED</code> or <code>PUBLISHED</code>. The <code>PUBLISHED</code>
     * status will initiate validation on the content.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ViewStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates the view status as either <code>SAVED</code> or <code>PUBLISHED</code>. The
     *         <code>PUBLISHED</code> status will initiate validation on the content.
     * @see ViewStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * View content containing all content necessary to render a view except for runtime input data and the runtime
     * input schema, which is auto-generated by this operation.
     * </p>
     * <p>
     * The total uncompressed content has a maximum file size of 400kB.
     * </p>
     * 
     * @return View content containing all content necessary to render a view except for runtime input data and the
     *         runtime input schema, which is auto-generated by this operation.</p>
     *         <p>
     *         The total uncompressed content has a maximum file size of 400kB.
     */
    public final ViewInputContent content() {
        return content;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(viewId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateViewContentRequest)) {
            return false;
        }
        UpdateViewContentRequest other = (UpdateViewContentRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(viewId(), other.viewId())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(content(), other.content());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateViewContentRequest").add("InstanceId", instanceId()).add("ViewId", viewId())
                .add("Status", statusAsString()).add("Content", content()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "ViewId":
            return Optional.ofNullable(clazz.cast(viewId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateViewContentRequest, T> g) {
        return obj -> g.apply((UpdateViewContentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateViewContentRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The identifier of the view. Both <code>ViewArn</code> and <code>ViewId</code> can be used.
         * </p>
         * 
         * @param viewId
         *        The identifier of the view. Both <code>ViewArn</code> and <code>ViewId</code> can be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder viewId(String viewId);

        /**
         * <p>
         * Indicates the view status as either <code>SAVED</code> or <code>PUBLISHED</code>. The <code>PUBLISHED</code>
         * status will initiate validation on the content.
         * </p>
         * 
         * @param status
         *        Indicates the view status as either <code>SAVED</code> or <code>PUBLISHED</code>. The
         *        <code>PUBLISHED</code> status will initiate validation on the content.
         * @see ViewStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ViewStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Indicates the view status as either <code>SAVED</code> or <code>PUBLISHED</code>. The <code>PUBLISHED</code>
         * status will initiate validation on the content.
         * </p>
         * 
         * @param status
         *        Indicates the view status as either <code>SAVED</code> or <code>PUBLISHED</code>. The
         *        <code>PUBLISHED</code> status will initiate validation on the content.
         * @see ViewStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ViewStatus
         */
        Builder status(ViewStatus status);

        /**
         * <p>
         * View content containing all content necessary to render a view except for runtime input data and the runtime
         * input schema, which is auto-generated by this operation.
         * </p>
         * <p>
         * The total uncompressed content has a maximum file size of 400kB.
         * </p>
         * 
         * @param content
         *        View content containing all content necessary to render a view except for runtime input data and the
         *        runtime input schema, which is auto-generated by this operation.</p>
         *        <p>
         *        The total uncompressed content has a maximum file size of 400kB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(ViewInputContent content);

        /**
         * <p>
         * View content containing all content necessary to render a view except for runtime input data and the runtime
         * input schema, which is auto-generated by this operation.
         * </p>
         * <p>
         * The total uncompressed content has a maximum file size of 400kB.
         * </p>
         * This is a convenience method that creates an instance of the {@link ViewInputContent.Builder} avoiding the
         * need to create one manually via {@link ViewInputContent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ViewInputContent.Builder#build()} is called immediately and its
         * result is passed to {@link #content(ViewInputContent)}.
         * 
         * @param content
         *        a consumer that will call methods on {@link ViewInputContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #content(ViewInputContent)
         */
        default Builder content(Consumer<ViewInputContent.Builder> content) {
            return content(ViewInputContent.builder().applyMutation(content).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String viewId;

        private String status;

        private ViewInputContent content;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateViewContentRequest model) {
            super(model);
            instanceId(model.instanceId);
            viewId(model.viewId);
            status(model.status);
            content(model.content);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getViewId() {
            return viewId;
        }

        public final void setViewId(String viewId) {
            this.viewId = viewId;
        }

        @Override
        public final Builder viewId(String viewId) {
            this.viewId = viewId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ViewStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final ViewInputContent.Builder getContent() {
            return content != null ? content.toBuilder() : null;
        }

        public final void setContent(ViewInputContent.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(ViewInputContent content) {
            this.content = content;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateViewContentRequest build() {
            return new UpdateViewContentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
